/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.SSHConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamDatasetUtils;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.fs.SCPDatasetHandler;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.security.AuthCtx;
import org.apache.log4j.Logger;

public class SCPDatasetTestHandler
extends FSLikeDatasetTestHandler {
    private static Logger logger = Logger.getLogger((String)"dku.input.scp");

    public SCPDatasetTestHandler(AuthCtx authCtx, SCPDatasetHandler handlerForData, DatasetHandler handlerForName, Dataset dataset) {
        super(authCtx, handlerForData, handlerForName, dataset);
    }

    @Override
    public InputSplit testConnection(FSLikeDatasetTestHandler.FSLikeDatasetTestResult ret) throws Exception {
        BuiltinFSDatasets.SCPDatasetConfig config = this.dataset.getParamsAs(BuiltinFSDatasets.SCPDatasetConfig.class);
        try {
            SSHConnection sftpConn = ConnectionsDAO.get().getMandatoryConnectionAs(this.handlerForData.authCtx, config.connection, SSHConnection.class);
            sftpConn.checkConfiguration();
            InputSplit sampleSplit = this.handlerForData.getSampleSplit();
            if (sampleSplit instanceof StreamsInputSplit) {
                ret.empty = StreamDatasetUtils.isStreamEmpty((StreamsInputSplit)sampleSplit);
            }
            ret.connectionOK = true;
            return sampleSplit;
        }
        catch (Exception e) {
            logger.info((Object)"SCP dataset test failed", (Throwable)e);
            ret.connectionError = new SerializedError((Throwable)e, false);
            return null;
        }
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) {
        return FSDatasetUtils.checkDatasetName(newDatasetName);
    }
}

