/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs.plugin;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FilesSelectionRules;
import com.dataiku.dip.io.AbstractImpersonatedSecretProtectedPythonKernel;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class CustomFSProviderPythonKernel
extends AbstractImpersonatedSecretProtectedPythonKernel<ResponderKernelLink> {
    private final APITicketService.Ticket ticket;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.fsprovider.read.kernel");

    public CustomFSProviderPythonKernel(ResponderKernelLink link, AuthCtx authCtx, File workDir, String pluginResourceFolderPath, String pluginPythonLibFolderPath, String projectKey, String envName, APITicketService.Ticket ticket) {
        super(link, GeneralSettingsDAO.CGrouppableProcessType.CUSTOM_PYTHON_DATA_ACCESS_COMPONENT, authCtx, workDir, pluginResourceFolderPath, false, CustomFSProviderPythonKernel.makePythonLibs("python-lib", pluginPythonLibFolderPath), projectKey, envName);
        this.ticket = ticket;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected IsolableProcess createAndStartProcess(ProcessBuilder pb, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws DKUSecurityException, IOException, InterruptedException {
        pb.environment().put("DKU_API_TICKET", this.ticket.getSecret());
        return super.createAndStartProcess(pb, cgrouppableProcessType);
    }

    public void killWithoutMercy() throws IOException, InterruptedException {
        try {
            APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
            apiTicketService.expireTicket(this.ticket);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to expire ticket", (Throwable)e);
        }
        super.killWithoutMercy();
    }

    @Override
    protected String getPythonModule() {
        return "dataiku.fsprovider.server";
    }

    public static class EnumerateResponse
    implements FSProviderResponse {
        public String errorMessage;
        public boolean enumerationPrefixExists;
        public boolean successful;
        public List<FSPath> paths;
    }

    public static class EnumerateRequest
    extends FSProviderRequest {
        public String prefix;
        public boolean firstNonEmpty;

        EnumerateRequest(String prefix, FSEnumerationSettings settings) {
            this.prefix = prefix;
            this.firstNonEmpty = settings.selectionRules != null && settings.selectionRules.mode != FilesSelectionRules.Mode.ALL ? false : settings.firstNonEmpty;
            this.type = "enumerate";
        }
    }

    public static class BrowseRequest
    extends FSProviderRequest {
        public String path;

        BrowseRequest(String path) {
            this.path = path;
            this.type = "browse";
        }
    }

    public static class MoveResponse
    implements FSProviderResponse {
        boolean done;
    }

    public static class MoveRequest
    extends FSProviderRequest {
        public String fromPath;
        public String toPath;

        MoveRequest(String fromPath, String toPath) {
            this.fromPath = fromPath;
            this.toPath = toPath;
            this.type = "move";
        }
    }

    public static class DeleteResponse
    implements FSProviderResponse {
        int count;
    }

    public static class DeleteRequest
    extends FSProviderRequest {
        public String path;

        DeleteRequest(String path) {
            this.path = path;
            this.type = "delete";
        }
    }

    public static class SetLastModifiedResponse
    implements FSProviderResponse {
        public boolean done;
    }

    public static class SetLastModifiedRequest
    extends FSProviderRequest {
        public String path;
        public long lastModified;

        SetLastModifiedRequest(String path, long lastModified) {
            this.path = path;
            this.lastModified = lastModified;
            this.type = "setmtime";
        }
    }

    public static class StatResponse
    implements FSProviderResponse {
        FSPathOrDirectory fspath;
    }

    public static class StatRequest
    extends FSProviderRequest {
        public String path;

        StatRequest(String path) {
            this.path = path;
            this.type = "stat";
        }
    }

    public static class CloseResponse
    implements FSProviderResponse {
    }

    public static class CloseRequest
    extends FSProviderRequest {
        CloseRequest() {
            this.type = "close";
        }
    }

    public static interface FSProviderResponse {
    }

    public static abstract class FSProviderRequest {
        public String type;
    }

    public static class StartServerResponse {
        public boolean ok;
        public String reason;
    }

    public static class StartServerRequest {
        public String code;
        public JsonObject config;
        public JsonObject pluginConfig;
        public String root;

        public StartServerRequest(String code, JsonObject config, JsonObject pluginConfig, String root) {
            this.code = code;
            this.config = config;
            this.pluginConfig = pluginConfig;
            this.root = root;
        }
    }
}

