/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.labeling;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowLabelingTask;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.IterableDescription;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.managedfolder.ManagedFolder;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public abstract class RelatedLabelingTasksIterable<I>
implements FlowPlaceholder.IterablePlaceholder<I, LabelingTask> {
    private final Class<I> input;
    private final boolean getSuccessors;

    protected RelatedLabelingTasksIterable(Class<I> input, boolean getSuccessors) {
        this.input = input;
        this.getSuccessors = getSuccessors;
    }

    @Override
    public IterableDescription<I, LabelingTask> getDescription() {
        return IterableDescription.iterablePlaceholder(this.input, LabelingTask.class, "$labeling_task");
    }

    protected Collection<LabelingTask> getRelatedLabelingTasks(FlowComputable flowComputable) {
        List<? extends GraphNode> resultAsNodes = this.getSuccessors ? flowComputable.getSuccessors() : flowComputable.getPredecessors();
        return resultAsNodes.stream().filter(successor -> successor instanceof FlowLabelingTask).map(successor -> ((FlowLabelingTask)successor).getLabelingTask()).collect(Collectors.toList());
    }

    public static class Folder
    extends RelatedLabelingTasksIterable<ManagedFolder> {
        public Folder(boolean getSuccessors) {
            super(ManagedFolder.class, getSuccessors);
        }

        @Override
        public Collection<LabelingTask> resolve(FlowDocumentContext context, ManagedFolder folder) throws PlaceholderExpectedException {
            return this.getRelatedLabelingTasks(context.getProjectFlowGraph().getFolder(folder.projectKey, folder.id));
        }
    }

    public static class Dataset
    extends RelatedLabelingTasksIterable<SerializedDataset> {
        public Dataset(boolean getSuccessors) {
            super(SerializedDataset.class, getSuccessors);
        }

        @Override
        public Collection<LabelingTask> resolve(FlowDocumentContext context, SerializedDataset dataset) throws PlaceholderExpectedException {
            return this.getRelatedLabelingTasks(context.getProjectFlowGraph().getDataset(dataset.projectKey, dataset.name));
        }
    }
}

