/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.model.details;

import com.dataiku.dip.analysis.ml.SMStatus;
import com.dataiku.dip.analysis.ml.SMVersionHeader;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringSMMgmtService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelSnippetData;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.prediction.PredictionModelSnippetData;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dss.shadelib.com.google.common.collect.MoreCollectors;
import org.springframework.beans.factory.annotation.Autowired;

public class ModelActiveVersionNamePlaceholder
implements FlowPlaceholder.TextPlaceholder<SavedModel> {
    @Autowired
    private PredictionSMMgmtService predictionMgmtService;
    @Autowired
    private ClusteringSMMgmtService clusteringMgmtService;

    public ModelActiveVersionNamePlaceholder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public PlaceholderOutput.Text resolve(FlowDocumentContext flowDocumentContext, SavedModel model) throws PlaceholderExpectedException {
        SMStatus status;
        MLTask.MLTaskType taskType = model.miniTask.taskType;
        if (taskType == MLTask.MLTaskType.PREDICTION) {
            status = this.predictionMgmtService.getStatus_NT(model);
        } else if (taskType == MLTask.MLTaskType.CLUSTERING) {
            status = this.clusteringMgmtService.getStatus_NT(model);
        } else {
            throw new IllegalArgumentException(String.format("Unknown type %s", new Object[]{taskType}));
        }
        SMVersionHeader versionHeader = (SMVersionHeader)status.versions.stream().filter(v -> v.active).collect(MoreCollectors.onlyElement());
        ModelUserMeta mum = versionHeader.snippet instanceof PredictionModelSnippetData ? ((PredictionModelSnippetData)versionHeader.snippet).userMeta : ((ClusteringModelSnippetData)versionHeader.snippet).userMeta;
        return new PlaceholderOutput.Text(mum.name);
    }

    @Override
    public Class<SavedModel> getInputType() {
        return SavedModel.class;
    }
}

