/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.j2ts.annotations.UIData;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

@UIModel
public enum EdaErrorCodes implements InfoMessage.MessageCode
{
    ERR_EDA_COMPUTE("Unexpected EDA compute error", InfoMessage.FixabilityCategory.UNKNOWN),
    ERR_EDA_COMPUTE_KERNEL_FAILURE("Unexpected EDA kernel failure", InfoMessage.FixabilityCategory.UNKNOWN),
    ERR_EDA_COMPUTE_INVALID_PARAMS("Invalid computation parameters", InfoMessage.FixabilityCategory.UNKNOWN),
    ERR_EDA_COMPUTE_NOT_INDEPENDENT("Groups must be disjoint to be considered independent", InfoMessage.FixabilityCategory.API_CALL),
    ERR_EDA_COMPUTE_UNKNOWN_TYPE("Unknown object type", InfoMessage.FixabilityCategory.API_CALL),
    ERR_EDA_COMPUTE_CAST_TO_NUMERICAL_FAILED("Could not cast string to numerical", InfoMessage.FixabilityCategory.DATA),
    ERR_EDA_COMPUTE_PARSE_TO_DATE_FAILED("Could not parse string to date", InfoMessage.FixabilityCategory.DATA),
    ERR_EDA_COMPUTE_INVALID_RESULT("Invalid results", InfoMessage.FixabilityCategory.DATA),
    ERR_EDA_COMPUTE_NO_DATA("No data", InfoMessage.FixabilityCategory.DATA),
    ERR_EDA_COMPUTE_NOT_ENOUGH_DATA("Not enough data", InfoMessage.FixabilityCategory.DATA),
    ERR_EDA_COMPUTE_NOT_ENOUGH_GROUPS("Not enough groups", InfoMessage.FixabilityCategory.DATA),
    ERR_EDA_COMPUTE_DEGENERATE("Degenerate case", InfoMessage.FixabilityCategory.DATA),
    ERR_EDA_COMPUTE_NO_SUCH_SAMPLE("Sample does not exist (or is not accessible)", InfoMessage.FixabilityCategory.UNKNOWN);

    private final String title;
    private final InfoMessage.FixabilityCategory fixability;
    @UIData
    public static final Map<EdaErrorCodes, String> titles;

    private EdaErrorCodes(String title, InfoMessage.FixabilityCategory fixability) {
        this.title = title;
        this.fixability = fixability;
    }

    public String getCode() {
        return this.name();
    }

    public String getCodeTitle() {
        return this.title;
    }

    public InfoMessage.FixabilityCategory getFixability() {
        return this.fixability;
    }

    static {
        titles = Arrays.stream(EdaErrorCodes.values()).collect(Collectors.toMap(x -> x, EdaErrorCodes::getCodeTitle));
    }
}

