/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.grouping;

import com.dataiku.dip.eda.compute.filtering.AndFilter;
import com.dataiku.dip.eda.compute.filtering.AnumFilter;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.GroupingResult;
import java.util.List;
import java.util.stream.Collectors;

public class MultiAnumGrouping
extends Grouping {
    public static final String TYPE = "multi_anum";
    public List<String> columns;

    public MultiAnumGrouping(List<String> columns) {
        this.columns = columns;
    }

    private MultiAnumGrouping() {
    }

    public static class MultiAnumGroupingResult
    extends GroupingResult {
        public List<String> columns;
        public List<List<String>> groupValues;

        public MultiAnumGroupingResult(List<String> columns, List<List<String>> groupValues) {
            this.columns = columns;
            this.groupValues = groupValues;
        }

        private MultiAnumGroupingResult() {
        }

        @Override
        public List<Filter> listFilters() {
            return this.groupValues.stream().map(this::getGroupFilter).collect(Collectors.toList());
        }

        private Filter getGroupFilter(List<String> columnValues) {
            Filter[] columnFilters = new Filter[columnValues.size()];
            for (int i = 0; i < columnValues.size(); ++i) {
                String column = this.columns.get(i);
                String value = columnValues.get(i);
                columnFilters[i] = AnumFilter.single(column, value);
            }
            return new AndFilter(null, columnFilters);
        }

        @Override
        public int size() {
            return this.groupValues.size();
        }
    }
}

