/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.timeseries.DurbinWatson;
import com.dataiku.dip.eda.compute.computations.timeseries.TimeSeriesComputation;
import com.dataiku.dip.eda.worksheets.cards.TimeSeriesCard;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.eda.worksheets.cards.fragments.TimeInfoFragment;
import com.dataiku.dip.eda.worksheets.models.Variable;

public class DurbinWatsonCard
extends TimeSeriesCard {
    public static final String TYPE = "durbin_watson";

    public DurbinWatsonCard(Variable seriesColumn, Variable timeColumn) {
        super(seriesColumn, timeColumn);
    }

    private DurbinWatsonCard() {
    }

    @Override
    protected TimeSeriesComputation getMainComputation() {
        return new DurbinWatson(this.seriesColumn.name, this.timeColumn.name);
    }

    @Override
    protected TimeSeriesCard.TimeSeriesCardResult buildCardResult(AvailableResult mainComputationResult, BoxPlotFragment boxPlot, TimeInfoFragment timeInfo) {
        DurbinWatson.DurbinWatsonResult result = mainComputationResult.as(DurbinWatson.DurbinWatsonResult.class);
        return new DurbinWatsonCardResult(result, boxPlot, timeInfo);
    }

    public static class DurbinWatsonCardResult
    extends TimeSeriesCard.TimeSeriesCardResult {
        public double statistic;

        public DurbinWatsonCardResult(DurbinWatson.DurbinWatsonResult result, BoxPlotFragment boxPlot, TimeInfoFragment timeInfo) {
            super(boxPlot, timeInfo);
            this.statistic = result.statistic;
        }

        private DurbinWatsonCardResult() {
        }
    }
}

