/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.hive.HiveScriptPreprocessor;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.hproxy.model.hive.ValidationResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class HiveValidationTools {
    public static void checkIfTryingToWriteOnInputs(RunnableSubgraph subgraph, ValidationResult rawHiveResponse, InfoMessage.InfoMessages messages) {
        Map<String, FlowComputable> sources = subgraph.getSourcesMap();
        for (ValidationResult.InsertOverwriteDef iodef : rawHiveResponse.insertOverwrites) {
            String ioTable = iodef.destinationTable;
            if (StringUtils.isBlank((String)ioTable) || sources.get(ioTable) == null) continue;
            InfoMessage err = InfoMessage.fatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, (String)"You are trying to overwrite the input dataset '%s'", (Object[])new Object[]{iodef.destinationTable}).withLineRange(iodef.lineFrom + 1, iodef.lineTo + 1);
            messages.addMessage(err);
        }
    }

    public static void removeIrrelevantMessages(ValidationResult rawHiveResponse, HiveScriptPreprocessor preprocessor) {
        ArrayList<ValidationResult.ValidationMessage> msgToRemove = new ArrayList<ValidationResult.ValidationMessage>();
        List<String> ignoredOutputs = preprocessor.getIgnoredOutputTables();
        block0: for (ValidationResult.ValidationMessage msg : rawHiveResponse.messages) {
            for (String tableName : ignoredOutputs) {
                if (msg.errorMessage.trim().equals("Table not found '" + tableName + "'")) {
                    msgToRemove.add(msg);
                    continue block0;
                }
                if (!msg.errorMessage.trim().equals("Table not found '`" + tableName + "`'")) continue;
                msgToRemove.add(msg);
                continue block0;
            }
        }
        for (ValidationResult.ValidationMessage msg : msgToRemove) {
            rawHiveResponse.messages.remove(msg);
        }
    }

    public static void copyMessagesToEnriched(ValidationResult rawHiveResponse, InfoMessage.InfoMessages messages) {
        for (ValidationResult.ValidationMessage msg : rawHiveResponse.messages) {
            switch (msg.severity) {
                case ERROR: {
                    InfoMessage error = InfoMessage.fatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, (String)"%s", (Object[])new Object[]{msg.errorMessage});
                    messages.addMessage(error);
                    if (msg.column >= 0) {
                        error.withLineRange(msg.errorLineFrom + 1, msg.errorLineFrom + 1);
                        error.withPos(msg.errorLineFrom + 1, msg.column + 1);
                        break;
                    }
                    error.withLineRange(msg.errorLineFrom + 1, msg.errorLineTo + 1);
                    break;
                }
                case WARNING: {
                    InfoMessage error = InfoMessage.fatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, (String)"%s", (Object[])new Object[]{msg.errorMessage});
                    messages.addMessage(error);
                    if (msg.column >= 0) {
                        error.withLineRange(msg.errorLineFrom + 1, msg.errorLineFrom + 1);
                        error.withPos(msg.errorLineFrom + 1, msg.column + 1);
                        break;
                    }
                    error.withLineRange(msg.errorLineFrom + 1, msg.errorLineTo + 1);
                }
            }
        }
    }

    private HiveValidationTools() {
    }
}

