/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.input.formats.FileBasedFormatDetector;
import com.dataiku.dip.input.formats.InputFormatsDetector;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eobjects.sassy.SasColumnType;
import org.eobjects.sassy.SasReader;
import org.eobjects.sassy.SasReaderCallback;

public class SASFormatDetector
implements FileBasedFormatDetector {
    @Override
    public List<InputFormatsDetector.FormatWithMetadata> detect(Dataset dataset, FSDatasetUtils.PathsBasedSplit split, FSPath path, String filename) throws Exception {
        InputFormatsDetector.FormatWithMetadata fwm = new InputFormatsDetector.FormatWithMetadata();
        fwm.type = "sas";
        ArrayList<InputFormatsDetector.FormatWithMetadata> list = new ArrayList<InputFormatsDetector.FormatWithMetadata>();
        list.add(fwm);
        return list;
    }

    @Override
    public Map<String, String> recomputeMetadata(String autodetectedFormatId, Dataset dataset, FSDatasetUtils.PathsBasedSplit split, FSPath path, String filename) throws Exception {
        if (autodetectedFormatId.equals("sas")) {
            HashMap<String, String> meta = new HashMap<String, String>();
            EnrichedInputStream eis = split.getStreamForPath(path);
            InputStream stream = eis.decompressedStream();
            SASReadMeta rd = new SASReadMeta();
            SasReader reader = new SasReader(stream, path.path());
            reader.read((SasReaderCallback)rd);
            return meta;
        }
        return null;
    }

    static class SASReadMeta
    implements SasReaderCallback {
        SASReadMeta() {
        }

        public void column(int index, String columnName, String columnLogicalName, SasColumnType sasColumnType, int indexLength) {
        }

        public boolean readData() {
            return false;
        }

        public boolean row(int i, Object[] objects) {
            return false;
        }
    }
}

