/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.hive.serde;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import java.util.ArrayList;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class SchemaConverter {
    private final ORCFileFormatConfig.ReadTemporalMode readTemporalMode;

    public SchemaConverter(ORCFileFormatConfig.ReadTemporalMode readTemporalMode) {
        this.readTemporalMode = readTemporalMode;
    }

    public Schema buildSchema(StructObjectInspector soi) {
        Schema schema = new Schema();
        for (SchemaColumn sc : this.buildStruct((StructObjectInspector)soi).objectFields) {
            schema.addColumn(sc);
        }
        return schema;
    }

    private SchemaColumn buildStruct(StructObjectInspector soi) {
        SchemaColumn sc = new SchemaColumn();
        sc.setType(Type.OBJECT);
        sc.objectFields = new ArrayList();
        for (StructField sf : soi.getAllStructFieldRefs()) {
            SchemaColumn sub = this.buildType(sf.getFieldObjectInspector());
            sub.setName(sf.getFieldName());
            sc.objectFields.add(sub);
        }
        return sc;
    }

    public SchemaColumn buildType(ObjectInspector oi) {
        if (oi.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            return this.buildPrimitiveType((PrimitiveObjectInspector)oi);
        }
        if (oi.getCategory() == ObjectInspector.Category.STRUCT) {
            return this.buildStruct((StructObjectInspector)oi);
        }
        if (oi.getCategory() == ObjectInspector.Category.LIST) {
            return this.buildList((ListObjectInspector)oi);
        }
        if (oi.getCategory() == ObjectInspector.Category.MAP) {
            return this.buildMap((MapObjectInspector)oi);
        }
        throw new RuntimeException("DSS doesn't support Hive type category: " + String.valueOf(oi.getCategory()));
    }

    private SchemaColumn buildMap(MapObjectInspector oi) {
        SchemaColumn sc = new SchemaColumn();
        sc.setType(Type.MAP);
        sc.mapKeys = this.buildType(oi.getMapKeyObjectInspector());
        sc.mapValues = this.buildType(oi.getMapValueObjectInspector());
        return sc;
    }

    private SchemaColumn buildList(ListObjectInspector oi) {
        SchemaColumn sc = new SchemaColumn();
        sc.setType(Type.ARRAY);
        sc.arrayContent = this.buildType(oi.getListElementObjectInspector());
        return sc;
    }

    private SchemaColumn buildPrimitiveType(PrimitiveObjectInspector oi) {
        SchemaColumn sc = new SchemaColumn();
        switch (oi.getPrimitiveCategory()) {
            case BOOLEAN: {
                sc.setType(Type.BOOLEAN);
                break;
            }
            case SHORT: {
                sc.setType(Type.SMALLINT);
                break;
            }
            case INT: {
                sc.setType(Type.INT);
                break;
            }
            case LONG: {
                sc.setType(Type.BIGINT);
                break;
            }
            case FLOAT: {
                sc.setType(Type.FLOAT);
                break;
            }
            case DOUBLE: {
                sc.setType(Type.DOUBLE);
                break;
            }
            case STRING: {
                sc.setType(Type.STRING);
                break;
            }
            case VARCHAR: {
                sc.setType(Type.STRING);
                break;
            }
            case CHAR: {
                sc.setType(Type.STRING);
                break;
            }
            case TIMESTAMP: {
                sc.setType(Type.DATE);
                break;
            }
            case DATE: {
                if (this.readTemporalMode == ORCFileFormatConfig.ReadTemporalMode.AS_TEMPORAL) {
                    sc.setType(Type.DATEONLY);
                    break;
                }
                sc.setType(Type.STRING);
                break;
            }
            case DECIMAL: {
                sc.setType(Type.DOUBLE);
                sc.withOriginalType(oi.getTypeName());
                break;
            }
            case VOID: 
            case BINARY: {
                sc.setType(Type.STRING);
                break;
            }
            case BYTE: {
                sc.setType(Type.TINYINT);
                break;
            }
            default: {
                throw new RuntimeException("Type " + String.valueOf(oi.getPrimitiveCategory()) + " is not supported");
            }
        }
        return sc;
    }
}

