/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;

public class LoggingRecordConsumer
extends RecordConsumer {
    private final RecordConsumerLogger eventLogger;
    private int depth = 0;

    LoggingRecordConsumer(RecordConsumerLogger logger) {
        this.eventLogger = logger;
    }

    public void startMessage() {
        this.eventLogger.log(this.depth, "startMessage()");
        ++this.depth;
    }

    public void endMessage() {
        --this.depth;
        this.eventLogger.log(this.depth, "endMessage()");
    }

    public void startField(String s, int i) {
        this.eventLogger.log(this.depth, "startField(" + s + "," + i + ")");
        ++this.depth;
    }

    public void endField(String s, int i) {
        --this.depth;
        this.eventLogger.log(this.depth, "endField(" + s + "," + i + ")");
    }

    public void startGroup() {
        this.eventLogger.log(this.depth, "startGroup()");
        ++this.depth;
    }

    public void endGroup() {
        --this.depth;
        this.eventLogger.log(this.depth, "endGroup()");
    }

    public void addInteger(int i) {
        this.eventLogger.log(this.depth, "addInteger(" + i + ")");
    }

    public void addLong(long l) {
        this.eventLogger.log(this.depth, "addLong(" + l + ")");
    }

    public void addBoolean(boolean b) {
        this.eventLogger.log(this.depth, "addBoolean(" + b + ")");
    }

    public void addBinary(Binary binary) {
        this.eventLogger.log(this.depth, "addBinary(" + binary.toStringUsingUTF8() + ")");
    }

    public void addFloat(float v) {
        this.eventLogger.log(this.depth, "addFloat(" + v + ")");
    }

    public void addDouble(double v) {
        this.eventLogger.log(this.depth, "addDouble(" + v + ")");
    }

    public static interface RecordConsumerLogger {
        public void log(int var1, String var2);
    }
}

