/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.remote;

import com.dataiku.dip.fs.Globbing;
import com.dataiku.dip.input.remote.RemoteFileUtils;
import com.dataiku.dip.io.OutputStreamWrapper;
import com.dataiku.dip.util.DKUIOUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.CharSequenceInputStream;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import gnu.trove.list.array.TByteArrayList;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class SSHRemote
implements AutoCloseable {
    private static Pattern cMessagePattern;
    private static Pattern filelistPattern;
    protected Session session;
    protected final int timeout;
    private static org.apache.log4j.Logger logger;

    private static RemoteFileUtils.RemoteFile parseNext(Reader rd) throws IOException {
        int c2;
        StringBuilder sb = new StringBuilder();
        while ((c2 = rd.read()) > 0) {
            sb.append((char)c2);
        }
        if (c2 != 0) {
            if (sb.length() == 0) {
                return null;
            }
            throw new IOException("error reading remote file list : premature end of stream");
        }
        Matcher matcher = filelistPattern.matcher(sb);
        if (!matcher.matches() || matcher.groupCount() != 5) {
            throw new IOException("error reading remote file list: invalid line : " + String.valueOf(sb));
        }
        RemoteFileUtils.RemoteFile result = new RemoteFileUtils.RemoteFile();
        result.type = matcher.group(1).charAt(0);
        if (result.type == 'f') {
            result.size = Long.parseLong(matcher.group(2));
        }
        result.mtime = Long.parseLong(matcher.group(3)) * 1000L;
        if (matcher.group(4) != null) {
            result.mtime += (long)Integer.parseInt((matcher.group(4) + "000").substring(1, 4));
        }
        result.name = matcher.group(5);
        return result;
    }

    public SSHRemote(String host, String username, boolean usePublicKey, String passphrase, String passwd, int port, int timeout) throws IOException {
        try {
            JSch jsch = new JSch();
            File knownHosts = new File(System.getProperty("user.home") + "/.ssh/known_hosts");
            if (knownHosts.exists()) {
                jsch.setKnownHosts(knownHosts.getPath());
            }
            JSch.setConfig((String)"StrictHostKeyChecking", (String)"no");
            if (usePublicKey) {
                File rsa;
                File dsa = new File(System.getProperty("user.home") + "/.ssh/id_dsa");
                if (dsa.exists()) {
                    jsch.addIdentity(dsa.getPath(), passphrase);
                }
                if ((rsa = new File(System.getProperty("user.home") + "/.ssh/id_rsa")).exists()) {
                    jsch.addIdentity(rsa.getPath(), passphrase);
                }
                JSch.setConfig((String)"PreferredAuthentications", (String)"publickey");
            } else {
                JSch.setConfig((String)"PreferredAuthentications", (String)"password");
            }
            if (port == 0) {
                port = 22;
            }
            this.timeout = timeout;
            this.session = jsch.getSession(username, host, port);
            if (!usePublicKey && passwd != null) {
                this.session.setPassword(passwd);
            }
            this.session.setTimeout(timeout);
            this.session.connect();
        }
        catch (JSchException e) {
            throw new IOException("SSH error connecting to " + host, e);
        }
    }

    @Override
    public void close() {
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    public void forwardRemotePort(String bindAddress, int number) throws JSchException {
        logger.info((Object)("Forward remote port " + bindAddress + " : " + number));
        this.session.setPortForwardingR(bindAddress, number, "127.0.0.1", number);
    }

    public RemoteFileUtils.RemoteFile get(String path) throws IOException {
        logger.debug((Object)("Stats for remote file '" + path + "'"));
        RemoteFileUtils.EnumerationResult enumeration = this.enumeratePath(path, 0);
        if (enumeration.error || enumeration.files.isEmpty()) {
            return null;
        }
        return enumeration.files.get(0);
    }

    public List<RemoteFileUtils.RemoteFile> list(String path) throws IOException {
        logger.debug((Object)("Listing '" + path + "'"));
        RemoteFileUtils.EnumerationResult enumeration = this.enumeratePath(path, 1);
        if (enumeration.error) {
            return null;
        }
        enumeration.files.remove(0);
        return enumeration.files;
    }

    public void mkdirs(String path) throws IOException {
        Object command = "mkdir -p ";
        if (path.startsWith("-")) {
            command = (String)command + "-- ";
        }
        this.exec((String)command + SSHRemote.shellQuote(path));
    }

    public void forceRemove(String path) throws IOException {
        if (StringUtils.isBlank((String)path)) {
            throw new IllegalArgumentException("Empty path");
        }
        Object command = "rm -rf ";
        if (path.startsWith("-")) {
            command = (String)command + "-- ";
        }
        this.exec((String)command + SSHRemote.shellQuote(path));
    }

    public void rename(String fromPath, String toPath) throws IOException {
        Object command = "mv ";
        if (fromPath.startsWith("-")) {
            command = (String)command + "-- ";
        }
        this.exec((String)command + SSHRemote.shellQuote(fromPath) + " " + SSHRemote.shellQuote(toPath));
    }

    public InputStream getInputStream(String path) throws IOException {
        long filesize;
        InputStream in;
        Channel channel;
        try {
            channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand("scp -f -- " + SSHRemote.shellQuote(path));
            OutputStream out = channel.getOutputStream();
            in = channel.getInputStream();
            channel.connect();
            out.write(0);
            out.flush();
            int c2 = in.read();
            switch (c2) {
                case 67: {
                    StringBuilder sb = SSHRemote.readLine(in);
                    Matcher matcher = cMessagePattern.matcher(sb);
                    if (!matcher.matches() || matcher.groupCount() != 3) {
                        throw new IOException("Invalid SCP server answer : C" + String.valueOf(sb));
                    }
                    filesize = Long.parseLong(matcher.group(2));
                    break;
                }
                case 1: {
                    throw new IOException("SCP error : " + String.valueOf(SSHRemote.readLine(in)));
                }
                case 2: {
                    throw new IOException("SCP fatal error : " + String.valueOf(SSHRemote.readLine(in)));
                }
                case 0: {
                    throw new IOException("Unexpected null reading SCP server answer");
                }
                case -1: {
                    throw new IOException("Unexpected EOF reading SCP server answer");
                }
                default: {
                    throw new IOException("Invalid SCP server answer : " + (char)c2 + String.valueOf(SSHRemote.readLine(in)));
                }
            }
            out.write(0);
            out.flush();
        }
        catch (JSchException e) {
            throw new IOException("SSH error", e);
        }
        return new InputStream(){
            volatile long bytesRead = 0L;

            @Override
            public int read() throws IOException {
                if (this.bytesRead >= filesize) {
                    return -1;
                }
                int i = in.read();
                if (i >= 0) {
                    ++this.bytesRead;
                    return i;
                }
                in.close();
                channel.disconnect();
                throw new IOException("Unexpected end of stream after " + this.bytesRead + " bytes, expected " + filesize);
            }

            @Override
            public void close() throws IOException {
                in.close();
                channel.disconnect();
            }
        };
    }

    public OutputStream getOutputStream(String path) throws IOException {
        try {
            Channel channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand("sh -c " + SSHRemote.shellQuote("cat > " + SSHRemote.shellQuote(path) + " && echo 'foo'"));
            channel.connect();
            return new FilterOutputStreamClosingChannel(channel.getOutputStream(), channel);
        }
        catch (JSchException e) {
            throw new IOException("SSH error", e);
        }
    }

    public void setLastModified(String path, long lastModified) throws IOException {
        String timestamp = DateTimeFormat.forPattern((String)"yyyyMMddHHmm.ss").withZone(DateTimeZone.UTC).print(lastModified);
        String command = "TZ=UTC touch -a -m -t " + timestamp + " ";
        this.exec(command + SSHRemote.shellQuote(path));
    }

    public RemoteFileUtils.EnumerationResult resolveGlob(String glob) throws IOException {
        boolean isAbsolute = glob.length() > 0 && glob.charAt(0) == '/';
        String[] segments = (isAbsolute ? glob.substring(1) : glob).split("/", -1);
        ArrayList<String> dirs = new ArrayList<String>();
        ArrayList<String> paths = new ArrayList<String>();
        Object prefix = isAbsolute ? "" : ".";
        dirs.add((String)prefix);
        RemoteFileUtils.EnumerationResult result = new RemoteFileUtils.EnumerationResult();
        for (String s : segments) {
            Object r;
            prefix = (String)prefix + "/" + s;
            result.files.clear();
            if (dirs.isEmpty()) {
                return result;
            }
            if (Globbing.hasGlobbing((String)s)) {
                paths.clear();
                for (String string : dirs) {
                    paths.add(string + "/");
                }
                r = this.enumeratePaths(paths, 1);
                if (((RemoteFileUtils.EnumerationResult)r).error) {
                    result.error = true;
                    result.msg.addAll(((RemoteFileUtils.EnumerationResult)r).msg);
                }
                dirs.clear();
                for (RemoteFileUtils.RemoteFile rf : ((RemoteFileUtils.EnumerationResult)r).files) {
                    if (!Globbing.matchPath((String)prefix, (String)rf.name, (String)"/")) continue;
                    if (rf.type == 'f') {
                        result.files.add(rf);
                        continue;
                    }
                    dirs.add(rf.name);
                    result.files.add(rf);
                }
                continue;
            }
            paths.clear();
            for (String string : dirs) {
                paths.add(string + "/" + s);
            }
            r = this.enumeratePaths(paths, 0);
            if (((RemoteFileUtils.EnumerationResult)r).error) {
                result.error = true;
                result.msg.addAll(((RemoteFileUtils.EnumerationResult)r).msg);
            }
            dirs.clear();
            for (RemoteFileUtils.RemoteFile rf : ((RemoteFileUtils.EnumerationResult)r).files) {
                if (rf.type == 'f') {
                    result.files.add(rf);
                    continue;
                }
                dirs.add(rf.name);
                result.files.add(rf);
            }
        }
        logger.debug((Object)("resolveGlob: \"" + glob + "\" matched " + result.files.size() + " paths"));
        return result;
    }

    protected RemoteFileUtils.EnumerationResult enumeratePaths(List<String> paths) throws IOException {
        return this.enumeratePaths(paths, -1);
    }

    protected RemoteFileUtils.EnumerationResult enumeratePath(String path) throws IOException {
        return this.enumeratePaths((List<String>)ImmutableList.of((Object)path));
    }

    protected RemoteFileUtils.EnumerationResult enumeratePath(String path, int depth) throws IOException {
        return this.enumeratePaths((List<String>)ImmutableList.of((Object)path), depth);
    }

    protected RemoteFileUtils.EnumerationResult enumeratePaths(List<String> paths, int depth) throws IOException {
        RemoteFileUtils.EnumerationResult result = new RemoteFileUtils.EnumerationResult();
        if (paths.isEmpty()) {
            return result;
        }
        String cmd = "LC_ALL=en_US.UTF-8 TZ=UTC xargs -0 sh -c 'find -- \"$@\"" + (depth == 0 ? " -maxdepth 0" : (depth == 1 ? " -maxdepth 1" : "")) + " \\( -type f -o -type d \\) -printf \"%y %s %T@ \" -print0' find";
        StringBuilder stdin = new StringBuilder();
        for (String p : paths) {
            stdin.append(p);
            stdin.append('\u0000');
        }
        try {
            logger.info((Object)("sending remote command: " + cmd));
            ChannelExec channel = (ChannelExec)this.session.openChannel("exec");
            channel.setCommand(cmd);
            channel.setInputStream((InputStream)new CharSequenceInputStream((CharSequence)stdin, "UTF-8"));
            channel.setErrStream((OutputStream)new LineArrayOutputStream(result.msg));
            InputStreamReader rd = new InputStreamReader(channel.getInputStream(), "UTF-8");
            channel.connect();
            TimeoutWatcher watcher = new TimeoutWatcher(this.timeout);
            try {
                RemoteFileUtils.RemoteFile rf;
                while ((rf = SSHRemote.parseNext(rd)) != null) {
                    result.files.add(rf);
                    watcher.progress();
                }
                int status = channel.getExitStatus();
                if (status > 0) {
                    result.error = true;
                    logger.warn((Object)("remote file enumeration returned status " + status));
                }
            }
            catch (InterruptedIOException e) {
                result.error = true;
                throw new IOException("timeout reading remote file list", e);
            }
            finally {
                watcher.done();
                channel.disconnect();
                if (result.error) {
                    logger.warn((Object)"remote file enumeration failed");
                    for (String m : result.msg) {
                        logger.warn((Object)m);
                    }
                }
            }
        }
        catch (JSchException e) {
            throw new IOException("SSH error", e);
        }
    }

    protected RemoteFileUtils.EnumerationResult enumerate(List<RemoteFileUtils.RemoteFile> dirs) throws IOException {
        ArrayList<String> paths = new ArrayList<String>();
        for (RemoteFileUtils.RemoteFile rf : dirs) {
            paths.add(rf.name);
        }
        return this.enumeratePaths(paths);
    }

    protected void exec(String toExecute) throws IOException {
        ChannelExec channel;
        try {
            channel = (ChannelExec)this.session.openChannel("exec");
        }
        catch (JSchException e) {
            throw new IOException("SSH error", e);
        }
        try {
            String command = "LC_ALL=en_US.UTF-8 " + toExecute;
            logger.debug((Object)("Executing remote command: " + command));
            channel.setCommand(command);
            channel.connect();
            channel.getOutputStream().close();
            channel.getInputStream().close();
            while (!channel.isClosed()) {
                Thread.sleep(100L);
            }
            if (channel.getExitStatus() != 0) {
                throw new IOException("SSH command error, status " + channel.getExitStatus());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("Interrupted call");
        }
        catch (JSchException e) {
            throw new IOException("SSH error", e);
        }
        finally {
            channel.disconnect();
        }
    }

    public String execAndGet(String toExecute) throws IOException {
        ChannelExec channel;
        try {
            channel = (ChannelExec)this.session.openChannel("exec");
        }
        catch (JSchException e) {
            throw new IOException("SSH error", e);
        }
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String command = "LC_ALL=en_US.UTF-8 " + toExecute;
            logger.debug((Object)("Executing remote command: " + command));
            channel.setCommand(command);
            channel.connect();
            channel.getErrStream().close();
            channel.getInputStream().close();
            channel.setOutputStream((OutputStream)new LineArrayOutputStream(lines));
            while (!channel.isClosed()) {
                Thread.sleep(100L);
            }
            if (channel.getExitStatus() != 0) {
                throw new IOException("SSH command error, status " + channel.getExitStatus());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("Interrupted call");
        }
        catch (JSchException e) {
            throw new IOException("SSH error", e);
        }
        finally {
            channel.disconnect();
        }
        return Joiner.on((String)"\n").join(lines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void download(String remoteFile, OutputStream localFile) throws IOException {
        try {
            Channel channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand("scp -f " + SSHRemote.shellQuote(remoteFile));
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            TimeoutWatcher watcher = new TimeoutWatcher(this.timeout);
            try {
                out.write(0);
                out.flush();
                int c2 = in.read();
                long filesize = switch (c2) {
                    case 67 -> {
                        StringBuilder sb = SSHRemote.readLine(in);
                        Matcher matcher = cMessagePattern.matcher(sb);
                        if (!matcher.matches() || matcher.groupCount() != 3) {
                            throw new IOException("Invalid SCP server answer : C" + String.valueOf(sb));
                        }
                        yield Long.parseLong(matcher.group(2));
                    }
                    case 1 -> throw new IOException("SCP error : " + String.valueOf(SSHRemote.readLine(in)));
                    case 2 -> throw new IOException("SCP fatal error : " + String.valueOf(SSHRemote.readLine(in)));
                    case 0 -> throw new IOException("Unexpected null reading SCP server answer");
                    case -1 -> throw new IOException("Unexpected EOF reading SCP server answer");
                    default -> throw new IOException("Invalid SCP server answer : " + (char)c2 + String.valueOf(SSHRemote.readLine(in)));
                };
                watcher.progress();
                out.write(0);
                out.flush();
                DownloadProgressCopyCallback update = new DownloadProgressCopyCallback(watcher, filesize);
                long n = DKUIOUtils.copyLarge(in, localFile, filesize, update);
                if (n != filesize) {
                    throw new IOException("Unexpected end of input stream reading SCP file contents : " + n + " should be " + filesize);
                }
                c2 = in.read();
                switch (c2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw new IOException("SCP error : " + String.valueOf(SSHRemote.readLine(in)));
                    }
                    case 2: {
                        throw new IOException("SCP fatal error : " + String.valueOf(SSHRemote.readLine(in)));
                    }
                    case -1: {
                        throw new IOException("Unexpected EOF reading SCP server answer");
                    }
                    default: {
                        throw new IOException("Invalid SCP server answer : " + (char)c2 + String.valueOf(SSHRemote.readLine(in)));
                    }
                }
                watcher.progress();
                localFile.close();
                out.write(0);
                out.flush();
                c2 = in.read();
                switch (c2) {
                    case -1: {
                        return;
                    }
                    case 1: {
                        throw new IOException("SCP error : " + String.valueOf(SSHRemote.readLine(in)));
                    }
                    case 2: {
                        throw new IOException("SCP fatal error : " + String.valueOf(SSHRemote.readLine(in)));
                    }
                    default: {
                        throw new IOException("Invalid SCP server answer : " + (char)c2 + String.valueOf(SSHRemote.readLine(in)));
                    }
                }
            }
            finally {
                channel.disconnect();
                watcher.done();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("timeout downloading file");
        }
        catch (JSchException e) {
            throw new IOException("SSH error", e);
        }
    }

    protected static boolean skip(String name) {
        return StringUtils.isBlank((String)name) || ".".equals(name) || "..".equals(name);
    }

    private static StringBuilder readLine(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            int c2;
            if ((c2 = in.read()) < 0) {
                throw new IOException("unexpected EOF reading server answer");
            }
            if (c2 == 0) {
                throw new IOException("unexpected null reading server answer");
            }
            if (c2 == 10) {
                return sb;
            }
            sb.append((char)c2);
        }
    }

    public static String shellQuote(String s) {
        StringBuilder result = new StringBuilder();
        result.append('\'');
        for (char c2 : s.toCharArray()) {
            if (c2 != '\'') {
                result.append(c2);
                continue;
            }
            result.append("'\\''");
        }
        result.append('\'');
        return result.toString();
    }

    static {
        JSch.setLogger((Logger)new JSchLogger());
        cMessagePattern = Pattern.compile("^(\\d{4}) (\\d+) (.+)");
        filelistPattern = Pattern.compile("^([fd]) (\\d+) (\\d+)(\\.\\d*)? (.+)", 32);
        logger = org.apache.log4j.Logger.getLogger((String)"dku.remotefiles.ssh");
    }

    protected static class FilterOutputStreamClosingChannel
    extends OutputStreamWrapper {
        private final Channel channel;

        public FilterOutputStreamClosingChannel(OutputStream out, Channel channel) {
            super(out);
            this.channel = channel;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
                if (this.channel instanceof ChannelExec) {
                    byte[] outd = IOUtils.toByteArray((InputStream)this.channel.getInputStream());
                    logger.info((Object)("Upload status is " + this.channel.getExitStatus() + " and " + outd.length + " bytes"));
                }
            }
            finally {
                logger.info((Object)"Close channel");
                this.channel.disconnect();
            }
        }
    }

    private static class LineArrayOutputStream
    extends OutputStream {
        List<String> out;
        TByteArrayList buf = new TByteArrayList();

        public LineArrayOutputStream(List<String> out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            if (b == 10) {
                this.out.add(new String(this.buf.toArray(), StandardCharsets.UTF_8));
                this.buf.clear();
            } else {
                this.buf.add((byte)b);
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.buf.isEmpty()) {
                this.out.add(new String(this.buf.toArray(), StandardCharsets.UTF_8));
            }
        }
    }

    protected static class TimeoutWatcher
    extends Thread {
        private Thread t;
        private long currentProgress = 0L;
        private int timeout;

        TimeoutWatcher(int timeout) {
            this.timeout = timeout;
            this.t = Thread.currentThread();
            this.start();
        }

        synchronized void progress() {
            ++this.currentProgress;
        }

        synchronized void done() {
            this.currentProgress = -1L;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                long prev = 0L;
                while (true) {
                    Thread.sleep(this.timeout);
                    TimeoutWatcher timeoutWatcher = this;
                    synchronized (timeoutWatcher) {
                        if (this.currentProgress == -1L) {
                            return;
                        }
                        if (this.currentProgress == prev) {
                            logger.debug((Object)("interrupting thread " + this.t.getName()));
                            this.t.interrupt();
                            return;
                        }
                        prev = this.currentProgress;
                    }
                }
            }
            catch (InterruptedException e) {
                logger.info((Object)"Wait thread interrupted");
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    protected static class DownloadProgressCopyCallback
    implements DKUIOUtils.CopyCallback {
        private final TimeoutWatcher watcher;
        private final long filesize;
        private long lastUpdate;

        public DownloadProgressCopyCallback(TimeoutWatcher watcher, long filesize) {
            this.watcher = watcher;
            this.filesize = filesize;
        }

        @Override
        public boolean update(long copied) {
            this.watcher.progress();
            if (this.lastUpdate == 0L || copied - this.lastUpdate > 1000000L) {
                logger.info((Object)("downloaded " + copied + "/" + this.filesize + " bytes"));
                this.lastUpdate = copied;
            }
            return true;
        }
    }

    private static class JSchLogger
    implements Logger {
        private static org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)"dku.remotefiles.ssh.jsch");

        private JSchLogger() {
        }

        Level getLevel(int level) {
            switch (level) {
                case 0: {
                    return Level.DEBUG;
                }
                case 1: {
                    return Level.INFO;
                }
                case 2: {
                    return Level.WARN;
                }
                default: {
                    return Level.ERROR;
                }
                case 4: 
            }
            return Level.FATAL;
        }

        public boolean isEnabled(int level) {
            return this.getLevel(level).isGreaterOrEqual((Priority)logger.getEffectiveLevel());
        }

        public void log(int level, String message) {
            logger.log((Priority)this.getLevel(level), (Object)message);
        }
    }

    protected static class FilterInputStreamClosingChannel
    extends FilterInputStream {
        private final Channel channel;

        public FilterInputStreamClosingChannel(InputStream in, Channel channel) {
            super(in);
            this.channel = channel;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.channel.disconnect();
            }
        }
    }
}

