/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.snowflakecortex;

import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SnowflakeCompletionRESTQuery {
    @Nonnull
    public String model;
    public List<Message> messages;
    @Nullable
    @SerializedName(value="max_tokens")
    public Integer maxTokens;
    @Nullable
    public Double temperature;
    @Nullable
    @SerializedName(value="top_p")
    public Double topP;
    public boolean stream = false;
    @Nullable
    @SerializedName(value="tool_choice")
    public ToolChoice toolChoice;
    @Nullable
    public List<FunctionTool> tools;

    public static class ToolResultContent {
        public String type = "text";
        public String text;
    }

    public static class ToolResult {
        @SerializedName(value="tool_use_id")
        public String toolUseId;
        public String name;
        public List<ToolResultContent> content = new ArrayList<ToolResultContent>();
    }

    public static class ToolResultWrapper
    extends ContentPart {
        @SerializedName(value="tool_results")
        public ToolResult result;

        public ToolResultWrapper() {
            super("tool_results");
        }
    }

    public static class ToolUse {
        @SerializedName(value="tool_use_id")
        public String toolUseId;
        public String name;
        public JsonObject input;
    }

    public static class ToolUseWrapper
    extends ContentPart {
        @SerializedName(value="tool_use")
        public ToolUse toolUse = new ToolUse();

        public ToolUseWrapper() {
            super("tool_use");
        }
    }

    public static class ImageContentDetails {
        public String type = "base64";
        public String content;
        @SerializedName(value="content_type")
        public String contentType;
    }

    public static class ImageContentPart
    extends UserContentPart {
        public ImageContentDetails details;

        public ImageContentPart() {
            super("image");
        }
    }

    public static class TextContentPart
    extends UserContentPart {
        public String text;

        public TextContentPart() {
            super("text");
        }
    }

    public static abstract class UserContentPart
    extends ContentPart {
        protected UserContentPart(String type) {
            super(type);
        }
    }

    @PolyJSON(value={@Mapping(value=TextContentPart.class, type="text"), @Mapping(value=ImageContentPart.class, type="image"), @Mapping(value=ToolUseWrapper.class, type="tool_use"), @Mapping(value=ToolResultWrapper.class, type="tool_results")})
    public static abstract class ContentPart {
        public String type;

        protected ContentPart(String type) {
            this.type = type;
        }
    }

    public static class AssistantMessage
    extends Message {
        @Nullable
        public String content;
        @Nullable
        @SerializedName(value="content_list")
        public List<ToolUseWrapper> contentList;

        public AssistantMessage() {
            super("assistant");
        }
    }

    public static class ToolMessage
    extends Message {
        @SerializedName(value="content_list")
        public List<ToolResultWrapper> contentList;

        public ToolMessage() {
            super("user");
        }
    }

    public static class CompositeUserMessage
    extends Message {
        @Nullable
        @SerializedName(value="content_list")
        public List<UserContentPart> contentList;

        public CompositeUserMessage() {
            super("user");
        }
    }

    public static class UserMessage
    extends Message {
        public String content;

        public UserMessage() {
            super("user");
        }
    }

    public static class SystemMessage
    extends Message {
        public String content;

        public SystemMessage() {
            super("system");
        }
    }

    public static abstract class Message {
        public String role;

        protected Message(String role) {
            this.role = role;
        }
    }

    public static class FunctionToolDesc {
        public String type;
        public String name;
        @Nullable
        public String description;
        @Nullable
        @SerializedName(value="input_schema")
        public JsonObject inputSchema;
    }

    public static class FunctionTool {
        @SerializedName(value="tool_spec")
        public FunctionToolDesc toolSpec = new FunctionToolDesc();
    }

    public static enum ToolChoiceType {
        auto,
        required,
        tool;

    }

    public static class ToolChoice {
        public ToolChoiceType type;
    }
}

