/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataflow.ActivityState;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.jobrunner.SerializedJobActivity;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.DataQualityRunOrigin;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.metrics.ChecksSet;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.MetricsService;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.metrics.probes.AdvancedStatsDatasetProbeType;
import com.dataiku.dip.metrics.probes.ReportingProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.dataquality.AbstractCheckReport;
import com.dataiku.dip.server.services.dataquality.DataQualityRulesLaunchService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetricsLaunchService {
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private MetricsComputationService metricsComputationService;
    @Autowired
    private MetricsService metricsService;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private DataQualityRulesLaunchService dataQualityRulesLaunchService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.metrics.launch");

    public Callable<String> onActivityDone(final AuthCtx authCtx, String jobProjectKey, String jobId, final SerializedJobActivityStatus sja) throws Exception {
        final ArrayList done = Lists.newArrayList();
        final MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
        environment.startedFromBuild = true;
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettings();
        environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
        environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
        for (SerializedJobActivity.Target target : sja.def.targets) {
            Partitionable object = null;
            MetricTargetType objectType = null;
            Partition partition = null;
            Dataset dataset = this.datasetAccessService.getOrNull(target.projectKey, target.datasetName);
            if (dataset != null) {
                partition = MetricsComputationService.makePartitionFromId(dataset.getPartitioningSchema(), target.partitionId);
                object = dataset;
                objectType = MetricTargetType.DATASET;
            }
            ManagedFolder folder = (ManagedFolder)this.managedFolderDAO.getOrNull(target.projectKey, target.datasetName);
            if (object == null && folder != null) {
                partition = MetricsComputationService.makePartitionFromId(folder.getPartitioningSchema(), target.partitionId);
                object = folder;
                objectType = MetricTargetType.MANAGED_FOLDER;
            }
            SavedModel model = (SavedModel)this.savedModelsDAO.getOrNull(target.projectKey, target.datasetName);
            if (object == null && model != null) {
                object = model;
                objectType = MetricTargetType.SAVED_MODEL;
                partition = MetricsComputationService.fakeSMVersionPartition(sja.targets.get((int)0).modelVersionId);
            }
            ModelEvaluationStore mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNull(target.projectKey, target.datasetName);
            if (object == null && mes != null) {
                object = mes;
                objectType = MetricTargetType.MODEL_EVALUATION_STORE;
                SerializedJobActivityStatus.SerializedTargetDS targetMES = sja.targets.stream().filter(t -> FlowComputable.FCType.MODEL_EVALUATION_STORE == t.type).findFirst().orElseThrow(() -> new IllegalArgumentException("No target is a Model Evaluation Store"));
                partition = MetricsComputationService.fakeMEVersionPartition(targetMES.evaluationId);
            }
            if (objectType == null) continue;
            ObjectInActivityDone item = new ObjectInActivityDone(object, objectType, partition, dataset, folder, model, mes);
            done.add(item);
        }
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                for (ObjectInActivityDone item : done) {
                    HashMap metricsValues = Maps.newHashMap();
                    metricsValues.put(new ReportingProbeType.ReportingMetric(ReportingProbeType.ReportingMetrics.WARNING_COUNT), Long.toString(sja.getWarningsTotalCount()));
                    metricsValues.put(new ReportingProbeType.ReportingMetric(ReportingProbeType.ReportingMetrics.BUILD_SUCCESS), Boolean.toString(sja.state == ActivityState.DONE));
                    metricsValues.put(new ReportingProbeType.ReportingMetric(ReportingProbeType.ReportingMetrics.BUILD_DURATION), Long.toString(sja.endTime - sja.startTime));
                    metricsValues.put(new ReportingProbeType.ReportingMetric(ReportingProbeType.ReportingMetrics.BUILD_START_DATE), DKUtils.isoFormatReadableByDateFormat((long)sja.startTime));
                    HashMap expandedMetricsValues = Maps.newHashMap();
                    for (Map.Entry metricValue : metricsValues.entrySet()) {
                        Metric metric = (Metric)metricValue.getKey();
                        expandedMetricsValues.put(metric, (String)metricValue.getValue());
                    }
                    MetricsLaunchService.this.metricsComputationService.saveMetricsValues(authCtx, item.object, item.objectType, item.partition, DateTime.now(), expandedMetricsValues, environment);
                }
                return "done";
            }
        };
    }

    public Callable<List<AbstractCheckReport>> startRunChecksForActivitySynchronously(final AuthCtx authCtx, final String jobProjectKey, final String jobId, SerializedJobActivityStatus sja) throws Exception {
        final ArrayList done = Lists.newArrayList();
        final MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
        environment.startedFromBuild = true;
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettings();
        environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
        environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
        for (SerializedJobActivity.Target target : sja.def.targets) {
            Partitionable object = null;
            MetricTargetType objectType = null;
            Partition partition = null;
            Dataset dataset = this.datasetAccessService.getOrNull(target.projectKey, target.datasetName);
            if (dataset != null) {
                partition = MetricsComputationService.makePartitionFromId(dataset.getPartitioningSchema(), target.partitionId);
                object = dataset;
                objectType = MetricTargetType.DATASET;
            }
            ManagedFolder folder = (ManagedFolder)this.managedFolderDAO.getOrNull(target.projectKey, target.datasetName);
            if (object == null && folder != null) {
                partition = MetricsComputationService.makePartitionFromId(folder.getPartitioningSchema(), target.partitionId);
                object = folder;
                objectType = MetricTargetType.MANAGED_FOLDER;
            }
            SavedModel model = (SavedModel)this.savedModelsDAO.getOrNull(target.projectKey, target.datasetName);
            if (object == null && model != null) {
                object = model;
                objectType = MetricTargetType.SAVED_MODEL;
                if (StringUtils.equals((String)sja.recipeType, (String)"python") || StringUtils.startsWith((String)sja.recipeType, (String)"CustomCode_")) continue;
                partition = MetricsComputationService.fakeSMVersionPartition(sja.targets.get((int)0).modelVersionId);
            }
            ModelEvaluationStore mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNull(target.projectKey, target.datasetName);
            if (object == null && mes != null) {
                object = mes;
                objectType = MetricTargetType.MODEL_EVALUATION_STORE;
                if (StringUtils.equals((String)sja.recipeType, (String)"python") || StringUtils.startsWith((String)sja.recipeType, (String)"CustomCode_")) continue;
                SerializedJobActivityStatus.SerializedTargetDS targetMES = sja.targets.stream().filter(t -> FlowComputable.FCType.MODEL_EVALUATION_STORE == t.type).findFirst().orElseThrow(() -> new IllegalArgumentException("No target is a Model Evaluation Store"));
                partition = MetricsComputationService.fakeMEVersionPartition(targetMES.evaluationId);
            }
            if (objectType == null) continue;
            ObjectInActivityDone item = new ObjectInActivityDone(object, objectType, partition, dataset, folder, model, mes);
            if (objectType == MetricTargetType.DATASET && dataset != null && partition != null && partition.isAll()) {
                try {
                    item.datasetHandler = DatasetHandlerFactory.build(authCtx, dataset);
                    done.add(item);
                }
                catch (Exception ex) {
                    logger.error((Object)("Failed build handler of " + dataset.getFullName()), (Throwable)ex);
                }
                continue;
            }
            if (objectType == MetricTargetType.MANAGED_FOLDER && folder != null && partition != null && partition.isAll()) {
                try {
                    item.folderHandler = (ManagedFolderHandler)folder.buildHandler(authCtx);
                    done.add(item);
                }
                catch (Exception ex) {
                    logger.error((Object)("Failed build handler of " + folder.getFullName()), (Throwable)ex);
                }
                continue;
            }
            done.add(item);
        }
        return new Callable<List<AbstractCheckReport>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AbstractCheckReport> call() throws Exception {
                ArrayList expanded = Lists.newArrayList();
                for (ObjectInActivityDone item : done) {
                    if (item.datasetHandler != null) {
                        try {
                            for (Partition p : item.datasetHandler.listPartitions()) {
                                expanded.add(item.withPartition(p));
                            }
                            expanded.add(item);
                            continue;
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Failed to list partitions of " + item.dataset.getFullName()), (Throwable)ex);
                            continue;
                        }
                        finally {
                            item.datasetHandler.close();
                            continue;
                        }
                    }
                    if (item.folderHandler != null) {
                        try {
                            for (Partition p : item.folderHandler.listPartitions()) {
                                expanded.add(item.withPartition(p));
                            }
                            expanded.add(item);
                        }
                        catch (Exception ex) {
                            logger.error((Object)("Failed to list partitions of " + item.folder.getFullName()), (Throwable)ex);
                        }
                        continue;
                    }
                    expanded.add(item);
                }
                ArrayList reports = Lists.newArrayList();
                for (ObjectInActivityDone item : expanded) {
                    HashMap metricsValues = Maps.newHashMap();
                    if (item.objectType == MetricTargetType.SAVED_MODEL) {
                        MetricsLaunchService.this.metricsComputationService.scoopSavedModelMetrics(item.model, item.partition, metricsValues);
                    } else if (item.objectType == MetricTargetType.MODEL_EVALUATION_STORE) {
                        MetricsLaunchService.this.metricsComputationService.scoopMESMetrics(item.mes, item.partition, metricsValues);
                    }
                    HashMap expandedMetricsValues = Maps.newHashMap();
                    for (Map.Entry metricValue : metricsValues.entrySet()) {
                        Metric metric = (Metric)metricValue.getKey();
                        expandedMetricsValues.put(metric, (String)metricValue.getValue());
                    }
                    if (expandedMetricsValues.size() > 0) {
                        MetricsLaunchService.this.metricsComputationService.saveMetricsValues(authCtx, item.object, item.objectType, item.partition, DateTime.now(), expandedMetricsValues, environment);
                    }
                    MetricsEngineDesc.MetricsEngineContext context = new MetricsEngineDesc.MetricsEngineContext(authCtx);
                    Object fr = null;
                    DataQualityRunOrigin.Build runOrigin = new DataQualityRunOrigin.Build(jobProjectKey, jobId);
                    switch (item.objectType) {
                        case DATASET: {
                            List<DataQualityRule> rules = item.dataset.getModel().getDataQualityRuleSet().getAutoRunRules();
                            fr = MetricsLaunchService.this.dataQualityRulesLaunchService.computeRulesOnSinglePartition(authCtx, item.dataset, rules, item.partition.id(), DataQualityRulesLaunchService.RunOptions.fromBuildJob(jobProjectKey, jobId));
                            break;
                        }
                        case MANAGED_FOLDER: {
                            fr = MetricsLaunchService.this.launchComputeMetricsAndRunChecks(authCtx, item.folder, item.partition, context, environment, (DataQualityRunOrigin)runOrigin);
                            break;
                        }
                        case SAVED_MODEL: {
                            fr = MetricsLaunchService.this.launchComputeMetricsAndRunChecks(authCtx, item.model, item.partition.id(), context, environment, (DataQualityRunOrigin)runOrigin);
                            break;
                        }
                        case MODEL_EVALUATION_STORE: {
                            fr = MetricsLaunchService.this.launchComputeMetricsAndRunChecks(authCtx, item.mes, item.partition.id(), context, environment, (DataQualityRunOrigin)runOrigin);
                            break;
                        }
                        case PROJECT: {
                            break;
                        }
                        default: {
                            throw new NotImplementedException();
                        }
                    }
                    if (fr == null) continue;
                    fr = MetricsLaunchService.this.futureService.waitForFinalResponse((FutureResponse)fr);
                    reports.add((AbstractCheckReport)fr.result);
                }
                return reports;
            }
        };
    }

    public Callable<List<AbstractCheckReport>> onJobDone(final AuthCtx user, Set<String> datasetsFullName, final String jobProjectKey, final String jobId) throws Exception {
        final MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettings();
        environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
        environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
        environment.startedFromBuild = true;
        final ArrayList partitioneds = Lists.newArrayList();
        for (String datasetFullName : datasetsFullName) {
            Dataset dataset = this.datasetAccessService.getOrNull(DatasetLocUtils.DatasetLoc.resolveFull(datasetFullName));
            if (dataset != null) {
                partitioneds.add(dataset);
                continue;
            }
            ManagedFolder folder = (ManagedFolder)this.managedFolderDAO.getOrNull(DatasetLocUtils.DatasetLoc.resolveFull(datasetFullName));
            if (folder == null) continue;
            partitioneds.add(folder);
        }
        return new Callable<List<AbstractCheckReport>>(){

            @Override
            public List<AbstractCheckReport> call() throws Exception {
                ArrayList reports = Lists.newArrayList();
                for (Partitionable partitioned : partitioneds) {
                    PartitioningScheme partitioningScheme = partitioned.getPartitioningSchema();
                    if (partitioningScheme == null || !partitioningScheme.isPartitioned()) continue;
                    MetricsEngineDesc.MetricsEngineContext context = new MetricsEngineDesc.MetricsEngineContext(user);
                    FutureResponse fr = null;
                    DataQualityRunOrigin.Build runOrigin = new DataQualityRunOrigin.Build(jobProjectKey, jobId);
                    if (partitioned instanceof Dataset) {
                        List<DataQualityRule> rules = ((Dataset)partitioned).getModel().getDataQualityRuleSet().getAutoRunRules();
                        fr = MetricsLaunchService.this.dataQualityRulesLaunchService.computeRulesOnFullDataset(user, (Dataset)partitioned, rules, DataQualityRulesLaunchService.RunOptions.fromBuildJob(jobProjectKey, jobId));
                    } else {
                        if (!(partitioned instanceof ManagedFolder)) continue;
                        fr = MetricsLaunchService.this.launchComputeMetricsAndRunChecks(user, (ManagedFolder)partitioned, Partition.newALL((PartitioningScheme)partitioningScheme), context, environment, (DataQualityRunOrigin)runOrigin);
                    }
                    if (fr == null) continue;
                    fr = MetricsLaunchService.this.futureService.waitForFinalResponse(fr);
                    reports.add((AbstractCheckReport)fr.result);
                }
                return reports;
            }
        };
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReport> computeDetailedColumnMetrics_NT(String columnName, String partitionId, boolean forceRefresh, Dataset dataset, AuthCtx user, MetricsComputationService.MetricsComputationEnvironment metricsEnvironment, SerializedShakerScript.FullSampleStatisticsConfig statisticsConfig) throws Exception {
        ProbesSet metrics;
        TransactionContext.assertNoAttachedTransaction();
        PartitioningScheme partitioningScheme = dataset.getPartitioningSchema();
        Partition partition = partitioningScheme != null && partitioningScheme.isPartitioned() ? (StringUtils.isNotBlank((String)partitionId) ? MetricsComputationService.makePartitionFromId(partitioningScheme, partitionId) : Partition.newALL((PartitioningScheme)partitioningScheme)) : Partition.newNP();
        if (forceRefresh || StringUtils.isBlank((String)columnName)) {
            metrics = StringUtils.isNotBlank((String)columnName) ? this.metricsService.subsetProbesForColumn(dataset, columnName, statisticsConfig) : this.metricsService.subsetProbesForAllColumns(dataset, statisticsConfig);
        } else {
            DataService.FullSampleColumnDetailedAnalysis detailedMetrics = this.metricsService.getDetailedColumnMetrics_NT(dataset, columnName, partition, user);
            boolean needsMin = detailedMetrics.categorical.min == null || !detailedMetrics.categorical.min.current;
            boolean needsMax = detailedMetrics.categorical.max == null || !detailedMetrics.categorical.max.current;
            boolean needsCount = detailedMetrics.categorical.count == null || !detailedMetrics.categorical.count.current;
            boolean needsCountDistinct = detailedMetrics.categorical.countDistinct == null || !detailedMetrics.categorical.countDistinct.current;
            boolean needsCountMissing = detailedMetrics.categorical.countMissing == null || !detailedMetrics.categorical.countMissing.current;
            boolean needsCountInvalid = detailedMetrics.categorical.countInvalid == null || !detailedMetrics.categorical.countInvalid.current;
            boolean needsMode = detailedMetrics.categorical.mode == null || !detailedMetrics.categorical.mode.current;
            boolean needsTopk = detailedMetrics.categorical.top10 == null || !detailedMetrics.categorical.top10.current;
            boolean needsMean = detailedMetrics.numeric != null && (detailedMetrics.numeric.mean == null || !detailedMetrics.numeric.mean.current);
            boolean needsSum = detailedMetrics.numeric != null && (detailedMetrics.numeric.sum == null || !detailedMetrics.numeric.sum.current);
            boolean needsStddev = detailedMetrics.numeric != null && (detailedMetrics.numeric.stddev == null || !detailedMetrics.numeric.stddev.current);
            boolean needsTopValue = !new AdvancedStatsDatasetProbeType.AdvancedStatsDatasetProbeConfiguration().numberTopValues.equals(statisticsConfig.numberTopValues);
            statisticsConfig.basic = statisticsConfig.basic & (needsMin || needsMax || needsCount || needsCountMissing || needsMean || needsStddev || needsSum);
            statisticsConfig.countDistinct &= needsCountDistinct;
            statisticsConfig.advanced = statisticsConfig.advanced & (needsMode || needsTopk || needsTopValue);
            statisticsConfig.validity &= needsCountInvalid;
            metrics = this.metricsService.subsetProbesForColumn(dataset, columnName, statisticsConfig);
        }
        return this.launchComputeMetrics(user, dataset, partition, metrics, new MetricsEngineDesc.MetricsEngineContext(user), metricsEnvironment);
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReport> launchComputeMetrics(AuthCtx user, Dataset dataset, Partition partition, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        ProbesSet metrics = dataset.getModel().getMetrics();
        return this.launchComputeMetrics(user, dataset, partition, metrics, context, environment);
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReport> launchComputeMetrics(AuthCtx user, Dataset dataset, Partition partition, ProbesSet metrics, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        ComputeMetricsThread ft = new ComputeMetricsThread((DSSAuthCtx)user, dataset, MetricTargetType.DATASET, partition, metrics, context, environment);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<MetricsComputationService.MetricsComputationReport>>(){});
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReport> launchComputeMetrics(AuthCtx user, ManagedFolder folder, Partition partition, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        ProbesSet metrics = folder.metrics;
        return this.launchComputeMetrics(user, folder, partition, metrics, context, environment);
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReport> launchComputeMetrics(AuthCtx user, ManagedFolder folder, Partition partition, ProbesSet metrics, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        ComputeMetricsThread ft = new ComputeMetricsThread((DSSAuthCtx)user, folder, MetricTargetType.MANAGED_FOLDER, partition, metrics, context, environment);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<MetricsComputationService.MetricsComputationReport>>(){});
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReport> launchComputeMetrics(AuthCtx user, ModelEvaluationStore mes, Partition partition, ProbesSet metrics, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        ComputeMetricsThread ft = new ComputeMetricsThread((DSSAuthCtx)user, mes, MetricTargetType.MODEL_EVALUATION_STORE, partition, metrics, context, environment);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<MetricsComputationService.MetricsComputationReport>>(){});
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReport> launchComputeMetrics(AuthCtx user, ModelEvaluationStore mes, Partition partition, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        ProbesSet metrics = mes.metrics;
        return this.launchComputeMetrics(user, mes, partition, metrics, context, environment);
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReport> launchComputeMetrics(AuthCtx user, SavedModel model, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        ProbesSet metrics = model.metrics;
        return this.launchComputeMetrics(user, model, metrics, context, environment);
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReport> launchComputeMetrics(AuthCtx user, SavedModel model, ProbesSet metrics, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        ComputeMetricsThread ft = new ComputeMetricsThread((DSSAuthCtx)user, model, MetricTargetType.SAVED_MODEL, null, metrics, context, environment);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<MetricsComputationService.MetricsComputationReport>>(){});
    }

    public FutureResponse<AbstractCheckReport.MetricsCheckReport> launchRunChecks(AuthCtx user, ManagedFolder folder, Partition partition, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) throws Exception {
        ChecksSet checks = folder.checks;
        return this.launchRunChecks(user, folder, partition, checks, environment, runOrigin);
    }

    public FutureResponse<AbstractCheckReport.MetricsCheckReport> launchRunChecks(AuthCtx user, ManagedFolder folder, Partition partition, ChecksSet checks, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) throws Exception {
        RunMFChecksThread ft = new RunMFChecksThread(user, folder, partition, checks, environment, runOrigin);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<AbstractCheckReport.MetricsCheckReport>>(){});
    }

    public FutureResponse<AbstractCheckReport.MetricsCheckReport> launchRunChecksOnSMVersion(AuthCtx user, SavedModel sm, String version, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) throws Exception {
        RunSMVersionChecksThread ft = new RunSMVersionChecksThread(user, sm, version, sm.metricsChecks, environment, runOrigin);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<AbstractCheckReport.MetricsCheckReport>>(){});
    }

    public FutureResponse<AbstractCheckReport.MetricsCheckReport> launchRunChecksOnSMVersion(AuthCtx user, SavedModel sm, String version, ChecksSet checks, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) throws Exception {
        RunSMVersionChecksThread ft = new RunSMVersionChecksThread(user, sm, version, checks, environment, runOrigin);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<AbstractCheckReport.MetricsCheckReport>>(){});
    }

    public FutureResponse<AbstractCheckReport.MetricsCheckReport> launchRunChecks(AuthCtx user, ModelEvaluationStore mes, String evaluationId, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) throws Exception {
        ChecksSet checks = mes.metricsChecks;
        return this.launchRunChecks(user, mes, evaluationId, checks, environment, runOrigin);
    }

    public FutureResponse<AbstractCheckReport.MetricsCheckReport> launchRunChecks(AuthCtx user, ModelEvaluationStore mes, String evaluationId, ChecksSet checks, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) throws Exception {
        RunMEChecksThread ft = new RunMEChecksThread(user, mes, evaluationId, checks, environment, runOrigin);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<AbstractCheckReport.MetricsCheckReport>>(){});
    }

    public FutureResponse<MetricsComputationService.MetricsCheckReportsAndPartitions> launchRunChecksOnAllPartitions(AuthCtx user, ManagedFolder folder, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) throws Exception {
        return this.launchRunChecksOnAllPartitions(user, folder, folder.checks, environment, runOrigin);
    }

    public FutureResponse<MetricsComputationService.MetricsCheckReportsAndPartitions> launchRunChecksOnAllPartitions(AuthCtx user, ManagedFolder folder, ChecksSet checksSet, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) throws Exception {
        ComputeCheckValuesOnAllPartitionsThread ft = new ComputeCheckValuesOnAllPartitionsThread(user, folder, checksSet, environment, runOrigin);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<MetricsComputationService.MetricsCheckReportsAndPartitions>>(){});
    }

    public FutureResponse<MetricsComputationService.MetricsCheckReportsAndPartitions> launchRunChecksOnAllPartitions(AuthCtx user, ModelEvaluationStore mes, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) throws Exception {
        return this.launchRunChecksOnAllPartitions(user, mes, mes.metricsChecks, environment, runOrigin);
    }

    public FutureResponse<MetricsComputationService.MetricsCheckReportsAndPartitions> launchRunChecksOnAllPartitions(AuthCtx user, ModelEvaluationStore mes, ChecksSet checksSet, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) throws Exception {
        List<String> runIds = this.modelEvaluationStoresCRUDService.listRunIds(mes);
        List<Partition> partitions = runIds.stream().map(MetricsComputationService::fakeMEVersionPartition).collect(Collectors.toList());
        ComputeCheckValuesOnAllPartitionsThread ft = new ComputeCheckValuesOnAllPartitionsThread(user, mes, partitions, checksSet, environment, runOrigin);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<MetricsComputationService.MetricsCheckReportsAndPartitions>>(){});
    }

    private FutureResponse<AbstractCheckReport.MetricsCheckReport> launchComputeMetricsAndRunChecks(AuthCtx user, SavedModel savedModel, String version, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) throws Exception {
        ProbesSet metrics = savedModel.metrics;
        ChecksSet checks = savedModel.metricsChecks;
        ComputeMetricsAndRunChecksOnAnyObjectThread ft = new ComputeMetricsAndRunChecksOnAnyObjectThread((DSSAuthCtx)user, savedModel, MetricsComputationService.fakeSMVersionPartition(version), metrics, checks, context, environment, runOrigin);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<AbstractCheckReport.MetricsCheckReport>>(){});
    }

    private FutureResponse<AbstractCheckReport.MetricsCheckReport> launchComputeMetricsAndRunChecks(AuthCtx user, ModelEvaluationStore modelEvaluationStore, String evaluationId, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) throws Exception {
        ProbesSet metrics = modelEvaluationStore.metrics;
        ChecksSet checks = modelEvaluationStore.metricsChecks;
        ComputeMetricsAndRunChecksOnAnyObjectThread ft = new ComputeMetricsAndRunChecksOnAnyObjectThread((DSSAuthCtx)user, modelEvaluationStore, MetricsComputationService.fakeMEVersionPartition(evaluationId), metrics, checks, context, environment, runOrigin);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<AbstractCheckReport.MetricsCheckReport>>(){});
    }

    private FutureResponse<AbstractCheckReport.MetricsCheckReport> launchComputeMetricsAndRunChecks(AuthCtx user, ManagedFolder folder, Partition partition, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) throws Exception {
        ProbesSet metrics = folder.metrics;
        ChecksSet checks = folder.checks;
        ComputeMetricsAndRunChecksOnAnyObjectThread ft = new ComputeMetricsAndRunChecksOnAnyObjectThread((DSSAuthCtx)user, folder, partition, metrics, checks, context, environment, runOrigin);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<AbstractCheckReport.MetricsCheckReport>>(){});
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReportsAndPartitions> launchComputeMetricsOnAllAndAllPartitions(AuthCtx user, Dataset dataset, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        return this.launchComputeMetricsOnAllAndAllPartitions(user, dataset, dataset.getModel().getMetrics(), environment);
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReportsAndPartitions> launchComputeMetricsOnAllAndAllPartitions(AuthCtx user, Dataset dataset, ProbesSet probesSet, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        ComputeMetricValuesOnAllAndAllPartitionsThread ft = new ComputeMetricValuesOnAllAndAllPartitionsThread(user, MetricTargetType.DATASET, dataset, probesSet, environment, true);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<MetricsComputationService.MetricsComputationReportsAndPartitions>>(){});
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReportsAndPartitions> launchComputeMetricsOnAllAndAllPartitions(AuthCtx user, ManagedFolder folder, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        return this.launchComputeMetricsOnAllAndAllPartitions(user, folder, folder.metrics, environment);
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReportsAndPartitions> launchComputeMetricsOnAllAndAllPartitions(AuthCtx user, ManagedFolder folder, ProbesSet probesSet, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        ComputeMetricValuesOnAllAndAllPartitionsThread ft = new ComputeMetricValuesOnAllAndAllPartitionsThread(user, MetricTargetType.MANAGED_FOLDER, folder, probesSet, environment, true);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<MetricsComputationService.MetricsComputationReportsAndPartitions>>(){});
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReportsAndPartitions> launchComputeMetricsOnAllPartitions(AuthCtx user, Dataset dataset, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        return this.launchComputeMetricsOnAllPartitions(user, dataset, dataset.getModel().getMetrics(), environment);
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReportsAndPartitions> launchComputeMetricsOnAllPartitions(AuthCtx user, Dataset dataset, ProbesSet probesSet, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        ComputeMetricValuesOnAllAndAllPartitionsThread ft = new ComputeMetricValuesOnAllAndAllPartitionsThread(user, MetricTargetType.DATASET, dataset, probesSet, environment, false);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<MetricsComputationService.MetricsComputationReportsAndPartitions>>(){});
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReportsAndPartitions> launchComputeMetricsOnAllPartitions(AuthCtx user, ManagedFolder folder, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        return this.launchComputeMetricsOnAllPartitions(user, folder, folder.metrics, environment);
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReportsAndPartitions> launchComputeMetricsOnAllPartitions(AuthCtx user, ManagedFolder folder, ProbesSet probesSet, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        ComputeMetricValuesOnAllAndAllPartitionsThread ft = new ComputeMetricValuesOnAllAndAllPartitionsThread(user, MetricTargetType.MANAGED_FOLDER, folder, probesSet, environment, false);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<MetricsComputationService.MetricsComputationReportsAndPartitions>>(){});
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReports> launchComputeMetricsWithExplicitPartitions(AuthCtx user, Dataset dataset, List<Partition> partitions, ProbesSet metrics, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        Validate.notNull(partitions);
        for (Partition p : partitions) {
            Validate.isTrue((!p.id().equals("ALL") ? 1 : 0) != 0);
        }
        ComputeMetricValuesOnExplicitPartitionsThread ft = new ComputeMetricValuesOnExplicitPartitionsThread(user, dataset, partitions, metrics, environment);
        return this.futureService.runFuture(ft, 10L, new TypeToken<FutureResponse<MetricsComputationService.MetricsComputationReports>>(){});
    }

    public FutureResponse<MetricsComputationService.MetricsComputationReports> launchComputeMetricsWithExplicitPartitionIds(AuthCtx user, Dataset dataset, List<String> partitionIds, ProbesSet metrics, MetricsComputationService.MetricsComputationEnvironment environment) throws Exception {
        Validate.notNull(partitionIds);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (String partitionId : partitionIds) {
            partitions.add(PartitionFactory.fromIdentifier(dataset.getPartitioningSchema(), partitionId));
        }
        return this.launchComputeMetricsWithExplicitPartitions(user, dataset, partitions, metrics, environment);
    }

    public static FuturePayload buildFuturePayload(Dataset dataset, boolean metrics, boolean checks, boolean all) {
        return MetricsLaunchService.buildFuturePayload(DSSFuturePayloadUtils.forDataset(dataset), "dataset", metrics, checks, all);
    }

    public static FuturePayload buildFuturePayload(ManagedFolder folder, boolean metrics, boolean checks, boolean all) {
        return MetricsLaunchService.buildFuturePayload(DSSFuturePayloadUtils.forTaggableObject(folder), "folder", metrics, checks, all);
    }

    public static FuturePayload buildFuturePayload(SavedModel model, boolean metrics, boolean checks) {
        return MetricsLaunchService.buildFuturePayload(DSSFuturePayloadUtils.forTaggableObject(model), "model", metrics, checks, false);
    }

    public static FuturePayload buildFuturePayload(ModelEvaluationStore mes, boolean metrics, boolean checks, boolean all) {
        return MetricsLaunchService.buildFuturePayload(DSSFuturePayloadUtils.forTaggableObject(mes), "model", metrics, checks, all);
    }

    public static FuturePayload buildFuturePayload(FuturePayload.FuturePayloadTarget object, String displayType, boolean metrics, boolean checks, boolean all) {
        FuturePayload fp = new FuturePayload();
        fp.action = (metrics ? "metrics_" : "") + (checks ? "checks_" : "") + "computation";
        fp = fp.withExtra("all", (Object)all).withExtra("metrics", (Object)metrics).withExtra("checks", (Object)checks);
        fp.targets.add(object);
        String name = object.name;
        String projectKey = object.projectKey;
        fp.displayName = metrics && checks ? (all ? "Compute all metrics and checks on " : "Compute metrics and checks on ") + displayType + " " + name + " (" + projectKey + ")" : (metrics ? (all ? "Compute all metrics on " : "Compute metrics on ") + displayType + " " + name + " (" + projectKey + ")" : (all ? "Compute all checks on " : "Compute checks on ") + displayType + " " + name + " (" + projectKey + ")");
        return fp;
    }

    private class ObjectInActivityDone {
        Object object;
        MetricTargetType objectType;
        Partition partition;
        Dataset dataset;
        ManagedFolder folder;
        SavedModel model;
        DatasetHandler datasetHandler;
        ManagedFolderHandler folderHandler;
        ModelEvaluationStore mes;

        ObjectInActivityDone(Object object, MetricTargetType objectType, Partition partition, Dataset dataset, ManagedFolder folder, SavedModel model, ModelEvaluationStore mes) {
            this.object = object;
            this.objectType = objectType;
            this.partition = partition;
            this.dataset = dataset;
            this.folder = folder;
            this.model = model;
            this.mes = mes;
        }

        public ObjectInActivityDone withPartition(Partition p) {
            return new ObjectInActivityDone(this.object, this.objectType, p, this.dataset, this.folder, this.model, this.mes);
        }
    }

    private class ComputeMetricsThread
    extends FutureThread<MetricsComputationService.MetricsComputationReport> {
        private ProbesSet metrics;
        private Partition partition;
        private Object object;
        private MetricTargetType objectType;
        private MetricsComputationService.MetricsComputationReport computed;
        private MetricsEngineDesc.MetricsEngineContext context;
        private MetricsComputationService.MetricsComputationEnvironment environment;
        private final FuturePayload futurePayload;
        private final String objectInfoForStartDoneMessage;

        public ComputeMetricsThread(DSSAuthCtx user, Object object, MetricTargetType objectType, Partition partition, ProbesSet metrics, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationService.MetricsComputationEnvironment environment) {
            super(user);
            this.object = object;
            this.objectType = objectType;
            this.partition = partition;
            this.metrics = metrics;
            this.context = context;
            this.environment = environment;
            switch (objectType) {
                case DATASET: {
                    this.futurePayload = MetricsLaunchService.buildFuturePayload((Dataset)object, true, false, false);
                    this.objectInfoForStartDoneMessage = "dataset:" + ((Dataset)object).getFullName();
                    break;
                }
                case MANAGED_FOLDER: {
                    this.futurePayload = MetricsLaunchService.buildFuturePayload((ManagedFolder)object, true, false, false);
                    this.objectInfoForStartDoneMessage = "managed_folder:" + ((ManagedFolder)object).getFullId();
                    break;
                }
                case MODEL_EVALUATION_STORE: {
                    this.futurePayload = MetricsLaunchService.buildFuturePayload((ModelEvaluationStore)object, true, false, false);
                    this.objectInfoForStartDoneMessage = "mes:" + ((ModelEvaluationStore)object).getFullId();
                    break;
                }
                case SAVED_MODEL: {
                    this.futurePayload = MetricsLaunchService.buildFuturePayload((SavedModel)object, true, false);
                    this.objectInfoForStartDoneMessage = "saved_model:" + ((SavedModel)object).getFullId();
                    break;
                }
                default: {
                    throw new Error("unreachable");
                }
            }
        }

        public String getPayloadForStartDoneMessage() {
            return this.objectInfoForStartDoneMessage;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public MetricsComputationService.MetricsComputationReport getResult() {
            return this.computed;
        }

        public void execute() throws Exception {
            try {
                this.computed = MetricsLaunchService.this.metricsComputationService.computeMetrics(this.owner, this.object, this.objectType, this.partition, this.metrics, this.context, this.environment);
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to compute metrics", (Throwable)ex);
                throw ex;
            }
        }
    }

    private class RunMFChecksThread
    extends SimpleFutureThread<AbstractCheckReport.MetricsCheckReport> {
        private ChecksSet checks;
        private ManagedFolder mf;
        private Partition partition;
        private MetricsComputationService.MetricsComputationEnvironment environment;
        private FuturePayload futurePayload;
        private DataQualityRunOrigin runOrigin;

        public RunMFChecksThread(AuthCtx user, ManagedFolder mf, Partition partition, ChecksSet checks, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) {
            super(user);
            this.mf = mf;
            this.partition = partition;
            this.checks = checks;
            this.environment = environment;
            this.futurePayload = MetricsLaunchService.buildFuturePayload(mf, false, true, false);
            this.runOrigin = runOrigin;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public AbstractCheckReport.MetricsCheckReport compute() throws Exception {
            try {
                return MetricsLaunchService.this.metricsComputationService.checkManagedFolder(this.owner, this.mf, this.partition, this.checks, this.environment, this.runOrigin);
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to run checks", (Throwable)ex);
                throw ex;
            }
        }
    }

    private class RunSMVersionChecksThread
    extends SimpleFutureThread<AbstractCheckReport.MetricsCheckReport> {
        private ChecksSet checks;
        private String version;
        private SavedModel sm;
        private MetricsComputationService.MetricsComputationEnvironment environment;
        private FuturePayload futurePayload;
        private final DataQualityRunOrigin runOrigin;

        public RunSMVersionChecksThread(AuthCtx user, SavedModel sm, String version, ChecksSet metrics, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) {
            super(user);
            this.sm = sm;
            this.version = version;
            this.checks = metrics;
            this.environment = environment;
            this.futurePayload = MetricsLaunchService.buildFuturePayload(sm, false, true);
            this.runOrigin = runOrigin;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public AbstractCheckReport.MetricsCheckReport compute() throws Exception {
            try {
                return MetricsLaunchService.this.metricsComputationService.checkSavedModelVersion(this.owner, this.sm, this.version, this.checks, this.environment, this.runOrigin);
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to run checks", (Throwable)ex);
                throw ex;
            }
        }
    }

    private class RunMEChecksThread
    extends SimpleFutureThread<AbstractCheckReport.MetricsCheckReport> {
        private ChecksSet checks;
        private ModelEvaluationStore mes;
        private String evaluationId;
        private MetricsComputationService.MetricsComputationEnvironment environment;
        private FuturePayload futurePayload;
        private final DataQualityRunOrigin runOrigin;

        public RunMEChecksThread(AuthCtx user, ModelEvaluationStore mes, String evaluationId, ChecksSet metrics, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) {
            super(user);
            this.mes = mes;
            this.evaluationId = evaluationId;
            this.checks = metrics;
            this.environment = environment;
            this.futurePayload = MetricsLaunchService.buildFuturePayload(mes, false, true, false);
            this.runOrigin = runOrigin;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public AbstractCheckReport.MetricsCheckReport compute() throws Exception {
            try {
                return MetricsLaunchService.this.metricsComputationService.checkModelEvaluation(this.owner, this.mes, this.evaluationId, this.checks, this.environment, this.runOrigin);
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to run checks", (Throwable)ex);
                throw ex;
            }
        }
    }

    private class ComputeCheckValuesOnAllPartitionsThread
    extends SimpleFutureThread<MetricsComputationService.MetricsCheckReportsAndPartitions> {
        private ChecksSet checksSet;
        private MetricTargetType objectType;
        private Partitionable dataset;
        private ManagedFolderHandler folderHandler;
        private List<Partition> mesPartitions;
        private MetricsComputationService.MetricsComputationEnvironment environment;
        private final FuturePayload futurePayload;
        private final DataQualityRunOrigin runOrigin;

        public ComputeCheckValuesOnAllPartitionsThread(AuthCtx user, ManagedFolder folder, ChecksSet checksSet, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) {
            super(user);
            this.objectType = MetricTargetType.MANAGED_FOLDER;
            this.dataset = folder;
            this.folderHandler = (ManagedFolderHandler)folder.buildHandler(user);
            this.checksSet = checksSet;
            this.environment = environment;
            this.mesPartitions = null;
            this.futurePayload = MetricsLaunchService.buildFuturePayload(folder, false, true, true);
            this.runOrigin = runOrigin;
        }

        public ComputeCheckValuesOnAllPartitionsThread(AuthCtx user, ModelEvaluationStore mes, List<Partition> mesPartitions, ChecksSet checksSet, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) {
            super(user);
            this.objectType = MetricTargetType.MODEL_EVALUATION_STORE;
            this.dataset = mes;
            this.folderHandler = null;
            this.checksSet = checksSet;
            this.environment = environment;
            this.mesPartitions = mesPartitions;
            this.futurePayload = MetricsLaunchService.buildFuturePayload(mes, false, true, true);
            this.runOrigin = runOrigin;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public MetricsComputationService.MetricsCheckReportsAndPartitions compute() throws Exception {
            MetricsComputationService.MetricsCheckReportsAndPartitions ret = new MetricsComputationService.MetricsCheckReportsAndPartitions();
            try {
                MetricsEngineDesc.MetricsEngineContext context = new MetricsEngineDesc.MetricsEngineContext(this.owner);
                this.initPartitions(context);
                try (FutureProgress.AutocloseableFutureProgressState afp = FutureProgress.pushAutoCloseableState((String)"Updating partitions", (double)context.partitions.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    for (Partition partition : context.partitions) {
                        AbstractCheckReport.MetricsCheckReport report;
                        switch (this.objectType) {
                            case MANAGED_FOLDER: {
                                report = MetricsLaunchService.this.metricsComputationService.checkManagedFolder(this.owner, (ManagedFolder)this.dataset, partition, this.checksSet, this.environment, this.runOrigin);
                                report.description = String.format("dataset:%s partition:%s", this.dataset.getFullName(), partition.id());
                                break;
                            }
                            case MODEL_EVALUATION_STORE: {
                                report = MetricsLaunchService.this.metricsComputationService.checkModelEvaluation(this.owner, (ModelEvaluationStore)this.dataset, partition.id(), this.checksSet, this.environment, this.runOrigin);
                                report.description = String.format("store:%s run:%s", this.dataset.getFullName(), partition.id());
                                break;
                            }
                            default: {
                                throw new NotImplementedException("Only dataset, folder and model evaluations can have partitions (or runs)");
                            }
                        }
                        ret.reports.add(report);
                        afp.increment(1.0);
                    }
                }
                ret.partitionIds = context.partitions.stream().map(Partition::id).collect(Collectors.toSet());
                MetricsComputationService.MetricsCheckReportsAndPartitions metricsCheckReportsAndPartitions = ret;
                return metricsCheckReportsAndPartitions;
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to compute metrics", (Throwable)ex);
                throw ex;
            }
            finally {
                if (this.folderHandler != null) {
                    this.folderHandler.close();
                }
            }
        }

        private void initPartitions(MetricsEngineDesc.MetricsEngineContext context) throws Exception {
            switch (this.objectType) {
                case MANAGED_FOLDER: {
                    context.partitions = this.folderHandler.listPartitions();
                    break;
                }
                case MODEL_EVALUATION_STORE: {
                    context.partitions = this.mesPartitions;
                    break;
                }
                default: {
                    throw new NotImplementedException("Only dataset, folder and model evaluations can have partitions (or runs)");
                }
            }
        }
    }

    private class ComputeMetricsAndRunChecksOnAnyObjectThread
    extends FutureThread<AbstractCheckReport.MetricsCheckReport> {
        private ChecksSet checks;
        private ProbesSet metrics;
        private Partition partition;
        private Object object;
        private MetricTargetType type;
        private AbstractCheckReport.MetricsCheckReport checkResults;
        private MetricsEngineDesc.MetricsEngineContext context;
        private MetricsComputationService.MetricsComputationEnvironment environment;
        private FuturePayload futurePayload;
        private final DataQualityRunOrigin runOrigin;

        private ComputeMetricsAndRunChecksOnAnyObjectThread(DSSAuthCtx user, Partition partition, ProbesSet metrics, ChecksSet checks, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) {
            super(user);
            this.partition = partition;
            this.metrics = metrics;
            this.checks = checks;
            this.context = context;
            this.environment = environment;
            this.runOrigin = runOrigin;
        }

        public ComputeMetricsAndRunChecksOnAnyObjectThread(DSSAuthCtx user, ManagedFolder managedFolder, Partition partition, ProbesSet metrics, ChecksSet checks, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) {
            this(user, partition, metrics, checks, context, environment, runOrigin);
            this.type = MetricTargetType.MANAGED_FOLDER;
            this.object = managedFolder;
            this.futurePayload = MetricsLaunchService.buildFuturePayload(managedFolder, true, true, false);
        }

        public ComputeMetricsAndRunChecksOnAnyObjectThread(DSSAuthCtx user, SavedModel savedModel, Partition partition, ProbesSet metrics, ChecksSet checks, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) {
            this(user, partition, metrics, checks, context, environment, runOrigin);
            this.type = MetricTargetType.SAVED_MODEL;
            this.object = savedModel;
            this.futurePayload = MetricsLaunchService.buildFuturePayload(savedModel, true, true);
        }

        public ComputeMetricsAndRunChecksOnAnyObjectThread(DSSAuthCtx user, ModelEvaluationStore modelEvaluationStore, Partition partition, ProbesSet metrics, ChecksSet checks, MetricsEngineDesc.MetricsEngineContext context, MetricsComputationService.MetricsComputationEnvironment environment, DataQualityRunOrigin runOrigin) {
            this(user, partition, metrics, checks, context, environment, runOrigin);
            this.type = MetricTargetType.MODEL_EVALUATION_STORE;
            this.object = modelEvaluationStore;
            this.futurePayload = MetricsLaunchService.buildFuturePayload(modelEvaluationStore, true, true, false);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public AbstractCheckReport.MetricsCheckReport getResult() {
            return this.checkResults;
        }

        public void execute() throws Exception {
            try {
                MetricsLaunchService.this.metricsComputationService.computeMetrics(this.owner, this.object, this.type, this.partition, this.metrics, this.context, this.environment);
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to compute metrics", (Throwable)ex);
                throw ex;
            }
            try {
                switch (this.type) {
                    case SAVED_MODEL: {
                        this.checkResults = MetricsLaunchService.this.metricsComputationService.checkSavedModelVersion(this.owner, (SavedModel)this.object, this.partition.id(), this.checks, this.environment, this.runOrigin);
                        break;
                    }
                    case MODEL_EVALUATION_STORE: {
                        this.checkResults = MetricsLaunchService.this.metricsComputationService.checkModelEvaluation(this.owner, (ModelEvaluationStore)this.object, this.partition.id(), this.checks, this.environment, this.runOrigin);
                        break;
                    }
                    case MANAGED_FOLDER: {
                        this.checkResults = MetricsLaunchService.this.metricsComputationService.checkManagedFolder(this.owner, (ManagedFolder)this.object, this.partition, this.checks, this.environment, this.runOrigin);
                        break;
                    }
                    case PROJECT: {
                        throw new NotImplementedException();
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to run checks", (Throwable)ex);
                throw ex;
            }
        }
    }

    private class ComputeMetricValuesOnAllAndAllPartitionsThread
    extends SimpleFutureThread<MetricsComputationService.MetricsComputationReportsAndPartitions> {
        private final ProbesSet probesSet;
        private final MetricTargetType objectType;
        private final Partitionable object;
        private final DatasetHandler datasetHandler;
        private final ManagedFolderHandler folderHandler;
        private final MetricsComputationService.MetricsComputationEnvironment environment;
        private final FuturePayload futurePayload;
        private final boolean computeForPartitionAll;
        private final PartitioningScheme partitioningScheme;

        public ComputeMetricValuesOnAllAndAllPartitionsThread(AuthCtx user, MetricTargetType type, Object object, ProbesSet probesSet, MetricsComputationService.MetricsComputationEnvironment environment, boolean computeForPartitionAll) {
            super(user);
            this.objectType = type;
            this.computeForPartitionAll = computeForPartitionAll;
            this.object = (Partitionable)object;
            if (type == MetricTargetType.DATASET) {
                Dataset dataset = (Dataset)object;
                this.datasetHandler = DatasetHandlerFactory.build(user, dataset);
                this.futurePayload = MetricsLaunchService.buildFuturePayload(dataset, true, false, true);
                this.folderHandler = null;
                this.partitioningScheme = dataset.getPartitioningSchema();
            } else if (type == MetricTargetType.MANAGED_FOLDER) {
                ManagedFolder folder = (ManagedFolder)object;
                this.folderHandler = (ManagedFolderHandler)folder.buildHandler(user);
                this.futurePayload = MetricsLaunchService.buildFuturePayload(folder, true, false, true);
                this.datasetHandler = null;
                this.partitioningScheme = folder.getPartitioningSchema();
            } else {
                throw new NotImplementedException("Only dataset and folder can have partitions");
            }
            this.probesSet = probesSet;
            this.environment = environment;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public MetricsComputationService.MetricsComputationReportsAndPartitions compute() throws Exception {
            MetricsComputationService.MetricsComputationReportsAndPartitions ret = new MetricsComputationService.MetricsComputationReportsAndPartitions();
            try {
                FutureProgress.AutocloseableFutureProgressState afp;
                MetricsEngineDesc.MetricsEngineContext context = new MetricsEngineDesc.MetricsEngineContext(this.owner);
                List<Partition> list = context.partitions = this.objectType == MetricTargetType.DATASET ? this.datasetHandler.listPartitions() : this.folderHandler.listPartitions();
                if (this.computeForPartitionAll) {
                    afp = FutureProgress.pushAutoCloseableState((String)"Updating global status");
                    try {
                        MetricsComputationService.MetricsComputationReport report = MetricsLaunchService.this.metricsComputationService.computeMetrics(this.owner, this.object, this.objectType, Partition.newALL((PartitioningScheme)this.partitioningScheme), this.probesSet, context, this.environment);
                        report.description = String.format("dataset:%s partition:ALL", this.object.getFullName());
                        ret.reports.add(report);
                    }
                    finally {
                        if (afp != null) {
                            afp.close();
                        }
                    }
                }
                afp = FutureProgress.pushAutoCloseableState((String)"Updating partitions", (double)context.partitions.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                try {
                    for (Partition partition : context.partitions) {
                        MetricsComputationService.MetricsComputationReport report = MetricsLaunchService.this.metricsComputationService.computeMetrics(this.owner, this.object, this.objectType, partition, this.probesSet, context, this.environment);
                        report.description = String.format("dataset:%s partition:%s", this.object.getFullName(), partition.id());
                        ret.reports.add(report);
                        afp.increment(1.0);
                    }
                }
                finally {
                    if (afp != null) {
                        afp.close();
                    }
                }
                List<String> partitionIds = context.partitions.stream().map(Partition::id).collect(Collectors.toList());
                ret.partitionsList = new MetricsService.MetricPartitionsList(this.object.getPartitioningSchema(), partitionIds);
                MetricsComputationService.MetricsComputationReportsAndPartitions metricsComputationReportsAndPartitions = ret;
                return metricsComputationReportsAndPartitions;
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to compute metrics", (Throwable)ex);
                throw ex;
            }
            finally {
                if (this.datasetHandler != null) {
                    this.datasetHandler.close();
                }
                if (this.folderHandler != null) {
                    this.folderHandler.close();
                }
            }
        }
    }

    private class ComputeMetricValuesOnExplicitPartitionsThread
    extends SimpleFutureThread<MetricsComputationService.MetricsComputationReports> {
        private ProbesSet probesSet;
        private Dataset dataset;
        private MetricsComputationService.MetricsComputationEnvironment environment;
        private List<Partition> partitions;
        private FuturePayload futurePayload;

        public ComputeMetricValuesOnExplicitPartitionsThread(AuthCtx user, Dataset dataset, List<Partition> partitions, ProbesSet probesSet, MetricsComputationService.MetricsComputationEnvironment environment) {
            super(user);
            Validate.notNull(partitions);
            this.dataset = dataset;
            this.partitions = partitions;
            this.probesSet = probesSet;
            this.environment = environment;
            this.futurePayload = MetricsLaunchService.buildFuturePayload(dataset, true, false, false);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        @Override
        public MetricsComputationService.MetricsComputationReports compute() throws Exception {
            MetricsComputationService.MetricsComputationReports ret = new MetricsComputationService.MetricsComputationReports();
            try {
                MetricsEngineDesc.MetricsEngineContext context = new MetricsEngineDesc.MetricsEngineContext(this.owner);
                context.partitions = this.partitions;
                try (FutureProgress.AutocloseableFutureProgressState afp = FutureProgress.pushAutoCloseableState((String)"Updating partitions", (double)context.partitions.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    for (Partition partition : context.partitions) {
                        MetricsComputationService.MetricsComputationReport report = MetricsLaunchService.this.metricsComputationService.computeMetrics(this.owner, this.dataset, MetricTargetType.DATASET, partition, this.probesSet, context, this.environment);
                        report.description = String.format("dataset:%s partition:%s", this.dataset.getFullName(), partition.id());
                        ret.reports.add(report);
                        afp.increment(1.0);
                    }
                }
                return ret;
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to compute metrics", (Throwable)ex);
                throw ex;
            }
        }
    }
}

