/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.PythonProbeEngine;
import com.dataiku.dip.metrics.probes.CustomPythonProbesService;
import com.dataiku.dip.metrics.probes.LoadedPythonProbe;
import com.dataiku.dip.metrics.probes.MetricBuilder;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CustomPythonProbeType
extends ProbeType
implements MetricBuilder,
IPluginifiedMeta {
    public static final String TYPE = "py_plugin";
    private final LoadedPythonProbe loadedDesc;
    private final CustomPythonProbesService customPythonProbesService;

    @Override
    public List<MetricComputer> getComputers(IBasicMeaningsService basicMeaningsService) {
        ArrayList computers = Lists.newArrayList();
        computers.add(new MetricComputer.PythonEngineComputer(){

            @Override
            public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
                if (metric instanceof CustomPythonMetric && objectType == MetricTargetType.DATASET) {
                    return new PythonProbeEngine.PythonProbeEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
                }
                return null;
            }

            @Override
            public String getProbeType() {
                return CustomPythonProbeType.this.getType();
            }

            @Override
            public String getCode(Probe probe) throws IOException {
                return CustomPythonProbeType.this.customPythonProbesService.getCode(CustomPythonProbeType.this.getType());
            }

            @Override
            public String getResourceFolder() {
                return CustomPythonProbeType.this.customPythonProbesService.getResourceFolder(CustomPythonProbeType.this.getType());
            }

            @Override
            public String getLibFolder() {
                return CustomPythonProbeType.this.customPythonProbesService.getLibFolder(CustomPythonProbeType.this.getType());
            }

            @Override
            public PluginSettingsResolver.ResolvedSettings getPluginConfig(Probe pythonProbe, AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
                JsonObject config = pythonProbe.getConfigurationAs(CustomPythonProbeConfiguration.class).config;
                return CustomPythonProbeType.this.customPythonProbesService.getExpandedPluginSettings(CustomPythonProbeType.this.getType(), authCtx, projectKey, config);
            }

            @Override
            public String getEnvName(Probe pythonProbe, String projectKey) throws IOException {
                CodeEnvSelector envSelector = new CodeEnvSelector();
                return envSelector.selectForCustomPythonRecipe(CustomPythonProbeType.this.loadedDesc.ownerPluginId);
            }
        });
        return computers;
    }

    public CustomPythonProbeType(LoadedPythonProbe loadedDesc, CustomPythonProbesService customPythonProbesService) {
        this.loadedDesc = loadedDesc;
        this.customPythonProbesService = customPythonProbesService;
        this.type = loadedDesc.probeType;
    }

    private String getProbeName(Probe probe) {
        return StringUtils.isNotBlank((String)probe.getMeta().getName()) ? probe.getMeta().getName() : probe.getType();
    }

    private String getProbeTypeName(CustomPythonProbeType probeType) {
        return StringUtils.isNotBlank((String)probeType.loadedDesc.desc.meta.label) ? probeType.loadedDesc.desc.meta.label : probeType.loadedDesc.desc.id;
    }

    @Override
    public List<Metric> getMetricsToCompute(Probe probe, Object object, MetricTargetType objectType, boolean forDisplay) {
        ArrayList primer = Lists.newArrayList();
        if (!forDisplay) {
            primer.add(new CustomPythonMetric(this.getType(), "__primer__", Type.STRING, this.getProbeName(probe), this.getProbeTypeName(this)));
        }
        return primer;
    }

    @Override
    public ProbeConfiguration buildFullConfiguration(List<SchemaColumn> column, Probe probe) {
        return null;
    }

    @Override
    public ProbeType trimForSave() {
        return this;
    }

    @Override
    public Class<? extends ProbeConfiguration> getParamsClazz() {
        return CustomPythonProbeConfiguration.class;
    }

    @Override
    public ProbeMetadata getMeta() {
        String name = this.loadedDesc.desc.meta.label;
        return new ProbeMetadata().withLevel(10).withName(StringUtils.isNotBlank((String)name) ? name : this.loadedDesc.id);
    }

    @Override
    public boolean isUserSelectedProbe() {
        return true;
    }

    @Override
    public Metric build(String name, Type dataType, Probe probe) {
        return new CustomPythonMetric(this.getType(), name, dataType, this.getProbeName(probe), this.getProbeTypeName(this));
    }

    @Override
    public IElementLoadedDesc getLoadedDesc() {
        return this.loadedDesc;
    }

    public static class CustomPythonMetric
    extends Metric {
        public String name;
        public String probeName;
        public String probeTypeName;

        public CustomPythonMetric(String probeType, String name, Type resultDataType, String probeName, String probeTypeName) {
            super(probeType, resultDataType);
            this.name = name;
            this.probeName = probeName;
            this.probeTypeName = probeTypeName;
            this.id = Metric.serializeMetric(this);
        }

        @Override
        public String getIdType() {
            return CustomPythonProbeType.TYPE;
        }

        @Override
        public String getColumn() {
            return null;
        }

        @Override
        public String getColumnInvariantId(String placeholder) {
            return this.getId();
        }

        public String getName() {
            return this.name;
        }

        public String getProbeName() {
            return this.probeName;
        }

        public String getProbeTypeName() {
            return this.probeTypeName;
        }

        @Override
        public MetricMetadata getMeta() {
            return new MetricMetadata().withName(this.name + " (" + this.probeTypeName + " : " + this.probeName + ")");
        }

        @Override
        public Probe getMatchingProbe(List<Probe> probes) {
            return CustomPythonMetric.getProbeFromName(probes, this.getProbeName());
        }
    }

    public static class CustomPythonProbeConfiguration
    implements ProbeConfiguration {
        public JsonObject config = new JsonObject();

        public JsonObject getConfig() {
            return this.config;
        }
    }

    public static class CustomPythonMetricSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric metric) {
            if (!(metric instanceof CustomPythonMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metric.getClass().getSimpleName());
            }
            CustomPythonMetric pythonMetric = (CustomPythonMetric)metric;
            return Metric.buildMetricIdFromParts(CustomPythonProbeType.TYPE, pythonMetric.getType(), pythonMetric.getName(), pythonMetric.getProbeName(), pythonMetric.getProbeTypeName());
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            List<String> parts = Metric.buildPartsFromMetricId(metricId);
            if (parts.size() != 5 || !parts.get(0).equals(CustomPythonProbeType.TYPE)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metricId);
            }
            return new CustomPythonMetric(parts.get(1), parts.get(2), Type.STRING, parts.get(3), parts.get(4));
        }
    }
}

