/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common;

import com.dataiku.dip.PivotAllFilteredOutException;
import com.dataiku.dip.PivotCannotDisplayWithEmptyAxesException;
import com.dataiku.dip.pivot.backend.dss.LongDataTensor;
import com.dataiku.dip.utils.ErrorContext;
import java.util.Arrays;

public class ResponseValidator {
    private ResponseValidator() {
    }

    public static void validateRecordsCount(long totalRecordsBeforeFiltering, long totalRecordsAfterFiltering) {
        if (totalRecordsAfterFiltering == 0L) {
            if (totalRecordsBeforeFiltering > 0L) {
                throw new PivotAllFilteredOutException();
            }
            throw ErrorContext.iae((String)"Unable to build: either the selected data sample or the dataset is empty.");
        }
    }

    public static void validateNonEmptyAxes(LongDataTensor counts) {
        if (Arrays.stream(counts.axisLengths).allMatch(axisLength -> axisLength == 0)) {
            throw new PivotCannotDisplayWithEmptyAxesException();
        }
    }
}

