/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins.dev;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.agents.tools.custom.CustomAgentToolsService;
import com.dataiku.dip.analysis.ml.prediction.CustomPythonPredictionAlgoService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.codestudio.blocks.BlockBasedCodeStudioTemplateParams;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.llm.custom.CustomPythonLLMsService;
import com.dataiku.dip.llm.governance.custom.CustomGuardrailsService;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.PluginExtraInfo;
import com.dataiku.dip.plugins.PluginSettingsAccessService;
import com.dataiku.dip.plugins.PluginsLoadService;
import com.dataiku.dip.plugins.RegularPluginsRegistryService;
import com.dataiku.dip.plugins.dev.DevPluginValidationService;
import com.dataiku.dip.plugins.dev.FolderEditorService;
import com.dataiku.dip.plugins.dev.PluginsGitService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.recipes.code.scala.CodeMode;
import com.dataiku.dip.savedmodels.agents.CustomAgentsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.UrlRedactionUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.utils.AcceptAllFilter;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.git.DSSTransactionProviderSettings;
import com.dataiku.dip.transactions.git.cli.GitRemoteCommands;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.DKUIOUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.bokeh.BokehWebAppMeta;
import com.dataiku.dip.webapps.dash.DashWebAppMeta;
import com.dataiku.dip.webapps.shiny.ShinyWebAppMeta;
import com.dataiku.dip.webapps.standard.StandardWebAppMeta;
import com.dataiku.dip.webapps.streamlit.StreamlitWebAppMeta;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.io.FileWriteMode;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DevPluginsService {
    private static final String CLASSPACKAGE_REPLACEMENT = "__CLASSPACKAGE__";
    private static final String CLASSNAME_REPLACEMENT = "__CLASSNAME__";
    private static final String LABEL_REPLACEMENT = "__LABEL__";
    private static final String ID_REPLACEMENT = "__ID__";
    private static final String DESCRIPTION_REPLACEMENT = "__DESCRIPTION__";
    private static final String TEMPLATE_BLOCKS_REPLACEMENT = "__TEMPLATE_BLOCKS__";
    @Autowired
    private IPluginsRegistryService pluginsService;
    @Autowired
    private DevPluginValidationService devPluginValidationService;
    @Autowired
    private PluginSettingsAccessService pluginSettingsAccessService;
    @Autowired
    private PluginsLoadService loadService;
    @Autowired
    private FolderEditorService folderEditorService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    IPluginsRegistryService pluginsRegistry;
    @Autowired
    CustomPythonPredictionAlgoService pythonPredictionAlgoService;
    @Autowired
    CustomGuardrailsService guardrailsService;
    @Autowired
    CustomAgentsService agentsService;
    @Autowired
    CustomAgentToolsService agentToolsService;
    @Autowired
    CustomPythonLLMsService pythonLLMsService;
    private Map<String, TransactionProvider> transactionProviders = new HashMap<String, TransactionProvider>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.plugins.dev");

    @PostConstruct
    private void setupGit() throws IOException {
        logger.debug((Object)"Init plugindev service");
        FileUtils.forceMkdir((File)DevPluginsService.getPluginsRoot());
    }

    public File getPluginRoot(String pluginId) {
        return DKUFileUtils.getWithin((File)DevPluginsService.getPluginsRoot(), (String[])new String[]{pluginId});
    }

    public static File getPluginsRoot() {
        return ApplicationConfigurator.getFile((String[])new String[]{"plugins", "dev"});
    }

    private RelFile pluginRelFile(String pluginId, String ... elements) {
        if (ApplicationConfigurator.getPluginGitMode() == DSSGitModel.PluginGitMode.GLOBAL) {
            elements = (String[])ObjectArrays.concat((Object)pluginId, (Object[])elements);
        }
        return new RelFile(elements);
    }

    public synchronized TransactionProvider getTransactionProvider(String pluginId) throws IOException {
        if (ApplicationConfigurator.getPluginGitMode() == DSSGitModel.PluginGitMode.GLOBAL) {
            return this.getGlobalTransactionProvider();
        }
        TransactionProvider p = this.transactionProviders.get(pluginId);
        if (p != null) {
            return p;
        }
        logger.debug((Object)("Creating a transaction provider for plugin " + pluginId));
        File pluginRoot = this.getPluginRoot(pluginId);
        if (!pluginRoot.exists()) {
            throw new RuntimeException("Plugin folder does not exist: " + pluginId);
        }
        p = new TransactionProvider(pluginRoot, (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(false, true, true, true));
        this.transactionProviders.put(pluginId, p);
        return p;
    }

    private synchronized TransactionProvider getGlobalTransactionProvider() throws IOException {
        TransactionProvider p = this.transactionProviders.get(null);
        if (p != null) {
            return p;
        }
        logger.debug((Object)"Creating a transaction provider for plugin dev directory");
        File pluginDev = DevPluginsService.getPluginsRoot();
        FileUtils.forceMkdir((File)pluginDev);
        p = new TransactionProvider(pluginDev, (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(false, true, true, true));
        this.transactionProviders.put(null, p);
        return p;
    }

    public synchronized List<InstalledPluginDesc> listDevPlugins() {
        ArrayList<InstalledPluginDesc> ret = new ArrayList<InstalledPluginDesc>();
        for (InstalledPluginDesc ipd : this.pluginsService.getLoadedPlugins()) {
            if (ipd.origin != InstalledPluginDesc.PluginOrigin.DEV) continue;
            ret.add(ipd);
        }
        return ret;
    }

    public synchronized DevPluginData getMandatory(AuthCtx authCtx, String pluginId) throws Exception {
        DevPluginData dpd = new DevPluginData();
        for (InstalledPluginDesc ipd : this.pluginsService.getLoadedPlugins()) {
            if (ipd.origin != InstalledPluginDesc.PluginOrigin.DEV || !pluginId.equals(ipd.desc.id)) continue;
            dpd.installedDesc = ipd;
            dpd.settings = this.pluginSettingsAccessService.get(authCtx, pluginId, null);
            dpd.baseFolderPath = this.pluginsService.getActualPluginFolder(pluginId).getCanonicalPath();
            dpd.extraInfo = new PluginExtraInfo(ipd);
            return dpd;
        }
        throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Dev plugin " + pluginId + " not found.");
    }

    public boolean isPluginDev(String pluginId) {
        for (InstalledPluginDesc ipd : this.pluginsService.getLoadedPlugins()) {
            if (!pluginId.equals(ipd.desc.id)) continue;
            return ipd.origin == InstalledPluginDesc.PluginOrigin.DEV;
        }
        throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Dev plugin " + pluginId + " not found.");
    }

    public void checkPluginIsDev(String pluginId) {
        for (InstalledPluginDesc ipd : this.pluginsService.getLoadedPlugins()) {
            if (!pluginId.equals(ipd.desc.id)) continue;
            if (ipd.origin == InstalledPluginDesc.PluginOrigin.DEV) {
                return;
            }
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_WRONG_TYPE, "Plugin " + pluginId + " is not a dev plugin");
        }
        throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Dev plugin " + pluginId + " not found.");
    }

    public List<FolderEditorService.FolderContent> getDevPluginContent_NT(String pluginId) throws Exception {
        this.checkPluginIsDev(pluginId);
        try (Transaction t = this.getTransactionProvider(pluginId).beginRead();){
            List<FolderEditorService.FolderContent> list = this.folderEditorService.getFolderContent(this.pluginRelFile(pluginId, new String[0]), (TransactionRef)t);
            return list;
        }
    }

    public FolderEditorService.FolderContent getDevPluginContent_NT(String pluginId, String path, boolean sendAnyway) throws Exception {
        this.checkPluginIsDev(pluginId);
        try (Transaction t = this.getTransactionProvider(pluginId).beginRead();){
            FolderEditorService.FolderContent folderContent = this.folderEditorService.getFolderContent(this.pluginRelFile(pluginId, new String[0]), path, sendAnyway, null, t);
            return folderContent;
        }
    }

    public byte[] previewImageStream_NT(String pluginId, String path) throws Exception {
        this.checkPluginIsDev(pluginId);
        try (Transaction t = this.getTransactionProvider(pluginId).beginRead();){
            byte[] byArray = this.folderEditorService.previewImageStream(this.pluginRelFile(pluginId, new String[0]), path, t);
            return byArray;
        }
    }

    public void getRawDevPluginContent_NT(HttpServletResponse resp, String pluginId, String path) throws Exception {
        this.checkPluginIsDev(pluginId);
        try (Transaction t = this.getTransactionProvider(pluginId).beginRead();){
            this.folderEditorService.getRawFolderContent(resp, this.pluginRelFile(pluginId, new String[0]), path, t);
        }
    }

    public FolderEditorService.FolderContent getFileDetails(String pluginId, String path, Transaction t) throws Exception {
        this.checkPluginIsDev(pluginId);
        return this.folderEditorService.getFileDetails(this.pluginRelFile(pluginId, new String[0]), path, t);
    }

    public void setOrAddDevPluginContent_NT(String pluginId, String path, String data, AuthCtx authCtx) throws Exception {
        this.checkPluginIsDev(pluginId);
        this.checkPluginContent(pluginId, path, data);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            this.folderEditorService.setOrAddFolderContent(this.pluginRelFile(pluginId, new String[0]), path, data, t);
            t.commitV("Edited file '%s'", new Object[]{path});
        }
    }

    public void setDevPluginContentList_NT(String pluginId, Map<String, String> fileMap, AuthCtx authCtx) throws Exception {
        this.checkPluginIsDev(pluginId);
        this.checkPluginContent(pluginId, fileMap);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            for (Map.Entry<String, String> pathToData : fileMap.entrySet()) {
                this.folderEditorService.setFolderContent(this.pluginRelFile(pluginId, new String[0]), pathToData.getKey(), pathToData.getValue(), (RWTransactionRef)t);
            }
            t.commitV("Edited files", new Object[0]);
        }
    }

    public void streamContent_NT(String pluginId, String path, HttpServletResponse resp) throws IOException {
        this.checkPluginIsDev(pluginId);
        try (Transaction t = this.getTransactionProvider(pluginId).beginRead();){
            this.folderEditorService.streamContent(this.pluginRelFile(pluginId, new String[0]), path, resp, t);
        }
    }

    public InfoMessage.InfoMessages validatePluginContent(String pluginId, Map<String, String> fileMap) {
        this.checkPluginIsDev(pluginId);
        return this.devPluginValidationService.validatePluginFiles(pluginId, fileMap);
    }

    public void checkPluginContent(String pluginId, Map<String, String> fileMap) throws CodedException {
        this.checkPluginIsDev(pluginId);
        for (Map.Entry<String, String> e : fileMap.entrySet()) {
            InfoMessage.InfoMessages messages;
            String path = e.getKey();
            String data = e.getValue();
            if (!"plugin.json".equals(path) || !(messages = this.devPluginValidationService.validatePluginDesc(data, pluginId)).anyFatal()) continue;
            throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_INVALID_DEFINITION, messages.firstFatal().message);
        }
    }

    private void checkPluginContent(String pluginId, String path, String data) throws CodedException {
        HashMap<String, String> fileMap = new HashMap<String, String>();
        fileMap.put(path, data);
        this.checkPluginContent(pluginId, fileMap);
    }

    public void addDevPluginContent_NT(String pluginId, String path, boolean isFolder, AuthCtx authCtx) throws Exception {
        this.checkPluginIsDev(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            this.folderEditorService.addFolderContent(this.pluginRelFile(pluginId, new String[0]), path, isFolder, (RWTransactionRef)t);
            t.commitV("Created file '%s'", new Object[]{path});
        }
    }

    public void removeDevPluginContent_NT(String pluginId, String path, AuthCtx authCtx) throws Exception {
        this.checkPluginIsDev(pluginId);
        if ("plugin.json".equals(path)) {
            throw new IllegalArgumentException("Cannot delete plugin.json");
        }
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            this.folderEditorService.removeFolderContent(this.pluginRelFile(pluginId, new String[0]), path, t);
            t.commitV("Removed '%s'", new Object[]{path});
        }
    }

    public void decompressDevPluginContent_NT(String pluginId, String path, AuthCtx authCtx) throws Exception {
        this.checkPluginIsDev(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            this.folderEditorService.decompressFolderContent(this.pluginRelFile(pluginId, new String[0]), path, t);
            t.commitV("Decompressed file '%s'", new Object[]{path});
        }
    }

    public void streamPluginContent_NT(String pluginId, OutputStream os) throws IOException {
        this.checkPluginIsDev(pluginId);
        try (Transaction t = this.getTransactionProvider(pluginId).beginRead();){
            this.folderEditorService.streamFolderContent(this.pluginRelFile(pluginId, new String[0]), pluginId, (RelFileFilter)new AcceptAllFilter(), os, t, null);
        }
    }

    public void deleteDevPlugin_NT(String pluginId, AuthCtx authCtx) throws Exception {
        this.checkPluginIsDev(pluginId);
        try (RWTransaction t = this.getGlobalTransactionProvider().beginWrite(authCtx);){
            t.deleteDirectory(new RelFile(new String[]{pluginId}));
            t.commitV("Removed plugin '%s'", new Object[]{pluginId});
        }
        this.transactionProviders.remove(pluginId);
        this.loadService.unloadPlugin(pluginId);
    }

    public FolderEditorService.FolderContent renameDevPluginContent_NT(String pluginId, String path, String newName, AuthCtx authCtx) throws Exception {
        this.checkPluginIsDev(pluginId);
        if ("plugin.json".equals(path)) {
            throw new IllegalArgumentException("Cannot rename plugin.json");
        }
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            FolderEditorService.FolderContent newContent = this.folderEditorService.renameFolderContent(this.pluginRelFile(pluginId, new String[0]), path, newName, t);
            t.commitV("Renamed '%s' into '%s'", new Object[]{path, newName});
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
    }

    public FolderEditorService.FolderContent moveDevPluginContent_NT(String pluginId, String path, String toPath, AuthCtx authCtx) throws Exception {
        this.checkPluginIsDev(pluginId);
        if ("plugin.json".equals(path)) {
            throw new IllegalArgumentException("Cannot move plugin.json");
        }
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            FolderEditorService.FolderContent newContent = this.folderEditorService.moveFolderContent(this.pluginRelFile(pluginId, new String[0]), path, toPath, t);
            t.commitV("Moved '%s' to '%s'", new Object[]{path, toPath});
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
    }

    public FolderEditorService.FolderContent copyDevPluginContent_NT(String pluginId, String path, AuthCtx authCtx) throws Exception {
        this.checkPluginIsDev(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            FolderEditorService.FolderContent newContent = this.folderEditorService.copyFolderContent(this.pluginRelFile(pluginId, new String[0]), path, t);
            t.commitV("Copied '%s'", new Object[]{path});
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
    }

    public FolderEditorService.UploadFeasabilities checkUploadContent_NT(String pluginId, String path, List<String> filePaths) throws Exception {
        this.checkPluginIsDev(pluginId);
        try (Transaction t = this.getTransactionProvider(pluginId).beginRead();){
            FolderEditorService.UploadFeasabilities uploadFeasabilities = this.folderEditorService.checkUploadContent(this.pluginRelFile(pluginId, new String[0]), path, filePaths, t);
            return uploadFeasabilities;
        }
    }

    public FolderEditorService.FolderContent uploadContent_NT(String pluginId, String path, InputStream inputStream, String originalFilename, AuthCtx authCtx) throws Exception {
        this.checkPluginIsDev(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            FolderEditorService.FolderContent newContent = this.folderEditorService.uploadContent(this.pluginRelFile(pluginId, new String[0]), path, inputStream, originalFilename, t).call();
            t.commitV("Uploaded file '%s' into '%s'", new Object[]{originalFilename, "/" + path});
            FolderEditorService.FolderContent folderContent = newContent;
            return folderContent;
        }
    }

    public void checkDoesNotExist(String pluginId) {
        for (InstalledPluginDesc ipd : this.pluginsService.getLoadedPlugins()) {
            if (!pluginId.equals(ipd.desc.id)) continue;
            throw new IllegalArgumentException("Plugin already exists");
        }
    }

    public FutureResponse<InfoMessage> startCreatePlugin(String pluginId, DevPluginBootstrapMode mode, String gitRepository, String gitCheckout, String gitPath, AuthCtx authCtx) throws Exception {
        CreatePluginSimpleFutureThread ft = new CreatePluginSimpleFutureThread(pluginId, mode, gitRepository, gitCheckout, gitPath, authCtx);
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<InfoMessage>>(){});
    }

    public void createEmptyPluginAndWait(String pluginId, AuthCtx authCtx) throws Exception {
        TransactionContext.warnAttachedTransaction();
        FutureResponse<InfoMessage> future = this.startCreatePlugin(pluginId, DevPluginBootstrapMode.EMPTY, null, null, null, authCtx);
        this.futureService.waitForFinalResponse(future);
    }

    public String bootstrapConfig_NT(AuthCtx authCtx, String pluginId) throws Exception {
        logger.info((Object)("Bootstrap dev plugin config: " + pluginId));
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile descFile = this.pluginRelFile(pluginId, "plugin.json");
            if (!t.exists(descFile)) {
                String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-plugin.json");
                jsonFile = jsonFile.replace(ID_REPLACEMENT, pluginId);
                String pluginLabel = StringUtils.capitalize((String)pluginId.replace('-', ' '));
                jsonFile = jsonFile.replace(LABEL_REPLACEMENT, pluginLabel);
                jsonFile = jsonFile.replace("__AUTHOR__", authCtx.getIdentifier());
                t.writeStringUTF8(descFile, jsonFile);
                t.commit("Created plugin " + pluginId);
            }
            File pluginFolder = RegularPluginsRegistryService.getDevPluginFolder(pluginId);
            String string = pluginFolder.getAbsolutePath();
            return string;
        }
    }

    private RecipeConversionResult addNewCustomPythonThingToDevPlugin_NT(String pluginId, String elementId, AuthCtx authCtx, String baseName, String baseLabel) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, "python-" + baseName + "s", elementId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-python-" + baseName + ".json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, elementId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, baseLabel + " " + elementId);
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-python-" + baseName + ".py");
            pyFile = pyFile.replace(ID_REPLACEMENT, elementId);
            pyFile = pyFile.replace(LABEL_REPLACEMENT, baseLabel + " " + elementId);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{baseName + ".py"}), pyFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{baseName + ".json"}), jsonFile);
            t.commitV("Added component '%s' (%s)", new Object[]{elementId, baseLabel});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, elementId);
            return recipeConversionResult;
        }
    }

    private RecipeConversionResult addNewCustomJythonThingToDevPlugin(String pluginId, String elementId, AuthCtx authCtx, String baseName, String baseLabel) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, "jython-" + baseName + "s", elementId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-jython-" + baseName + ".json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, elementId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, baseLabel + " " + elementId);
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-jython-" + baseName + ".py");
            pyFile = pyFile.replace(ID_REPLACEMENT, elementId);
            pyFile = pyFile.replace(LABEL_REPLACEMENT, baseLabel + " " + elementId);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{baseName + ".py"}), pyFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{baseName + ".json"}), jsonFile);
            t.commitV("Added component '%s' (%s)", new Object[]{elementId, baseLabel});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, elementId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewPythonPredictionAlgoToDevPlugin(String pluginId, String algoId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, this.pythonPredictionAlgoService.getFolderName(), algoId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "boostrap-python-prediction-algo.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, algoId);
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), "boostrap-python-prediction-algo.py");
            pyFile = pyFile.replace(ID_REPLACEMENT, algoId);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"algo.py"}), pyFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"algo.json"}), jsonFile);
            t.commitV("Added new Python Prediction algo '%s'", new Object[]{algoId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, algoId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewStandardWebAppTemplateToDevPlugin(String pluginId, String elementId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, "web-app-templates", "standard", elementId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-standard-web-app-meta.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, elementId);
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-standard-web-app.py");
            pyFile = pyFile.replace(ID_REPLACEMENT, elementId);
            String cssFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-standard-web-app.css");
            cssFile = cssFile.replace(ID_REPLACEMENT, elementId);
            String jsFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-standard-web-app.js");
            jsFile = jsFile.replace(ID_REPLACEMENT, elementId);
            String htmlFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-standard-web-app.html");
            htmlFile = htmlFile.replace(ID_REPLACEMENT, elementId);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"app.py"}), pyFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"meta.json"}), jsonFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"app.css"}), cssFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"app.js"}), jsFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"app.html"}), htmlFile);
            t.commitV("Added new Standard Web App Template '%s'", new Object[]{elementId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, elementId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewBokehWebAppTemplateToDevPlugin(String pluginId, String elementId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, "web-app-templates", "bokeh", elementId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-bokeh-web-app-meta.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, elementId);
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-bokeh-web-app-backend.py");
            pyFile = pyFile.replace(ID_REPLACEMENT, elementId);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"backend.py"}), pyFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"meta.json"}), jsonFile);
            t.commitV("Added new Bokeh Web App Template '%s'", new Object[]{elementId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, elementId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewDashWebAppTemplateToDevPlugin(String pluginId, String elementId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, "web-app-templates", "dash", elementId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-dash-web-app-meta.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, elementId);
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-dash-web-app-backend.py");
            pyFile = pyFile.replace(ID_REPLACEMENT, elementId);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"backend.py"}), pyFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"meta.json"}), jsonFile);
            t.commitV("Added new Dash Web App Template '%s'", new Object[]{elementId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, elementId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewShinyWebAppTemplateToDevPlugin(String pluginId, String elementId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, "web-app-templates", "shiny", elementId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-shiny-web-app-meta.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, elementId);
            String serverCode = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-shiny-web-app-server.R");
            serverCode = serverCode.replace(ID_REPLACEMENT, elementId);
            String uiCode = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-shiny-web-app-ui.R");
            uiCode = uiCode.replace(ID_REPLACEMENT, elementId);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"server.R"}), serverCode);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"ui.R"}), uiCode);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"meta.json"}), jsonFile);
            t.commitV("Added new Shiny Web App Template '%s'", new Object[]{elementId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, elementId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewStreamlitWebAppTemplateToDevPlugin(String pluginId, String elementId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, "web-app-templates", "streamlit", elementId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-streamlit-web-app-meta.json").replace(ID_REPLACEMENT, elementId);
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-streamlit-web-app-backend.py").replace(ID_REPLACEMENT, elementId);
            String config = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-streamlit-web-app-config.toml").replace(ID_REPLACEMENT, elementId);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"backend.py"}), pyFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"config.toml"}), config);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"meta.json"}), jsonFile);
            t.commitV("Added new Streamlit Web App Template '%s'", new Object[]{elementId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, elementId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewRMarkdownReportTemplateToDevPlugin(String pluginId, String elementId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, "report-templates", "rmarkdown", elementId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-rmarkdown-meta.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, elementId);
            String scriptFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-rmarkdown-script.Rmd");
            scriptFile = scriptFile.replace(ID_REPLACEMENT, elementId);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"script.Rmd"}), scriptFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"meta.json"}), jsonFile);
            t.commitV("Added new Rmarkdown Report Template '%s'", new Object[]{elementId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, elementId);
            return recipeConversionResult;
        }
    }

    public Object addNewCustomFieldsToDevPlugin(String pluginId, String customFieldsId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, "custom-fields", customFieldsId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-custom-fields.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, customFieldsId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, "Custom fields " + customFieldsId);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"custom-fields.json"}), jsonFile);
            t.commitV("Added new Custom Fields '%s'", new Object[]{customFieldsId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, customFieldsId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewNotebookTemplateToDevPlugin(String pluginId, String elementId, String type, String language, boolean preBuilt, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = null;
            elementDirectory = preBuilt ? this.pluginRelFile(pluginId, "notebook-templates", type, "pre-built", elementId) : this.pluginRelFile(pluginId, "notebook-templates", type, language, elementId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-" + language + "-notebook-meta.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, elementId);
            String notebookFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-" + language + "-notebook-notebook.ipynb");
            notebookFile = notebookFile.replace(ID_REPLACEMENT, elementId);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"notebook.ipynb"}), notebookFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"meta.json"}), jsonFile);
            t.commitV("Added new Notebook Template '%s'", new Object[]{elementId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, elementId);
            return recipeConversionResult;
        }
    }

    private File checkPluginFolder(String pluginId) {
        File pluginFolder = RegularPluginsRegistryService.getDevPluginFolder(pluginId);
        if (!pluginFolder.isDirectory()) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Dev plugin " + pluginId + " does not exist");
        }
        return pluginFolder;
    }

    private RelFile checkPluginFolderInTransaction(RWTransaction t, String pluginId) throws IOException {
        RelFile pluginFolder = this.pluginRelFile(pluginId, new String[0]);
        if (!t.exists(pluginFolder) || !t.isDirectory(pluginFolder)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Dev plugin " + pluginId + " does not exist");
        }
        return pluginFolder;
    }

    private RecipeConversionResult addNewCustomSQLThingToDevPlugin(String pluginId, String elementId, AuthCtx authCtx, String baseName, String baseLabel) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, "sql-" + baseName + "s", elementId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-sql-" + baseName + ".json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, elementId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, baseLabel + " " + elementId);
            String sqlFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-sql-" + baseName + ".sql");
            sqlFile = sqlFile.replace(ID_REPLACEMENT, elementId);
            sqlFile = sqlFile.replace(LABEL_REPLACEMENT, baseLabel + " " + elementId);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{baseName + ".sql"}), sqlFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{baseName + ".json"}), jsonFile);
            t.commitV("Added component '%s' (%s)", new Object[]{elementId, baseLabel});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, elementId);
            return recipeConversionResult;
        }
    }

    private RecipeConversionResult addNewCustomJavaThingToDevPlugin(String pluginId, String elementId, String fullClassName, AuthCtx authCtx, String baseName, String baseLabel, boolean jsonFileNameVariant, boolean inClasspathAtStartup) throws Exception {
        this.checkPluginFolder(pluginId);
        int classNamePos = fullClassName.lastIndexOf(46);
        if (classNamePos < 0) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_COMPONENT_PARAMETER, "Invalid class name (missing package definition) : " + fullClassName);
        }
        String classPackage = fullClassName.substring(0, classNamePos);
        String className = fullClassName.substring(classNamePos + 1);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, "java-" + baseName + "s", elementId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-java-" + baseName + ".json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, elementId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, baseLabel + " " + elementId);
            jsonFile = jsonFile.replace(CLASSNAME_REPLACEMENT, className);
            jsonFile = jsonFile.replace(CLASSPACKAGE_REPLACEMENT, classPackage);
            String javaFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-java-" + baseName + ".j");
            javaFile = javaFile.replace(ID_REPLACEMENT, elementId);
            javaFile = javaFile.replace(LABEL_REPLACEMENT, baseLabel + " " + elementId);
            javaFile = javaFile.replace(CLASSNAME_REPLACEMENT, className);
            javaFile = javaFile.replace(CLASSPACKAGE_REPLACEMENT, classPackage);
            this.writeJavaFile(elementDirectory, classPackage, className, javaFile, t);
            this.addBuildXML(pluginId, this.pluginRelFile(pluginId, new String[0]), "java-" + baseName + "s/" + elementId, t, inClasspathAtStartup);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{(jsonFileNameVariant ? "j" : "") + baseName + ".json"}), jsonFile);
            t.commitV("Added component '%s' (%s)", new Object[]{elementId, baseLabel});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, elementId);
            return recipeConversionResult;
        }
    }

    private void writeJavaFile(RelFile componentDir, String classPackage, String className, String data, RWTransaction t) throws Exception {
        this.writeFileIntoJavaPackage(componentDir, classPackage, className + ".java", data, t);
    }

    private void writeFileIntoJavaPackage(RelFile componentDir, String classPackage, String fileName, String data, RWTransaction t) throws Exception {
        String fileHierarchy = "src/" + StringUtils.replace((String)classPackage, (String)".", (String)"/");
        RelFile javaFileLoc = componentDir.appendChildPath(fileHierarchy + "/" + fileName);
        t.makeDirectory(javaFileLoc.getParent());
        t.writeStringUTF8(javaFileLoc, data);
    }

    private void addBuildXML(String pluginId, RelFile pluginFolder, String componentDir, RWTransaction t) throws Exception {
        this.addBuildXML(pluginId, pluginFolder, componentDir, t, false);
    }

    private void addBuildXML(String pluginId, RelFile pluginFolder, String componentDir, RWTransaction t, boolean inClasspathAtStartup) throws Exception {
        RelFile buildxml = new RelFile(pluginFolder, new String[]{"build.xml"});
        if (!t.exists(buildxml)) {
            String buildxmlfile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-build.xml");
            buildxmlfile = buildxmlfile.replace("__PLUGIN_ID__", pluginId);
            buildxmlfile = buildxmlfile.replace("__DIST_DIR__", inClasspathAtStartup ? "lib" : "java-lib");
            buildxmlfile = buildxmlfile.replace("__COMPONENT_DIR__", componentDir);
            t.writeStringUTF8(buildxml, buildxmlfile);
        }
    }

    public RecipeConversionResult addNewCustomPyDatasetToDevPlugin(String pluginId, String connectorId, AuthCtx authCtx) throws Exception {
        return this.addNewCustomPythonThingToDevPlugin_NT(pluginId, connectorId, authCtx, "connector", "Custom dataset");
    }

    public RecipeConversionResult addNewCustomPyFormatToDevPlugin(String pluginId, String formatId, AuthCtx authCtx) throws Exception {
        return this.addNewCustomPythonThingToDevPlugin_NT(pluginId, formatId, authCtx, "format", "Custom format");
    }

    public RecipeConversionResult addNewCustomJavaFormatToDevPlugin(String pluginId, String formatId, String className, AuthCtx authCtx) throws Exception {
        return this.addNewCustomJavaThingToDevPlugin(pluginId, formatId, className, authCtx, "format", "Custom format", true, false);
    }

    public RecipeConversionResult addNewCustomPyProbeToDevPlugin(String pluginId, String probeId, AuthCtx authCtx) throws Exception {
        return this.addNewCustomPythonThingToDevPlugin_NT(pluginId, probeId, authCtx, "probe", "Custom probe");
    }

    public RecipeConversionResult addNewCustomPyCheckToDevPlugin(String pluginId, String checkId, AuthCtx authCtx) throws Exception {
        return this.addNewCustomPythonThingToDevPlugin_NT(pluginId, checkId, authCtx, "check", "Custom check");
    }

    public RecipeConversionResult addNewCustomJythonProcessorToDevPlugin(String pluginId, String checkId, AuthCtx authCtx) throws Exception {
        return this.addNewCustomJythonThingToDevPlugin(pluginId, checkId, authCtx, "processor", "Custom processor");
    }

    public RecipeConversionResult addNewCustomSqlProbeToDevPlugin(String pluginId, String probeId, AuthCtx authCtx) throws Exception {
        return this.addNewCustomSQLThingToDevPlugin(pluginId, probeId, authCtx, "probe", "Custom probe");
    }

    public RecipeConversionResult addNewCustomPyTriggerToDevPlugin(String pluginId, String triggerId, AuthCtx authCtx) throws Exception {
        return this.addNewCustomPythonThingToDevPlugin_NT(pluginId, triggerId, authCtx, "trigger", "Custom trigger");
    }

    public RecipeConversionResult addNewCustomPyRunnableToDevPlugin(String pluginId, String runnableId, AuthCtx authCtx) throws Exception {
        return this.addNewCustomPythonThingToDevPlugin_NT(pluginId, runnableId, authCtx, "runnable", "Custom runnable");
    }

    public RecipeConversionResult addNewCustomJavaRunnableToDevPlugin(String pluginId, String runnableId, String className, AuthCtx authCtx) throws Exception {
        return this.addNewCustomJavaThingToDevPlugin(pluginId, runnableId, className, authCtx, "runnable", "Custom runnable", false, false);
    }

    public Object addNewCustomJavaPolicyHookToDevPlugin(String pluginId, String policyHooksId, String className, AuthCtx authCtx) throws Exception {
        return this.addNewCustomJavaThingToDevPlugin(pluginId, policyHooksId, className, authCtx, "policy-hook", "Custom policy hooks", false, false);
    }

    public Object addNewCustomJavaUserSupplierToDevPlugin(String pluginId, String userSupplierId, String className, AuthCtx authCtx) throws Exception {
        return this.addNewCustomJavaThingToDevPlugin(pluginId, userSupplierId, className, authCtx, "custom-user-supplier", "Custom user supplier", false, true);
    }

    public Object addNewCustomJavaUserAuthenticatorToDevPlugin(String pluginId, String userSupplierId, String className, AuthCtx authCtx) throws Exception {
        return this.addNewCustomJavaThingToDevPlugin(pluginId, userSupplierId, className, authCtx, "custom-user-authenticator", "Custom user authenticator", false, true);
    }

    public Object addNewCustomJavaUserAuthenticatorAndSupplierToDevPlugin(String pluginId, String userSupplierId, String className, AuthCtx authCtx) throws Exception {
        return this.addNewCustomJavaThingToDevPlugin(pluginId, userSupplierId, className, authCtx, "custom-user-authenticator-and-supplier", "Custom user authenticator and supplier", false, true);
    }

    public RecipeConversionResult addNewCustomJavaDatasetToDevPlugin(String pluginId, String connectorId, String className, AuthCtx authCtx) throws Exception {
        return this.addNewCustomJavaThingToDevPlugin(pluginId, connectorId, className, authCtx, "connector", "Custom dataset", false, false);
    }

    public RecipeConversionResult addNewCustomJavaRecipeToDevPlugin(String pluginId, String recipeId, String fullClassName, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        int classNamePos = fullClassName.lastIndexOf(46);
        if (classNamePos < 0) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_COMPONENT_PARAMETER, "Invalid class name (missing package definition) : " + fullClassName);
        }
        String classPackage = fullClassName.substring(0, classNamePos);
        String className = fullClassName.substring(classNamePos + 1);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile recipeDirectory = this.pluginRelFile(pluginId, "custom-recipes", recipeId);
            t.makeDirectory(recipeDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-java-recipe.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, recipeId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, "Custom recipe " + recipeId);
            jsonFile = jsonFile.replace("__KIND__", "JAVA");
            jsonFile = jsonFile.replace(CLASSNAME_REPLACEMENT, className);
            jsonFile = jsonFile.replace(CLASSPACKAGE_REPLACEMENT, classPackage);
            String javaFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-java-recipe.j");
            javaFile = javaFile.replace(ID_REPLACEMENT, recipeId);
            javaFile = javaFile.replace(LABEL_REPLACEMENT, "Custom recipe " + recipeId);
            javaFile = javaFile.replace(CLASSNAME_REPLACEMENT, className);
            javaFile = javaFile.replace(CLASSPACKAGE_REPLACEMENT, classPackage);
            this.writeJavaFile(recipeDirectory, classPackage, className, javaFile, t);
            this.addBuildXML(pluginId, this.pluginRelFile(pluginId, new String[0]), "custom-recipes/" + recipeId, t);
            t.writeStringUTF8(new RelFile(recipeDirectory, new String[]{"recipe.json"}), jsonFile);
            t.commitV("Added custom recipe '%s'", new Object[]{recipeId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(recipeDirectory).getAbsolutePath(), pluginId, recipeId);
            return recipeConversionResult;
        }
    }

    private RecipeConversionResult addCustomRecipeFromExisting(String pluginId, String scriptData, String kind, String bootstrapFile, String targetFile, String recipeFolder, AuthCtx authCtx) throws Exception {
        return this.addCustomRecipeFromExisting(pluginId, scriptData, kind, "", bootstrapFile, targetFile, recipeFolder, authCtx);
    }

    private RecipeConversionResult addCustomRecipeFromExisting(String pluginId, String scriptData, String kind, String additionalConfig, String bootstrapFile, String targetFile, String recipeFolder, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            String customRecipeId = recipeFolder;
            String customRecipeLabel = this.idToLabel(customRecipeId);
            RelFile recipeDirectory = this.pluginRelFile(pluginId, "custom-recipes", customRecipeId);
            t.makeDirectory(recipeDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-recipe.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, customRecipeId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, customRecipeLabel);
            jsonFile = jsonFile.replace("__KIND__", kind);
            jsonFile = jsonFile.replace("__ADDITIONAL_CONFIG__", additionalConfig);
            Object codeFile = DKUIOUtils.getResourceFileContent(this.getClass(), bootstrapFile);
            codeFile = ((String)codeFile).replace(ID_REPLACEMENT, customRecipeId);
            codeFile = ((String)codeFile).replace(LABEL_REPLACEMENT, customRecipeLabel);
            codeFile = (String)codeFile + scriptData;
            t.writeStringUTF8(new RelFile(recipeDirectory, new String[]{targetFile}), (String)codeFile);
            RelFile jsonFileToOpen = new RelFile(recipeDirectory, new String[]{"recipe.json"});
            t.writeStringUTF8(jsonFileToOpen, jsonFile);
            t.commitV("Added custom recipe '%s'", new Object[]{customRecipeId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(recipeDirectory).getAbsolutePath(), pluginId, customRecipeId, jsonFileToOpen.getFullPath());
            return recipeConversionResult;
        }
    }

    public WebAppConversionResult addCustomWebAppFromExisting(String targetPluginId, WebApp webapp, String webappType, AuthCtx authCtx) throws IOException {
        this.checkPluginFolder(targetPluginId);
        try (RWTransaction t = this.getTransactionProvider(targetPluginId).beginWrite(authCtx);){
            RelFile webappDirectory = this.pluginRelFile(targetPluginId, "webapps", webappType);
            if (t.exists(webappDirectory)) {
                throw new RuntimeException("Plugin webapp \"" + webappType + "\"already exists");
            }
            String json = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-webapp.json");
            json = json.replace(ID_REPLACEMENT, webappType);
            json = json.replace(LABEL_REPLACEMENT, this.idToLabel(webappType));
            json = json.replace(DESCRIPTION_REPLACEMENT, "");
            json = json.replace("__BASE_TYPE__", webapp.type);
            boolean hasBackend = false;
            boolean noJSSecurity = true;
            boolean hideWebAppConfig = true;
            ArrayList jsLibraries = null;
            switch (webapp.type) {
                case "STANDARD": {
                    StandardWebAppMeta.StandardWebAppParams params = webapp.getParamsAs(StandardWebAppMeta.StandardWebAppParams.class);
                    hasBackend = params.backendEnabled;
                    noJSSecurity = false;
                    jsLibraries = Lists.newArrayList(params.libraries);
                    t.writeStringUTF8(new RelFile(webappDirectory, new String[]{"body.html"}), params.html);
                    t.writeStringUTF8(new RelFile(webappDirectory, new String[]{"style.css"}), params.css);
                    t.writeStringUTF8(new RelFile(webappDirectory, new String[]{"app.js"}), this.addJsHelperCommentForWebApp(params.js));
                    if (!hasBackend) break;
                    t.writeStringUTF8(new RelFile(webappDirectory, new String[]{"backend.py"}), this.addPythonHelperCommentForWebApp(params.python));
                    break;
                }
                case "BOKEH": {
                    BokehWebAppMeta.BokehWebAppParams params = webapp.getParamsAs(BokehWebAppMeta.BokehWebAppParams.class);
                    hasBackend = true;
                    t.writeStringUTF8(new RelFile(webappDirectory, new String[]{"backend.py"}), this.addPythonHelperCommentForWebApp(params.python));
                    break;
                }
                case "DASH": {
                    DashWebAppMeta.DashWebAppParams params = webapp.getParamsAs(DashWebAppMeta.DashWebAppParams.class);
                    hasBackend = true;
                    t.writeStringUTF8(new RelFile(webappDirectory, new String[]{"backend.py"}), this.addPythonHelperCommentForWebApp(params.python));
                    break;
                }
                case "SHINY": {
                    ShinyWebAppMeta.ShinyWebAppParams params = webapp.getParamsAs(ShinyWebAppMeta.ShinyWebAppParams.class);
                    hasBackend = true;
                    t.writeStringUTF8(new RelFile(webappDirectory, new String[]{"ui.R"}), this.addRHelperCommentForWebApp(params.ui));
                    t.writeStringUTF8(new RelFile(webappDirectory, new String[]{"server.R"}), this.addRHelperCommentForWebApp(params.server));
                    break;
                }
                case "STREAMLIT": {
                    StreamlitWebAppMeta.StreamlitWebAppParams params = webapp.getParamsAs(StreamlitWebAppMeta.StreamlitWebAppParams.class);
                    hasBackend = true;
                    t.writeStringUTF8(new RelFile(webappDirectory, new String[]{"backend.py"}), this.addPythonHelperCommentForWebApp(params.python));
                    t.writeStringUTF8(new RelFile(webappDirectory, new String[]{"config.toml"}), params.config);
                    break;
                }
                default: {
                    throw new Error("Not implemented");
                }
            }
            json = json.replace("__HAS_BACKEND__", Boolean.toString(hasBackend));
            json = json.replace("__NO_JS_SECURITY__", Boolean.toString(noJSSecurity));
            json = json.replace("__JS_LIBRARIES__", jsLibraries == null ? "null" : JSON.json((Object)jsLibraries));
            json = json.replace("__HIDE_WEBAPP_CONFIG__", Boolean.toString(hideWebAppConfig));
            RelFile jsonFile = new RelFile(webappDirectory, new String[]{"webapp.json"});
            t.writeStringUTF8(jsonFile, json);
            t.commit("added custom webapp");
            WebAppConversionResult webAppConversionResult = new WebAppConversionResult(t.resolve(webappDirectory).getAbsolutePath(), targetPluginId, webappType, jsonFile.getFullPath());
            return webAppConversionResult;
        }
    }

    private String idToLabel(String id) {
        return StringUtils.capitalize((String)id.replace('-', ' '));
    }

    private String addRHelperCommentForWebApp(String code) {
        return "# Access the parameters that end-users filled in using webapp config\n# For example, for a parameter called \"input_dataset\"\n# input_dataset <- dkuWebAppConfig()[['input_dataset']]\n\n" + code;
    }

    private String addJsHelperCommentForWebApp(String code) {
        return "// Access the parameters that end-users filled in using webapp config\n// For example, for a parameter called \"input_dataset\"\n// input_dataset = dataiku.getWebAppConfig()['input_dataset']\n\n" + code;
    }

    private String addPythonHelperCommentForWebApp(String code) {
        return "from dataiku.customwebapp import *\n\n# Access the parameters that end-users filled in using webapp config\n# For example, for a parameter called \"input_dataset\"\n# input_dataset = get_webapp_config()[\"input_dataset\"]\n\n" + code;
    }

    public RecipeConversionResult addCustomRecipeFromPython(String pluginId, TargetPluginMode targetPluginMode, String scriptData, String recipeFolder, AuthCtx authCtx) throws Exception {
        logger.info((Object)"Creating custom code recipe from Python recipe");
        if (targetPluginMode == TargetPluginMode.NEW) {
            this.createEmptyPluginAndWait(pluginId, authCtx);
        }
        return this.addCustomRecipeFromExisting(pluginId, scriptData, "PYTHON", "frompython-recipe.py", "recipe.py", recipeFolder, authCtx);
    }

    public RecipeConversionResult addCustomRecipeFromR(String pluginId, TargetPluginMode targetPluginMode, String scriptData, String recipeFolder, AuthCtx authCtx) throws Exception {
        logger.info((Object)"Creating custom code recipe from R recipe");
        if (targetPluginMode == TargetPluginMode.NEW) {
            this.createEmptyPluginAndWait(pluginId, authCtx);
        }
        return this.addCustomRecipeFromExisting(pluginId, scriptData, "R", "fromR-recipe.R", "recipe.R", recipeFolder, authCtx);
    }

    public RecipeConversionResult addCustomRecipeFromPyspark(String pluginId, TargetPluginMode targetPluginMode, String scriptData, String recipeFolder, AuthCtx authCtx) throws Exception {
        logger.info((Object)"Creating custom code recipe from PySpark recipe");
        if (targetPluginMode == TargetPluginMode.NEW) {
            this.createEmptyPluginAndWait(pluginId, authCtx);
        }
        return this.addCustomRecipeFromExisting(pluginId, scriptData, "PYSPARK", "frompyspark-recipe.py", "recipe.py", recipeFolder, authCtx);
    }

    public RecipeConversionResult addCustomRecipeFromSparkScala(String pluginId, TargetPluginMode targetPluginMode, String scriptData, String recipeFolder, CodeMode codeMode, AuthCtx authCtx) throws Exception {
        logger.info((Object)"Creating custom code recipe from Spark-Scala recipe");
        if (targetPluginMode == TargetPluginMode.NEW) {
            this.createEmptyPluginAndWait(pluginId, authCtx);
        }
        String bootstrapFile = switch (codeMode) {
            case CodeMode.FREE_FORM -> "fromsparkscala-recipe.scala";
            case CodeMode.FUNCTION -> "fromsparkscala-fn-recipe.scala";
            default -> throw new UnsupportedOperationException("Unsupported code mode " + String.valueOf((Object)codeMode));
        };
        String additionalConfig = "\"codeMode\": \"" + String.valueOf((Object)codeMode) + "\",";
        return this.addCustomRecipeFromExisting(pluginId, scriptData, "SPARK_SCALA", additionalConfig, bootstrapFile, "recipe.scala", recipeFolder, authCtx);
    }

    public RecipeConversionResult addNewCustomPyExporterToDevPlugin(String pluginId, String exporterId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile exporterDirectory = this.pluginRelFile(pluginId, "python-exporters", exporterId);
            t.makeDirectory(exporterDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-python-exporter.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, exporterId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, "Custom exporter " + exporterId);
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-python-exporter.py");
            pyFile = pyFile.replace(ID_REPLACEMENT, exporterId);
            pyFile = pyFile.replace(LABEL_REPLACEMENT, "Custom exporter " + exporterId);
            t.writeStringUTF8(new RelFile(exporterDirectory, new String[]{"exporter.py"}), pyFile);
            t.writeStringUTF8(new RelFile(exporterDirectory, new String[]{"exporter.json"}), jsonFile);
            t.commitV("Added custom python exporter '%s'", new Object[]{exporterId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(exporterDirectory).getAbsolutePath(), pluginId, exporterId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewCustomJavaExporterToDevPlugin(String pluginId, String exporterId, String fullClassName, AuthCtx authCtx) throws Exception {
        int classNamePos = fullClassName.lastIndexOf(46);
        if (classNamePos < 0) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_COMPONENT_PARAMETER, "Invalid class name (missing package definition) : " + fullClassName);
        }
        String classPackage = fullClassName.substring(0, classNamePos);
        String className = fullClassName.substring(classNamePos + 1);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile pluginFolder = this.pluginRelFile(pluginId, new String[0]);
            if (!t.exists(pluginFolder) || !t.isDirectory(pluginFolder)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Dev plugin " + pluginId + " does not exist");
            }
            RelFile exporterDirectory = this.pluginRelFile(pluginId, "java-exporters", exporterId);
            t.makeDirectory(exporterDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-java-exporter.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, exporterId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, "Custom exporter " + exporterId);
            jsonFile = jsonFile.replace(CLASSNAME_REPLACEMENT, className);
            jsonFile = jsonFile.replace(CLASSPACKAGE_REPLACEMENT, classPackage);
            String javaFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-java-exporter.j");
            javaFile = javaFile.replace(ID_REPLACEMENT, exporterId);
            javaFile = javaFile.replace(LABEL_REPLACEMENT, "Custom exporter " + exporterId);
            javaFile = javaFile.replace(CLASSNAME_REPLACEMENT, className);
            javaFile = javaFile.replace(CLASSPACKAGE_REPLACEMENT, classPackage);
            this.writeJavaFile(exporterDirectory, classPackage, className, javaFile, t);
            this.addBuildXML(pluginId, pluginFolder, "java-exporters/" + exporterId, t);
            t.writeStringUTF8(new RelFile(exporterDirectory, new String[]{"jexporter.json"}), jsonFile);
            t.commitV("Added custom java exporter '%s'", new Object[]{exporterId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(exporterDirectory).getAbsolutePath(), pluginId, exporterId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewCustomPyStepToDevPlugin(String pluginId, String stepId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile stepDirectory = this.pluginRelFile(pluginId, "python-steps", stepId);
            t.makeDirectory(stepDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-python-step.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, stepId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, "Custom step " + stepId);
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-python-step.py");
            pyFile = pyFile.replace(ID_REPLACEMENT, stepId);
            pyFile = pyFile.replace(LABEL_REPLACEMENT, "Custom step " + stepId);
            t.writeStringUTF8(new RelFile(stepDirectory, new String[]{"step.py"}), pyFile);
            t.writeStringUTF8(new RelFile(stepDirectory, new String[]{"step.json"}), jsonFile);
            t.commitV("Added custom python step '%s'", new Object[]{stepId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(stepDirectory).getAbsolutePath(), pluginId, stepId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewCustomPyClusterToDevPlugin(String pluginId, String clusterId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile clusterDirectory = this.pluginRelFile(pluginId, "python-clusters", clusterId);
            t.makeDirectory(clusterDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-python-cluster.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, clusterId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, "Custom cluster " + clusterId);
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-python-cluster.py");
            pyFile = pyFile.replace(ID_REPLACEMENT, clusterId);
            pyFile = pyFile.replace(LABEL_REPLACEMENT, "Custom cluster " + clusterId);
            t.writeStringUTF8(new RelFile(clusterDirectory, new String[]{"cluster.py"}), pyFile);
            t.writeStringUTF8(new RelFile(clusterDirectory, new String[]{"cluster.json"}), jsonFile);
            t.commitV("Added custom python cluster '%s'", new Object[]{clusterId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(clusterDirectory).getAbsolutePath(), pluginId, clusterId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewCustomPyCodeStudioBlockToDevPlugin(String pluginId, String codeStudioBlockId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile clusterDirectory = this.pluginRelFile(pluginId, "python-code-studio-blocks", codeStudioBlockId);
            t.makeDirectory(clusterDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-python-code-studio-block.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, codeStudioBlockId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, "Custom Code Studio block " + codeStudioBlockId);
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-python-code-studio-block.py");
            pyFile = pyFile.replace(ID_REPLACEMENT, codeStudioBlockId);
            pyFile = pyFile.replace(LABEL_REPLACEMENT, "Custom Code Studio block " + codeStudioBlockId);
            t.writeStringUTF8(new RelFile(clusterDirectory, new String[]{"codeStudioBlock.py"}), pyFile);
            t.writeStringUTF8(new RelFile(clusterDirectory, new String[]{"codeStudioBlock.json"}), jsonFile);
            t.commitV("Added custom python Code Studio block '%s'", new Object[]{codeStudioBlockId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(clusterDirectory).getAbsolutePath(), pluginId, codeStudioBlockId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewCustomPyCodeStudioTemplateToDevPlugin(String pluginId, String codeStudioId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile clusterDirectory = this.pluginRelFile(pluginId, "python-code-studios", codeStudioId);
            t.makeDirectory(clusterDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-python-code-studio-template.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, codeStudioId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, "Custom Code Studio " + codeStudioId);
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-python-code-studio-template.py");
            pyFile = pyFile.replace(ID_REPLACEMENT, codeStudioId);
            pyFile = pyFile.replace(LABEL_REPLACEMENT, "Custom Code Studio " + codeStudioId);
            t.writeStringUTF8(new RelFile(clusterDirectory, new String[]{"code_studio.py"}), pyFile);
            t.writeStringUTF8(new RelFile(clusterDirectory, new String[]{"code_studio.json"}), jsonFile);
            t.commitV("Added custom python Code Studio template '%s'", new Object[]{codeStudioId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(clusterDirectory).getAbsolutePath(), pluginId, codeStudioId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewCustomPyProjectStandardsCheckSpecToDevPlugin(String pluginId, String projectStandardsCheckSpecId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile checkerDirectory = this.pluginRelFile(pluginId, "python-project-standards-check-specs", projectStandardsCheckSpecId);
            t.makeDirectory(checkerDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-python-project-standards-check-spec.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, projectStandardsCheckSpecId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, "Custom Project Standards Check Template " + projectStandardsCheckSpecId);
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-python-project-standards-check-spec.py");
            pyFile = pyFile.replace(ID_REPLACEMENT, projectStandardsCheckSpecId);
            pyFile = pyFile.replace(LABEL_REPLACEMENT, "Custom Project Standards Check Template " + projectStandardsCheckSpecId);
            t.writeStringUTF8(new RelFile(checkerDirectory, new String[]{"project_standards_check_spec.py"}), pyFile);
            t.writeStringUTF8(new RelFile(checkerDirectory, new String[]{"project_standards_check_spec.json"}), jsonFile);
            t.commitV("Added custom python Project Standards Check Spec '%s'", new Object[]{projectStandardsCheckSpecId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(checkerDirectory).getAbsolutePath(), pluginId, projectStandardsCheckSpecId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewCustomPyFSProviderToDevPlugin(String pluginId, String fsProviderId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile fsProviderDirectory = this.pluginRelFile(pluginId, "python-fs-providers", fsProviderId);
            t.makeDirectory(fsProviderDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-python-fs-provider.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, fsProviderId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, "Custom FS provider " + fsProviderId);
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-python-fs-provider.py");
            pyFile = pyFile.replace(ID_REPLACEMENT, fsProviderId);
            pyFile = pyFile.replace(LABEL_REPLACEMENT, "Custom FS provider " + fsProviderId);
            t.writeStringUTF8(new RelFile(fsProviderDirectory, new String[]{"fs-provider.py"}), pyFile);
            t.writeStringUTF8(new RelFile(fsProviderDirectory, new String[]{"fs-provider.json"}), jsonFile);
            t.commitV("Added custom python fs provider '%s'", new Object[]{fsProviderId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(fsProviderDirectory).getAbsolutePath(), pluginId, fsProviderId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewCustomJavaFSProviderToDevPlugin(String pluginId, String fsProviderId, String fullClassName, AuthCtx authCtx) throws Exception {
        int classNamePos = fullClassName.lastIndexOf(46);
        if (classNamePos < 0) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_COMPONENT_PARAMETER, "Invalid class name (missing package definition) : " + fullClassName);
        }
        String classPackage = fullClassName.substring(0, classNamePos);
        String className = fullClassName.substring(classNamePos + 1);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile pluginFolder = this.checkPluginFolderInTransaction(t, pluginId);
            RelFile fsProviderDirectory = this.pluginRelFile(pluginId, "java-fs-providers", fsProviderId);
            t.makeDirectory(fsProviderDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-java-fs-provider.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, fsProviderId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, "Custom FS provider " + fsProviderId);
            jsonFile = jsonFile.replace(CLASSNAME_REPLACEMENT, className);
            jsonFile = jsonFile.replace(CLASSPACKAGE_REPLACEMENT, classPackage);
            String javaFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-java-fs-provider.j");
            javaFile = javaFile.replace(ID_REPLACEMENT, fsProviderId);
            javaFile = javaFile.replace(LABEL_REPLACEMENT, "Custom FS provider " + fsProviderId);
            javaFile = javaFile.replace(CLASSNAME_REPLACEMENT, className);
            javaFile = javaFile.replace(CLASSPACKAGE_REPLACEMENT, classPackage);
            this.writeJavaFile(fsProviderDirectory, classPackage, className, javaFile, t);
            this.addBuildXML(pluginId, pluginFolder, "java-fs-providers/" + fsProviderId, t);
            t.writeStringUTF8(new RelFile(fsProviderDirectory, new String[]{"fs-provider.json"}), jsonFile);
            t.commitV("Added custom java fs provider '%s'", new Object[]{fsProviderId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(fsProviderDirectory).getAbsolutePath(), pluginId, fsProviderId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewCustomJavaDialectToDevPlugin(String pluginId, String dialectId, String fullClassName, AuthCtx authCtx) throws Exception {
        int classNamePos = fullClassName.lastIndexOf(46);
        if (classNamePos < 0) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_COMPONENT_PARAMETER, "Invalid class name (missing package definition) : " + fullClassName);
        }
        String classPackage = fullClassName.substring(0, classNamePos);
        String className = fullClassName.substring(classNamePos + 1);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile pluginFolder = this.checkPluginFolderInTransaction(t, pluginId);
            RelFile dialectDirectory = this.pluginRelFile(pluginId, "java-dialects", dialectId);
            t.makeDirectory(dialectDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-java-dialect.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, dialectId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, "Custom dialect " + dialectId);
            jsonFile = jsonFile.replace(CLASSNAME_REPLACEMENT, className);
            jsonFile = jsonFile.replace(CLASSPACKAGE_REPLACEMENT, classPackage);
            String javaFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-java-dialect.j");
            javaFile = javaFile.replace(ID_REPLACEMENT, dialectId);
            javaFile = javaFile.replace(LABEL_REPLACEMENT, "Custom dialect " + dialectId);
            javaFile = javaFile.replace(CLASSNAME_REPLACEMENT, className);
            javaFile = javaFile.replace(CLASSPACKAGE_REPLACEMENT, classPackage);
            this.writeJavaFile(dialectDirectory, classPackage, className, javaFile, t);
            this.addBuildXML(pluginId, pluginFolder, "java-dialects/" + dialectId, t);
            t.writeStringUTF8(new RelFile(dialectDirectory, new String[]{"dialect.json"}), jsonFile);
            t.commitV("Added custom java dialect '%s'", new Object[]{dialectId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(dialectDirectory).getAbsolutePath(), pluginId, dialectId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewCustomJavaExpositionToDevPlugin(String pluginId, String expositionId, String fullClassName, AuthCtx authCtx) throws Exception {
        int classNamePos = fullClassName.lastIndexOf(46);
        if (classNamePos < 0) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_COMPONENT_PARAMETER, "Invalid class name (missing package definition) : " + fullClassName);
        }
        String classPackage = fullClassName.substring(0, classNamePos);
        String className = fullClassName.substring(classNamePos + 1);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile pluginFolder = this.checkPluginFolderInTransaction(t, pluginId);
            RelFile expositionDirectory = this.pluginRelFile(pluginId, "java-expositions", expositionId);
            t.makeDirectory(expositionDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-java-exposition.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, expositionId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, "Custom exposition " + expositionId);
            jsonFile = jsonFile.replace(CLASSNAME_REPLACEMENT, className);
            jsonFile = jsonFile.replace(CLASSPACKAGE_REPLACEMENT, classPackage);
            String javaFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-java-exposition.j");
            javaFile = javaFile.replace(ID_REPLACEMENT, expositionId);
            javaFile = javaFile.replace(LABEL_REPLACEMENT, "Custom exposition " + expositionId);
            javaFile = javaFile.replace(CLASSNAME_REPLACEMENT, className);
            javaFile = javaFile.replace(CLASSPACKAGE_REPLACEMENT, classPackage);
            String yamlFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-java-exposition.yaml");
            this.writeJavaFile(expositionDirectory, classPackage, className, javaFile, t);
            this.writeFileIntoJavaPackage(expositionDirectory, classPackage, "base.yaml", yamlFile, t);
            this.addBuildXML(pluginId, pluginFolder, "java-expositions/" + expositionId, t);
            t.writeStringUTF8(new RelFile(expositionDirectory, new String[]{"exposition.json"}), jsonFile);
            t.commitV("Added custom java exposition '%s'", new Object[]{expositionId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(expositionDirectory).getAbsolutePath(), pluginId, expositionId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewCustomCodeEnvToDevPlugin(String pluginId, CodeEnvModel.EnvLang envLang, boolean forceConda, AuthCtx authCtx) throws Exception {
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            CodeEnvModel.AbstractPluginEnvDesc desc;
            this.checkPluginFolderInTransaction(t, pluginId);
            RelFile codeEnvDir = this.pluginRelFile(pluginId, "code-env");
            t.makeDirectory(codeEnvDir);
            for (CodeEnvModel.EnvLang el : CodeEnvModel.EnvLang.values()) {
                RelFile codeEnvLangDir = new RelFile(codeEnvDir, new String[]{el.getFolderName()});
                if (!t.exists(codeEnvLangDir)) continue;
                throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_COMPONENT_PARAMETER, "Dev plugin already has a code env of type " + el.name());
            }
            RelFile codeEnvLangDir = new RelFile(codeEnvDir, new String[]{envLang.getFolderName()});
            RelFile codeEnvSpecDir = new RelFile(codeEnvLangDir, new String[]{"spec"});
            t.makeDirectory(codeEnvLangDir);
            t.makeDirectory(codeEnvSpecDir);
            RelFile descFile = new RelFile(codeEnvLangDir, new String[]{"desc.json"});
            RelFile specFile = new RelFile(codeEnvSpecDir, new String[]{envLang.getPackageFileName()});
            RelFile condaSpecFile = new RelFile(codeEnvSpecDir, new String[]{"environment.spec"});
            if (envLang == CodeEnvModel.EnvLang.PYTHON) {
                desc = CodeEnvModel.PythonPluginEnvDesc.createNewWithDefaults();
            } else if (envLang == CodeEnvModel.EnvLang.R) {
                desc = new CodeEnvModel.RPluginEnvDesc();
            } else {
                throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_COMPONENT_PARAMETER, "Unknown code env language " + String.valueOf((Object)envLang));
            }
            desc.forceConda = forceConda;
            desc.installCorePackages = true;
            t.writeObject(descFile, (Object)desc);
            t.writeStringUTF8(specFile, "");
            if (forceConda) {
                t.writeStringUTF8(condaSpecFile, "");
            }
            t.commitV("Added custom code env '%s'", new Object[]{envLang});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(codeEnvLangDir).getAbsolutePath(), pluginId, envLang.getFolderName());
            return recipeConversionResult;
        }
    }

    public void removeCustomCodeEnvFromDevPlugin(String pluginId, AuthCtx authCtx) throws Exception {
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            this.checkPluginFolderInTransaction(t, pluginId);
            RelFile codeEnvDir = this.pluginRelFile(pluginId, "code-env");
            t.deleteDirectory(codeEnvDir);
            t.commit("Removed custom code env");
            this.loadService.reloadPlugin(pluginId);
        }
    }

    public RecipeConversionResult addNewParameterSetToDevPlugin(String pluginId, String elementId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, "parameter-sets", elementId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-parameter-set.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, elementId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, "Parameter set " + elementId);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"parameter-set.json"}), jsonFile);
            t.commit("Added parameter set " + elementId);
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, elementId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewAppTemplateToDevPlugin(String pluginId, String appName, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, "apps", appName);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-app.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, appName);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, "App template " + appName);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"app.json"}), jsonFile);
            t.commitV("Added new app template '%s'", new Object[]{appName});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, appName);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewCodeStudioTemplateToDevPlugin(String pluginId, String label, AuthCtx authCtx, CodeStudioTemplate template, File resourcesStageDir) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory;
            if (resourcesStageDir.exists()) {
                NativeFS srcFolderFS = NativeFS.from((File)resourcesStageDir).build();
                RelFile dstFolder = this.pluginRelFile(pluginId, "resource", "python-code-studios", label);
                if (t.exists(dstFolder)) {
                    t.deleteDirectory(dstFolder);
                }
                FSUtils.newRecursiveCopy().from((ReadOnlyFS)srcFolderFS, new RelFile(new String[0])).to((ReadWriteFS)t, dstFolder).run();
            }
            if (t.exists(elementDirectory = this.pluginRelFile(pluginId, "python-code-studios", label))) {
                t.deleteDirectory(elementDirectory);
            }
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-exported-code-studio-template.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, label);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, "Code Studio template " + label);
            jsonFile = jsonFile.replace(DESCRIPTION_REPLACEMENT, StringUtils.defaultIfBlank((String)template.shortDesc, (String)""));
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-exported-code-studio-template.py");
            pyFile = pyFile.replace(ID_REPLACEMENT, label);
            pyFile = pyFile.replace(LABEL_REPLACEMENT, "Code Studio template " + label);
            pyFile = pyFile.replace(TEMPLATE_BLOCKS_REPLACEMENT, JSON.pretty(template.getParamsAs(BlockBasedCodeStudioTemplateParams.class).blocks).replace("\\", "\\\\"));
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"code_studio.py"}), pyFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"code_studio.json"}), jsonFile);
            t.commitV("Added new Code Studio template '%s'", new Object[]{label});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, label);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addNewCustomSampleDatasetToDevPlugin(String pluginId, String label, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, "sample-datasets", label);
            t.makeDirectory(elementDirectory);
            RelFile dataDirectory = this.pluginRelFile(pluginId, "sample-datasets", label, "data");
            t.makeDirectory(dataDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-sample-dataset.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, pluginId);
            jsonFile = jsonFile.replace(LABEL_REPLACEMENT, label);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"dataset.json"}), jsonFile);
            t.writeStringUTF8(new RelFile(dataDirectory, new String[]{"sample.csv"}), DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-sample-dataset.csv"));
            t.commitV("Added new custom file resource dataset component '%s'", new Object[]{pluginId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, label);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult getRecipeConversionResult(String pluginId, String elementKind, String elementId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (Transaction t = this.getTransactionProvider(pluginId).beginRead();){
            RelFile elementDirectory = this.pluginRelFile(pluginId, elementKind, elementId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, elementId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addGuardrailToDevPlugin(String pluginId, String guardrailId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, this.guardrailsService.getFolderName(), guardrailId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-guardrail.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, guardrailId);
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-guardrail.py");
            pyFile = pyFile.replace(ID_REPLACEMENT, guardrailId);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"guardrail.py"}), pyFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"guardrail.json"}), jsonFile);
            t.commitV("Added new guardrail '%s'", new Object[]{guardrailId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, guardrailId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addAgentToDevPlugin(String pluginId, String agentId, String template, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, this.agentsService.getFolderName(), agentId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-agent.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, agentId);
            String pyFile = StringUtils.isBlank((String)template) ? DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-agent.py") : template;
            pyFile = pyFile.replace(ID_REPLACEMENT, agentId);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"agent.py"}), pyFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"agent.json"}), jsonFile);
            t.commitV("Added new agent '%s'", new Object[]{agentId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, agentId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addAgentToolToDevPlugin(String pluginId, String toolId, AuthCtx authCtx) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, this.agentToolsService.getFolderName(), toolId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-agent-tool.json");
            jsonFile = jsonFile.replace(ID_REPLACEMENT, toolId);
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), "bootstrap-agent-tool.py");
            pyFile = pyFile.replace(ID_REPLACEMENT, toolId);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"tool.py"}), pyFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"tool.json"}), jsonFile);
            t.commitV("Added new agent tool '%s'", new Object[]{toolId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, toolId);
            return recipeConversionResult;
        }
    }

    public RecipeConversionResult addCustomLLMToDevPlugin(String pluginId, String toolId, AuthCtx authCtx, String jsonModelTemplate, String pythonModelTemplate) throws Exception {
        this.checkPluginFolder(pluginId);
        try (RWTransaction t = this.getTransactionProvider(pluginId).beginWrite(authCtx);){
            RelFile elementDirectory = this.pluginRelFile(pluginId, this.pythonLLMsService.getFolderName(), toolId);
            t.makeDirectory(elementDirectory);
            String jsonFile = DKUIOUtils.getResourceFileContent(this.getClass(), jsonModelTemplate);
            jsonFile = jsonFile.replace(ID_REPLACEMENT, toolId);
            String pyFile = DKUIOUtils.getResourceFileContent(this.getClass(), pythonModelTemplate);
            pyFile = pyFile.replace(ID_REPLACEMENT, toolId);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"llm.py"}), pyFile);
            t.writeStringUTF8(new RelFile(elementDirectory, new String[]{"llm.json"}), jsonFile);
            t.commitV("Added new custom model '%s'", new Object[]{toolId});
            this.loadService.reloadPlugin(pluginId);
            RecipeConversionResult recipeConversionResult = new RecipeConversionResult(t.resolve(elementDirectory).getAbsolutePath(), pluginId, toolId);
            return recipeConversionResult;
        }
    }

    public static class DevPluginData {
        InstalledPluginDesc installedDesc;
        String baseFolderPath;
        PluginSettingsAccessService.PluginUISettings settings;
        PluginExtraInfo extraInfo;
    }

    private class CreatePluginSimpleFutureThread
    extends SimpleFutureThread<InfoMessage> {
        private String pluginId;
        private final DevPluginBootstrapMode mode;
        private final String gitRepository;
        private final String gitCheckout;
        private final String gitPath;
        private final FuturePayload futurePayload;

        CreatePluginSimpleFutureThread(String pluginId, DevPluginBootstrapMode mode, String gitRepository, String gitCheckout, String gitPath, AuthCtx authCtx) {
            super(authCtx);
            this.pluginId = pluginId;
            this.mode = mode;
            this.gitRepository = gitRepository;
            this.gitCheckout = gitCheckout;
            this.gitPath = gitPath;
            this.futurePayload = this.buildFuturePayload(gitRepository);
        }

        private FuturePayload buildFuturePayload(String pluginId) {
            FuturePayload fp = new FuturePayload();
            fp.action = "plugin_create";
            fp.targets.add(new FuturePayload.FuturePayloadTarget(StringUtils.defaultIfBlank((String)pluginId, (String)"plugin-import-from-git"), "PLUGIN"));
            fp.displayName = "Creating plugin";
            return fp;
        }

        @Override
        protected InfoMessage compute() throws Exception {
            switch (this.mode) {
                case EMPTY: {
                    DevPluginsService.this.checkDoesNotExist(this.pluginId);
                    logger.debug((Object)("New empty plugin: " + this.pluginId));
                    File pluginRoot = DevPluginsService.this.getPluginRoot(this.pluginId);
                    File pythonLib = new File(pluginRoot, "python-lib");
                    FileUtils.forceMkdir((File)pluginRoot);
                    FileUtils.forceMkdir((File)pythonLib);
                    String pythonModuleName = this.pluginId.replace("-", "");
                    File pythonPackageFile = new File(pythonLib, pythonModuleName);
                    String bootstrapCode = "# When creating plugins, it is a good practice to put the specific logic in libraries and keep plugin components (recipes, etc) short. \n# You can add functionalities to this package and/or create new packages under \"python-lib\"";
                    FileUtils.forceMkdir((File)pythonPackageFile);
                    com.google.common.io.Files.asCharSink((File)new File(pythonPackageFile, "__init__.py"), (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)bootstrapCode);
                    RelFile descFile = DevPluginsService.this.pluginRelFile(this.pluginId, "plugin.json");
                    String jsonFile = DKUIOUtils.getResourceFileContent(((Object)((Object)this)).getClass(), "bootstrap-plugin.json");
                    jsonFile = jsonFile.replace(DevPluginsService.ID_REPLACEMENT, this.pluginId);
                    String pluginLabel = StringUtils.capitalize((String)this.pluginId.replace('-', ' '));
                    jsonFile = jsonFile.replace(DevPluginsService.LABEL_REPLACEMENT, pluginLabel);
                    jsonFile = jsonFile.replace("__AUTHOR__", this.owner.getIdentifier());
                    com.google.common.io.Files.asCharSink((File)new File(pluginRoot, descFile.getLeafName()), (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)jsonFile);
                    break;
                }
                case GIT_CLONE: {
                    GitRemoteCommands git;
                    logger.debug((Object)("New dev plugin: git clone of " + UrlRedactionUtils.sanitizeHttpUrls((String)this.gitRepository)));
                    PluginsGitService.checkPerPluginGit();
                    try (AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"plugin-clones", (String)Long.toString(System.currentTimeMillis()));){
                        git = new GitRemoteCommands((File)tmpDir);
                        git.clone(this.owner, this.gitRepository, null, ".", true);
                        this.pluginId = DevPluginsService.this.loadService.getPluginId((File)tmpDir);
                        DevPluginsService.this.checkDoesNotExist(this.pluginId);
                        if (!tmpDir.setExecutable(true, false)) {
                            logger.error((Object)String.format("Unable to change execution permissions on file %s", tmpDir.getAbsolutePath()));
                        }
                        if (!tmpDir.setReadable(true, false)) {
                            logger.error((Object)String.format("Unable to change read permissions on file %s", tmpDir.getAbsolutePath()));
                        }
                        Files.move(tmpDir.toPath(), DevPluginsService.this.getPluginRoot(this.pluginId).toPath(), new CopyOption[0]);
                        break;
                    }
                }
                case GIT_EXPORT: {
                    GitRemoteCommands git;
                    logger.infoV("Creating dev plugin through git export (repository=%s checkout=%s path=%s)", new Object[]{UrlRedactionUtils.sanitizeHttpUrls((String)this.gitRepository), this.gitCheckout, this.gitPath});
                    PluginsGitService.checkPerPluginGit();
                    AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"plugin-clones", (String)Long.toString(System.currentTimeMillis()));
                    try {
                        git = new GitRemoteCommands((File)tmpDir);
                        git.shallowClone(this.owner, this.gitRepository, this.gitCheckout);
                        Object outputDir = tmpDir;
                        if (StringUtils.isNotBlank((String)this.gitPath)) {
                            if (!((File)(outputDir = new File((File)outputDir, this.gitPath))).exists()) {
                                throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_WRONG_PATH, "Given path for plugin does not exist in repository: '" + this.gitPath + "'");
                            }
                        } else {
                            DKUFileUtils.forceDelete((File)new File((File)outputDir, ".git"));
                        }
                        if (!((File)outputDir).setExecutable(true, false)) {
                            logger.error((Object)String.format("Unable to change execution permissions on file %s", ((File)outputDir).getAbsolutePath()));
                        }
                        if (!((File)outputDir).setReadable(true, false)) {
                            logger.error((Object)String.format("Unable to change read permissions on file %s", ((File)outputDir).getAbsolutePath()));
                        }
                        this.pluginId = DevPluginsService.this.loadService.getPluginId((File)outputDir);
                        DevPluginsService.this.checkDoesNotExist(this.pluginId);
                        Files.move(((File)outputDir).toPath(), DevPluginsService.this.getPluginRoot(this.pluginId).toPath(), new CopyOption[0]);
                        if (tmpDir == null) break;
                    }
                    catch (Throwable git2) {
                        if (tmpDir != null) {
                            try {
                                tmpDir.close();
                            }
                            catch (Throwable outputDir) {
                                git2.addSuppressed(outputDir);
                            }
                        }
                        throw git2;
                    }
                    tmpDir.close();
                    break;
                }
            }
            DevPluginsService.this.bootstrapConfig_NT(this.owner, this.pluginId);
            try (Transaction t = DevPluginsService.this.transactionService.beginRead();){
                DevPluginsService.this.loadService.loadAfterStartup(this.pluginId);
            }
            t = DevPluginsService.this.transactionService.beginWriteAsDSS();
            try {
                Object notableAction = "";
                PluginSettings settings = DevPluginsService.this.pluginsRegistry.getSettings(this.pluginId);
                if (this.mode == DevPluginBootstrapMode.GIT_CLONE) {
                    settings.gitConfig.defaultRemoteName = "origin";
                    notableAction = "Set default Git remote on to " + UrlRedactionUtils.sanitizeHttpUrls((String)this.gitRepository);
                }
                DevPluginsService.this.pluginsRegistry.setSettings(this.pluginId, settings);
                t.commit("Bootstrap settings on " + this.pluginId + (String)(StringUtils.isNotBlank((String)notableAction) ? "(" + (String)notableAction + ")" : ""));
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
            return new InfoMessage(InfoMessage.Severity.SUCCESS, "Successfully created plugin.", this.pluginId);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }
    }

    public static enum DevPluginBootstrapMode {
        EMPTY,
        GIT_CLONE,
        GIT_EXPORT;

    }

    public static class RecipeConversionResult {
        public String pathToFiles;
        public String pluginId;
        public String recipeId;
        public String relativePathToOpen;

        RecipeConversionResult(String pathToFiles, String pluginId, String recipeId) {
            this.pathToFiles = pathToFiles;
            this.pluginId = pluginId;
            this.recipeId = recipeId;
        }

        RecipeConversionResult(String pathToFiles, String pluginId, String recipeId, String relativePathToOpen) {
            this.pathToFiles = pathToFiles;
            this.pluginId = pluginId;
            this.recipeId = recipeId;
            this.relativePathToOpen = relativePathToOpen;
        }
    }

    public static class WebAppConversionResult {
        public String pathToFiles;
        public String pluginId;
        public String webappType;
        public String relativePathToOpen;

        public WebAppConversionResult(String pathToFiles, String pluginId, String webappType, String relativePathToOpen) {
            this.pathToFiles = pathToFiles;
            this.pluginId = pluginId;
            this.webappType = webappType;
            this.relativePathToOpen = relativePathToOpen;
        }
    }

    public static enum TargetPluginMode {
        NEW,
        EXISTING;

    }
}

