/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport.model;

import com.dataiku.dip.code.CodeEnvModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class ProjectRemappingSettings {
    public List<ConnectionRemapping> connections = new ArrayList<ConnectionRemapping>();
    public List<CodeEnvRemapping> codeEnvs = new ArrayList<CodeEnvRemapping>();
    public List<ContainerExecRemapping> containerExecs = new ArrayList<ContainerExecRemapping>();
    public boolean enableContainerExecRemapping;

    public ConnectionRemapping getRemappingForConnection(String source) {
        if (source == null) {
            return null;
        }
        for (ConnectionRemapping remapping : this.connections) {
            if (!StringUtils.equals((String)remapping.source, (String)source)) continue;
            return remapping;
        }
        return null;
    }

    public CodeEnvRemapping getRemappingForCodeEnv(CodeEnvModel.UsedCodeEnvRef env) {
        if (env.envName == null) {
            return null;
        }
        for (CodeEnvRemapping remapping : this.codeEnvs) {
            if (!StringUtils.equals((String)remapping.source, (String)env.envName)) continue;
            return remapping;
        }
        return null;
    }

    public ContainerExecRemapping getRemappingForContainerExec(String source) {
        if (source == null) {
            return null;
        }
        for (ContainerExecRemapping remapping : this.containerExecs) {
            if (!StringUtils.equals((String)remapping.source, (String)source)) continue;
            return remapping;
        }
        return null;
    }

    public static class ConnectionRemapping
    extends AbstractRemapping {
    }

    public static class CodeEnvRemapping
    extends AbstractRemapping {
    }

    public static class ContainerExecRemapping
    extends AbstractRemapping {
    }

    public static class AbstractRemapping {
        public String source;
        public String target;

        public int hashCode() {
            return Objects.hash(this.source, this.target);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbstractRemapping that = (AbstractRemapping)o;
            return Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target);
        }
    }
}

