/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.consistency;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.BigQueryConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionWithGoogleAuthCredentials;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.DynamoDBConnection;
import com.dataiku.dip.connections.ElasticSearchConnection;
import com.dataiku.dip.connections.FTPConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.connections.KerberizableConnection;
import com.dataiku.dip.connections.MongoDBConnection;
import com.dataiku.dip.connections.RedshiftConnection;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.shaker.ShakerRecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.processors.udf.PythonUDF;
import com.dataiku.dip.shaker.sql.AbstractSqlQueryWithSchemaBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CDECompatibilityCheckerService {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private ComputableFromRefService cfrService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private VariablesService variablesService;
    private static final String DEFAULT_HDFS_SCHEME = "hdfs:";
    private static final String WARNING_PREFIX = "Cannot run in containers: ";
    private static final String ENGINE_LABEL_LOCAL_SUFFIX = " (local)";
    private static final String ENGINE_LABEL_CONTAINERIZED_SUFFIX = " (containerized)";
    private static final Pattern JDBC_HOST_PATTERN = Pattern.compile("^jdbc:.*://([^:/]+)(:.*)?(/.*)?$");
    private static final Pattern SCHEME_PATTERN = Pattern.compile("^([^:]+:).*$");
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.cde.check");

    private void downgradeRecipeEngineStatus(RecipeEngineStatus status, String reason) {
        if (status.statusWarnLevel != RecipeEngineStatus.WarningLevel.WARN && status.statusWarnLevel != RecipeEngineStatus.WarningLevel.ERROR) {
            status.label = status.label + ENGINE_LABEL_LOCAL_SUFFIX;
            status.description = "Computation cannot run in container: " + reason;
            status.isCDEDowngradedToLocal = true;
        }
    }

    private void setContainerizedRecipeEngineStatus(RecipeEngineStatus status) {
        status.label = status.label + ENGINE_LABEL_CONTAINERIZED_SUFFIX;
        status.isCDEDowngradedToLocal = false;
    }

    public void checkRecipeEngineStatus(AuthCtx authCtx, SerializedRecipe sr, @Nullable String payload, RecipeEngineStatus status, ContainerExecSelection containerExecSelection) throws IOException, DKUSecurityException {
        BasicWarningCollector collector = new BasicWarningCollector();
        if (status.isCDEDowngradedToLocal != null) {
            logger.warn((Object)"status was already checked for cde, cannot be done multiple times");
            return;
        }
        ContainerExecRuntimeConfig containerConfig = this.getContainerConfig(authCtx, sr, containerExecSelection, collector);
        if (containerConfig != null) {
            this.check(authCtx, sr, payload, collector);
        }
        if (collector.hasWarnings()) {
            this.downgradeRecipeEngineStatus(status, collector.warnings.get(0));
        } else if (containerConfig != null) {
            this.setContainerizedRecipeEngineStatus(status);
        }
    }

    public ContainerExecRuntimeConfig getContainerConfig(boolean isRunningInContainer, AuthCtx authCtx, WarningsContext warningsContext, ContainerExecSelection containerSelection, SerializedRecipe sr, @Nullable String payload) throws IOException, DKUSecurityException {
        if (isRunningInContainer) {
            return null;
        }
        WarningsContextCollector collector = new WarningsContextCollector(warningsContext);
        ContainerExecRuntimeConfig containerConfig = this.getContainerConfig(authCtx, sr, containerSelection, collector);
        if (containerConfig == null) {
            return null;
        }
        this.check(authCtx, sr, payload, collector);
        if (collector.hasWarnings()) {
            logger.warn((Object)"Reverting to local execution");
            return null;
        }
        return containerConfig;
    }

    private ContainerExecRuntimeConfig getContainerConfig(AuthCtx authCtx, SerializedRecipe sr, ContainerExecSelection containerExecSelection, WarningCollector collector) {
        ContainerExecRuntimeConfig containerConfig = null;
        try {
            containerConfig = new ContainerExecConfigSelector().select_autoTXN_visualRecipesWorkloads(authCtx, sr.getProjectKey(), containerExecSelection);
        }
        catch (ContainerExecConfigSelector.ContainerConfigurationWorkloadTypeException e) {
            collector.nok("Container config workload incompatibility");
        }
        catch (Exception e) {
            collector.nok("Unable to get container config");
        }
        return containerConfig;
    }

    private void check(AuthCtx authCtx, SerializedRecipe sr, @Nullable String payload, WarningCollector collector) throws IOException, DKUSecurityException {
        FlowComputable source;
        for (SerializedRecipe.RecipeInput input : sr.getFlatInputs()) {
            source = this.cfrService.get(sr.projectKey, input.ref);
            this.check(authCtx, sr, collector, source);
        }
        for (SerializedRecipe.RecipeOutput output : sr.getFlatOutputs()) {
            source = this.cfrService.get(sr.projectKey, output.ref);
            this.check(authCtx, sr, collector, source);
        }
        if (sr.getType().equals(ShakerRecipeMeta.META.getType())) {
            this.checkShakerPayload(sr, payload, collector);
        }
    }

    private void checkShakerPayload(SerializedRecipe sr, @Nullable String payload, WarningCollector collector) {
        if (payload == null) {
            return;
        }
        SerializedShakerScript rawSss = (SerializedShakerScript)JSON.parse((String)payload, SerializedShakerScript.class);
        VariablesContext vc = this.variablesService.getForProject(sr.getProjectKey());
        SerializedShakerScript sss = rawSss.expandedDeepCopy(vc);
        List<ProcessorScriptStep> processors = AbstractSqlQueryWithSchemaBuilder.getFlattenedEnabledProcessorsList(sss);
        for (ProcessorScriptStep pss : processors) {
            if (pss.disabled || !pss.type.equals(PythonUDF.META.getName())) continue;
            collector.nok("Script contains Python steps");
            break;
        }
    }

    private void check(AuthCtx authCtx, SerializedRecipe sr, WarningCollector collector, FlowComputable computable) throws IOException, DKUSecurityException {
        switch (computable.getType()) {
            case DATASET: {
                Dataset dataset = ((FlowDataset)computable).getMandatoryUnsafe(this.datasetsDAO);
                this.check(authCtx, sr, collector, dataset);
                break;
            }
            case STREAMING_ENDPOINT: {
                collector.nok("Cannot use streaming endpoints in containers");
                break;
            }
            case MANAGED_FOLDER: {
                ManagedFolder managedFolder = ((FlowManagedFolder)computable).getManagedFolder();
                String conn = managedFolder.getParams().getConnection();
                if (!StringUtils.isNotBlank((String)conn)) break;
                this.check(authCtx, sr, collector, this.connectionsDAO.getConnection(authCtx, conn));
                break;
            }
            default: {
                collector.nok("Cannot run in containers with " + computable.getType().toTaggableType().toHumanReadableString() + " input/output");
            }
        }
    }

    private void check(AuthCtx authCtx, SerializedRecipe sr, WarningCollector collector, Dataset dataset) throws IOException, DKUSecurityException {
        if ("JobsDB".equals(dataset.getType())) {
            collector.nok("Cannot use internal metrics datasets in containers");
            return;
        }
        if ("StatsDB".equals(dataset.getType())) {
            collector.nok("Cannot use internal stats datasets in containers");
            return;
        }
        if ("hiveserver2".equals(dataset.getType())) {
            collector.nok("Cannot use Hive datasets in containers");
            return;
        }
        String connectionName = dataset.getParams().getConnection();
        if (StringUtils.isNotBlank((String)connectionName)) {
            DSSConnection connection = this.connectionsDAO.getConnection(authCtx, connectionName);
            if (connection == null) {
                logger.info((Object)("Cannot find connection " + connectionName + " of dataset " + dataset.getFullName() + ", not checking"));
            } else {
                this.check(authCtx, sr, collector, connection);
            }
        } else {
            logger.info((Object)("Dataset " + dataset.getFullName() + " has no connection, not checking"));
        }
    }

    private void check(AuthCtx authCtx, SerializedRecipe sr, WarningCollector collector, DSSConnection connection) throws IOException {
        KerberizableConnection kerberizableConnection;
        AbstractSQLConnection sqlConnection;
        AbstractSQLConnection.AbstractSQLParams params;
        if ("false".equalsIgnoreCase(ConnectionUtils.geDkuPropertyOrNull(connection, "cde.compatible"))) {
            collector.nok("Connection explicitely flagged as not compatible with CDE");
        }
        if (connection instanceof AbstractSQLConnection && (params = (sqlConnection = (AbstractSQLConnection)connection).getParams()) instanceof AbstractSQLConnection.AbstractSQLParamsWithStdFields) {
            AbstractSQLConnection.AbstractSQLParamsWithStdFields paramsWithStdFields = (AbstractSQLConnection.AbstractSQLParamsWithStdFields)params;
            String host = this.guessJdbcHost(paramsWithStdFields.host, paramsWithStdFields.useURL, paramsWithStdFields.url);
            if (this.isLocalhost(host)) {
                collector.nok("Cannot use connections to localhost in containers");
            }
        }
        if (connection instanceof KerberizableConnection && (kerberizableConnection = (KerberizableConnection)((Object)connection)).isKerberosLoginEnabled()) {
            collector.nok("Cannot use Kerberos authentication in containers for " + connection.getType());
        }
        switch (connection.getType()) {
            case "Cassandra": 
            case "SSH": {
                collector.nok("Cannot use " + connection.getType() + " connections in containers");
                break;
            }
            case "HDFS": {
                GeneralSettingsDAO.GeneralSettings settings = this.generalSettingsDAO.getUnsafeAutoTXN();
                if (!settings.hadoopSettings.kerberosLoginEnabled) break;
                HDFSConnection hdfsConnection = (HDFSConnection)connection;
                HDFSConnection.RootAndExtraConf rootAndExtraConf = hdfsConnection.getUnresolvedRootAndExtraConf(authCtx, sr.projectKey);
                String scheme = this.guessScheme(rootAndExtraConf.root, rootAndExtraConf.extraConf);
                if (!StringUtils.defaultIfBlank((String)scheme, (String)"").startsWith(DEFAULT_HDFS_SCHEME)) break;
                collector.nok("Cannot use Kerberos authentication in containers for HDFS");
                break;
            }
            case "BigQuery": {
                BigQueryConnection bigqueryConnection = (BigQueryConnection)connection;
                if (bigqueryConnection.params.authType != ConnectionWithGoogleAuthCredentials.AuthType.ENVIRONMENT || bigqueryConnection.params.driverMode != BigQueryConnection.BigQueryDriverMode.CUSTOM) break;
                collector.nok("Cannot use authentication from environment with the Simba driver in containers for BigQuery");
                break;
            }
            case "Redshift": {
                RedshiftConnection redshiftConnection = (RedshiftConnection)connection;
                if (redshiftConnection.getParams().redshiftAuthenticationMode != RedshiftConnection.RedshiftDriverAuthenticationMode.IAM_WITH_HOST && redshiftConnection.getParams().redshiftAuthenticationMode != RedshiftConnection.RedshiftDriverAuthenticationMode.IAM_WITH_CLUSTER_ID) break;
                collector.nok("Cannot use IAM authentication in containers for Redshift");
                break;
            }
            case "DynamoDB": {
                DynamoDBConnection dynamodbConnection = (DynamoDBConnection)connection;
                if (!dynamodbConnection.params.useDefaultCredentials) break;
                collector.nok("Cannot use default credentials in containers for DynamoDB");
                break;
            }
            case "FTP": {
                FTPConnection ftpConnection = (FTPConnection)connection;
                String host = ftpConnection.params.host;
                if (!this.isLocalhost(host)) break;
                collector.nok("Cannot use connections to localhost in containers");
                break;
            }
            case "MongoDB": {
                MongoDBConnection mongoConnection = (MongoDBConnection)connection;
                String host = mongoConnection.params.host;
                if (!this.isLocalhost(host)) break;
                collector.nok("Cannot use connections to localhost in containers");
                break;
            }
            case "ElasticSearch": {
                ElasticSearchConnection esConnection = (ElasticSearchConnection)connection;
                String host = esConnection.params.host;
                if (!this.isLocalhost(host)) break;
                collector.nok("Cannot use connections to localhost in containers");
            }
        }
    }

    private String guessJdbcHost(String host, boolean useURL, String url) {
        if (useURL) {
            Matcher urlMatcher = JDBC_HOST_PATTERN.matcher(url);
            if (urlMatcher.matches()) {
                return urlMatcher.group(1);
            }
            return "";
        }
        return StringUtils.defaultIfBlank((String)host, (String)"");
    }

    private boolean isLocalhost(String host) {
        if (StringUtils.isBlank((String)host)) {
            return false;
        }
        if (Pattern.matches("^(localhost|127\\.0\\.0\\.1)$", host)) {
            return true;
        }
        try {
            InetAddress address = InetAddress.getByName(host);
            return address.isLoopbackAddress() || address.isLinkLocalAddress();
        }
        catch (Exception e) {
            logger.warn((Object)("Could not check if " + host + " is local"), (Throwable)e);
            return false;
        }
    }

    private String guessScheme(String root, List<AbstractSQLConnection.CustomDatabaseProperty> extraConf) {
        Matcher rootMatcher = SCHEME_PATTERN.matcher(StringUtils.defaultIfBlank((String)root, (String)""));
        if (rootMatcher.matches()) {
            return rootMatcher.group(1);
        }
        for (AbstractSQLConnection.CustomDatabaseProperty kv : extraConf) {
            Matcher valueMatcher;
            if (!"fs.defaultFS".equals(kv.name) || !(valueMatcher = SCHEME_PATTERN.matcher(StringUtils.defaultIfBlank((String)kv.value, (String)""))).matches()) continue;
            return valueMatcher.group(1);
        }
        return DEFAULT_HDFS_SCHEME;
    }

    private class BasicWarningCollector
    implements WarningCollector {
        private final List<String> warnings = new ArrayList<String>();

        BasicWarningCollector() {
        }

        @Override
        public void nok(String reason) {
            this.warnings.add(reason);
        }

        @Override
        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }
    }

    public static interface WarningCollector {
        public void nok(String var1);

        public boolean hasWarnings();
    }

    private class WarningsContextCollector
    implements WarningCollector {
        private final WarningsContext warningsContext;
        private int warningCount = 0;

        WarningsContextCollector(WarningsContext warningsContext) {
            this.warningsContext = warningsContext;
        }

        @Override
        public void nok(String reason) {
            ++this.warningCount;
            if (this.warningsContext != null) {
                this.warningsContext.addWarning(WarningsContext.WarningType.CONTAINERIZED_ENGINE_INCOMPATIBILITY, CDECompatibilityCheckerService.WARNING_PREFIX + reason, logger);
            } else {
                logger.warn((Object)(CDECompatibilityCheckerService.WARNING_PREFIX + reason));
            }
        }

        @Override
        public boolean hasWarnings() {
            return this.warningCount > 0;
        }
    }
}

