/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.common.doc_extraction.chunks;

import com.dataiku.dip.docextraction.StructuredContent;
import com.dataiku.dip.docextraction.StructuredContentDTO;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.docextraction.common.chunks.StructuredExtractionChunk;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocumentPageRange;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.ExtractedMetadata;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.MultimodalPart;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.MultimodalTextPart;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.SourceFile;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.chunks.RuleChunk;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.chunks.StructuredImageRuleChunk;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class StructuredRuleChunk
extends RuleChunk {
    public String text;
    public List<String> outline;
    public StructuredContent parentStructure;
    public StructuredContent.PageRange pageRange;

    public StructuredRuleChunk() {
    }

    public StructuredRuleChunk(StructuredExtractionChunk chunk) {
        this.text = chunk.fullContent;
        this.outline = chunk.outline;
        this.parentStructure = chunk.parentStructure;
        this.pageRange = chunk.pageRange;
    }

    public static StructuredRuleChunk buildFromExtractionChunk(StructuredExtractionChunk chunk) {
        if (chunk.imageRef != null) {
            return new StructuredImageRuleChunk(chunk);
        }
        return new StructuredRuleChunk(chunk);
    }

    @Override
    public String getTextValue() {
        return this.text;
    }

    @Override
    public String toJson() {
        if (this.parentStructure != null) {
            StructuredContentDTO dto = this.parentStructure.toDTO(true);
            JsonObject obj = JSON.toJsonObject((Object)dto);
            ArrayList parentOutline = this.outline == null || this.outline.size() <= 1 ? new ArrayList() : this.outline.subList(0, this.outline.size() - 1);
            obj.add("outline", (JsonElement)JSON.toJsonArray(parentOutline));
            return obj.toString();
        }
        return "";
    }

    @Override
    public MultimodalPart getMultimodalValue() {
        return new MultimodalTextPart(this.getTextValue());
    }

    @Override
    public ExtractedMetadata getGeneratedMetadata(InputRefs.ManagedFolderDocumentRef sourceDocument) {
        SourceFile sourceFileMetadata = new SourceFile(sourceDocument.managedFolderId, sourceDocument.filePath);
        ExtractedMetadata metadata = new ExtractedMetadata();
        metadata.sourceFile = sourceFileMetadata;
        ArrayList<String> sectionOutline = new ArrayList<String>();
        if (this.outline != null) {
            for (int i = 0; i < this.outline.size(); ++i) {
                String text = this.outline.get(i);
                String cleanedHeader = StringUtils.stripEnd((String)StringUtils.stripEnd((String)StringUtils.strip((String)text, (String)"#"), (String)"="), (String)"-");
                sectionOutline.add(cleanedHeader);
            }
            metadata.sectionOutline = sectionOutline;
        }
        if (this.pageRange != null && this.pageRange.start != null && this.pageRange.end != null) {
            metadata.pageRange = new DocumentPageRange(this.pageRange.start, this.pageRange.end);
        }
        return metadata;
    }

    public void prependOutlineToText(boolean prependFullOutlineToEachChunksPriorSplitting) {
        if (this.outline != null && !this.outline.isEmpty()) {
            String textPrepended;
            StringBuilder builder = new StringBuilder();
            if (!prependFullOutlineToEachChunksPriorSplitting) {
                builder.append(this.outline.get(this.outline.size() - 1)).append("\n");
            } else {
                this.outline.forEach(level -> builder.append((String)level).append("\n"));
            }
            this.text = textPrepended = builder.append(StringUtils.isNotBlank((String)this.text) ? this.text : "").toString();
        }
    }

    public static List<StructuredRuleChunk> skipEmptySectionsAndPrependOutlineIfNeeded(List<StructuredRuleChunk> chunks, boolean prependFullOutline) {
        boolean keepEmptySections = !prependFullOutline;
        List<StructuredRuleChunk> filteredChunks = chunks.stream().filter(chunk -> keepEmptySections || StringUtils.isNotBlank((String)chunk.getTextValue())).toList();
        filteredChunks.forEach(chunk -> chunk.prependOutlineToText(prependFullOutline));
        return filteredChunks;
    }
}

