/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.shaker;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.code.impala.ImpalaExecutor;
import com.dataiku.dip.recipes.shaker.AbstractShakerRecipeSQLRunner;
import com.dataiku.dip.recipes.shaker.ShakerRecipeParams;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.sql.ImpalaSqlQueryWithSchemaBuilder;
import com.dataiku.dip.shaker.sql.ShakerSQLTranslator;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.queries.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class ShakerRecipeImpalaRunner
extends AbstractShakerRecipeSQLRunner {
    ShakerRecipeImpalaRunner(JobActivity activity) {
        super(activity);
        this.sqlQueryWithSchemaBuilder = new ImpalaSqlQueryWithSchemaBuilder(activity);
    }

    @Override
    protected String getEngineType() {
        return "Impala";
    }

    @Override
    protected AbortableRecipeRunner buildRecipeRunner(ShakerSQLTranslator.TranslatorResult translatorResult) throws IOException, SQLException, DKUSecurityException {
        ImpalaExecutor.ImpalaExecutorParams impalaParams = this.recipe.getModel().getParamsAs(ShakerRecipeParams.class).engineParams.impala;
        ArrayList preQueries = null;
        if (!StringUtils.isBlank((String)impalaParams.preQueries)) {
            Splitter splitter = new Splitter(new ImpalaSQLDialect().getSemicolonExclusionPortionFinders());
            preQueries = Lists.newArrayList((Object[])splitter.split(impalaParams.preQueries));
        }
        ImpalaExecutor impalaRunner = new ImpalaExecutor(this.activity, impalaParams, translatorResult.translated.toSQL(this.sqlQueryWithSchemaBuilder.getDialect()), preQueries, null);
        SpringUtils.getInstance().autowire((Object)impalaRunner);
        return impalaRunner;
    }
}

