/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.ksql;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.streaming.ksql.KsqlRESTClient;
import com.dataiku.dip.recipes.streaming.ksql.KsqlSchemaHandler;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatsFactory;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.kafka.SingleValueKafkaFormat;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class KsqlSynchronizer {
    private final KsqlRESTClient client;
    private static Logger logger = Logger.getLogger((String)"dip.ksql.sync");

    public KsqlSynchronizer(KsqlRESTClient client) {
        this.client = client;
    }

    private String buildDescribeStatement(String name) {
        return KsqlSynchronizer.buildDescribeStatement(this.client, name);
    }

    private static String buildDescribeStatement(KsqlRESTClient client, String name) {
        if (client.useOldStyleDescribe()) {
            return String.format("describe extended `%s`;", name);
        }
        return String.format("describe `%s` extended;", name);
    }

    public CompatibilityAndReason checkSynchronizability(StreamingEndpoint se) throws Exception {
        KafkaStreamingEndpointParams params = se.getParamsAs(KafkaStreamingEndpointParams.class);
        if (!"json".equals(params.formatType) && !"avro".equals(params.formatType)) {
            return new CompatibilityAndReason(Compatibility.NOT_SYNCHRONIZABLE).withReason(String.format("Can only synchronize endpoints using the JSON or Avro format, but is %s", params.formatType));
        }
        if (!"single".equals(params.keyFormatType)) {
            return new CompatibilityAndReason(Compatibility.NOT_SYNCHRONIZABLE).withReason(String.format("Can only synchronize endpoints with keys using the single-value format, but is %s", params.keyFormatType));
        }
        List<SchemaColumn> keyColumns = KafkaFormatsFactory.getSerializer(params.keyFormatType, params.keyFormatParams).getSchemaColumns(se.schema);
        List<SchemaColumn> valueColumns = KafkaFormatsFactory.getSerializer(params.formatType, params.formatParams).getSchemaColumns(se.schema);
        HashSet keyColumnNames = Sets.newHashSet();
        for (SchemaColumn column : keyColumns) {
            keyColumnNames.add(column.getName());
        }
        for (SchemaColumn sc : valueColumns) {
            if (keyColumnNames.contains(sc.getName())) continue;
            if ("ROWKEY".equals(sc.getName())) {
                return new CompatibilityAndReason(Compatibility.NOT_SYNCHRONIZABLE).withReason(String.format("Cannot have a value column named ROWKEY", new Object[0]));
            }
            if (!"ROWTIME".equals(sc.getName())) continue;
            return new CompatibilityAndReason(Compatibility.NOT_SYNCHRONIZABLE).withReason(String.format("Cannot have a value column named ROWTIME", new Object[0]));
        }
        return null;
    }

    public CompatibilityAndReason checkCompatibilityWithExisting(StreamingEndpoint se) throws Exception {
        KsqlRESTClient.StatementResponseDescribe description;
        CompatibilityAndReason synchronizability = this.checkSynchronizability(se);
        if (synchronizability != null) {
            return synchronizability;
        }
        KafkaStreamingEndpointParams params = se.getParamsAs(KafkaStreamingEndpointParams.class);
        try {
            KsqlRESTClient.StatementRequest request = new KsqlRESTClient.StatementRequest();
            request.ksql = this.buildDescribeStatement(se.id);
            KsqlRESTClient.StatementResponses responses = this.client.post("/ksql", JSON.toJsonObject((Object)request), KsqlRESTClient.StatementResponses.class, new String[0]);
            if (responses.size() != 1) {
                return new CompatibilityAndReason(Compatibility.DOES_NOT_EXIST).withReason("Stream not registered in Ksql");
            }
            KsqlRESTClient.StatementResponse response = (KsqlRESTClient.StatementResponse)responses.get(0);
            description = response.sourceDescription;
        }
        catch (KsqlRESTClient.KsqlStatementException e) {
            return new CompatibilityAndReason(Compatibility.DOES_NOT_EXIST).withReason(e.data.get("message").getAsString());
        }
        if (params.ksqlParams.syncAs == KafkaStreamingEndpointParams.KsqlSyncType.STREAM && description.type != KsqlRESTClient.KsqlObjectType.STREAM) {
            return new CompatibilityAndReason(Compatibility.INCOMPATIBLE_TYPE).withReason("Name `" + se.id + "` is not a stream in Ksql (" + String.valueOf((Object)description.type) + ")");
        }
        if (params.ksqlParams.syncAs == KafkaStreamingEndpointParams.KsqlSyncType.TABLE && description.type != KsqlRESTClient.KsqlObjectType.TABLE) {
            return new CompatibilityAndReason(Compatibility.INCOMPATIBLE_TYPE).withReason("Name `" + se.id + "` is not a table in Ksql (" + String.valueOf((Object)description.type) + ")");
        }
        if (!description.topic.equals(params.topic)) {
            return new CompatibilityAndReason(Compatibility.INCOMPATIBLE_TOPIC).withReason(String.format("Stream `%s` is attached to a differnt topic: %s instead of %s", se.id, description.topic, params.topic));
        }
        if (!StringUtils.equalsIgnoreCase((String)description.valueFormat, (String)this.ksqlFormatName(params.formatType))) {
            return new CompatibilityAndReason(Compatibility.INCOMPATIBLE_FORMAT).withReason("Value formats don't match : " + description.valueFormat + " in ksql, " + params.formatType + " in endpoint");
        }
        List<KsqlRESTClient.KsqlField> currentSchema = this.getSchemaWithRowkey(se.schema, params);
        logger.info((Object)("stream fields=" + JSON.pretty(description.fields)));
        HashSet ignoreFields = Sets.newHashSet();
        if (StringUtils.isNotBlank((String)params.timestampColumn)) {
            ignoreFields.add(params.timestampColumn);
        }
        return this.checkCompatibility(currentSchema, description.fields, ignoreFields);
    }

    private String ksqlFormatName(String formatType) {
        switch (formatType) {
            case "avro": {
                return "avro";
            }
            case "json": {
                return "json";
            }
            case "single": {
                return "kafka";
            }
        }
        return null;
    }

    public CompatibilityAndReason checkCompatibilityWithExplained(StreamingEndpoint se, List<KsqlRESTClient.KsqlField> actualSchema) throws Exception {
        CompatibilityAndReason synchronizability = this.checkSynchronizability(se);
        if (synchronizability != null) {
            return synchronizability;
        }
        KafkaStreamingEndpointParams params = se.getParamsAs(KafkaStreamingEndpointParams.class);
        List<KsqlRESTClient.KsqlField> currentSchema = this.getSchemaWithRowkey(se.schema, params);
        actualSchema = (List)JSON.parse((String)JSON.json(actualSchema), (TypeToken)new TypeToken<List<KsqlRESTClient.KsqlField>>(){});
        logger.info((Object)("stream fields=" + JSON.pretty((Object)actualSchema)));
        HashSet ignoreFields = Sets.newHashSet();
        if (StringUtils.isNotBlank((String)params.timestampColumn)) {
            ignoreFields.add(params.timestampColumn);
        }
        return this.checkCompatibility(currentSchema, actualSchema, ignoreFields);
    }

    private static Pair<List<SchemaColumn>, List<SchemaColumn>> getKeyValueColumns(Schema inputSchema, KafkaStreamingEndpointParams params) {
        Schema currentSchema = (Schema)JSON.deepCopy((Object)inputSchema);
        List<SchemaColumn> keyColumns = KafkaFormatsFactory.getSerializer(params.keyFormatType, params.keyFormatParams).getSchemaColumns(currentSchema);
        List<SchemaColumn> valueColumns = KafkaFormatsFactory.getSerializer(params.formatType, params.formatParams).getSchemaColumns(currentSchema);
        HashSet keyColumnNames = Sets.newHashSet();
        for (SchemaColumn sc : keyColumns) {
            keyColumnNames.add(sc.getName());
        }
        Iterator<SchemaColumn> it = valueColumns.iterator();
        logger.info((Object)("Remove " + Joiner.on((String)", ").join((Iterable)keyColumnNames) + " from value columns"));
        while (it.hasNext()) {
            SchemaColumn sc;
            sc = it.next();
            if (!keyColumnNames.contains(sc.getName())) continue;
            it.remove();
        }
        return new Pair(keyColumns, valueColumns);
    }

    private List<KsqlRESTClient.KsqlField> getSchemaWithRowkey(Schema inputSchema, KafkaStreamingEndpointParams params) throws Exception {
        Pair<List<SchemaColumn>, List<SchemaColumn>> columns = KsqlSynchronizer.getKeyValueColumns(inputSchema, params);
        List valueColumns = (List)columns.second;
        ArrayList keyColumns = Lists.newArrayList();
        SingleValueKafkaFormat.SingleValueKafkaFormatParams keyFormatParams = (SingleValueKafkaFormat.SingleValueKafkaFormatParams)JSON.parse((JsonElement)params.keyFormatParams, SingleValueKafkaFormat.SingleValueKafkaFormatParams.class);
        String rowKeyName = StringUtils.defaultIfBlank((String)keyFormatParams.columnName, (String)"ROWKEY");
        if (params.ksqlParams.keyType == null) {
            keyColumns.add(new SchemaColumn(rowKeyName, keyFormatParams.columnType.dssType()));
        } else {
            keyColumns.add(new SchemaColumn(rowKeyName, params.ksqlParams.keyType.dssType()));
        }
        Schema currentSchema = new Schema();
        currentSchema.columns.addAll(keyColumns);
        currentSchema.columns.addAll(valueColumns);
        logger.info((Object)("fixedUpSchemaForRowkey=" + JSON.pretty((Object)currentSchema)));
        KsqlSchemaHandler schemaHandler = new KsqlSchemaHandler();
        List<KsqlRESTClient.KsqlField> fields = schemaHandler.toKsql(currentSchema);
        for (KsqlRESTClient.KsqlField field : fields) {
            if (!field.name.equals(rowKeyName)) continue;
            field.type = "key";
            break;
        }
        return fields;
    }

    public CompatibilityAndReason checkCompatibility(List<KsqlRESTClient.KsqlField> expectedSchema, List<KsqlRESTClient.KsqlField> actualSchema, Set<String> ignoreFields) throws Exception {
        Object keyField;
        HashMap expectedFields = Maps.newHashMap();
        HashMap actualFields = Maps.newHashMap();
        KsqlRESTClient.KsqlField expectedRowKey = null;
        KsqlRESTClient.KsqlField actualRowKey = null;
        for (KsqlRESTClient.KsqlField field : expectedSchema) {
            expectedFields.put(field.name, field);
            if (!"key".equalsIgnoreCase(field.type)) continue;
            expectedRowKey = field;
        }
        for (KsqlRESTClient.KsqlField field : actualSchema) {
            actualFields.put(field.name, field);
            if (!"key".equalsIgnoreCase(field.type)) continue;
            actualRowKey = field;
        }
        logger.info((Object)("Rowkey expected=" + JSON.json(expectedRowKey) + " actual=" + JSON.json(actualRowKey)));
        if (actualRowKey != null && expectedRowKey == null) {
            keyField = (KsqlRESTClient.KsqlField)JSON.deepCopy(actualRowKey);
            expectedFields.put(((KsqlRESTClient.KsqlField)keyField).name, keyField);
            expectedSchema.add((KsqlRESTClient.KsqlField)keyField);
        } else if (actualRowKey == null && expectedRowKey != null) {
            keyField = (KsqlRESTClient.KsqlField)JSON.deepCopy((Object)expectedRowKey);
            actualFields.put(((KsqlRESTClient.KsqlField)keyField).name, keyField);
            actualSchema.add((KsqlRESTClient.KsqlField)keyField);
        }
        if (actualFields.containsKey("ROWTIME") && !expectedFields.containsKey("ROWTIME")) {
            keyField = (KsqlRESTClient.KsqlField)JSON.deepCopy((Object)((KsqlRESTClient.KsqlField)actualFields.get("ROWTIME")));
            expectedFields.put(((KsqlRESTClient.KsqlField)keyField).name, keyField);
            expectedSchema.add((KsqlRESTClient.KsqlField)keyField);
        } else if (!actualFields.containsKey("ROWTIME") && expectedFields.containsKey("ROWTIME")) {
            keyField = (KsqlRESTClient.KsqlField)JSON.deepCopy((Object)((KsqlRESTClient.KsqlField)expectedFields.get("ROWTIME")));
            actualFields.put(((KsqlRESTClient.KsqlField)keyField).name, keyField);
            actualSchema.add((KsqlRESTClient.KsqlField)keyField);
        }
        for (String ignore : ignoreFields) {
            KsqlRESTClient.KsqlField keyField2;
            if (actualFields.containsKey(ignore) && !expectedFields.containsKey(ignore)) {
                keyField2 = (KsqlRESTClient.KsqlField)JSON.deepCopy((Object)((KsqlRESTClient.KsqlField)actualFields.get(ignore)));
                expectedFields.put(keyField2.name, keyField2);
                expectedSchema.add(keyField2);
                continue;
            }
            if (actualFields.containsKey(ignore) || !expectedFields.containsKey(ignore)) continue;
            keyField2 = (KsqlRESTClient.KsqlField)JSON.deepCopy((Object)((KsqlRESTClient.KsqlField)expectedFields.get(ignore)));
            actualFields.put(keyField2.name, keyField2);
            actualSchema.add(keyField2);
        }
        Sets.SetView missing = Sets.difference(expectedFields.keySet(), actualFields.keySet());
        Sets.SetView extra = Sets.difference(actualFields.keySet(), expectedFields.keySet());
        if (missing.size() > 0 || extra.size() > 0) {
            TreeSet missingOrdered = Sets.newTreeSet((Iterable)missing);
            TreeSet extraOrdered = Sets.newTreeSet((Iterable)extra);
            Object missingList = Joiner.on((String)"`, `").join((Iterable)missingOrdered);
            Object extraList = Joiner.on((String)"`, `").join((Iterable)extraOrdered);
            missingList = ((String)missingList).isEmpty() ? "" : "`" + (String)missingList + "`";
            extraList = ((String)extraList).isEmpty() ? "" : "`" + (String)extraList + "`";
            return new CompatibilityAndReason(Compatibility.INCOMPATIBLE_SCHEMA).withReason(String.format("Field names don't match: in dss but not in ksql=%s, in ksql but not in dss=%s", missingList, extraList));
        }
        ArrayList fieldDifferences = Lists.newArrayList();
        for (Map.Entry expected : expectedFields.entrySet()) {
            KsqlRESTClient.KsqlField expectedField = (KsqlRESTClient.KsqlField)expected.getValue();
            KsqlRESTClient.KsqlField actualField = (KsqlRESTClient.KsqlField)actualFields.get(expected.getKey());
            if (expectedField.schema.type == KsqlRESTClient.KsqlFieldType.DOUBLE && actualField.schema.type == KsqlRESTClient.KsqlFieldType.DECIMAL) continue;
            if (expectedField.schema.type != actualField.schema.type) {
                fieldDifferences.add(String.format("`%s` -> %s instead of %s", new Object[]{expectedField.name, actualField.schema.type, expectedField.schema.type}));
                continue;
            }
            if (this.recCheckType(expectedField, actualField)) continue;
            fieldDifferences.add(String.format("`%s` -> differences in subtypes", expectedField.name));
        }
        if (!fieldDifferences.isEmpty()) {
            return new CompatibilityAndReason(Compatibility.INCOMPATIBLE_SCHEMA).withReason(String.format("Field types don't match: %s", Joiner.on((String)", ").join((Iterable)fieldDifferences)));
        }
        return new CompatibilityAndReason(Compatibility.COMPATIBLE);
    }

    private boolean recCheckType(KsqlRESTClient.KsqlField expectedField, KsqlRESTClient.KsqlField actualField) {
        if (expectedField.schema.type == KsqlRESTClient.KsqlFieldType.DOUBLE && actualField.schema.type == KsqlRESTClient.KsqlFieldType.DECIMAL) {
            return true;
        }
        if (expectedField.schema.type != actualField.schema.type) {
            return false;
        }
        if (expectedField.schema.type == KsqlRESTClient.KsqlFieldType.ARRAY || expectedField.schema.type == KsqlRESTClient.KsqlFieldType.MAP) {
            KsqlRESTClient.KsqlField expectedSubField = new KsqlRESTClient.KsqlField();
            expectedSubField.schema = expectedField.schema.memberSchema;
            KsqlRESTClient.KsqlField actualSubField = new KsqlRESTClient.KsqlField();
            actualSubField.schema = actualField.schema.memberSchema;
            return this.recCheckType(expectedSubField, actualSubField);
        }
        if (expectedField.schema.type == KsqlRESTClient.KsqlFieldType.STRUCT) {
            if (expectedField.schema.fields == null && actualField.schema.fields != null) {
                return false;
            }
            if (expectedField.schema.fields != null && actualField.schema.fields == null) {
                return false;
            }
            if (expectedField.schema.fields != null) {
                if (expectedField.schema.fields.size() != actualField.schema.fields.size()) {
                    return false;
                }
                for (int i = 0; i < expectedField.schema.fields.size(); ++i) {
                    if (this.recCheckType(expectedField.schema.fields.get(i), actualField.schema.fields.get(i))) continue;
                    return false;
                }
                return true;
            }
            return true;
        }
        return true;
    }

    public void dropTableOrStream(StreamingEndpoint se, boolean silent, boolean terminateQueries) throws IOException {
        KsqlRESTClient.KsqlObjectType objectType;
        if (terminateQueries) {
            this.terminateQueries(se, silent);
        }
        if ((objectType = this.getTypeIfExists(se)) == null) {
            return;
        }
        this.client.runFullySingleStatement(String.format("drop %s %s`%s`;", objectType.name().toLowerCase(), silent ? "IF EXISTS " : "", se.id), silent, "drop " + objectType.name().toLowerCase());
    }

    public List<String> terminateQueries(StreamingEndpoint se, boolean silent) throws IOException {
        ArrayList terminated = Lists.newArrayList();
        for (String queryId : this.listQueries(se, silent)) {
            if (!this.terminateQuery(queryId, silent)) continue;
            terminated.add(queryId);
        }
        return terminated;
    }

    public List<String> listQueries(StreamingEndpoint se, boolean silent) throws IOException {
        KsqlRESTClient.StatementResponseDescribe description;
        try {
            KsqlRESTClient.StatementRequest request = new KsqlRESTClient.StatementRequest();
            request.ksql = this.buildDescribeStatement(se.id);
            KsqlRESTClient.StatementResponses responses = this.client.post("/ksql", JSON.toJsonObject((Object)request), KsqlRESTClient.StatementResponses.class, new String[0]);
            if (responses.size() != 1) {
                throw new IOException("Too many responses despite single-statement query");
            }
            KsqlRESTClient.StatementResponse response = (KsqlRESTClient.StatementResponse)responses.get(0);
            description = response.sourceDescription;
        }
        catch (KsqlRESTClient.KsqlStatementException e) {
            String errorMessage = "Unable to describe stream, command failed : " + e.data.get("message").getAsString();
            if (silent) {
                logger.warn((Object)errorMessage);
                return Lists.newArrayList();
            }
            throw new IOException(errorMessage);
        }
        ArrayList queries = Lists.newArrayList();
        for (KsqlRESTClient.StatementResponseQuery query : description.readQueries) {
            queries.add(query.id);
        }
        for (KsqlRESTClient.StatementResponseQuery query : description.writeQueries) {
            queries.add(query.id);
        }
        return queries;
    }

    public static List<String> listQueries(KsqlRESTClient client, String name, boolean silent) throws IOException {
        KsqlRESTClient.StatementResponseDescribe description;
        try {
            KsqlRESTClient.StatementRequest request = new KsqlRESTClient.StatementRequest();
            request.ksql = KsqlSynchronizer.buildDescribeStatement(client, name);
            KsqlRESTClient.StatementResponses responses = client.post("/ksql", JSON.toJsonObject((Object)request), KsqlRESTClient.StatementResponses.class, new String[0]);
            if (responses.size() != 1) {
                throw new IOException("Too many responses despite single-statement query");
            }
            KsqlRESTClient.StatementResponse response = (KsqlRESTClient.StatementResponse)responses.get(0);
            description = response.sourceDescription;
        }
        catch (KsqlRESTClient.KsqlStatementException e) {
            String errorMessage = "Unable to describe stream, command failed : " + e.data.get("message").getAsString();
            if (silent) {
                logger.warn((Object)errorMessage);
                return Lists.newArrayList();
            }
            throw new IOException(errorMessage);
        }
        ArrayList queries = Lists.newArrayList();
        for (KsqlRESTClient.StatementResponseQuery query : description.readQueries) {
            queries.add(query.id);
        }
        for (KsqlRESTClient.StatementResponseQuery query : description.writeQueries) {
            queries.add(query.id);
        }
        return queries;
    }

    public boolean terminateQuery(String queryId, boolean silent) throws IOException {
        return this.client.runFullySingleStatement(String.format("terminate `%s`;", queryId), silent, "terminate query");
    }

    public KsqlRESTClient.KsqlObjectType getTypeIfExists(StreamingEndpoint se) throws IOException {
        if (this.streamExists(se)) {
            return KsqlRESTClient.KsqlObjectType.STREAM;
        }
        if (this.tableExists(se)) {
            return KsqlRESTClient.KsqlObjectType.TABLE;
        }
        return null;
    }

    private boolean streamExists(StreamingEndpoint se) throws IOException {
        KsqlRESTClient.StatementRequest request = new KsqlRESTClient.StatementRequest();
        request.ksql = String.format("show streams;", new Object[0]);
        KsqlRESTClient.StatementResponses responses = this.client.post("/ksql", JSON.toJsonObject((Object)request), KsqlRESTClient.StatementResponses.class, new String[0]);
        if (responses.size() != 1) {
            throw new IOException("Unable to drop stream, no response from ksql");
        }
        KsqlRESTClient.StatementResponse response = (KsqlRESTClient.StatementResponse)responses.get(0);
        for (KsqlRESTClient.StatementResponseStream stream : response.streams) {
            if (!stream.name.equals(se.id)) continue;
            return true;
        }
        return false;
    }

    private boolean tableExists(StreamingEndpoint se) throws IOException {
        KsqlRESTClient.StatementRequest request = new KsqlRESTClient.StatementRequest();
        request.ksql = String.format("show tables;", new Object[0]);
        KsqlRESTClient.StatementResponses responses = this.client.post("/ksql", JSON.toJsonObject((Object)request), KsqlRESTClient.StatementResponses.class, new String[0]);
        if (responses.size() != 1) {
            throw new IOException("Unable to drop stream, no response from ksql");
        }
        KsqlRESTClient.StatementResponse response = (KsqlRESTClient.StatementResponse)responses.get(0);
        for (KsqlRESTClient.StatementResponseTable table : response.tables) {
            if (!table.name.equals(se.id)) continue;
            return true;
        }
        return false;
    }

    public void createTableOrStream(StreamingEndpoint se) throws Exception {
        this.client.runFullySingleStatement(this.buildCreateStatement(se) + ";", false, "create stream");
    }

    public String buildCreateStatement(StreamingEndpoint se) throws IOException, Exception {
        KafkaStreamingEndpointParams params = se.getParamsAs(KafkaStreamingEndpointParams.class);
        String properties = this.buildStreamOrTableProperties(se, false);
        ArrayList schemaString = Lists.newArrayList();
        List<KsqlRESTClient.KsqlField> currentSchema = this.getSchemaWithRowkey(se.schema, params);
        for (KsqlRESTClient.KsqlField field : currentSchema) {
            Object repr = KsqlSynchronizer.repr(field);
            if ("key".equalsIgnoreCase(field.type)) {
                repr = params.ksqlParams.syncAs == KafkaStreamingEndpointParams.KsqlSyncType.TABLE && !this.client.usesOldStyleRowkeys() ? (String)repr + " PRIMARY KEY" : (String)repr + " KEY";
            } else if (field.name.equals("ROWTIME") || field.name.equals(params.timestampColumn)) continue;
            schemaString.add(repr);
        }
        return String.format("create %s `%s` (%s) with (%s)", params.ksqlParams.syncAs.name().toLowerCase(), se.id, Joiner.on((String)", ").join((Iterable)schemaString), properties);
    }

    public String buildStreamOrTableProperties(StreamingEndpoint se, boolean forCtas) throws IOException, Exception {
        KafkaStreamingEndpointParams params = se.getParamsAs(KafkaStreamingEndpointParams.class);
        HashMap propertiesMap = Maps.newHashMap();
        for (SimpleKeyValue kv : params.ksqlParams.properties) {
            if (forCtas && kv.key.toLowerCase().startsWith("window_")) {
                logger.info((Object)("Skipping " + kv.key + " in context of a CTAS"));
                continue;
            }
            propertiesMap.put(kv.key, kv.value);
        }
        propertiesMap.put("kafka_topic", params.topic);
        if (!"single".equals(params.keyFormatType)) {
            throw new IOException("Can only synchronize kafka endpoints with keys using the single-value format");
        }
        if (!"json".equals(params.formatType) && !"avro".equals(params.formatType)) {
            throw new IOException("Can only synchronize kafka endpoints that use the json or Avro format");
        }
        if (se.schema == null || se.schema.columns.isEmpty()) {
            throw new IOException("Can only synchronize kafka endpoints with a non-empty schema");
        }
        propertiesMap.put("value_format", params.formatType.toUpperCase());
        if (StringUtils.isNotBlank((String)params.ksqlParams.timestamp)) {
            propertiesMap.put("timestamp", params.ksqlParams.timestamp);
            SchemaColumn timestampColumn = se.schema.getColumn(params.ksqlParams.timestamp);
            if (timestampColumn != null && timestampColumn.getType() == Type.STRING && StringUtils.isNotBlank((String)params.ksqlParams.timestampFormat)) {
                propertiesMap.put("timestamp_format", params.ksqlParams.timestampFormat.replace("'", "''"));
            }
        }
        SingleValueKafkaFormat.SingleValueKafkaFormatParams keyFormatParams = (SingleValueKafkaFormat.SingleValueKafkaFormatParams)JSON.parse((JsonElement)params.keyFormatParams, SingleValueKafkaFormat.SingleValueKafkaFormatParams.class);
        if (StringUtils.isNotBlank((String)keyFormatParams.columnName) && this.client.usesOldStyleRowkeys() && params.ksqlParams.syncAs == KafkaStreamingEndpointParams.KsqlSyncType.STREAM && !"ROWKEY".equals(keyFormatParams.columnName)) {
            propertiesMap.put("key", keyFormatParams.columnName);
        }
        if (!forCtas && params.ksqlParams.windowType != KafkaStreamingEndpointParams.KsqlWindowType.NONE) {
            propertiesMap.put("window_type", params.ksqlParams.windowType.name());
        }
        ArrayList streamProperties = Lists.newArrayList();
        for (Map.Entry kv : propertiesMap.entrySet()) {
            streamProperties.add(String.format("%s='%s'", kv.getKey(), kv.getValue()));
        }
        return Joiner.on((String)", ").join((Iterable)streamProperties);
    }

    private static String repr(KsqlRESTClient.KsqlField field) {
        return String.format("`%s` %s", field.name, KsqlSynchronizer.repr(field.schema));
    }

    private static String repr(KsqlRESTClient.KsqlFieldSchema field) {
        if (field.type == KsqlRESTClient.KsqlFieldType.ARRAY) {
            return String.format("%s<%s>", field.type.name(), KsqlSynchronizer.repr(field.memberSchema));
        }
        if (field.type == KsqlRESTClient.KsqlFieldType.MAP) {
            return String.format("%s<STRING, %s>", field.type.name(), KsqlSynchronizer.repr(field.memberSchema));
        }
        if (field.type == KsqlRESTClient.KsqlFieldType.STRUCT) {
            ArrayList subFields = Lists.newArrayList();
            for (KsqlRESTClient.KsqlField sub : field.fields) {
                subFields.add(KsqlSynchronizer.repr(sub));
            }
            return String.format("%s<%s>", field.type.name(), Joiner.on((String)", ").join((Iterable)subFields));
        }
        return field.type.name();
    }

    public Schema adjustNewSchema(StreamingEndpoint se, Schema newSchema) {
        Schema updated = new Schema();
        KafkaStreamingEndpointParams params = se.getParamsAs(KafkaStreamingEndpointParams.class);
        SingleValueKafkaFormat.SingleValueKafkaFormatParams keyFormatParams = (SingleValueKafkaFormat.SingleValueKafkaFormatParams)JSON.parse((JsonElement)params.keyFormatParams, SingleValueKafkaFormat.SingleValueKafkaFormatParams.class);
        for (SchemaColumn sc : newSchema.getColumns()) {
            if ("ROWTIME".equals(sc.getName()) || StringUtils.isBlank((String)keyFormatParams.columnName) && "ROWKEY".equals(sc.getName())) continue;
            if (StringUtils.isNotBlank((String)keyFormatParams.columnName) && "ROWKEY".equals(sc.getName())) {
                SchemaColumn nsc = (SchemaColumn)JSON.deepCopy((Object)sc);
                nsc.setName(keyFormatParams.columnName);
                updated.addColumn(nsc);
                continue;
            }
            updated.addColumn(sc);
        }
        return updated;
    }

    public void fillUpdateResult(RecipeSchemaService.ComputableSchemaAutoupdateResult updateResult, StreamingEndpoint se, List<KsqlRESTClient.KsqlField> explanation) throws Exception {
        KsqlRESTClient.KsqlField rowKey = null;
        for (KsqlRESTClient.KsqlField field : explanation) {
            if (!"key".equalsIgnoreCase(field.type)) continue;
            rowKey = field;
        }
        KsqlSchemaHandler schemaHandler = new KsqlSchemaHandler();
        updateResult.newSchema = schemaHandler.fromKsql(explanation);
        updateResult.newSchema = this.adjustNewSchema(se, updateResult.newSchema);
        if (rowKey != null) {
            updateResult.getKsqlParams().keyType = SingleValueKafkaFormat.KeyType.fromKsqlType(rowKey.schema.type);
            updateResult.getKsqlParams().keyName = rowKey.name;
        }
    }

    public static class CompatibilityAndReason {
        public Compatibility compatibility;
        public String reason;

        public CompatibilityAndReason(Compatibility compatibility) {
            this.compatibility = compatibility;
        }

        public CompatibilityAndReason withReason(String reason) {
            this.reason = reason;
            return this;
        }
    }

    public static enum Compatibility {
        DOES_NOT_EXIST,
        NOT_SYNCHRONIZABLE,
        INCOMPATIBLE_TYPE,
        INCOMPATIBLE_TOPIC,
        INCOMPATIBLE_FORMAT,
        INCOMPATIBLE_SCHEMA,
        COMPATIBLE;

    }
}

