/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck.detectors;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.sanitycheck.SanityCheckDetectorBase;
import com.dataiku.dip.sanitycheck.SanityCheckInfoMessages;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.html.HtmlEscapers;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class JDBCDetector
implements SanityCheckDetectorBase {
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.sanitycheck.jdbcdetector");

    public List<InfoMessage.MessageCode> getCodes() {
        return Arrays.asList(Codes.values());
    }

    public SanityCheckInfoMessages runAnalysis(Set<String> exclusionList) {
        SanityCheckInfoMessages messages = new SanityCheckInfoMessages();
        if (!exclusionList.contains(Codes.WARN_MISC_JDBC_JARS_CONFLICT.getCode())) {
            List conflictProneJars;
            logger.info((Object)"looking for JDBC drivers in <DATA_DIR>/lib/jdbc");
            List files = DKUFileUtils.listJarFiles((File)DKUApp.getFile((String[])new String[]{"lib", "jdbc"}));
            if (!files.isEmpty() && !(conflictProneJars = files.stream().map(File::getName).filter(this::isNastyJar).collect(Collectors.toList())).isEmpty()) {
                String jars = String.join((CharSequence)"\n", conflictProneJars);
                logger.debugV("Found conflict prone jars in lib/jdbc drivers: %s", new Object[]{jars});
                messages.withHTMLAndExtraInfo(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)Codes.WARN_MISC_JDBC_JARS_CONFLICT, "<p>There are jars in your instance's jdbc folder that can generate conflicts within a Dataiku instance. Consider moving these drivers to their own subdirectories.</p>", "List of the jar files", String.format("<pre>%s</pre>", HtmlEscapers.htmlEscaper().escape(jars)));
            }
        }
        return messages;
    }

    private boolean isNastyJar(String jarName) {
        return (jarName = jarName.toLowerCase()).contains("ndp-jdbc-driver") || jarName.contains("hive") || jarName.equalsIgnoreCase("ql.jar") || jarName.contains("httpcore") || jarName.contains("httpclient") || jarName.contains("libthrift") || jarName.contains("zookeeper");
    }

    public static enum Codes implements InfoMessage.MessageCode
    {
        WARN_MISC_JDBC_JARS_CONFLICT("JDBC drivers - some JARs are prone to version conflicts", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private Codes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

