/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.reports;

import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.runnables.DSSRunnableResult;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.dip.warnings.WarningsContext;
import java.util.List;
import java.util.Map;

@PolyJSON(value={@Mapping(value=BuiltDataset.class, type="BUILT_DATASET"), @Mapping(value=BuiltManagedFolder.class, type="BUILT_FOLDER"), @Mapping(value=BuiltSavedModel.class, type="BUILT_MODEL"), @Mapping(value=BuiltEvaluationStore.class, type="BUILT_EVALUATION_STORE"), @Mapping(value=BuiltRetrievableKnowledge.class, type="BUILT_RETRIEVABLE_KNOWLEDGE"), @Mapping(value=BuiltStreamingEndpoint.class, type="BUILT_STREAMING_ENDPOINT"), @Mapping(value=CheckedDataset.class, type="CHECKED_DATASET"), @Mapping(value=CheckedFlowElementConsistency.class, type="CHECKED_FLOW_ELEMENT_CONSISTENCY"), @Mapping(value=HiveMetastoreSynchronized.class, type="SYNCED_DATASET"), @Mapping(value=UpdatedFromHive.class, type="UPDATED_FROM_HIVE"), @Mapping(value=StepDone.class, type="STEP_DONE"), @Mapping(value=JobExecuted.class, type="JOB_EXECUTED", typeAliases={"JOB_STARTED"}), @Mapping(value=ScenarioDone.class, type="SCENARIO_DONE"), @Mapping(value=CodeExecuted.class, type="CODE_EXECUTED"), @Mapping(value=TriggerFired.class, type="TRIGGER_FIRED"), @Mapping(value=ComputedMetrics.class, type="COMPUTED_METRICS"), @Mapping(value=CreatedDashboardExport.class, type="CREATED_DASHBOARD_EXPORT"), @Mapping(value=CreatedModelDocumentExport.class, type="CREATED_MODEL_DOCUMENTATION_EXPORT"), @Mapping(value=CreatedFlowDocumentExport.class, type="CREATED_FLOW_DOCUMENTATION_EXPORT"), @Mapping(value=CreatedJupyterExport.class, type="CREATED_JUPYTER_EXPORT"), @Mapping(value=SnapshotRMarkdownReport.class, type="CREATED_RMARKDOWN_EXPORT"), @Mapping(value=CreatedWikiExport.class, type="CREATED_WIKI_EXPORT"), @Mapping(value=CreatedWikiArticleExport.class, type="CREATED_WIKI_ARTICLE_EXPORT"), @Mapping(value=MadeLambdaPackage.class, type="MADE_LAMBDA_PACKAGE"), @Mapping(value=PublishedLambdaService.class, type="PUBLISHED_LAMBDA_PACKAGE"), @Mapping(value=MadeBundle.class, type="MADE_BUNDLE"), @Mapping(value=PublishedBundle.class, type="PUBLISHED_BUNDLE"), @Mapping(value=ActivatedPublishedPackage.class, type="ACTIVATED_PUBLISHED_PACKAGE"), @Mapping(value=ProducedByRunnable.class, type="PRODUCED_BY_RUNNABLE"), @Mapping(value=RestartedWebApp.class, type="RESTART_WEBAPP"), @Mapping(value=StoppedWebApp.class, type="STOPPED_WEBAPP"), @Mapping(value=PingedWebApp.class, type="PINGED_WEBAPP"), @Mapping(value=QueriedWebApp.class, type="QUERIED_WEBAPP"), @Mapping(value=BuiltReport.class, type="BUILT_REPORT"), @Mapping(value=SetUpCluster.class, type="SET_UP_CLUSTER"), @Mapping(value=ToreDownCluster.class, type="TORE_DOWN_CLUSTER"), @Mapping(value=StartedCluster.class, type="STARTED_CLUSTER"), @Mapping(value=StoppedCluster.class, type="STOPPED_CLUSTER"), @Mapping(value=StartedContinuousActivity.class, type="STARTED_CONTINUOUS_ACTIVITY"), @Mapping(value=StoppedContinuousActivity.class, type="STOPPED_CONTINUOUS_ACTIVITY"), @Mapping(value=ReloadSchema.class, type="RELOAD_SCHEMA"), @Mapping(value=RestartCodeStudio.class, type="RESTART_CODE_STUDIO"), @Mapping(value=StopCodeStudio.class, type="STOP_CODE_STUDIO"), @Mapping(value=RanPythonUnitTest.class, type="RAN_PYTHON_UNIT_TEST"), @Mapping(value=SwappedRecipeInputs.class, type="SWAPPED_RECIPE_INPUTS"), @Mapping(value=ComparedDatasets.class, type="COMPARED_DATASETS"), @Mapping(value=RestoredFlowTestInitialState.class, type="RESTORED_FLOW_TEST_INITIAL_STATE")}, enumClass=ReportItemType.class)
public abstract class ReportItem {
    public ReportTargetItem target;
    public long start;
    public long end;
    public Outcome outcome;
    public WarningsContext.SerializedThrowable thrown;
    public SmartLogTail logTail;
    public WarningsContext.SerializedWarnings warnings;
    public Map<String, Object> info;

    public ReportItemType getType() {
        return (ReportItemType)JSON.getEnumType((Object)this);
    }

    public ReportTargetItem getTargetItem() {
        return this.target;
    }

    public Outcome getOutcome() {
        return this.outcome;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public ReportItem withOutcome(Outcome outcome) {
        this.outcome = outcome;
        return this;
    }

    public ReportItem withStart(long start) {
        this.start = start;
        return this;
    }

    public ReportItem withEnd(long end) {
        this.end = end;
        return this;
    }

    public WarningsContext.SerializedThrowable getThrown() {
        return this.thrown;
    }

    public SmartLogTail getLogTail() {
        return this.logTail;
    }

    public WarningsContext.SerializedWarnings getWarnings() {
        return this.warnings;
    }

    public ReportItem withThrown(WarningsContext.SerializedThrowable thrown) {
        this.thrown = thrown;
        return this;
    }

    public ReportItem withThrown(Throwable thrown) {
        this.thrown = new WarningsContext.SerializedThrowable(thrown);
        return this;
    }

    public ReportItem withLogTail(SmartLogTail logTail) {
        this.logTail = logTail;
        return this;
    }

    public ReportItem withWarnings(WarningsContext.SerializedWarnings warnings) {
        this.warnings = warnings == null ? null : WarningsContext.SerializedWarnings.copyCounts((WarningsContext.SerializedWarnings)warnings);
        return this;
    }

    public static enum ReportItemType {
        SCENARIO_DONE,
        STEP_DONE,
        BUILT_DATASET,
        BUILT_MODEL,
        BUILT_FOLDER,
        BUILT_STREAMING_ENDPOINT,
        BUILT_EVALUATION_STORE,
        BUILT_RETRIEVABLE_KNOWLEDGE,
        CHECKED_DATASET,
        CHECKED_FLOW_ELEMENT_CONSISTENCY,
        SYNCED_DATASET,
        UPDATED_FROM_HIVE,
        JOB_EXECUTED,
        CODE_EXECUTED,
        TRIGGER_FIRED,
        COMPUTED_METRICS,
        CREATED_JUPYTER_EXPORT,
        MADE_LAMBDA_PACKAGE,
        PUBLISHED_LAMBDA_PACKAGE,
        MADE_BUNDLE,
        PUBLISHED_BUNDLE,
        ACTIVATED_PUBLISHED_PACKAGE,
        PRODUCED_BY_RUNNABLE,
        RESTART_WEBAPP,
        STOPPED_WEBAPP,
        PINGED_WEBAPP,
        QUERIED_WEBAPP,
        RESTART_CODE_STUDIO,
        STOP_CODE_STUDIO,
        BUILT_REPORT,
        CREATED_RMARKDOWN_EXPORT,
        CREATED_DASHBOARD_EXPORT,
        CREATED_WIKI_EXPORT,
        CREATED_WIKI_ARTICLE_EXPORT,
        CREATED_MODEL_DOCUMENTATION_EXPORT,
        CREATED_FLOW_DOCUMENTATION_EXPORT,
        SET_UP_CLUSTER,
        TORE_DOWN_CLUSTER,
        STARTED_CLUSTER,
        STOPPED_CLUSTER,
        STARTED_CONTINUOUS_ACTIVITY,
        STOPPED_CONTINUOUS_ACTIVITY,
        RELOAD_SCHEMA,
        RAN_PYTHON_UNIT_TEST,
        SWAPPED_RECIPE_INPUTS,
        COMPARED_DATASETS,
        RESTORED_FLOW_TEST_INITIAL_STATE;

    }

    public static enum Outcome {
        SUCCESS,
        WARNING,
        FAILED,
        ABORTED;

    }

    public static class RestoredFlowTestInitialState
    extends ReportItem {
        private RestoredFlowTestInitialState() {
        }

        public RestoredFlowTestInitialState(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class ComparedDatasets
    extends ReportItem {
        private ComparedDatasets() {
        }

        public ComparedDatasets(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class SwappedRecipeInputs
    extends ReportItem {
        private SwappedRecipeInputs() {
        }

        public SwappedRecipeInputs(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class RanPythonUnitTest
    extends ReportItem {
        private String runReport;

        private RanPythonUnitTest() {
        }

        public RanPythonUnitTest(ReportTargetItem target) {
            this.target = target;
        }

        public String getRunReport() {
            return this.runReport;
        }

        public RanPythonUnitTest withRunReport(String runReport) {
            this.runReport = runReport;
            return this;
        }
    }

    public static class ReloadSchema
    extends ReportItem {
        public int detectedButNotInSchema;
        public int inSchemaButNotDetected;

        private ReloadSchema() {
        }

        public ReloadSchema(ReportTargetItem target) {
            this.target = target;
        }

        public ReloadSchema withChanges(int detectedButNotInSchema, int inSchemaButNotDetected) {
            this.detectedButNotInSchema = detectedButNotInSchema;
            this.inSchemaButNotDetected = inSchemaButNotDetected;
            return this;
        }
    }

    public static class StoppedContinuousActivity
    extends ReportItem {
        private StoppedContinuousActivity() {
        }

        public StoppedContinuousActivity(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class StartedContinuousActivity
    extends ReportItem {
        private StartedContinuousActivity() {
        }

        public StartedContinuousActivity(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class StoppedCluster
    extends ReportItem {
        private StoppedCluster() {
        }

        public StoppedCluster(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class StartedCluster
    extends ReportItem {
        private StartedCluster() {
        }

        public StartedCluster(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class ToreDownCluster
    extends ReportItem {
        private ToreDownCluster() {
        }

        public ToreDownCluster(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class SetUpCluster
    extends ReportItem {
        private SetUpCluster() {
        }

        public SetUpCluster(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class ProducedByRunnable
    extends ReportItem {
        public DSSRunnableResult.ResultType resultType;
        public String resultLabel;

        private ProducedByRunnable() {
        }

        public ProducedByRunnable(ReportTargetItem target) {
            this.target = target;
        }

        public ProducedByRunnable withResultType(DSSRunnableResult.ResultType resultType) {
            this.resultType = resultType;
            return this;
        }

        public ProducedByRunnable withResultLabel(String resultLabel) {
            this.resultLabel = resultLabel;
            return this;
        }
    }

    public static class ActivatedPublishedPackage
    extends ReportItem {
        public String publishedPackageId;
        public String deployerType;

        private ActivatedPublishedPackage() {
        }

        public ActivatedPublishedPackage(ReportTargetItem target) {
            this.target = target;
        }

        public ActivatedPublishedPackage withPublishedPackageId(String publishedPackageId) {
            this.publishedPackageId = publishedPackageId;
            return this;
        }

        public ActivatedPublishedPackage withDeployerType(String deployerType) {
            this.deployerType = deployerType;
            return this;
        }
    }

    public static class PublishedBundle
    extends ReportItem {
        public String bundleId;

        private PublishedBundle() {
        }

        public PublishedBundle(ReportTargetItem target) {
            this.target = target;
        }

        public PublishedBundle withBundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }
    }

    public static class MadeBundle
    extends ReportItem {
        public String bundleId;

        private MadeBundle() {
        }

        public MadeBundle(ReportTargetItem target) {
            this.target = target;
        }

        public MadeBundle withBundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }
    }

    public static class PublishedLambdaService
    extends ReportItem {
        public String packageId;

        private PublishedLambdaService() {
        }

        public PublishedLambdaService(ReportTargetItem target) {
            this.target = target;
        }

        public PublishedLambdaService withPackageId(String packageId) {
            this.packageId = packageId;
            return this;
        }
    }

    public static class MadeLambdaPackage
    extends ReportItem {
        public String packageId;

        private MadeLambdaPackage() {
        }

        public MadeLambdaPackage(ReportTargetItem target) {
            this.target = target;
        }

        public MadeLambdaPackage withPackageId(String packageId) {
            this.packageId = packageId;
            return this;
        }
    }

    public static class BuiltReport
    extends ReportItem {
        String runAs;

        private BuiltReport() {
        }

        public BuiltReport(ReportTargetItem target) {
            this.target = target;
        }

        public void withRunAs(String runAs) {
            this.runAs = runAs;
        }
    }

    public static class StopCodeStudio
    extends ReportItem {
        String runAs;

        @Override
        public ReportItemType getType() {
            return ReportItemType.STOP_CODE_STUDIO;
        }

        private StopCodeStudio() {
        }

        public StopCodeStudio(ReportTargetItem target) {
            this.target = target;
        }

        public void withRunAs(String runAs) {
            this.runAs = runAs;
        }
    }

    public static class RestartCodeStudio
    extends ReportItem {
        String runAs;

        @Override
        public ReportItemType getType() {
            return ReportItemType.RESTART_CODE_STUDIO;
        }

        private RestartCodeStudio() {
        }

        public RestartCodeStudio(ReportTargetItem target) {
            this.target = target;
        }

        public void withRunAs(String runAs) {
            this.runAs = runAs;
        }
    }

    public static class QueriedWebApp
    extends ReportItem {
        String label;
        boolean anonymousRequest;
        String requestUser;
        String requestMethod;
        String requestPath;
        List<SimpleKeyValue> requestParams;
        boolean hasRequestBody;
        String requestContentType;
        String expectedResponseType;
        int expectedResponseStatus;
        boolean hasExpectedResponseBody;

        private QueriedWebApp() {
        }

        public QueriedWebApp(ReportTargetItem target) {
            this.target = target;
        }

        public QueriedWebApp withLabel(String label) {
            this.label = label;
            return this;
        }

        public QueriedWebApp withAnonymousRequest(boolean anonymousRequest) {
            this.anonymousRequest = anonymousRequest;
            return this;
        }

        public QueriedWebApp withRequestUser(String requestUser) {
            this.requestUser = requestUser;
            return this;
        }

        public QueriedWebApp withRequestMethod(String requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public QueriedWebApp withRequestPath(String requestPath) {
            this.requestPath = requestPath;
            return this;
        }

        public QueriedWebApp withRequestParams(List<SimpleKeyValue> requestParams) {
            this.requestParams = requestParams;
            return this;
        }

        public QueriedWebApp withHasRequestBody(boolean hasRequestBody) {
            this.hasRequestBody = hasRequestBody;
            return this;
        }

        public QueriedWebApp withExpectedResponseStatus(int expectedResponseStatus) {
            this.expectedResponseStatus = expectedResponseStatus;
            return this;
        }

        public QueriedWebApp withHasExpectedResponseBody(boolean hasExpectedResponseBody) {
            this.hasExpectedResponseBody = hasExpectedResponseBody;
            return this;
        }

        public QueriedWebApp withRequestContentType(String requestContentType) {
            this.requestContentType = requestContentType;
            return this;
        }

        public QueriedWebApp withExpectedResponseType(String expectedResponseType) {
            this.expectedResponseType = expectedResponseType;
            return this;
        }
    }

    public static class PingedWebApp
    extends ReportItem {
        private PingedWebApp() {
        }

        public PingedWebApp(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class StoppedWebApp
    extends ReportItem {
        String runAs;

        private StoppedWebApp() {
        }

        public StoppedWebApp(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class RestartedWebApp
    extends ReportItem {
        String runAs;

        private RestartedWebApp() {
        }

        public RestartedWebApp(ReportTargetItem target) {
            this.target = target;
        }

        public RestartedWebApp withRunAs(String runAs) {
            this.runAs = runAs;
            return this;
        }
    }

    public static class CreatedWikiArticleExport
    extends ReportItem {
        private CreatedWikiArticleExport() {
        }

        public CreatedWikiArticleExport(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class CreatedWikiExport
    extends ReportItem {
        private CreatedWikiExport() {
        }

        public CreatedWikiExport(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class SnapshotRMarkdownReport
    extends ReportItem {
        public boolean execute;

        private SnapshotRMarkdownReport() {
        }

        public SnapshotRMarkdownReport(ReportTargetItem target) {
            this.target = target;
        }

        public SnapshotRMarkdownReport withExecute(boolean execute) {
            this.execute = execute;
            return this;
        }
    }

    public static class CreatedJupyterExport
    extends ReportItem {
        public boolean executedNotebook;

        private CreatedJupyterExport() {
        }

        public CreatedJupyterExport(ReportTargetItem target) {
            this.target = target;
        }

        public CreatedJupyterExport withExecutedNotebook(boolean executedNotebook) {
            this.executedNotebook = executedNotebook;
            return this;
        }
    }

    public static class CreatedFlowDocumentExport
    extends ReportItem {
        private CreatedFlowDocumentExport() {
        }

        public CreatedFlowDocumentExport(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class CreatedModelDocumentExport
    extends ReportItem {
        private CreatedModelDocumentExport() {
        }

        public CreatedModelDocumentExport(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class CreatedDashboardExport
    extends ReportItem {
        private CreatedDashboardExport() {
        }

        public CreatedDashboardExport(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class ComputedMetrics
    extends ReportItem {
        public int metricCount;

        private ComputedMetrics() {
        }

        public ComputedMetrics(ReportTargetItem target) {
            this.target = target;
        }

        public ComputedMetrics withMetricCount(int metricCount) {
            this.metricCount = metricCount;
            return this;
        }
    }

    public static class TriggerFired
    extends ReportItem {
        private TriggerFired() {
        }

        public TriggerFired(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class CodeExecuted
    extends ReportItem {
        public String errorMessage;

        private CodeExecuted() {
        }

        public CodeExecuted(ReportTargetItem target) {
            this.target = target;
        }

        public CodeExecuted withErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }
    }

    public static class UpdatedFromHive
    extends ReportItem {
        private UpdatedFromHive() {
        }

        public UpdatedFromHive(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class HiveMetastoreSynchronized
    extends ReportItem {
        private HiveMetastoreSynchronized() {
        }

        public HiveMetastoreSynchronized(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class CheckedDataset
    extends ReportItem {
        public boolean hasError;
        public boolean hasWarning;

        private CheckedDataset() {
        }

        public CheckedDataset(ReportTargetItem target) {
            this.target = target;
        }

        public CheckedDataset withHasError(boolean hasError) {
            this.hasError = hasError;
            return this;
        }

        public ReportItem withHasWarning(boolean hasWarning) {
            this.hasWarning = hasWarning;
            return this;
        }
    }

    public static class CheckedFlowElementConsistency
    extends ReportItem {
        public boolean hasError;
        public boolean hasWarning;

        private CheckedFlowElementConsistency() {
        }

        public CheckedFlowElementConsistency(ReportTargetItem target) {
            this.target = target;
        }

        public CheckedFlowElementConsistency withHasError(boolean hasError) {
            this.hasError = hasError;
            return this;
        }

        public CheckedFlowElementConsistency withHasWarning(boolean hasWarning) {
            this.hasWarning = hasWarning;
            return this;
        }
    }

    public static class BuiltStreamingEndpoint
    extends ReportItem {
        private BuiltStreamingEndpoint() {
        }

        public BuiltStreamingEndpoint(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class BuiltSavedModel
    extends ReportItem {
        public String versionId;

        private BuiltSavedModel() {
        }

        public BuiltSavedModel(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class BuiltRetrievableKnowledge
    extends ReportItem {
        private BuiltRetrievableKnowledge() {
        }

        public BuiltRetrievableKnowledge(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class BuiltEvaluationStore
    extends ReportItem {
        public String evaluationId;

        private BuiltEvaluationStore() {
        }

        public BuiltEvaluationStore(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class BuiltManagedFolder
    extends ReportItem {
        private BuiltManagedFolder() {
        }

        public BuiltManagedFolder(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class BuiltDataset
    extends ReportItem {
        private BuiltDataset() {
        }

        public BuiltDataset(ReportTargetItem target) {
            this.target = target;
        }
    }

    public static class ScenarioDone
    extends ReportItem {
        public String login;
        public String trigger;
        public String runId;
        public String abortMessage;

        private ScenarioDone() {
        }

        public ScenarioDone(ReportTargetItem target) {
            this.target = target;
        }

        public ScenarioDone withLogin(String login) {
            this.login = login;
            return this;
        }

        public ScenarioDone withTrigger(String trigger) {
            this.trigger = trigger;
            return this;
        }

        public ScenarioDone withRunId(String runId) {
            this.runId = runId;
            return this;
        }

        public ScenarioDone withAbortMessage(String abortMessage) {
            this.abortMessage = abortMessage;
            return this;
        }
    }

    public static class JobExecuted
    extends ReportItem {
        public final String jobId;

        private JobExecuted() {
            this.jobId = null;
        }

        public JobExecuted(String jobId) {
            this.target = new ReportTargetItem.JobsItem();
            this.jobId = jobId;
        }
    }

    public static class StepDone
    extends ReportItem {
        private StepDone() {
        }

        public StepDone(ReportTargetItem target) {
            this.target = target;
        }
    }
}

