/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.reports.RMarkdownReportRunner;
import com.dataiku.dip.reports.Report;
import com.dataiku.dip.reports.ReportTemplateDesc;
import com.dataiku.dip.reports.ReportsService;
import com.dataiku.dip.reports.ReportsTemplateService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.TagFilterUtils;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.EncodedContent;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ReportsController
extends DIPInternalControllerBase {
    @Autowired
    private ReportsService reportsService;
    @Autowired
    private ReportsTemplateService templatesService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private AuditTrailService auditTrailService;
    static Logger logger = Logger.getLogger((String)"dku.reports.controller");

    @AuditNotNeeded
    @RequestMapping(value={"/api/reports/list-templates"})
    public void listTemplates(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        ReportsController.writeJSON((HttpServletResponse)resp, this.templatesService.listOfType(type));
    }

    @AuditedCall(value={"msgType", "reports-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/reports/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ReportsController.writeJSON((HttpServletResponse)resp, this.reportsService.listUnsafe(projectKey));
        }
    }

    @AuditedCall(value={"msgType", "reports-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/reports/list-heads"})
    public void listHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false) String tagFilter) throws Exception {
        AuthCtx user;
        TaggableObjectsService.FilteredTaggableItems heads = new TaggableObjectsService.FilteredTaggableItems();
        TagFilterUtils.TagFilter tf = (TagFilterUtils.TagFilter)JSON.parse((String)tagFilter, TagFilterUtils.TagFilter.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            for (Report.ReportListItem head : this.reportsService.listHeads(projectKey)) {
                if (!TagFilterUtils.matches(tf, head.tags)) {
                    ++heads.filteredOut;
                    continue;
                }
                heads.items.add(head);
            }
        }
        this.interestsService.enrichHeads(user.getAssociatedDSSUser(), projectKey, heads.items);
        ReportsController.writeJSON((HttpServletResponse)resp, heads);
    }

    @AuditedCall(value={"msgType", "report-get", "projectKey", "${projectKey}", "reportId", "${id}"})
    @RequestMapping(value={"/api/reports/get-full-info"})
    public void getFullInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        NavigatorService.ReportFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            info = this.navigatorService.getReportFullInfo(projectKey, id);
        }
        this.navigatorService.addInfo_NT(info, u);
        ReportsController.writeJSON((HttpServletResponse)resp, (Object)info);
    }

    @AuditedCall(value={"msgType", "report-get", "projectKey", "${projectKey}", "reportId", "${id}"})
    @RequestMapping(value={"/api/reports/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        AuthCtx authCtx;
        Report.ReportSummary summary = new Report.ReportSummary();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            summary.object = this.reportsService.getMandatoryUnsafe(projectKey, id);
            summary.script = this.reportsService.getScript(projectKey, id);
        }
        summary.timeline = this.timelinesService.getObjectTimeline_NT(summary.object, 0, 100);
        summary.interest = this.interestsService.getObjectAndUserInterest_noFail(authCtx, summary.object);
        ReportsController.writeJSON((HttpServletResponse)resp, (Object)summary);
    }

    @AuditInline
    @RequestMapping(value={"/api/reports/create"})
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name, @RequestParam String templateDesc) throws Exception {
        ReportsService.ReportWithScript rs2;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            ReportTemplateDesc desc = (ReportTemplateDesc)JSON.parse((String)templateDesc, ReportTemplateDesc.class);
            rs2 = this.reportsService.create(projectKey, name, desc);
            t.commitV("Created report %s (%s.%s)", new Object[]{rs2.report.name, rs2.report.projectKey, rs2.report.id});
            this.auditTrailService.generic("report-create").with("projectKey", projectKey).with("reportId", rs2.report.id).emit();
        }
        ReportsController.writeJSON((HttpServletResponse)resp, (Object)new Id(rs2.report.id));
    }

    @AuditInline
    @RequestMapping(value={"/api/reports/save"})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam String reportData, @RequestParam(required=false) String script, @RequestParam(required=false) String commitMessage) throws Exception {
        Report savedReport;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            Report report = (Report)JSON.parse((String)reportData, Report.class);
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, report.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.reportsService.getMandatoryUnsafe(report.projectKey, report.id);
            savedReport = this.reportsService.save(report, script, false);
            if (StringUtils.isNotBlank((String)commitMessage)) {
                t.commit(commitMessage, 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
            } else {
                t.commit(String.format("Saved report %s (%s.%s)", report.name, report.projectKey, report.id), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
            }
            this.auditTrailService.generic("report-save").with("projectKey", report.projectKey).with("reportId", report.id).emit();
        }
        ReportsController.writeJSON((HttpServletResponse)resp, (Object)new Id(savedReport.id));
    }

    @AuditInline
    @RequestMapping(value={"/api/reports/save-metadata"})
    public void saveMetadata(HttpServletRequest req, HttpServletResponse resp, @RequestParam String reportData) throws Exception {
        Report savedReport;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            Report report = (Report)JSON.parse((String)reportData, Report.class);
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(user, report.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.reportsService.getMandatoryUnsafe(report.projectKey, report.id);
            savedReport = this.reportsService.save(report, null, false);
            t.commit(String.format("Saved report %s (%s.%s)", report.name, report.projectKey, report.id), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
            this.auditTrailService.generic("repor-save").with("projectKey", report.projectKey).with("reportId", report.id).emit();
        }
        ReportsController.writeJSON((HttpServletResponse)resp, (Object)new Id(savedReport.id));
    }

    @AuditInline
    @RequestMapping(value={"/api/reports/copy"})
    public void copy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam String newName) throws Exception {
        Report report;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            report = this.reportsService.copy(projectKey, id, newName);
            t.commitV("Copied report %s into %s (%s.%s into %s.%s)", new Object[]{report.name, newName, projectKey, id, projectKey, report.id});
            this.auditTrailService.generic("report-create").with("projectKey", projectKey).with("reportId", report.id).with("fromProjectKey", projectKey).with("fromReportId", id).emit();
        }
        ReportsController.writeJSON((HttpServletResponse)resp, (Object)report);
    }

    @AuditedCall(value={"msgType", "report-build", "projectKey", "${projectKey}", "reportId", "${id}"})
    @RequestMapping(value={"/api/reports/build"})
    public void buildReport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        String script;
        Report report;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            report = this.reportsService.getMandatoryUnsafe(projectKey, id);
            script = this.reportsService.getScript(projectKey, id);
        }
        FutureResponse<RMarkdownReportRunner.ReportBuildResponse> ret = this.reportsService.build_NT(report, script, authCtx);
        ReportsController.writeJSON((HttpServletResponse)resp, ret);
    }

    @AuditedCall(value={"msgType", "report-view", "projectKey", "${projectKey}", "reportId", "${id}"})
    @RequestMapping(value={"/api/reports/view"})
    public void view(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam boolean inEditMode) throws Exception {
        String contentType;
        byte[] content;
        Report report;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            report = this.reportsService.getMandatoryUnsafe(projectKey, id);
        }
        Report.ReportOutputFormat format = report.params.viewFormat;
        File viewFile = this.reportsService.getReportViewFile(report);
        if (viewFile.exists()) {
            try (FileInputStream input = new FileInputStream(viewFile);){
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)input, (OutputStream)bos);
                content = bos.toByteArray();
                contentType = format.getContentType();
            }
        } else {
            logger.info((Object)("Report view file not found: " + viewFile.getAbsolutePath()));
            Object message = "The report has not been built yet.";
            message = inEditMode ? (String)message + " Save or click 'Force build' to build it" : (String)message + " Go to 'Edit' to build it";
            content = ((String)message).getBytes();
            contentType = "text/html";
        }
        ReportsController.writeJSON((HttpServletResponse)resp, (Object)new EncodedContent(content, contentType));
    }

    @AuditedCall(value={"msgType", "report-prepare-download", "projectKey", "${projectKey}", "reportId", "${id}"})
    @RequestMapping(value={"/api/reports/prepare-download"})
    public void prepareDownload(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam String format) throws Exception {
        String script;
        Report report;
        AuthCtx u;
        Report.ReportOutputFormat f;
        try {
            f = Report.ReportOutputFormat.valueOf(format);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown export format: " + format, e);
        }
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            report = this.reportsService.getMandatoryUnsafe(projectKey, id);
            script = this.reportsService.getScript(projectKey, id);
        }
        ReportsController.writeJSON((HttpServletResponse)resp, this.reportsService.startDownload_NT(u, report, script, f, false, null));
    }

    @AuditedCall(value={"msgType", "report-download", "projectKey", "${projectKey}", "reportId", "${id}"})
    @RequestMapping(value={"/api/reports/download"})
    public void download(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam String format) throws Exception {
        Report report;
        Report.ReportOutputFormat downloadFormat;
        try {
            downloadFormat = Report.ReportOutputFormat.valueOf(format);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown export format: " + format, e);
        }
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            report = this.reportsService.getMandatoryUnsafe(projectKey, id);
        }
        File file = this.reportsService.getSingleReportDownloadFile(report, downloadFormat);
        this.writeFileForDownload(resp, file, downloadFormat.getContentType(), report.name + "." + downloadFormat.getExtension());
    }
}

