/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.p;

import com.dataiku.dip.llm.cache.BackendLLMCacheService;
import com.dataiku.dip.llm.cache.ILLMCacheService;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LLMCachePrivilegedIntercomController
extends DIPInternalControllerBase {
    public static final String COMPLETIONS_RESOURCE = "completions";
    public static final String EMBEDDINGS_RESOURCE = "embeddings";
    public static final String RERANKING_RESOURCE = "rerankings";
    @Autowired
    private BackendLLMCacheService llmCacheService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;
    @Autowired
    private SharedSecretAuthService authService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.intercom.llmCache");

    @AuditNotNeeded
    @ResponseBody
    @RequestMapping(value={"/api/pintercom/llm-cache/completions/get"})
    public ILLMCacheService.QueryCacheResult<LLMClient.SimpleCompletionResponseOrError> getCompletion(HttpServletRequest req, @RequestParam String requestObj) throws Exception {
        this.authService.failIfNoSharedSecret(req);
        CacheGetRequest request = (CacheGetRequest)JSON.parse((String)requestObj, (TypeToken)new TypeToken<CacheGetRequest<LLMClient.SingleCompletionQuery, LLMClient.CompletionSettings>>(){});
        logger.trace(() -> "Received a LLM cache GET request: " + JSON.json((Object)request));
        AuthCtx counterpartAuthCtx = this.authCtxCreationService.create_autoTxn(request.authCtxIdentifier);
        return this.llmCacheService.get(counterpartAuthCtx, request.llmId, request.contextProjectKey, (LLMClient.SingleCompletionQuery)request.query, (LLMClient.CompletionSettings)request.settings);
    }

    @AuditNotNeeded
    @ResponseBody
    @RequestMapping(value={"/api/pintercom/llm-cache/embeddings/get"})
    public ILLMCacheService.QueryCacheResult<LLMClient.SimpleEmbeddingResponseOrError> getEmbedding(HttpServletRequest req, @RequestParam String requestObj) throws Exception {
        this.authService.failIfNoSharedSecret(req);
        CacheGetRequest request = (CacheGetRequest)JSON.parse((String)requestObj, (TypeToken)new TypeToken<CacheGetRequest<LLMClient.EmbeddingQuery, LLMClient.EmbeddingSettings>>(){});
        logger.trace(() -> "Received a LLM cache GET request: " + JSON.json((Object)request));
        AuthCtx counterpartAuthCtx = this.authCtxCreationService.create_autoTxn(request.authCtxIdentifier);
        return this.llmCacheService.get(counterpartAuthCtx, request.llmId, request.contextProjectKey, (LLMClient.EmbeddingQuery)request.query, (LLMClient.EmbeddingSettings)request.settings);
    }

    @AuditNotNeeded
    @ResponseBody
    @RequestMapping(value={"/api/pintercom/llm-cache/rerankings/get"})
    public ILLMCacheService.QueryCacheResult<LLMClient.SingleRerankingResponseOrError> getReranking(HttpServletRequest req, @RequestParam String requestObj) throws Exception {
        this.authService.failIfNoSharedSecret(req);
        CacheGetRequest request = (CacheGetRequest)JSON.parse((String)requestObj, (TypeToken)new TypeToken<CacheGetRequest<LLMClient.RerankingQuery, LLMClient.RerankingSettings>>(){});
        logger.trace(() -> "Received a LLM cache GET request: " + JSON.json((Object)request));
        AuthCtx counterpartAuthCtx = this.authCtxCreationService.create_autoTxn(request.authCtxIdentifier);
        return this.llmCacheService.get(counterpartAuthCtx, request.llmId, request.contextProjectKey, (LLMClient.RerankingQuery)request.query, (LLMClient.RerankingSettings)request.settings);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/pintercom/llm-cache/completions/put"})
    public void putCompletion(HttpServletRequest req, HttpServletResponse resp, @RequestParam String requestObj) throws Exception {
        this.authService.failIfNoSharedSecret(req);
        CachePutRequest request = (CachePutRequest)JSON.parse((String)requestObj, (TypeToken)new TypeToken<CachePutRequest<LLMClient.SingleCompletionQuery, LLMClient.CompletionSettings, LLMClient.SimpleCompletionResponseOrError>>(){});
        logger.trace(() -> "Received a LLM cache PUT request: " + JSON.json((Object)request));
        AuthCtx counterpartAuthCtx = this.authCtxCreationService.create_autoTxn(request.authCtxIdentifier);
        this.llmCacheService.put(counterpartAuthCtx, request.llmId, request.contextProjectKey, (LLMClient.SingleCompletionQuery)request.query, (LLMClient.CompletionSettings)request.settings, (LLMClient.SimpleCompletionResponseOrError)request.response);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/pintercom/llm-cache/embeddings/put"})
    public void putEmbedding(HttpServletRequest req, HttpServletResponse resp, @RequestParam String requestObj) throws Exception {
        this.authService.failIfNoSharedSecret(req);
        CachePutRequest request = (CachePutRequest)JSON.parse((String)requestObj, (TypeToken)new TypeToken<CachePutRequest<LLMClient.EmbeddingQuery, LLMClient.EmbeddingSettings, LLMClient.SimpleEmbeddingResponseOrError>>(){});
        logger.trace(() -> "Received a LLM cache PUT request: " + JSON.json((Object)request));
        AuthCtx counterpartAuthCtx = this.authCtxCreationService.create_autoTxn(request.authCtxIdentifier);
        this.llmCacheService.put(counterpartAuthCtx, request.llmId, request.contextProjectKey, (LLMClient.EmbeddingQuery)request.query, (LLMClient.EmbeddingSettings)request.settings, (LLMClient.SimpleEmbeddingResponseOrError)request.response);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/pintercom/llm-cache/rerankings/put"})
    public void putReranking(HttpServletRequest req, HttpServletResponse resp, @RequestParam String requestObj) throws Exception {
        this.authService.failIfNoSharedSecret(req);
        CachePutRequest request = (CachePutRequest)JSON.parse((String)requestObj, (TypeToken)new TypeToken<CachePutRequest<LLMClient.RerankingQuery, LLMClient.RerankingSettings, LLMClient.SingleRerankingResponseOrError>>(){});
        logger.trace(() -> "Received a LLM cache PUT request: " + JSON.json((Object)request));
        AuthCtx counterpartAuthCtx = this.authCtxCreationService.create_autoTxn(request.authCtxIdentifier);
        this.llmCacheService.put(counterpartAuthCtx, request.llmId, request.contextProjectKey, (LLMClient.RerankingQuery)request.query, (LLMClient.RerankingSettings)request.settings, (LLMClient.SingleRerankingResponseOrError)request.response);
    }

    public static class CacheGetRequest<TQuery, TSettings> {
        public String authCtxIdentifier;
        public String llmId;
        public String contextProjectKey;
        public TQuery query;
        public TSettings settings;
    }

    public static class CachePutRequest<TQuery, TSettings, TResponse> {
        public String authCtxIdentifier;
        public String llmId;
        public String contextProjectKey;
        public TQuery query;
        public TSettings settings;
        public TResponse response;
    }
}

