/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.dashboards.insights.InsightsService;
import com.dataiku.dip.dashboards.insights.staticfile.StaticFileInsightMeta;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.ErrorContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class InsightsIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private InsightsService insightsService;
    static Pattern idPattern = Pattern.compile("^[\\w-]+$");

    @AuditedCall(value={"msgType", "static-insight-save", "projectKey", "${projectKey}", "insightId", "${id"})
    @RequestMapping(value={"/api/tintercom/insights/save-static-file-insight"})
    public void saveStaticFileInsight(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam(required=false, defaultValue="") String label, @RequestParam String payload, @RequestParam String contentType) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.projectsService.checkPerm(t.getUser(), projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.checkId(id);
            Insight insight = this.insightsService.getOrNull(projectKey, id);
            if (insight == null) {
                insight = new Insight();
                insight.projectKey = projectKey;
                insight.type = "static_file";
                insight.id = id;
                this.insightsService.setOwnerOnNewInsight(insight, t.getUser());
                insight.name = StringUtils.isBlank((String)label) ? id : label;
                StaticFileInsightMeta.StaticFileInsightParams params = new StaticFileInsightMeta.StaticFileInsightParams();
                params.contentType = contentType;
                insight.params = params;
                StaticFileInsightMeta.StaticFileInsightHandler sih = new StaticFileInsightMeta.StaticFileInsightHandler(insight);
                params.filetype = sih.getGenericType();
                this.insightsService.save(insight, true, payload);
                t.commitV("Updated static file insight %s.%s (%s)", new Object[]{projectKey, id, insight.name});
            } else {
                if (!"static_file".equals(insight.type)) {
                    throw ErrorContext.iaef((String)"Insight %s is not a static file", (Object)id, (Object[])new Object[0]);
                }
                StaticFileInsightMeta.StaticFileInsightParams params = (StaticFileInsightMeta.StaticFileInsightParams)insight.params;
                params.contentType = contentType;
                StaticFileInsightMeta.StaticFileInsightHandler sih = new StaticFileInsightMeta.StaticFileInsightHandler(insight);
                params.filetype = sih.getGenericType();
                if (StringUtils.isNotBlank((String)label)) {
                    insight.name = label;
                }
                assert (insight.id.equals(id));
                this.insightsService.save(insight, true, payload);
                t.commitV("Updated static file insight %s.%s (%s)", new Object[]{projectKey, id, insight.name});
            }
        }
    }

    private void checkId(String id) {
        Matcher matcher = idPattern.matcher(id);
        if (!matcher.find()) {
            throw ErrorContext.iae((String)"Invalid id, allowed charaters are a-z, A-Z, 0-9, '_' and '-'.");
        }
    }
}

