/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.EventWithSeverity;
import com.dataiku.dip.server.notifications.backend.ProjectEvent;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class JobStateChangedEvent
extends BackendEvent
implements UserEvent,
ProjectEvent,
EventWithSeverity,
EventWithHumanReadableString {
    public static final String NAME = "job-state-change";
    public final String name = "job-state-change";
    public final String projectKey;
    public final String jobId;
    public final JobDef.JobTriggerType triggeredFrom;
    public final String initiator;
    public final long initiationTimestamp;
    public final long time;
    public final List<JobDef.JobOutput> outputs;
    public final JobState state;
    public final long warningsCount;
    public final String humanReadableJobDesc;
    public final String recipe;
    public String initiatorDisplayName;

    public JobStateChangedEvent(JobDef def, JobState state, long warningsCount) {
        this.projectKey = def.projectKey;
        this.jobId = def.id;
        this.triggeredFrom = def.triggeredFrom;
        this.initiator = def.initiator;
        this.initiationTimestamp = def.initiationTimestamp;
        this.time = System.currentTimeMillis();
        this.recipe = def.recipe;
        this.outputs = new ArrayList<JobDef.JobOutput>();
        HashSet<CallSite> outputsFullNames = new HashSet<CallSite>();
        for (JobDef.JobOutput output : def.outputs) {
            String outputName = output.targetDatasetProjectKey + "." + output.targetDataset;
            if (outputsFullNames.contains(outputName)) continue;
            outputsFullNames.add((CallSite)((Object)outputName));
            JobDef.JobOutput outputWithoutPartition = new JobDef.JobOutput(output.targetDatasetProjectKey, output.targetDataset, null);
            outputWithoutPartition.type = output.type;
            this.outputs.add(outputWithoutPartition);
        }
        this.state = state;
        this.warningsCount = warningsCount;
        this.humanReadableJobDesc = def.toHumanReadableString();
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getUserLogin() {
        return this.initiator;
    }

    @Override
    public EventWithSeverity.EventSeverity getSeverity() {
        switch (this.state) {
            case ABORTED: 
            case FAILED: {
                return EventWithSeverity.EventSeverity.ERROR;
            }
            case WAITING_CONFIRMATION: {
                return EventWithSeverity.EventSeverity.WARNING;
            }
            case DONE: {
                return EventWithSeverity.EventSeverity.OK;
            }
        }
        return EventWithSeverity.EventSeverity.NEUTRAL;
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        String jobMsg = markup.job(this.projectKey, this.jobId, this.humanReadableJobDesc);
        switch (this.state) {
            case ABORTED: {
                return "Job " + jobMsg + " aborted";
            }
            case DONE: {
                return "Job " + jobMsg + " done";
            }
            case RUNNING: {
                return "Job " + jobMsg + " running, started by " + markup.user(this.initiator, null);
            }
            case FAILED: {
                return "Job " + jobMsg + " failed";
            }
            case WAITING_CONFIRMATION: {
                return "Job " + jobMsg + " waiting for user confirmation";
            }
            case PAUSED: {
                return "Job " + jobMsg + " paused";
            }
            case PENDING: {
                return "Job " + jobMsg + " pending";
            }
            case STARTING: {
                return "Job " + jobMsg + " starting";
            }
            case COMPUTING_DEPS: 
            case NOT_STARTED: {
                return "?";
            }
        }
        throw new Error("unreachable");
    }
}

