/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.notifications.backend.CodeEnvRequestGrantedEvent;
import com.dataiku.dip.server.notifications.emails.AbstractCodeEnvRequestEmailBuilder;

public class CodeEnvRequestGrantedEmailBuilder
extends AbstractCodeEnvRequestEmailBuilder<CodeEnvRequestGrantedEvent> {
    public CodeEnvRequestGrantedEmailBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    String makeSubject(CodeEnvModel.EnvLang envLanguage, PublicUser user, String codeEnvName, String codeEnvTargetName) {
        if (codeEnvTargetName != null) {
            return "Code env request has been processed";
        }
        return "Code env " + codeEnvName + " has been created";
    }

    @Override
    String makeMainText(CodeEnvModel.EnvLang codeEnvLanguage, PublicUser requesterUser) {
        return null;
    }

    @Override
    String makeTitle(String codeEnvTargetName) {
        if (codeEnvTargetName != null) {
            return "Your code env request has been processed";
        }
        return "The code env you requested has been created";
    }

    @Override
    String makeRequestUrl(String requestId, String envName, CodeEnvModel.EnvLang codeEnvLanguage, String dssRootUrl) {
        HrefContext href = new HrefContext(dssRootUrl);
        return href.designCodeEnv(codeEnvLanguage, envName);
    }

    @Override
    protected String getCodeEnvTargetName(CodeEnvRequestGrantedEvent evt) {
        return evt.getTargetName();
    }
}

