/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeMeta;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeEngineParams;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualSQLRecipesService {
    @Autowired
    private VisualSQLRecipesBaseService baseService;
    @Autowired
    private RecipeSaveService recipeSaveService;
    private static Map<String, String> conversionTargetsToEngines = new HashMap<String, String>();
    private static Map<String, String> conversionTargetsToRecipeTypes = new HashMap<String, String>();

    public void convert(SerializedRecipe sr, RecipeStatus status, String sql, String target, VisualSQLRecipeEngineParams engineParams) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)target), (Object)"Cannot convert recipe: empty target format.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)sql), (Object)"Could not generate query");
        if (!this.baseService.canUseEngine(conversionTargetsToEngines.get(target), status)) {
            throw ErrorContext.iae((String)("Cannot convert to recipe type '" + target + "'"));
        }
        sr.type = conversionTargetsToRecipeTypes.get(target);
        if (sr.type.equals("spark_sql_query")) {
            SparkSQLQueryRecipeMeta.SparkSQLQueryRecipeParams newRecipeParams = new SparkSQLQueryRecipeMeta.SparkSQLQueryRecipeParams();
            if (engineParams != null && engineParams.sparkSQL != null) {
                if (engineParams.sparkSQL.sparkConfig != null) {
                    newRecipeParams.sparkConfig = engineParams.sparkSQL.sparkConfig;
                }
                if (engineParams.sparkSQL.readParams != null) {
                    newRecipeParams.readParams = engineParams.sparkSQL.readParams;
                }
            }
            sr.params = newRecipeParams;
        } else {
            sr.params = sr.type.equals("hive") ? (engineParams == null || engineParams.hive == null ? new HiveRecipeMeta.HiveRecipeParams() : engineParams.hive) : RecipeRegistry.getMeta(sr.type).paramsClass().newInstance();
        }
        sr.clearOutputsForRole("rejects");
        this.recipeSaveService.save(sr.projectKey, sr, sql);
    }

    public void convertSamplingRecipeToSplitRecipe(SerializedRecipe sr, String payload, String secondOutputDataset) throws IOException, DKUSecurityException, CodedException {
        FilterDesc filterRecipeParams = (FilterDesc)JSON.parse((String)payload, FilterDesc.class);
        SplitRecipePayloadParams splitRecipePayloadParams = new SplitRecipePayloadParams();
        splitRecipePayloadParams.mode = SplitRecipePayloadParams.Mode.FILTERS;
        SplitRecipePayloadParams.FilterSplitDesc filterSplitDesc = SplitRecipePayloadParams.FilterSplitDesc.defaultSplit();
        if ("SQL".equals(filterRecipeParams.uiData.mode)) {
            ComputedColumn computedSQLColumn = new ComputedColumn();
            computedSQLColumn.name = "SQL_Expression_" + sr.name;
            computedSQLColumn.expr = FilterDescUtils.getFilterRepr(filterRecipeParams);
            computedSQLColumn.type = "boolean";
            computedSQLColumn.mode = ComputedColumn.Mode.SQL;
            splitRecipePayloadParams.computedColumns.add(computedSQLColumn);
            FilterDesc.FilterUiCondition filterSQLCondition = new FilterDesc.FilterUiCondition();
            filterSQLCondition.input = computedSQLColumn.name;
            filterSQLCondition.operator = "true";
            filterSplitDesc.filter.uiData.conditions.add(filterSQLCondition);
        } else {
            filterSplitDesc.filter = filterRecipeParams;
        }
        splitRecipePayloadParams.filterSplits.clear();
        splitRecipePayloadParams.filterSplits.add(filterSplitDesc);
        sr.type = "split";
        sr.addOutput("main", secondOutputDataset, false);
        this.recipeSaveService.save(sr.projectKey, sr, JSON.pretty((Object)splitRecipePayloadParams));
    }

    static {
        conversionTargetsToEngines.put("hive", "HIVE");
        conversionTargetsToEngines.put("impala", "IMPALA");
        conversionTargetsToEngines.put("spark", "SPARK");
        conversionTargetsToEngines.put("sql", "SQL");
        conversionTargetsToEngines.put("sql_script", "SQL");
        conversionTargetsToRecipeTypes.put("hive", "hive");
        conversionTargetsToRecipeTypes.put("impala", "impala");
        conversionTargetsToRecipeTypes.put("spark", "spark_sql_query");
        conversionTargetsToRecipeTypes.put("sql", "sql_query");
        conversionTargetsToRecipeTypes.put("sql_script", "sql_script");
    }
}

