/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.agents.tools.custom.CustomAgentToolsService;
import com.dataiku.dip.agents.tools.custom.LoadedCustomAgentTool;
import com.dataiku.dip.apideployer.datamodel.config.InfraStage;
import com.dataiku.dip.charts.ScatterSettings;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.cluster.LoadedPythonPluginCluster;
import com.dataiku.dip.cluster.PythonPluginClustersService;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.codestudio.blocks.BlockBasedCodeStudioTemplateParams;
import com.dataiku.dip.codestudio.blocks.component.LoadedPythonPluginCodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.component.PythonPluginCodeStudioBlockService;
import com.dataiku.dip.codestudio.component.LoadedPythonPluginCodeStudioTemplate;
import com.dataiku.dip.codestudio.component.PythonPluginCodeStudioTemplateService;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomJavaPolicyHooksService;
import com.dataiku.dip.dao.CodeStudioTemplatesDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.UsersActivityDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.fs.plugin.CustomJavaFSProvidersService;
import com.dataiku.dip.datasets.fs.plugin.CustomPythonFSProvidersService;
import com.dataiku.dip.datasets.fs.plugin.LoadedFSProvider;
import com.dataiku.dip.datasets.sample.LoadedSampleDataset;
import com.dataiku.dip.datasets.sample.SampleDatasetsService;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.export.CustomJavaExportersService;
import com.dataiku.dip.export.CustomPythonExportersService;
import com.dataiku.dip.export.LoadedExporter;
import com.dataiku.dip.exposition.custom.CustomExpositionsService;
import com.dataiku.dip.exposition.custom.LoadedExposition;
import com.dataiku.dip.formats.custom.CustomJavaFormatsService;
import com.dataiku.dip.formats.custom.CustomPythonFormatsService;
import com.dataiku.dip.formats.custom.LoadedJavaFormat;
import com.dataiku.dip.formats.custom.LoadedPythonFormat;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.hive.HiveExecutionConfig;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.license.LicenseUtils;
import com.dataiku.dip.llm.custom.CustomJavaLLMsService;
import com.dataiku.dip.llm.custom.CustomPythonLLMsService;
import com.dataiku.dip.llm.custom.LoadedJavaLLM;
import com.dataiku.dip.llm.custom.LoadedPythonLLM;
import com.dataiku.dip.llm.governance.custom.CustomGuardrailsService;
import com.dataiku.dip.llm.governance.custom.LoadedCustomGuardrail;
import com.dataiku.dip.llm.online.LLMCostLimitingService;
import com.dataiku.dip.llm.online.LLMRateLimitingRunnerService;
import com.dataiku.dip.meanings.MeaningsService;
import com.dataiku.dip.metrics.checks.CustomPythonChecksService;
import com.dataiku.dip.metrics.checks.LoadedPythonCheck;
import com.dataiku.dip.metrics.probes.CustomPythonProbesService;
import com.dataiku.dip.metrics.probes.CustomSQLProbesService;
import com.dataiku.dip.metrics.probes.LoadedPythonProbe;
import com.dataiku.dip.metrics.probes.LoadedSQLProbe;
import com.dataiku.dip.onboarding.PageSpecificTourSettings;
import com.dataiku.dip.plugins.CustomJavaDatasetsService;
import com.dataiku.dip.plugins.CustomPythonDatasetsService;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.LoadedCustomDataset;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.plugins.model.PluginComponentRef;
import com.dataiku.dip.plugins.presets.LoadedParameterSet;
import com.dataiku.dip.plugins.presets.PluginParameterSetsService;
import com.dataiku.dip.processors.ConnectionPathTargetProcessorSettings;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.projectstandards.ProjectStandardsService;
import com.dataiku.dip.projectstandards.component.LoadedPythonPluginProjectStandardsCheckSpec;
import com.dataiku.dip.projectstandards.component.PythonPluginProjectStandardsService;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipesService;
import com.dataiku.dip.recipes.customcode.LoadedCustomCodeRecipeDesc;
import com.dataiku.dip.recipes.fromapp.LoadedAppRecipeDesc;
import com.dataiku.dip.rpc.LocalPrivilegedIntercomAPIClient;
import com.dataiku.dip.savedmodels.agents.CustomAgentsService;
import com.dataiku.dip.savedmodels.agents.LoadedCustomAgent;
import com.dataiku.dip.scheduler.runnables.CustomJavaRunnablesService;
import com.dataiku.dip.scheduler.runnables.CustomPythonRunnablesService;
import com.dataiku.dip.scheduler.runnables.LoadedRunnable;
import com.dataiku.dip.scheduler.steps.LoadedPythonPluginStep;
import com.dataiku.dip.scheduler.steps.PythonPluginStepsService;
import com.dataiku.dip.scheduler.triggers.LoadedPythonPluginTrigger;
import com.dataiku.dip.scheduler.triggers.PythonPluginTriggersService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.SSOSettings;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.GeneralSettingsChangedEvent;
import com.dataiku.dip.server.services.ATSurveyService;
import com.dataiku.dip.server.services.CloudStacksCloud;
import com.dataiku.dip.server.services.DeploymentMode;
import com.dataiku.dip.server.services.ImageService;
import com.dataiku.dip.server.services.InstanceLicenseKind;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.ThemesService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsageDataReporting;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.server.services.licensing.SAASInstanceService;
import com.dataiku.dip.shaker.processors.udf.CustomJythonProcessorsService;
import com.dataiku.dip.shaker.processors.udf.LoadedJythonProcessor;
import com.dataiku.dip.spark.SparkConfigurator;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.spark.submit.SparkSubmitHelper;
import com.dataiku.dip.sql.CustomJavaDialectsService;
import com.dataiku.dip.sql.LoadedJavaDialect;
import com.dataiku.dip.theming.model.DSSVisualizationTheme;
import com.dataiku.dip.theming.service.DSSVisualizationThemeService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.ApiKeyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.plugins.CustomWebAppsService;
import com.dataiku.dip.webapps.plugins.LoadedCustomWebApp;
import com.dataiku.dip.wikis.ArticlesCacheService;
import com.dataiku.dip.wikis.WikisService;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.Repository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GeneralSettingsService {
    private static boolean justAfterRegister;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private LicenseEnforcementService enforcementService;
    @Autowired
    private LicenseStatusService licenseService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IPluginsRegistryService pluginsService;
    @Autowired
    private UsersActivityDAO usersActivityDAO;
    @Autowired
    private UsersDAO userDAO;
    @Autowired
    private CustomPythonDatasetsService customPythonDatasetsService;
    @Autowired
    private CustomJavaDatasetsService customJavaDatasetsService;
    @Autowired
    private CustomPythonProbesService customPythonProbesService;
    @Autowired
    private CustomPythonChecksService customPythonChecksService;
    @Autowired
    private CustomSQLProbesService customSQLProbesService;
    @Autowired
    private CustomCodeRecipesService customCodeRecipesService;
    @Autowired
    private CustomPythonFormatsService customPythonFormatsService;
    @Autowired
    private CustomJavaFormatsService customJavaFormatsService;
    @Autowired
    private CustomPythonExportersService customPythonExporterService;
    @Autowired
    private CustomJavaExportersService customJavaExporterService;
    @Autowired
    private PythonPluginStepsService pythonPluginStepsService;
    @Autowired
    private PythonPluginTriggersService pythonPluginTriggersService;
    @Autowired
    private CustomPythonRunnablesService customPythonRunnablesService;
    @Autowired
    private CustomJavaRunnablesService customJavaRunnablesService;
    @Autowired
    private CustomWebAppsService customWebAppsService;
    @Autowired
    private CustomAgentsService customAgentsService;
    @Autowired
    private CustomAgentToolsService customAgentToolsService;
    @Autowired
    private CustomGuardrailsService customGuardrailsService;
    @Autowired
    private CustomPythonFSProvidersService customPythonFSProvidersService;
    @Autowired
    private CustomJavaFSProvidersService customJavaFSProvidersService;
    @Autowired
    private CustomJavaDialectsService customJavaDialectsService;
    @Autowired
    private CustomJythonProcessorsService customJythonStepsService;
    @Autowired
    private PythonPluginClustersService pythonPluginClustersService;
    @Autowired
    private PythonPluginCodeStudioTemplateService pythonPluginCodeStudioTemplateService;
    @Autowired
    private PythonPluginCodeStudioBlockService pythonPluginCodeStudioBlockService;
    @Autowired
    private PythonPluginProjectStandardsService pythonPluginProjectStandardsService;
    @Autowired
    private PluginParameterSetsService pluginPresetsService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private CustomJavaPolicyHooksService customJavaPolicyHooksService;
    @Autowired
    private CustomExpositionsService customExpositionsService;
    @Autowired
    private CustomJavaLLMsService customJavaLLMsService;
    @Autowired
    private CustomPythonLLMsService customPythonLLMsService;
    @Autowired
    private SampleDatasetsService sampleDatasetsService;
    @Autowired
    private MeaningsService meaningsService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private ThemesService themesService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private ImpersonationResolverService impersonationResolverService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ArticlesCacheService articlesCacheService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private AppsService appsService;
    @Autowired
    private CodeStudioTemplatesDAO codeStudioTemplatesDAO;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private DSSVisualizationThemeService chartThemeService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private WikisService wikisService;
    @Autowired
    private WorkspacesService workspacesService;
    @Autowired
    private ImageService imageService;
    private static DKULogger logger;

    @PostConstruct
    public void setup() throws IOException {
        logger.debug((Object)"Init settings service");
        try (Transaction t = this.transactionService.beginRead();){
            GeneralSettingsDAO.GeneralSettings gs = this.read();
            this.impersonationResolverService.setImpersonationConfig(gs.impersonation);
            DKUApp.setSecurityFlags((boolean)gs.security.hideLogs, (boolean)gs.security.hideErrorStacks, (boolean)gs.security.hideLogTails, (boolean)gs.security.secureCookies, (boolean)gs.security.sameSiteNoneCookies);
            ApiKeyUtils.setUseHashedApiKeys((boolean)gs.security.hashApiKeys);
        }
        logger.debug((Object)"Done init settings service");
        this.pubSub.subscribe("general-settings-changed", (DSSEventListener)new DSSEventListener<GeneralSettingsChangedEvent>(){

            public void on(GeneralSettingsChangedEvent evt) throws Exception {
                if (!JSON.jsonEquals((Object)evt.previousSettings.auditTrailSettings, (Object)evt.newSettings.auditTrailSettings)) {
                    logger.info((Object)"Audit settings changed, reconfiguring");
                    GeneralSettingsService.this.auditTrailService.reconfigure(evt.newSettings.auditTrailSettings);
                }
                if (!JSON.jsonEquals((Object)evt.previousSettings.eventServerSettings, (Object)evt.newSettings.eventServerSettings)) {
                    logger.info((Object)"Event server settings changed, triggering a reconfiguration");
                    GeneralSettingsService.this.triggerAsyncEventServerConfigurationReload();
                }
            }
        });
        this.pubSub.subscribe("nodes-directory-updated", (DSSEventListener)new DSSEventListener<DSSEvent>(){

            public void on(DSSEvent evt) throws Exception {
                logger.info((Object)"Nodes directory updated, checking for event server reconfiguration");
                NodesDirectory nd = ((NodesDirectoryService)SpringUtils.getBean(NodesDirectoryService.class)).getNodesDirectoryUnsafe_AutoTXN();
                if (nd.enabled && nd.getCurrentNode().configureEventServer) {
                    logger.info((Object)"Current node is an event server, triggering a server configuration update");
                    GeneralSettingsService.this.triggerAsyncEventServerConfigurationReload();
                }
            }
        });
    }

    private void triggerAsyncEventServerConfigurationReload() {
        new Thread(){

            @Override
            public void run() {
                try {
                    int eventServerPort = Integer.parseInt(System.getenv("DKU_EVENTSERVER_PORT"));
                    try (LocalPrivilegedIntercomAPIClient client = new LocalPrivilegedIntercomAPIClient(eventServerPort);){
                        client.postObject("/configure", Void.class, (Object)new JsonObject());
                    }
                    logger.info((Object)"Event server reconfiguration done");
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to reconfigure event server", (Throwable)e);
                }
            }
        }.start();
    }

    public GeneralSettingsDAO.GeneralSettings read() throws IOException {
        return this.generalSettingsDAO.read();
    }

    private void fillResultingUDRFlags(AppConfig appConfig, GeneralSettingsDAO.GeneralSettings gs, AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus licensedFeatures) {
        String overridePrivacyMode;
        appConfig.udrMode = gs.udrMode;
        if (licensedFeatures != null) {
            if (licensedFeatures.lockedTracking) {
                appConfig.udrMode = UsageDataReporting.UsageDataReportingMode.DEFAULT;
            }
            if (licensedFeatures.forbiddenTracking) {
                appConfig.udrMode = UsageDataReporting.UsageDataReportingMode.NO;
                appConfig.opalsEnabled = false;
            }
            if (licensedFeatures.mandatoryMinimalTracking && appConfig.udrMode == UsageDataReporting.UsageDataReportingMode.NO) {
                appConfig.udrMode = UsageDataReporting.UsageDataReportingMode.OPEN_ONLY;
            }
            appConfig.udrPrivacyMode = licensedFeatures.udrPrivacyMode;
            if (appConfig.udrPrivacyMode == null) {
                appConfig.udrPrivacyMode = UsageDataReporting.UsageDataReportingPrivacyMode.LINK;
            }
        } else {
            appConfig.udrMode = UsageDataReporting.UsageDataReportingMode.DEFAULT;
            appConfig.udrPrivacyMode = UsageDataReporting.UsageDataReportingPrivacyMode.LINK;
        }
        if (appConfig.udrMode == UsageDataReporting.UsageDataReportingMode.NO) {
            appConfig.npsSurveyActive = false;
            appConfig.npsSurveyEnabled = false;
            appConfig.atSurveyEnabled = false;
            appConfig.atSurveyStatus = null;
        }
        if (StringUtils.isNotBlank((String)(overridePrivacyMode = DKUApp.getParams().getParam("dku.tracking.usageDataPrivacyMode")))) {
            appConfig.udrPrivacyMode = UsageDataReporting.UsageDataReportingPrivacyMode.valueOf((String)overridePrivacyMode);
        }
        appConfig.errorsReporting = gs.errorsReportingEnabled;
        appConfig.pingTracking = ApplicationConfigurator.getParams().getBoolParam("dku.tracking.pingTracking", true);
        appConfig.pingTrackingInterval = ApplicationConfigurator.getParams().getIntParam("dku.tracking.pingTrackingInterval", Integer.valueOf(120000));
    }

    public AppConfig getConfigurationInternal(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        boolean unattendedMode;
        AppConfig c2 = new AppConfig();
        GeneralSettingsDAO.GeneralSettings generalSettings = this.read();
        c2.version = ApplicationConfigurator.getDSSVersion();
        if (System.getenv("DKUDISTRIB") != null) {
            String str = System.getenv("DKUDISTRIB");
            c2.distrib = StringUtils.split((String)str, (char)' ')[0];
            c2.distribVersion = str.substring(c2.distrib.length() + 1);
        } else {
            c2.distrib = "unknown";
            c2.distribVersion = "unknown";
        }
        c2.launcherVersion = System.getenv("DKU_LAUNCHER_VERSION");
        c2.dkuCloudSpaceId = System.getenv("DKU_CLOUD_SPACE_ID");
        c2.dkuCloudLaunchpadUrl = System.getenv("DKU_CLOUD_LAUNCHPAD_URL");
        if (StringUtils.isBlank((String)c2.dkuCloudLaunchpadUrl)) {
            c2.dkuCloudLaunchpadUrl = ApplicationConfigurator.getParams().getParam("dku.cloud.launchpadUrl");
        }
        c2.vmInfo = System.getenv("DKU_VM_INFO");
        c2.wslInfo = System.getenv("DKU_WSL_INFO");
        c2.deploymentMode = DKUApp.getDeploymentMode();
        c2.cloudStacksCloud = DKUApp.getCloudStacksCloud();
        c2.isAutomation = ApplicationConfigurator.isAutomation();
        c2.nodeType = DKUApp.getInstallNodeType();
        c2.dipInstanceId = ApplicationConfigurator.dipInstanceId();
        c2.installId = ApplicationConfigurator.getInstallId();
        c2.registrationChannel = ApplicationConfigurator.getParams().getParam("dku.registration.channel", null);
        c2.unattendedMode = unattendedMode = "true".equals(GeneralSettingsService.getCookieValue(req, "dku_unattended"));
        c2.debug = ApplicationConfigurator.debugEnabled();
        c2.devInstance = System.getenv("DSS_DEV") != null;
        c2.xsrfCookieName = UIAuthService.getXSRFCookieName();
        c2.nodeName = generalSettings.nodeName;
        c2.studioForgotPasswordUrl = generalSettings.studioForgotPasswordUrl;
        c2.dssExternalURL = generalSettings.studioExternalUrl;
        c2.offlineFrontend = unattendedMode || ApplicationConfigurator.getParams().getBoolParam("dku.offlineFrontend", false);
        c2.whiteLabeling = generalSettings.whiteLabeling != null ? generalSettings.whiteLabeling : new GeneralSettingsDAO.WhiteLabelingSettings();
        c2.disableAutomaticTriggers = generalSettings.disableAutomaticTriggers;
        c2.achievementsEnabled = false;
        c2.hashedApiKeysEnabled = ApiKeyUtils.useHashedApiKeys();
        c2.ssoLoginEnabled = generalSettings.ssoSettings.enabled;
        c2.ssoProtocol = generalSettings.ssoSettings.protocol;
        c2.noLoginMode = generalSettings.noLoginMode;
        c2.saasAuth = ApplicationConfigurator.isSAASAuth();
        if (c2.saasAuth) {
            c2.saasUserURL = ApplicationConfigurator.getMandatoryProperty((String)"saasUserURL");
            c2.saasAccess = (SAASInstanceService.UserAccessSummary)JSON.deepCopy((Object)this.authService.getSAASAccess(req));
            c2.saasAccess.xsrfTokenSalt = null;
            c2.saasAccess.accessToken = null;
        }
        c2.saasManagerURL = ApplicationConfigurator.getProperty((String)"saasManagerURL", (String)"https://my.dataiku.com/saas/api");
        c2.enableEmailAndDisplayNameModification = generalSettings.security.enableEmailAndDisplayNameModification;
        AuthCtx u = this.authService.getUserNoXSRF(req);
        if (u != null) {
            if (u.getAuthSource() != AuthCtx.AuthSource.USER_FROM_UI) {
                throw new DKUSecurityException("Unexpected auth source: " + String.valueOf(u.getAuthSource()));
            }
            c2.loggedIn = true;
            c2.login = u.getAssociatedDSSUserMand();
            UsersDAO.User user = this.userDAO.getOrNullUnsafe(c2.login);
            UsersService.UIUser uiUser = this.usersService.getUser_NoLeak(c2.login);
            uiUser.computeTrialStatus(generalSettings, user);
            c2.user = new PublicUser(uiUser.login, uiUser.displayName, uiUser.email, uiUser.creationDate, uiUser.sourceType);
            this.usersActivityDAO.updateUserLastSessionActivity(c2.login);
            c2.admin = u.isAdmin();
            c2.canAccessCloudDataikerAdminCapabilities = this.permissionsService.hasAdditionalCloudDataikerAdminPermission(u);
            c2.isCloudK8sInfraCreationEnabled = DKUApp.getParams().getBoolParam("dku.feature.cloudK8sDeployment.enabled", false);
            c2.areReportingToGraphiteSettingsDisplayed = DKUApp.getParams().getBoolParam("dku.deployer.reportingToGraphiteSettingsDisplayed", false);
            c2.areMetricsChartingServerSettingsDisplayed = DKUApp.getParams().getBoolParam("dku.deployer.metricsChartingServerSettingsDisplayed", false);
            if (req.getHeader("X-DKU-APIKey") == null) {
                this.authService.setXSRFCookie(req, resp);
            }
            c2.userProfile = this.licenseEnforcementService.getUserProfileByNameOrFallback(uiUser.resultingUserProfile);
            c2.globalPermissions = this.usersService.getUserEffectiveGroupPermissions(user).getResolved();
            if (uiUser.trialStatus.exists) {
                c2.trialStatus = uiUser.trialStatus;
            }
            c2.noneUsersCallToActionBehavior = generalSettings.licensingSettings.noneUsersCallToActionBehavior;
            c2.noneUsersCallToActionMessage = generalSettings.licensingSettings.noneUsersCallToActionMessage;
            c2.userProfileForTrialsStartedByNoneUsers = generalSettings.licensingSettings.userProfileForTrialsStartedByNoneUsers;
            c2.allowRequestAccessWithStartedTrial = generalSettings.licensingSettings.allowRequestAccessWithStartedTrial;
            if (user.npsSurveySettings != null && generalSettings.npsSurveyEnabled && !unattendedMode) {
                boolean bl = c2.npsSurveyActive = System.currentTimeMillis() >= user.npsSurveySettings.nextAction;
                if (c2.npsSurveyActive && user.atSurveySettings != null) {
                    user.atSurveySettings.nextAction = ATSurveyService.getNextSurveyInstant();
                }
            }
            boolean bl = c2.atSurveyEnabled = generalSettings.npsSurveyEnabled && !unattendedMode;
            if (c2.atSurveyEnabled) {
                c2.atSurveyStatus = user.atSurveySettings;
            }
            c2.npsSurveyEnabled = generalSettings.npsSurveyEnabled;
            c2.pageSpecificTourSettings = user.pageSpecificTourSettings;
            c2.opalsEnabled = generalSettings.opalsEnabled;
            c2.onboardingExperience = generalSettings.onboardingExperience;
            c2.requireProjectAdminPermissionToExportAndBundleProjects = generalSettings.security.requireProjectAdminPermissionToExportAndBundleProjects;
            c2.onboardingPending = !c2.isAutomation && user.onboardingPending();
        } else {
            c2.firstLoginAfterRegister = justAfterRegister;
            c2.signUpMessage = generalSettings.licensingSettings.signUpMessage;
        }
        c2.licensing = this.licenseService.getLicensingStatus();
        c2.licensing.properties = null;
        c2.communityEdition = c2.licensing.community;
        c2.ceEntrepriseTrial = c2.licensing.ceEntrepriseTrial;
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus licensedFeatures = null;
        if (c2.licensing.hasLicense) {
            licensedFeatures = this.enforcementService.getFeaturesStatus();
            if (c2.licensing.licenseContent.licenseKind != null) {
                c2.licenseKind = InstanceLicenseKind.valueOf((String)c2.licensing.licenseContent.licenseKind);
            } else if (c2.communityEdition) {
                c2.licenseKind = InstanceLicenseKind.COMMUNITY;
            }
            c2.licensedFeatures = licensedFeatures;
        } else {
            c2.licenseKind = InstanceLicenseKind.NONE;
        }
        if (c2.licenseKind == null) {
            c2.licenseKind = InstanceLicenseKind.UNKNOWN;
        }
        c2.licensingMode = ApplicationConfigurator.getLicensingMode();
        if (c2.licensingMode == DKUApp.LicensingMode.ON_PREMISE_DISCONNECTED && !c2.licensing.hasLicense) {
            c2.licensingMode = DKUApp.LicensingMode.NONE;
            c2.nodeId = LicenseUtils.getMainNodeId();
        }
        c2.anonRegistrationAllowed = ApplicationConfigurator.getParams().getBoolParam("dku.registration.anonAllowed", false);
        if (!c2.loggedIn) {
            c2.licensing.licenseContent = null;
            c2.licensing.sublicense = null;
            c2.licensedFeatures = null;
        }
        this.fillResultingUDRFlags(c2, generalSettings, licensedFeatures);
        if (c2.loggedIn) {
            c2.twitterEnabled = !c2.communityEdition;
            c2.rEnabled = true;
            c2.juliaEnabled = true;
            c2.hadoopEnabled = HadoopLoader.hadoopEnabled();
            c2.pigEnabled = "true".equals(System.getenv("DKU_PIG_ENABLED"));
            c2.hiveEnabled = HiveConfigurator.isHiveInstalled();
            c2.impalaEnabled = ImpalaConfigurator.impalaAvailableBase();
            c2.dropDataWithDatasetDeleteEnabled = generalSettings.dropDataWithDatasetDeleteEnabled;
            c2.impersonationEnabled = generalSettings.impersonation.enabled;
            c2.alationSettings = generalSettings.alationSettings;
            c2.graphicsExportsEnabled = generalSettings.graphicsExportsEnabled;
            c2.streamingEnabled = generalSettings.streamingEnabled;
            c2.showProjectsGraphView = generalSettings.showProjectsGraphView;
            c2.cdeEnabled = generalSettings.containerSettings.cdeEnabled;
            c2.cdePluginSupport = generalSettings.containerSettings.cdePluginSupport;
            c2.dataTableLinksEnabled = !generalSettings.security.disableDataTableLinks && DKUApp.getParams().getBoolParam("dku.feature.dataTableLinks.enabled", true);
            c2.eventServerEnabled = Boolean.parseBoolean(ApplicationConfigurator.getIniValue((String)"eventserver", (String)"enabled", (String)"false"));
            c2.postLogoutBehavior = generalSettings.security.postLogoutBehavior;
            c2.postLogoutCustomURL = generalSettings.security.postLogoutCustomURL;
            if (c2.hadoopEnabled) {
                c2.hadoopVersion = System.getenv("DKU_HADOOP_VERSION_STRING");
            }
            if (c2.hiveEnabled) {
                HiveSettings hiveSettings = generalSettings.hiveSettings;
                for (HiveExecutionConfig hiveExecutionConfig : hiveSettings.executionConfigs) {
                    c2.hiveExecutionConfigs.add(hiveExecutionConfig.name);
                }
                c2.hiveUrlContainsSecret = HiveSettings.urlContainsSecret();
            }
            c2.trialsEnabled = this.areTrialsEnabled(generalSettings, c2.licensing);
            if (!c2.trialsEnabled.booleanValue() && c2.noneUsersCallToActionBehavior == GeneralSettingsDAO.NoneUsersCallToActionBehavior.ALLOW_START_TRIAL) {
                c2.noneUsersCallToActionBehavior = GeneralSettingsDAO.NoneUsersCallToActionBehavior.ALLOW_REQUEST_ACCESS;
            }
            c2.noneUsersCallToActionMessage = generalSettings.licensingSettings.noneUsersCallToActionMessage;
            c2.userProfileForTrialsStartedByNoneUsers = generalSettings.licensingSettings.userProfileForTrialsStartedByNoneUsers;
            c2.upgradeProfileCallToActionMessage = generalSettings.licensingSettings.upgradeProfileCallToActionMessage;
            c2.allowProfileUpgradeRequests = generalSettings.licensingSettings.allowProfileUpgradeRequests;
            c2.synchronizeToMetastoreCatalogFlavor = generalSettings.metastoreCatalogsSettings.synchronizeTo.flavor;
            c2.appRecipes = this.appsService.listAppRecipeDescs(u);
            c2.studioAdminContactLabel = generalSettings.studioAdminContactLabel;
            c2.studioAdminContact = generalSettings.studioAdminContact;
            c2.recoBannerHomeMessage = generalSettings.recoBannerHomeMessage;
            c2.recoBannerMustReads = generalSettings.recoBannerMustReads;
            c2.rstudioServerEmbedURL = ApplicationConfigurator.getParams().getParam("dku.rstudioServerEmbedURL");
            SparkSettings sparkSettings = generalSettings.sparkSettings;
            c2.sparkEnabled = SparkConfigurator.sparkAvailableBase();
            if (c2.sparkEnabled) {
                for (SparkExecutionConfig sparkExecutionConfig : sparkSettings.executionConfigs) {
                    c2.sparkExecutionConfigs.add(sparkExecutionConfig.name);
                }
                c2.sparkVersion = SparkSubmitHelper.SPARK_VERSION;
            }
            c2.h2oEnabled = !StringUtils.isBlank((String)generalSettings.h2o_url);
            c2.interactiveSparkEngine = sparkSettings.interactiveExecutionEngine;
            c2.defaultDateonlyReadMode = ApplicationConfigurator.getParams().getBoolParam("dku.sql.defaultReadDatesAsDSSDates", false) ? AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE : AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS;
            c2.meanings = this.meaningsService.listAll();
            if (generalSettings.themeId != null) {
                try {
                    c2.theme = this.themesService.get(generalSettings.themeId);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to read configured theme " + generalSettings.themeId + ", ignoring"), (Throwable)e);
                }
            }
            c2.homeMessages = generalSettings.homeMessages;
            c2.permissionsByEmailEnabled = GeneralSettingsService.arePermissionsByEmailEnabled(generalSettings);
            c2.projectVisibility = generalSettings.projectVisibility;
            c2.appVisibility = generalSettings.appVisibility;
            c2.objectSharingRequestsMode = generalSettings.objectSharingRequestsMode;
            c2.emailChannelId = generalSettings.notifications.emailChannelId;
            c2.welcomeEmailSettings = generalSettings.welcomeEmailSettings;
            if (generalSettings.projectStatusList != null) {
                c2.projectStatusList = generalSettings.projectStatusList;
            }
            if (generalSettings.brandColors != null) {
                c2.brandColors = generalSettings.brandColors;
            }
            ProxySettings proxySettings = this.read().proxySettings;
            c2.hasGlobalProxy = proxySettings.hasProxy();
            c2.gitMode = ApplicationConfigurator.getGitMode();
            c2.pluginDevGitMode = ApplicationConfigurator.getPluginGitMode();
            c2.nbSimultaneousInsightLoading = ApplicationConfigurator.getParams().getIntParam("dku.nbSimultaneousInsightLoading", Integer.valueOf(4));
            try {
                c2.projectsModuleEnabled = !"false".equals(DKUApp.getIniValue((String)"modules", (String)"projects"));
            }
            catch (Exception exception) {
                c2.projectsModuleEnabled = true;
            }
            GeneralSettingsDAO.DeployerRef deployerRef = generalSettings.deployerClientSettings.getRef();
            c2.deployerMode = deployerRef.mode;
            c2.deployerClientEnabled = deployerRef.mode != GeneralSettingsDAO.DeployerMode.DISABLED;
            c2.deployerServerEnabled = deployerRef.mode == GeneralSettingsDAO.DeployerMode.LOCAL || deployerRef.mode == GeneralSettingsDAO.DeployerMode.REMOTE && generalSettings.deployerServerEnabledDespiteRemote;
            c2.deployerURL = deployerRef.nodeExternalUrl;
            c2.apiDeploymentStages = generalSettings.apiDeployerServerSettings.stages;
            c2.remoteDeployerMisconfigured = deployerRef.mode == GeneralSettingsDAO.DeployerMode.REMOTE && (StringUtils.isBlank((String)deployerRef.nodeExternalUrl) || StringUtils.isBlank((String)deployerRef.apiKey));
            c2.projectDeploymentStages = generalSettings.projectDeployerServerSettings.stages;
            c2.allowMultiNodeProjectDeployerInfrastructures = generalSettings.projectDeployerServerSettings.allowMultiNodeInfrastructures;
            c2.globalMaxDeploymentHooksKernels = ApplicationConfigurator.getParams().getIntParam("dku.deployer.hooks.kernels.maxTotal", Integer.valueOf(100));
            GeneralSettingsDAO.NodeRef governRef = generalSettings.governIntegrationSettings.getRef();
            c2.governEnabled = governRef.enabled;
            c2.governURL = governRef.nodeExternalUrl;
            c2.webappsIsolationMode = generalSettings.security.webappsIsolationMode;
            c2.webappsIsolationOrigin = generalSettings.security.webappsIsolationOrigin;
            c2.featureFlags.addAll(FeatureFlags.listEnabled());
            NodesDirectory nd = ((NodesDirectoryService)SpringUtils.getBean(NodesDirectoryService.class)).getNodesDirectoryUnsafe_AutoTXN();
            if (nd.enabled) {
                GeneralSettingsDAO.LocalAIServerSettings.AiAssistant[] currentNode = nd.getCurrentNode();
                c2.nodesDirectoryManagedDeployerServer = nd.enabled && currentNode.configureDeployerServer;
                c2.nodesDirectoryManagedDeployerClient = nd.enabled && nd.hasRemoteDeployerNode();
                c2.nodesDirectoryManagedDeployerClientRunning = c2.nodesDirectoryManagedDeployerClient && nd.isRemoteDeployerInstanceUp();
                c2.nodesDirectoryManagedEventServerClient = nd.enabled && nd.hasEventServerNode();
                c2.nodesDirectoryManagedGovernClient = nd.enabled && nd.hasGovernNode();
                c2.nodesDirectoryManagedGovernClientRunning = c2.nodesDirectoryManagedGovernClient && nd.isGovernInstanceUp();
            }
            c2.uiCustomization = generalSettings.uiCustomizationSettings;
            c2.autoAcceptSchemaChangeAtEndOfFlow = generalSettings.autoAcceptSchemaChangeAtEndOfFlow;
            c2.prepareAICompletionEnabled = !c2.communityEdition && generalSettings.aiDrivenAnalyticsSettings.prepareAICompletionEnabled;
            c2.aiGenerateSQLEnabled = !c2.communityEdition && generalSettings.aiDrivenAnalyticsSettings.aiGenerateSQLEnabled;
            c2.aiExplanationsEnabled = !c2.communityEdition && generalSettings.aiDrivenAnalyticsSettings.aiExplanationsEnabled;
            c2.storiesAIEnabled = !c2.communityEdition && generalSettings.dataikuStoriesSettings.enabled && generalSettings.aiDrivenAnalyticsSettings.storiesAIEnabled;
            c2.storiesVocalEnabled = c2.storiesAIEnabled != false && FeatureFlags.isEnabled((String)"storiesVocal");
            c2.askDataikuEnabled = !c2.communityEdition && generalSettings.askDataikuSettings.enabled;
            c2.askDataikuTelemetryEnabled = c2.askDataikuEnabled != false && generalSettings.askDataikuSettings.telemetryEnabled;
            c2.helpCenterSupportLinks = generalSettings.helpCenterSupportLinks;
            c2.scatterSettings = new ScatterSettings();
            c2.llmSettings = new LLMSettings(generalSettings.generativeAISettings.llmTraceSettings.traceExplorerDefaultWebApp);
            c2.selectedDSSVisualizationTheme = this.chartThemeService.get(generalSettings.selectedDSSVisualizationThemeId);
            for (GeneralSettingsDAO.LocalAIServerSettings.AiAssistant assistant : GeneralSettingsDAO.LocalAIServerSettings.AiAssistant.values()) {
                c2.isUsingLocalAiAssitant.put(assistant, generalSettings.localAIServerSettings.isLocalAiAssistantEnabled(assistant));
            }
        }
        if (c2.loggedIn) {
            for (InstalledPluginDesc ipd : this.pluginsService.getLoadedPlugins()) {
                boolean bl;
                boolean bl2 = false;
                try {
                    bl = u != null && u.getAuthSource() == AuthCtx.AuthSource.USER_FROM_UI && !this.permissionsService.hasPluginPrivilege(u, ipd.desc.id, Privileges.PluginLevelPrivilegeType.COMPONENTS_VIEWER);
                }
                catch (DKUSecurityException e) {
                    logger.debug((Object)"Unable to verify user privilege. Showing components.");
                }
                AppConfig.MinimalPluginDesc mpd = new AppConfig.MinimalPluginDesc(ipd, bl);
                if (ipd.desc.publicParams) {
                    try {
                        mpd.params = this.pluginsService.getSettings((String)ipd.desc.id).config;
                    }
                    catch (Error e) {
                        logger.warn((Object)("Unable to get public settings for plugin " + ipd.desc.id), (Throwable)e);
                    }
                }
                c2.loadedPlugins.add(mpd);
                if (ipd.desc.featureFlags == null) continue;
                for (String ff : ipd.desc.featureFlags) {
                    if (!StringUtils.isNotBlank((String)ff)) continue;
                    c2.featureFlags.add(ff);
                }
            }
            File customJSFile = ApplicationConfigurator.getFile((String)"local/custom.js");
            if (customJSFile.isFile()) {
                c2.customJS = FileUtils.readFileToString((File)customJSFile, (String)"utf8");
            }
            c2.customDatasets.addAll(this.customPythonDatasetsService.list());
            c2.customDatasets.addAll(this.customJavaDatasetsService.list());
            c2.customCodeRecipes = this.customCodeRecipesService.list();
            c2.customPythonProbes = this.customPythonProbesService.list();
            c2.customPythonChecks = this.customPythonChecksService.list();
            c2.customSQLProbes = this.customSQLProbesService.list();
            c2.customPythonFormats = this.customPythonFormatsService.list();
            c2.customJavaFormats = this.customJavaFormatsService.list();
            c2.customExporters.addAll(this.customPythonExporterService.list());
            c2.customExporters.addAll(this.customJavaExporterService.list());
            c2.customPythonPluginSteps = this.pythonPluginStepsService.list();
            c2.customPythonPluginTriggers = this.pythonPluginTriggersService.list();
            c2.customRunnables.addAll(this.customPythonRunnablesService.list());
            c2.customRunnables.addAll(this.customJavaRunnablesService.list());
            c2.customWebApps = this.customWebAppsService.list();
            c2.customAgents = this.customAgentsService.list();
            c2.customAgentTools = this.customAgentToolsService.list();
            c2.customGuardrails = this.customGuardrailsService.list();
            c2.customFSProviders.addAll(this.customPythonFSProvidersService.list());
            c2.customFSProviders.addAll(this.customJavaFSProvidersService.list());
            c2.customDialects.addAll(this.customJavaDialectsService.list());
            c2.customJythonProcessors.addAll(this.customJythonStepsService.list());
            c2.customPythonPluginClusters = this.pythonPluginClustersService.list();
            c2.customPythonPluginCodeStudioTemplates = this.pythonPluginCodeStudioTemplateService.list();
            c2.customPythonPluginCodeStudioBlocks = this.pythonPluginCodeStudioBlockService.list();
            c2.customPythonPluginProjectStandardsCheckSpecs = this.pythonPluginProjectStandardsService.list();
            c2.customParameterSets = this.pluginPresetsService.list();
            c2.customSampleDatasets = this.sampleDatasetsService.list();
            c2.customFieldsMap = this.customFieldsService.getCustomFieldsMap();
            c2.customFieldsPluginComponentRefs = this.customFieldsService.getPluginComponentRefs();
            c2.customPolicyHooksPluginComponentRefs = this.customJavaPolicyHooksService.getPluginComponentRefs();
            c2.customExpositions = this.customExpositionsService.list();
            c2.customJavaLLMs = this.customJavaLLMsService.list();
            c2.customPythonLLMs = this.customPythonLLMsService.list();
            c2.pluginDevExplicitCommit = generalSettings.pluginDevExplicitCommit;
            c2.alertBanner = generalSettings.personalHomePages.alertBanner;
        }
        if (c2.loggedIn) {
            c2.userSettings = this.userSettingsService.getForUser(c2.login);
            this.userSettingsService.setSmartHomePage(c2.userSettings.home, c2.userProfile, u);
        }
        if (!c2.loggedIn && generalSettings.security.hideVersionStringsWhenNotLogged) {
            c2.distrib = null;
            c2.distribVersion = null;
            c2.version = null;
            c2.launcherVersion = null;
            c2.deploymentMode = null;
            c2.dkuCloudSpaceId = null;
        }
        justAfterRegister = false;
        c2.helpIntegrationEnabled = generalSettings.helpIntegrationEnabled;
        c2.openTicketsFromOpalsEnabled = generalSettings.openTicketsFromOpalsEnabled;
        c2.k8sContainerConfigs = generalSettings.containerSettings.executionConfigs.stream().filter(x -> x.type == ContainerExecRuntimeConfig.Container.KUBERNETES && x.supportsWorkloadType(WorkloadType.USER_CODE)).map(x -> x.name).collect(Collectors.toList());
        c2.opalsUrl = ApplicationConfigurator.getProperty((String)"opals.url", (String)"https://help.dataiku.com");
        c2.opalsApiUrl = ApplicationConfigurator.getProperty((String)"opals.api.url", (String)"https://help.dataiku.com/api");
        c2.hideUserCenter = ApplicationConfigurator.getProperty((String)"dku.hideUserCenter", (String)"false").equalsIgnoreCase("true");
        try {
            Set pluginBlockTypesInEditorTemplates = this.codeStudioTemplatesDAO.listUnsafe().stream().filter(t -> t.isEditor && "block_based".equals(t.type)).flatMap(t -> t.getParamsAs(BlockBasedCodeStudioTemplateParams.class).blocks.stream()).filter(b -> b.type.startsWith("pycdstdioblk_")).map(b -> b.type).collect(Collectors.toSet());
            for (String name : new String[]{"jupyterlab", "rstudio", "vscode"}) {
                if (!pluginBlockTypesInEditorTemplates.stream().anyMatch(t -> t.toLowerCase().contains(name))) continue;
                c2.wellKnownEditorCodeStudios.add(name);
            }
        }
        catch (Exception e) {
            logger.info((Object)"Unable to check if some Code Studio is an IDE, assuming none", (Throwable)e);
        }
        c2.quickSharingElementsEnabled = generalSettings.quickSharingElementsEnabled;
        c2.dataStoryIntegrationEnabled = generalSettings.dataikuStoriesSettings.enabled;
        c2.pluginInstallRequestsEnabled = generalSettings.pluginInstallRequestsEnabled;
        c2.disableImmediateFlush = ApplicationConfigurator.getParams().getBoolParam("dku.featureStore.disableImmediateFlush", false);
        c2.defaultRagasMaxWorkers = ApplicationConfigurator.getParams().getIntParam("dku.llmEvaluation.defaultRagasMaxWorkers", Integer.valueOf(9));
        c2.codeEnvInstallRequestsEnabled = generalSettings.codeEnvInstallRequestsEnabled;
        c2.enablePopularDatasets = generalSettings.popularDatasetsSettings.enablePopularDatasets;
        c2.autogeneratedDocumentationEnabled = generalSettings.autogeneratedDocumentationEnabled;
        c2.enableVerboseLoggingNewSqlEditor = ApplicationConfigurator.getProperty((String)"dku.sql.newEditor.verbose", (boolean)false);
        if (c2.loggedIn) {
            c2.dataikuCloudUISettings = generalSettings.dataikuCloudUISettings;
            c2.namingRulesSettings = generalSettings.namingRulesSettings;
        }
        ProjectStandardsService psService = (ProjectStandardsService)SpringUtils.getBean(ProjectStandardsService.class);
        c2.canSkipProjectStandardsChecks = psService.getGeneralParametersUnsafe().canSkipProjectStandardsChecks;
        c2.isProjectStandardsConfigured = !psService.getChecksUnsafe().isEmpty();
        c2.projectStandardsMaxExecutionTimeoutMinutes = DKUApp.getParams().getIntParam("dku.projectstandards.maxExecutionTimeoutMinutes", Integer.valueOf(120));
        return c2;
    }

    public Map<String, String> getCustomHeadersForTracking(AuthCtx liu) {
        HashMap headers = Maps.newHashMap();
        headers.put("dipInstanceId", ApplicationConfigurator.dipInstanceId());
        headers.put("dssVersion", String.valueOf(ApplicationConfigurator.getDSSVersion()));
        LicenseStatusService.LicensingStatus licensing = this.licenseService.getLicensingStatus();
        InstanceLicenseKind licenseKind = null;
        if (licensing.hasLicense) {
            if (licensing.licenseContent.licenseKind != null) {
                licenseKind = InstanceLicenseKind.valueOf((String)licensing.licenseContent.licenseKind);
            } else if (licensing.community) {
                licenseKind = InstanceLicenseKind.COMMUNITY;
            }
        } else {
            licenseKind = InstanceLicenseKind.NONE;
        }
        if (licenseKind == null) {
            licenseKind = InstanceLicenseKind.UNKNOWN;
        }
        headers.put("dssLicenseKind", licenseKind.name());
        if (System.getenv("DKUDISTRIB") != null) {
            String str = System.getenv("DKUDISTRIB");
            String distrib = StringUtils.split((String)str, (char)' ')[0];
            headers.put("bkdDistrib", distrib);
            headers.put("bkdDistribVersion", str.substring(distrib.length() + 1));
        }
        return null;
    }

    private int dkuHashCode(String s) {
        int hash = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c2 = s.charAt(i);
            hash = (hash << 5) - hash + c2;
        }
        return hash;
    }

    public static boolean arePermissionsByEmailEnabled(GeneralSettingsDAO.GeneralSettings generalSettings) {
        return generalSettings.permissionsByEmailEnabled && !generalSettings.security.enableEmailAndDisplayNameModification;
    }

    private void checkEventServerUser(AuthCtx authCtx, ConnectionPathTargetProcessorSettings setting, InfoMessage.InfoMessages messages) {
        if (StringUtils.isEmpty((String)setting.runAs)) {
            messages.addMessage(InfoMessage.warning((String)"Event Server target user", (String)"Write as user must be defined"));
            return;
        }
        try (Transaction t = this.transactionService.beginRead();){
            UsersDAO.User user = this.userDAO.getOrNullUnsafe(setting.runAs);
            if (user == null) {
                messages.addMessage(InfoMessage.warning((String)"Event Server target user", (String)("Unknown user '" + setting.runAs + "'")));
            }
        }
        catch (IOException e) {
            messages.addMessage(InfoMessage.warning((String)"Event Server target user", (String)"Unable to read users"));
        }
    }

    private void checkEventServerConnection(AuthCtx authCtx, ConnectionPathTargetProcessorSettings setting, InfoMessage.InfoMessages messages) {
        if (StringUtils.isEmpty((String)setting.fileLikeConnectionName)) {
            messages.addMessage(InfoMessage.warning((String)"Event Server target connection", (String)"Connection name must be defined"));
            return;
        }
        try (Transaction t = this.transactionService.beginRead();){
            DSSConnection connection = this.connectionsDAO.getConnection(authCtx, setting.fileLikeConnectionName);
            if (connection == null) {
                messages.addMessage(InfoMessage.warning((String)"Event Server target connection", (String)("Unknown connection '" + setting.fileLikeConnectionName + "'")));
            }
        }
        catch (DKUSecurityException | IOException e) {
            messages.addMessage(InfoMessage.warning((String)"Event Server target connection", (String)"Unable to read connections"));
        }
    }

    private void checkEventServer(AuthCtx authCtx, ConnectionPathTargetProcessorSettings setting, InfoMessage.InfoMessages messages) throws DKUSecurityException {
        String path = setting.fileLikePathWithinConnection;
        if (path != null && ((path = path.trim()).equals("..") || path.contains("../") || path.contains("/.."))) {
            logger.error((Object)("Forbidden '..' segment in Event server path within connection, path='" + path + "'"));
            throw new DKUSecurityException("Forbidden '..' segment in Event server path within connection").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_FSLIKE_REACH_OUT_OF_ROOT);
        }
        this.checkEventServerUser(authCtx, setting, messages);
        this.checkEventServerConnection(authCtx, setting, messages);
    }

    public void checkEventServerSetting(AuthCtx authCtx, GeneralSettingsDAO.GeneralSettings gs, InfoMessage.InfoMessages messages) throws DKUSecurityException {
        for (ConnectionPathTargetProcessorSettings t : gs.eventServerSettings.targets) {
            this.checkEventServer(authCtx, t, messages);
        }
    }

    public boolean cleanupPromotedContentImages(GeneralSettingsDAO.GeneralSettings gs) throws IOException {
        Set<String> usedPromotedContentImageIds = gs.personalHomePages.promotedContent.stream().filter(content -> GeneralSettingsDAO.ThumbnailMode.UPLOAD.equals((Object)content.thumbnailMode) && StringUtils.isNotBlank((String)content.customThumbnailImageId)).map(content -> content.customThumbnailImageId).collect(Collectors.toSet());
        Set<String> deletedFilesAndDirectories = this.imageService.cleanupPromotedContentImages(usedPromotedContentImageIds);
        if (!deletedFilesAndDirectories.isEmpty()) {
            logger.info((Object)("Deleted unused promoted content images files/directories: " + String.join((CharSequence)", ", deletedFilesAndDirectories)));
            return true;
        }
        return false;
    }

    public GeneralSettingsChangedEvent save(AuthCtx authCtx, GeneralSettingsDAO.GeneralSettings gs) throws Exception {
        if (StringUtils.isNotBlank((String)gs.git.defaultBaseBranch) && !Repository.isValidRefName((String)("origin/" + gs.git.defaultBaseBranch))) {
            throw new IllegalArgumentException("Default Git base branch name contains invalid characters: " + gs.git.defaultBaseBranch);
        }
        GeneralSettingsDAO.GeneralSettings previous = this.generalSettingsDAO.read();
        if (gs.ldapSettings != null && gs.ldapSettings.enabled) {
            this.enforcementService.checkLdapAllowed();
        }
        gs.ldapSettings.encryptFields(this.passwordEncryptionService);
        gs.ssoSettings.encryptFields(this.passwordEncryptionService);
        gs.hadoopSettings.encryptFields(this.passwordEncryptionService);
        gs.hiveSettings.encryptFields(this.passwordEncryptionService);
        gs.impalaSettings.encryptFields(this.passwordEncryptionService);
        gs.sparkSettings.encryptFields(this.passwordEncryptionService);
        gs.proxySettings.encryptFields(this.passwordEncryptionService);
        gs.ssoSettings.openIDParams.encryptFields(this.passwordEncryptionService);
        gs.azureADSettings.encryptFields(this.passwordEncryptionService);
        gs.deployerClientSettings.encryptFields(this.passwordEncryptionService);
        gs.remoteDesignNodeCreds.forEach(c2 -> c2.encryptFields(this.passwordEncryptionService));
        gs.governIntegrationSettings.encryptFields(this.passwordEncryptionService);
        if (gs.dataikuCloudK8SApiDeploymentSettings != null && gs.dataikuCloudK8SApiDeploymentSettings.activityMonitoringSettings != null) {
            gs.dataikuCloudK8SApiDeploymentSettings.activityMonitoringSettings.encryptFields(this.passwordEncryptionService);
        }
        this.removeDeletedProjectStatus(gs);
        this.checkForbiddenCloudChanges(authCtx, previous, gs);
        this.generalSettingsDAO.save((GeneralSettingsDAO.GeneralSettings)Preconditions.checkNotNull((Object)gs));
        this.impersonationResolverService.setImpersonationConfig(gs.impersonation);
        GeneralSettingsChangedEvent evt = new GeneralSettingsChangedEvent(previous, gs);
        this.pubSub.publishAfterTransaction((DSSEvent)evt);
        return evt;
    }

    private void checkForbiddenCloudChanges(AuthCtx authCtx, GeneralSettingsDAO.GeneralSettings before, GeneralSettingsDAO.GeneralSettings after) throws DKUSecurityException {
        if (authCtx.getAuthSource() == AuthCtx.AuthSource.NONE) {
            return;
        }
        if (this.permissionsService.hasAdditionalCloudDataikerAdminPermission(authCtx)) {
            return;
        }
        logger.debug((Object)"Cloud limited-admin: checking for forbidden changes");
        assert (authCtx.isAdmin());
        assert (before != null);
        if (!JSON.jsonEquals((Object)before.auditTrailSettings, (Object)after.auditTrailSettings)) {
            throw new UnauthorizedException("Settings change forbidden", "cloud-customer-audit-change");
        }
        if (!JSON.jsonEquals((Object)before.impersonation, (Object)after.impersonation)) {
            throw new UnauthorizedException("Settings change forbidden", "cloud-customer-audit-change");
        }
    }

    private void removeDeletedProjectStatus(GeneralSettingsDAO.GeneralSettings gs) throws Exception {
        RelFile f = RelFile.global((String)"general-settings.json");
        GeneralSettingsDAO.GeneralSettings gsOld = (GeneralSettingsDAO.GeneralSettings)TransactionContext.retrieveWrite().readObjectDefault(f, GeneralSettingsDAO.GeneralSettings.class);
        List<GeneralSettingsDAO.ProjectStatus> oldProjectStatusList = gsOld.projectStatusList;
        List<GeneralSettingsDAO.ProjectStatus> newProjectStatusList = gs.projectStatusList;
        ArrayList<GeneralSettingsDAO.ProjectStatus> toDeleteProjectStatusList = new ArrayList<GeneralSettingsDAO.ProjectStatus>();
        for (GeneralSettingsDAO.ProjectStatus ps2 : oldProjectStatusList) {
            boolean wasDeleted = true;
            for (GeneralSettingsDAO.ProjectStatus pss : newProjectStatusList) {
                if (!StringUtils.equals((String)ps2.name, (String)pss.name)) continue;
                wasDeleted = false;
                break;
            }
            if (!wasDeleted) continue;
            toDeleteProjectStatusList.add(ps2);
        }
        this.projectsService.removeStatusesFromAllProjects(toDeleteProjectStatusList);
    }

    public GeneralSettingsDAO.ProjectStatus getProjectStatusWithName(String name) throws IOException {
        List<GeneralSettingsDAO.ProjectStatus> projectStatus = this.read().projectStatusList;
        for (GeneralSettingsDAO.ProjectStatus pj : projectStatus) {
            if (!name.equals(pj.name)) continue;
            return pj;
        }
        return null;
    }

    public GeneralSettingsDAO.ProjectStatus getDefaultProjectStatus() throws IOException {
        List<GeneralSettingsDAO.ProjectStatus> projectStatus = this.read().projectStatusList;
        if (projectStatus.size() > 0 && !"Archived".equals(projectStatus.get((int)0).name)) {
            return projectStatus.get(0);
        }
        return null;
    }

    private boolean areTrialsEnabled(GeneralSettingsDAO.GeneralSettings generalSettings, LicenseStatusService.LicensingStatus licensingStatus) {
        return generalSettings.licensingSettings.trialBehavior == GeneralSettingsDAO.TrialBehavior.ENABLED || generalSettings.licensingSettings.trialBehavior == GeneralSettingsDAO.TrialBehavior.ENABLED_IF_PRESENT_IN_LICENSE && licensingStatus.trialsExplicitlyEnabled;
    }

    public void checkTrialsEnabled(GeneralSettingsDAO.GeneralSettings generalSettings, LicenseStatusService.LicensingStatus licensingStatus) {
        if (!this.areTrialsEnabled(generalSettings, licensingStatus)) {
            throw new IllegalArgumentException("You are not allowed to start a trial, trials are disabled on this instance");
        }
    }

    public static void setJustAfterRegister(boolean justAfterRegister) {
        GeneralSettingsService.justAfterRegister = justAfterRegister;
    }

    private static String getCookieValue(HttpServletRequest req, String name) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    static {
        logger = DKULogger.getLogger((String)"dku.config");
    }

    @UIModel
    public static class AppConfig {
        boolean isAutomation;
        String nodeType;
        InstanceLicenseKind licenseKind;
        String dipInstanceId;
        String installId;
        DKUApp.DSSVersion version;
        String launcherVersion;
        String dkuCloudSpaceId;
        String dkuCloudLaunchpadUrl;
        DeploymentMode deploymentMode;
        CloudStacksCloud cloudStacksCloud;
        String vmInfo;
        String wslInfo;
        boolean hadoopEnabled;
        boolean hiveEnabled;
        boolean hiveUrlContainsSecret;
        public List<String> hiveExecutionConfigs = new ArrayList<String>();
        boolean impalaEnabled;
        boolean pigEnabled;
        boolean twitterEnabled;
        boolean rEnabled;
        boolean juliaEnabled;
        boolean hasGlobalProxy;
        boolean impersonationEnabled;
        boolean h2oEnabled;
        boolean graphicsExportsEnabled;
        AbstractSQLDatasetHandler.ReadTemporalMode defaultDateonlyReadMode;
        boolean dropDataWithDatasetDeleteEnabled;
        public boolean eventServerEnabled;
        boolean streamingEnabled;
        boolean showProjectsGraphView;
        boolean cdeEnabled;
        boolean cdePluginSupport;
        boolean dataTableLinksEnabled;
        boolean projectsModuleEnabled;
        boolean deployerClientEnabled;
        boolean deployerServerEnabled;
        String hadoopVersion;
        boolean ssoLoginEnabled;
        SSOSettings.SSOProtocol ssoProtocol;
        GeneralSettingsDAO.PostLogoutBehavior postLogoutBehavior;
        String postLogoutCustomURL;
        boolean loggedIn;
        String login;
        PublicUser user;
        boolean debug;
        boolean devInstance;
        LicenseStatusService.LicensingStatus licensing;
        UsageDataReporting.UsageDataReportingMode udrMode;
        UsageDataReporting.UsageDataReportingPrivacyMode udrPrivacyMode;
        boolean errorsReporting;
        boolean pingTracking;
        int pingTrackingInterval;
        GeneralSettingsDAO.GlobalVisibilitySettings projectVisibility;
        GeneralSettingsDAO.GlobalVisibilitySettings appVisibility;
        GeneralSettingsDAO.InheritableEnabledSetting objectSharingRequestsMode;
        boolean permissionsByEmailEnabled;
        String emailChannelId;
        GeneralSettingsDAO.WelcomeEmailSettings welcomeEmailSettings;
        boolean quickSharingElementsEnabled;
        boolean pluginInstallRequestsEnabled;
        boolean disableAutomaticTriggers;
        boolean achievementsEnabled;
        boolean patternsLearningEnabled;
        boolean npsSurveyEnabled;
        boolean npsSurveyActive;
        boolean onboardingPending;
        boolean atSurveyEnabled;
        ATSurveyService.ATSurveySettings atSurveyStatus;
        PageSpecificTourSettings pageSpecificTourSettings;
        boolean opalsEnabled;
        Boolean askDataikuEnabled;
        Boolean askDataikuTelemetryEnabled;
        boolean onboardingExperience;
        boolean codeEnvInstallRequestsEnabled;
        boolean hashedApiKeysEnabled;
        boolean admin;
        Boolean canAccessCloudDataikerAdminCapabilities;
        public boolean isCloudK8sInfraCreationEnabled;
        LicenseEnforcementService.TrialTokenStatus trialStatus;
        LimitsStatusComputer.LicensedProfile userProfile;
        Boolean allowNoneUsersToStartATrial;
        String userProfileForTrialsStartedByNoneUsers;
        boolean allowRequestAccessWithStartedTrial;
        String signUpMessage;
        boolean enableEmailAndDisplayNameModification;
        UsersDAO.GroupPermissions globalPermissions;
        public DKUApp.LicensingMode licensingMode;
        boolean saasAuth;
        String saasUserURL;
        boolean firstLoginAfterRegister;
        String saasManagerURL;
        SAASInstanceService.UserAccessSummary saasAccess;
        String xsrfCookieName;
        String nodeId;
        String studioForgotPasswordUrl;
        String studioAdminContactLabel;
        String studioAdminContact;
        String recoBannerHomeMessage;
        List<GeneralSettingsDAO.HelpCenterLabeledLink> recoBannerMustReads;
        String rstudioServerEmbedURL;
        DSSGitModel.GitMode gitMode;
        boolean communityEdition;
        boolean ceEntrepriseTrial;
        AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus licensedFeatures;
        Boolean trialsEnabled;
        GeneralSettingsDAO.NoneUsersCallToActionBehavior noneUsersCallToActionBehavior;
        String noneUsersCallToActionMessage;
        String upgradeProfileCallToActionMessage;
        boolean allowProfileUpgradeRequests;
        GeneralSettingsDAO.AlationCatalogSettings alationSettings;
        boolean offlineFrontend;
        boolean unattendedMode;
        GeneralSettingsDAO.MetastoreCatalogsSettings.MetastoreCatalogFlavor synchronizeToMetastoreCatalogFlavor;
        Map<GeneralSettingsDAO.LocalAIServerSettings.AiAssistant, Boolean> isUsingLocalAiAssitant = new HashMap<GeneralSettingsDAO.LocalAIServerSettings.AiAssistant, Boolean>();
        List<MinimalPluginDesc> loadedPlugins = new ArrayList<MinimalPluginDesc>();
        List<String> featureFlags = new ArrayList<String>();
        GeneralSettingsDAO.UICustomizationSettings uiCustomization;
        String customJS;
        String distrib;
        String distribVersion;
        boolean noLoginMode;
        Collection<LoadedCustomDataset<?>> customDatasets = new ArrayList();
        Collection<LoadedCustomCodeRecipeDesc> customCodeRecipes;
        Collection<LoadedPythonProbe> customPythonProbes;
        Collection<LoadedSQLProbe> customSQLProbes;
        Collection<LoadedPythonFormat> customPythonFormats;
        Collection<LoadedJavaFormat> customJavaFormats;
        Collection<LoadedExporter<?>> customExporters = new ArrayList();
        Collection<LoadedPythonCheck> customPythonChecks;
        Collection<LoadedPythonPluginStep> customPythonPluginSteps;
        Collection<LoadedPythonPluginTrigger> customPythonPluginTriggers;
        public Collection<LoadedRunnable<?>> customRunnables = new ArrayList();
        public Collection<LoadedFSProvider<?>> customFSProviders = new ArrayList();
        public Collection<LoadedJavaDialect> customDialects = new ArrayList<LoadedJavaDialect>();
        public Collection<LoadedJythonProcessor> customJythonProcessors = new ArrayList<LoadedJythonProcessor>();
        Collection<LoadedPythonPluginCluster> customPythonPluginClusters = new ArrayList<LoadedPythonPluginCluster>();
        Collection<LoadedPythonPluginCodeStudioTemplate> customPythonPluginCodeStudioTemplates = new ArrayList<LoadedPythonPluginCodeStudioTemplate>();
        Collection<LoadedPythonPluginCodeStudioBlock> customPythonPluginCodeStudioBlocks = new ArrayList<LoadedPythonPluginCodeStudioBlock>();
        Collection<LoadedPythonPluginProjectStandardsCheckSpec> customPythonPluginProjectStandardsCheckSpecs = new ArrayList<LoadedPythonPluginProjectStandardsCheckSpec>();
        Collection<LoadedParameterSet> customParameterSets = new ArrayList<LoadedParameterSet>();
        public Collection<LoadedExposition> customExpositions;
        public Collection<LoadedJavaLLM> customJavaLLMs;
        public Collection<LoadedPythonLLM> customPythonLLMs;
        public Collection<LoadedCustomWebApp> customWebApps;
        public Collection<LoadedCustomAgent> customAgents;
        public Collection<LoadedCustomAgentTool> customAgentTools;
        public Collection<LoadedSampleDataset> customSampleDatasets = new ArrayList<LoadedSampleDataset>();
        public Collection<LoadedCustomGuardrail> customGuardrails;
        Collection<LoadedAppRecipeDesc> appRecipes;
        Map<String, List<CustomFieldsService.PluginComponentCustomFields>> customFieldsMap = new HashMap<String, List<CustomFieldsService.PluginComponentCustomFields>>();
        List<PluginComponentRef> customFieldsPluginComponentRefs = new ArrayList<PluginComponentRef>();
        List<PluginComponentRef> customPolicyHooksPluginComponentRefs = new ArrayList<PluginComponentRef>();
        public boolean sparkEnabled;
        public AbstractSparkRecipeParams.SparkExecutionEngine interactiveSparkEngine;
        public List<String> sparkExecutionConfigs = new ArrayList<String>();
        public String sparkVersion;
        boolean anonRegistrationAllowed;
        String registrationChannel;
        boolean pluginDevExplicitCommit;
        DSSGitModel.PluginGitMode pluginDevGitMode;
        GeneralSettingsDAO.WebappsIsolationMode webappsIsolationMode;
        String webappsIsolationOrigin;
        MeaningsService.MeaningsList meanings;
        List<GeneralSettingsDAO.GlobalTagCategory> globalTagCategories;
        ThemesService.Theme theme;
        String dssExternalURL;
        String nodeName;
        List<GeneralSettingsDAO.ProjectStatus> projectStatusList;
        List<GeneralSettingsDAO.BrandColor> brandColors;
        public UserSettingsService.UserSettings userSettings;
        List<GeneralSettingsDAO.HomeMessage> homeMessages;
        int nbSimultaneousInsightLoading;
        public boolean areReportingToGraphiteSettingsDisplayed;
        public boolean areMetricsChartingServerSettingsDisplayed;
        GeneralSettingsDAO.DeployerMode deployerMode;
        String deployerURL;
        List<InfraStage> apiDeploymentStages;
        List<InfraStage> projectDeploymentStages;
        boolean allowMultiNodeProjectDeployerInfrastructures;
        boolean remoteDeployerMisconfigured;
        int globalMaxDeploymentHooksKernels;
        boolean governEnabled;
        String governURL;
        Boolean aiExplanationsEnabled;
        Boolean prepareAICompletionEnabled;
        Boolean aiGenerateSQLEnabled;
        Boolean storiesAIEnabled;
        Boolean storiesVocalEnabled;
        public GeneralSettingsDAO.WhiteLabelingSettings whiteLabeling;
        public boolean helpIntegrationEnabled;
        public boolean openTicketsFromOpalsEnabled;
        boolean nodesDirectoryManagedEventServerClient;
        boolean nodesDirectoryManagedDeployerServer;
        boolean nodesDirectoryManagedDeployerClient;
        boolean nodesDirectoryManagedDeployerClientRunning;
        boolean nodesDirectoryManagedGovernClient;
        boolean nodesDirectoryManagedGovernClientRunning;
        boolean autoAcceptSchemaChangeAtEndOfFlow;
        public List<String> k8sContainerConfigs = new ArrayList<String>();
        public List<String> wellKnownEditorCodeStudios = new ArrayList<String>();
        public String opalsUrl;
        public String opalsApiUrl;
        public List<GeneralSettingsDAO.HelpCenterLabeledLink> helpCenterSupportLinks = new ArrayList<GeneralSettingsDAO.HelpCenterLabeledLink>();
        boolean hideUserCenter;
        public boolean dataStoryIntegrationEnabled = false;
        public GeneralSettingsDAO.AlertBanner alertBanner;
        boolean disableImmediateFlush;
        ScatterSettings scatterSettings;
        boolean enablePopularDatasets;
        boolean requireProjectAdminPermissionToExportAndBundleProjects;
        public Map<String, String> translations;
        public Integer defaultRagasMaxWorkers;
        public DSSVisualizationTheme selectedDSSVisualizationTheme;
        public LLMSettings llmSettings;
        public GeneralSettingsDAO.DataikuCloudUISettings dataikuCloudUISettings;
        public GeneralSettingsDAO.NamingRulesSettings namingRulesSettings;
        public boolean autogeneratedDocumentationEnabled = true;
        public boolean enableVerboseLoggingNewSqlEditor;
        public boolean canSkipProjectStandardsChecks;
        public boolean isProjectStandardsConfigured;
        public int projectStandardsMaxExecutionTimeoutMinutes;

        @UIModel
        static class MinimalPluginDesc {
            String id;
            String label;
            String icon;
            String url;
            String description;
            String category;
            String recipesCategory;
            boolean hasDependencies;
            boolean hasCodeEnv;
            boolean isDev;
            boolean hasSettings;
            boolean hideComponents;
            List<String> customJSSnippets;
            JsonObject params;

            MinimalPluginDesc(InstalledPluginDesc ipd, boolean hideComponents) {
                this.id = ipd.desc.id;
                this.label = ipd.desc.meta.label;
                this.icon = ipd.desc.meta.icon;
                this.url = ipd.desc.meta.url;
                this.description = ipd.desc.meta.description;
                this.hasDependencies = ipd.requirementsSpec != null && ipd.requirementsSpec.python.size() + ipd.requirementsSpec.R.size() > 0;
                this.hasCodeEnv = ipd.codeEnvSpec != null;
                this.isDev = ipd.origin == InstalledPluginDesc.PluginOrigin.DEV;
                this.customJSSnippets = ipd.customJSSnippets;
                this.category = ipd.desc.meta.category;
                this.recipesCategory = ipd.desc.meta.recipesCategory;
                this.hasSettings = ipd.desc.params != null && ipd.desc.params.size() > 0;
                this.hideComponents = hideComponents;
            }
        }
    }

    private static class LLMSettings {
        boolean costLimitingEnabled = LLMCostLimitingService.isFeatureEnabled();
        List<GeneralSettingsDAO.LLMCostLimitingPeriodicity> costLimitingPeriodicities = GeneralSettingsDAO.LLMCostLimitingPeriodicity.listDisplayedPeriodicities();
        boolean rateLimitingEnabled = LLMRateLimitingRunnerService.isFeatureEnabled();
        GeneralSettingsDAO.TraceExplorerDefaultWebApp traceExplorerDefaultWebApp;

        LLMSettings(GeneralSettingsDAO.TraceExplorerDefaultWebApp traceExplorerDefaultWebApp) {
            this.traceExplorerDefaultWebApp = traceExplorerDefaultWebApp;
        }
    }
}

