/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.expr;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.text.StringMatchingMode;
import com.dataiku.dip.shaker.text.StringNormalizationMode;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class MatchCounter
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<MatchCounter, Parameter> META = new ProcessorMeta<MatchCounter, Parameter>(){

        @Override
        public String getName() {
            return "MatchCounter";
        }

        @Override
        public String getDocPage() {
            return "count-matches";
        }

        @Override
        public Category getCategory() {
            return Category.MISC;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.STRING, ProcessorTag.NLP});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.MatchCounter.HELP", "This processor counts the number of occurrences of a pattern in the specified column\n\n# Matching modes\n\n* 'Complete value' : counts complete cell values (output can only be 0 or 1)\n* 'Substring' : counts all occurrences of a string within the cell\n* 'Regular expression': counts matches of a regular expression\n\n# Normalization modes\n\n* Case-sensitive matches ('Exact' mode)\n* Case-insensitive matches ('Lowercase' mode)\n* Accents-insensitive matches ('Normalize' mode)\n\nNote: accent-insensitive matching is only available for 'complete value' matching.");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.MatchCounter.DESCRIPTION", 1.actionVerb("Count") + " occurrences")).withMNEColParam("inCol", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.INPUT_COLUMN", "Input column")).withParam("outCol", "string", true, false, this.translate(language, "SHAKER.PROCESSOR.MatchCounter.DESCRIPTION.OUT_COL", "Output column")).withParam("pattern", "string", true, false, this.translate(language, "SHAKER.PROCESSOR.MatchCounter.DESCRIPTION.PATTERN", "Pattern")).withParam(ParamDesc.advancedSelect("matchingMode", this.translate(language, "SHAKER.PROCESSOR.MatchCounter.DESCRIPTION.MATCH_MODE", "Match mode"), this.translate(language, "SHAKER.PROCESSOR.MatchCounter.DESCRIPTION.MATCH_MODE.TOOLTIP", "How to match the cell value"), StringMatchingMode.class, language).withDefaultValue(StringMatchingMode.FULL_STRING)).withParam(ParamDesc.advancedSelect("normalizationMode", this.translate(language, "SHAKER.PROCESSOR.MatchCounter.DESCRIPTION.NORMALIZATION_MODE", "Normalization mode"), this.translate(language, "SHAKER.PROCESSOR.MatchCounter.DESCRIPTION.NORMALIZATION_MODE.TOOLTIP", "How to transform the cell value before matching"), StringNormalizationMode.class, language).withDefaultValue(StringNormalizationMode.EXACT));
        }

        @Override
        public Object selfReport(Parameter parameter) {
            JsonObject obj = (JsonObject)JSON.parse((String)JSON.json((Object)parameter), JsonObject.class);
            obj.remove("inCol");
            obj.remove("outCol");
            obj.remove("pattern");
            return obj;
        }

        @Override
        public MatchCounter build(Parameter parameter) {
            return new MatchCounter(parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter counterParams = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                if (!Objects.equals(counterParams.inCol, counterParams.outCol)) {
                    updatedDatasetPairLineage.removeRelationsOnColumn(counterParams.outCol);
                }
                updatedDatasetPairLineage.addFactorizedColumnRelations(counterParams.inCol, counterParams.outCol);
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private Column inCD;
    private Column outCD;
    private Parameter param;
    private Pattern compiledPattern;
    private String normalizedPattern;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.shaker.expr.");

    public MatchCounter(Parameter param) {
        this.param = param;
        int flag = 0;
        if (param.normalizationMode == StringNormalizationMode.NORMALIZED && (param.matchingMode == StringMatchingMode.PATTERN || param.matchingMode == StringMatchingMode.SUBSTRING)) {
            throw ErrorContext.iaef((String)"Error: Normalization not available for %s", (Object)param.matchingMode.getLabel(), (Object[])new Object[0]);
        }
        this.normalizedPattern = param.normalizationMode.apply(param.pattern);
        if (param.normalizationMode == StringNormalizationMode.LOWERCASE) {
            flag = 66;
        }
        if (param.matchingMode == StringMatchingMode.PATTERN) {
            this.compiledPattern = Pattern.compile(this.normalizedPattern, flag);
        } else if (param.matchingMode == StringMatchingMode.SUBSTRING) {
            this.compiledPattern = Pattern.compile(Pattern.quote(this.normalizedPattern), flag);
        }
    }

    public void init() throws Exception {
        this.inCD = this.getColumnFactory().column(this.param.inCol, Processor.ProcessorRole.INPUT_COLUMN);
        this.outCD = this.getColumnFactory().columnAfter(this.param.inCol, this.param.outCol, Processor.ProcessorRole.OUTPUT_COLUMN);
    }

    public void processRow(Row row) throws Exception {
        String v = row.get(this.inCD);
        if (StringUtils.isBlank((String)v)) {
            row.put(this.outCD, 0);
        } else if (this.param.matchingMode == StringMatchingMode.FULL_STRING) {
            if (this.param.normalizationMode.apply(v).equals(this.normalizedPattern)) {
                row.put(this.outCD, 1);
            } else {
                row.put(this.outCD, 0);
            }
        } else {
            Matcher m = this.compiledPattern.matcher(v);
            int numMatches = 0;
            while (m.find()) {
                ++numMatches;
            }
            row.put(this.outCD, numMatches);
        }
    }

    public void postProcess() {
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = 1L;
        public String inCol;
        public String outCol;
        public StringNormalizationMode normalizationMode = StringNormalizationMode.EXACT;
        public StringMatchingMode matchingMode = StringMatchingMode.SUBSTRING;
        public String pattern;

        public void validate() throws IllegalArgumentException {
        }
    }
}

