/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.geo;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.geojoin.GeoUtils;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.text.Labelled;
import com.dataiku.dip.shaker.types.Latitude;
import com.dataiku.dip.shaker.types.Longitude;
import com.dataiku.dip.sql.PostgreSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoDistanceProcessor
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<GeoDistanceProcessor, Parameter> META = new ProcessorMeta<GeoDistanceProcessor, Parameter>(){

        @Override
        public String getName() {
            return "GeoDistanceProcessor";
        }

        @Override
        public String getDocPage() {
            return "geo-distance";
        }

        @Override
        public Category getCategory() {
            return Category.GEOGRAPHIC;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.GEOGRAPHIC});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.GeoDistanceProcessor.HELP", "This processor computes the distance between a geospatial column and another geospatial object.\n\nYou can compare a column with:\n\n* A specific geospatial object\n* Another geospatial column\n\nThe computation outputs a number of distance units (kilometers, miles) in another column.\nGeoJSON format is not supported with the SQL Engine when using PostgreSQL.");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.GeoDistanceProcessor.DESCRIPTION", 1.actionVerb("Compute") + " distance between geospatial objects"), false).withMNEColParam("input1", this.translate(language, "SHAKER.PROCESSOR.GeoDistanceProcessor.DESCRIPTION.INPUT1", "First geospatial column")).withColParam("input2", this.translate(language, "SHAKER.PROCESSOR.GeoDistanceProcessor.DESCRIPTION.INPUT2", "Second geospatial column")).withMNESParam("output", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.OUTPUT_COLUMN", "Output column")).withParam("refGeo", "string", false, true, "Second geospatial object").withParam(ParamDesc.advancedSelect("outputUnit", this.translate(language, "SHAKER.PROCESSOR.GeoDistanceProcessor.DESCRIPTION.DISTANCE_UNIT", "Distance unit"), "", DistanceUnit.class).withDefaultValue(DistanceUnit.KILOMETERS)).withParam(ParamDesc.advancedSelect("compareTo", this.translate(language, "SHAKER.PROCESSOR.GeoDistanceProcessor.DESCRIPTION.COMPARE_TO", "Compare to ..."), "", CompareTo.class, language).withDefaultValue(CompareTo.COLUMN));
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            if (dialect instanceof PostgreSQLDialect || dialect instanceof SnowflakeSQLDialect) {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            } else {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use the selected SQL engine, only PostgreSQL with PostGIS support enabled and Snowflake can be used");
            }
            return ret;
        }

        @Override
        public Object selfReport(Parameter parameter) {
            return JSON.deepCopyExcept((Object)parameter, (String[])new String[]{"input1", "input2", "output"});
        }

        @Override
        public GeoDistanceProcessor build(Parameter param) {
            return new GeoDistanceProcessor(param);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type:" + pss.params.getClass().getSimpleName());
            }
            Parameter processorParams = (Parameter)pss.params;
            if (StringUtils.isBlank((String)processorParams.input1)) {
                throw new IllegalConfigurationException("Missing first input column information for lineage on the geo distance processor.");
            }
            if (processorParams.compareTo == CompareTo.COLUMN && StringUtils.isBlank((String)processorParams.input2)) {
                throw new IllegalConfigurationException("Missing second input column information for lineage on the geo distance processor.");
            }
            if (processorParams.compareTo == CompareTo.GEOPOINT && (StringUtils.isBlank((String)processorParams.refLatitude) || StringUtils.isBlank((String)processorParams.refLongitude))) {
                throw new IllegalConfigurationException("Missing lat/lon information for lineage on the geo distance processor.");
            }
            if (processorParams.compareTo == CompareTo.GEOMETRY && StringUtils.isBlank((String)processorParams.refGeometry)) {
                throw new IllegalConfigurationException("Missing geometry information for lineage on the geo distance processor.");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                if (StringUtils.isNotBlank((String)processorParams.output)) {
                    if (!(Objects.equals(processorParams.input1, processorParams.output) || processorParams.compareTo == CompareTo.COLUMN && Objects.equals(processorParams.input2, processorParams.output))) {
                        updatedDatasetPairLineage.removeRelationsOnColumn(processorParams.output);
                    }
                    updatedDatasetPairLineage.addFactorizedColumnRelations(processorParams.input1, processorParams.output);
                    if (processorParams.compareTo == CompareTo.COLUMN) {
                        updatedDatasetPairLineage.addFactorizedColumnRelations(processorParams.input2, processorParams.output);
                    }
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    Parameter params;
    Column inCD1;
    Column inCD2;
    Column outCD;
    Geometry ref;
    private static final CoordinateReferenceSystem CRS = DefaultGeographicCRS.WGS84;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker");

    public GeoDistanceProcessor(Parameter params) {
        this.params = params;
    }

    public void init() throws Exception {
        this.inCD1 = this.getColumnFactory().column(this.params.input1, Processor.ProcessorRole.INPUT_COLUMN);
        if (this.params.compareTo == CompareTo.COLUMN && !StringUtils.isBlank((String)this.params.input2)) {
            this.inCD2 = this.getColumnFactory().column(this.params.input2, Processor.ProcessorRole.INPUT_COLUMN);
            this.outCD = this.getColumnFactory().columnAfter(this.params.input2, this.params.output, Processor.ProcessorRole.OUTPUT_COLUMN);
        } else if (this.params.compareTo == CompareTo.GEOPOINT && !StringUtils.isBlank((String)this.params.refLatitude) && !StringUtils.isBlank((String)this.params.refLongitude)) {
            double parsedLatitude = Latitude.convert((String)this.params.refLatitude);
            double parsedLongitude = Longitude.convert((String)this.params.refLongitude);
            if (!Double.isNaN(parsedLatitude) && !Double.isNaN(parsedLongitude)) {
                this.ref = GeoUtils.fromLngLat(parsedLongitude, parsedLatitude);
            }
            this.outCD = this.getColumnFactory().columnAfter(this.params.input1, this.params.output, Processor.ProcessorRole.OUTPUT_COLUMN);
        } else if (this.params.compareTo == CompareTo.GEOMETRY && !StringUtils.isBlank((String)this.params.refGeometry)) {
            this.ref = GeoUtils.convertSupportedFormatsToGeometry(this.params.refGeometry);
            this.outCD = this.getColumnFactory().columnAfter(this.params.input1, this.params.output, Processor.ProcessorRole.OUTPUT_COLUMN);
        } else {
            this.outCD = this.getColumnFactory().column(this.params.output, Processor.ProcessorRole.OUTPUT_COLUMN);
        }
    }

    public void processRow(Row row) throws Exception {
        String col1Value = row.get(this.inCD1);
        String col2Value = null;
        Geometry geom1 = null;
        Geometry geom2 = null;
        String error = null;
        if (this.inCD2 != null) {
            col2Value = row.get(this.inCD2);
        }
        if (col1Value != null) {
            try {
                geom1 = GeoUtils.convertSupportedFormatsToGeometry(col1Value);
            }
            catch (Exception e) {
                error = String.format("Failed to extract info from geometry '%s': %s", col1Value, e.getMessage());
            }
        }
        if (this.params.compareTo == CompareTo.COLUMN && col2Value != null) {
            try {
                geom2 = GeoUtils.convertSupportedFormatsToGeometry(col2Value);
            }
            catch (Exception e) {
                error = String.format("Failed to extract info from geometry '%s': %s", col2Value, e.getMessage());
            }
        } else if (this.ref != null) {
            geom2 = this.ref;
        }
        if (geom1 != null && geom2 != null) {
            GeodeticCalculator gc = new GeodeticCalculator(CRS);
            Coordinate[] closestPoints = DistanceOp.nearestPoints((Geometry)geom2, (Geometry)geom1);
            gc.setStartingPosition((Position)JTS.toDirectPosition((Coordinate)closestPoints[0], (CoordinateReferenceSystem)CRS));
            gc.setDestinationPosition((Position)JTS.toDirectPosition((Coordinate)closestPoints[1], (CoordinateReferenceSystem)CRS));
            double distance = gc.getOrthodromicDistance();
            distance /= 1000.0;
            if (this.params.outputUnit == DistanceUnit.MILES) {
                distance = DistanceUnit.kmToMiles(distance);
            }
            row.put(this.outCD, distance);
        }
        if (error != null) {
            this.warningsContext.addWarning(WarningsContext.WarningType.INPUT_DATA_BAD_GEO, error, logger);
        }
    }

    public void postProcess() throws Exception {
    }

    private static String translate(String lang, String id, String defaultValue) {
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        return ts.translateNoContext(lang, id, defaultValue, new Object[0]);
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String input1;
        public String input2;
        public String output;
        public DistanceUnit outputUnit;
        public CompareTo compareTo;
        public String refLatitude;
        public String refLongitude;
        public String refGeometry;

        public void validate() throws IllegalArgumentException {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CompareTo implements Labelled
    {
        COLUMN{

            @Override
            public String getLabel() {
                return this.getLabel("en");
            }

            @Override
            public String getLabel(String language) {
                return GeoDistanceProcessor.translate(language, "SHAKER.PROCESSOR.GeoDistanceProcessor.CompareTo.COLUMN", "Compare to column");
            }
        }
        ,
        GEOPOINT{

            @Override
            public String getLabel() {
                return this.getLabel("en");
            }

            @Override
            public String getLabel(String language) {
                return GeoDistanceProcessor.translate(language, "SHAKER.PROCESSOR.GeoDistanceProcessor.CompareTo.GEOPOINT", "Compare to specific geopoint");
            }
        }
        ,
        GEOMETRY{

            @Override
            public String getLabel() {
                return this.getLabel("en");
            }

            @Override
            public String getLabel(String language) {
                return GeoDistanceProcessor.translate(language, "SHAKER.PROCESSOR.GeoDistanceProcessor.CompareTo.GEOMETRY", "Compare to specific geometry");
            }
        };

    }

    public static enum DistanceUnit implements Labelled
    {
        KILOMETERS,
        MILES;

        public static final double KM_TO_MILES_RATIO = 0.621371;

        @Override
        public String getLabel() {
            String s = super.toString();
            return s.substring(0, 1) + s.substring(1).toLowerCase();
        }

        public static DistanceUnit getDistanceUnitByName(String name) {
            if (!StringUtils.isBlank((String)name)) {
                if (name.equals(KILOMETERS.toString())) {
                    return KILOMETERS;
                }
                if (name.equals(MILES.toString())) {
                    return MILES;
                }
            }
            return null;
        }

        public static double kmToMiles(double distance) {
            return distance * 0.621371;
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;

        private SQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            String input1 = this.parameter.input1;
            String input2 = this.parameter.input2;
            DistanceUnit outputUnit = this.parameter.outputUnit;
            String compareTo = null;
            if (!StringUtils.isBlank((String)this.parameter.output)) {
                if (this.parameter.compareTo == CompareTo.COLUMN) {
                    compareTo = input2;
                } else if (this.parameter.compareTo == CompareTo.GEOMETRY && !StringUtils.isBlank((String)this.parameter.refGeometry)) {
                    compareTo = this.parameter.refGeometry;
                } else if (this.parameter.compareTo == CompareTo.GEOPOINT && !StringUtils.isBlank((String)this.parameter.refLatitude) && !StringUtils.isBlank((String)this.parameter.refLongitude)) {
                    double parsedLatitude = Latitude.convert((String)this.parameter.refLatitude);
                    double parsedLongitude = Longitude.convert((String)this.parameter.refLongitude);
                    if (!Double.isNaN(parsedLatitude) && !Double.isNaN(parsedLongitude)) {
                        compareTo = GeoUtils.fromLngLat(parsedLongitude, parsedLatitude).toString();
                    }
                }
                boolean isRefFixed = this.parameter.compareTo != CompareTo.COLUMN;
                this.addColumnInChain(this.parameter.output, chain, input1, compareTo, outputUnit, isRefFixed);
            }
            return chain;
        }

        public SQLQueryWithSchema addColumnInChain(String outputColumn, SQLQueryWithSchema chain, String input1, String input2, DistanceUnit outputUnit, boolean isRefFixed) {
            chain.addColumn(new SchemaColumn(outputColumn, Type.DOUBLE));
            ExpressionBuilder eb = input2 == null ? new ExpressionBuilder.ExpressionBuilderFactory().cst(null) : (isRefFixed ? chain.col(input1).stDistance(input2) : chain.col(input1).stDistance(chain.col(input2)));
            eb = eb.div(1000.0);
            if (outputUnit.equals(DistanceUnit.MILES)) {
                eb = eb.time(0.621371);
            }
            chain.select(eb, outputColumn);
            chain.markColumnModified(outputColumn);
            return chain;
        }
    }
}

