/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.data.currency.CurrencyAmount;
import com.dataiku.dip.data.currency.CurrencyExtractionUtils;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.PrepareSnowflakeUDFUtils;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.SnowflakeUDFProcessorTranslator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CurrencySplitter {
    public static final ProcessorMeta<StreamImpl, Parameter> META = new ProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "CurrencySplitter";
        }

        @Override
        public String getDocPage() {
            return "currency-splitter";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MATH, ProcessorTag.SPLIT});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.CurrencySplitter.HELP", "This processor takes a column containing an amount of money with its currency symbol ($,\u00a3,...)and outputs two new columns: in the first one the amount (number), in the second one the currencycode (USD,GBP,...).\n\n");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.CurrencySplitter.DESCRIPTION", 1.actionVerb("Split") + " currencies in column"), "", false).withMNEColParam("inCol", this.translate(language, "SHAKER.PROCESSOR.CurrencySplitter.DESCRIPTION.IN_COL", "Column to be split")).withParam("outColCurrencyCode", "string", true, false, this.translate(language, "SHAKER.PROCESSOR.CurrencySplitter.DESCRIPTION.OUT_COL_CURRENCY_CODE", "Output column name for currency code")).withParam("outColAmount", "string", true, false, this.translate(language, "SHAKER.PROCESSOR.CurrencySplitter.DESCRIPTION.OUT_COL_AMOUNT", "Output column name for amounts of money")).withParam("pristineAmount", "boolean", true, false, this.translate(language, "SHAKER.PROCESSOR.CurrencySplitter.DESCRIPTION.PRISTINE_AMOUNT", "Leave the amount as is"));
        }

        @Override
        public Object selfReport(Parameter p) {
            return JSON.deepCopyExcept((Object)p, (String[])new String[]{"inCol", "outColAmount", "outColCurrencyCode"});
        }

        @Override
        public StreamImpl build(Parameter params) {
            return new StreamImpl(params);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return this.getCapabilities(sp, report, dialect, null);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect, AbstractSQLConnection conn) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            if (PrepareSnowflakeUDFUtils.canUseSnowflakeUDF(conn)) {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            }
            return ret;
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) throws IOException {
            return new SnowflakeUDFSQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter currencySplitterParams = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                if (StringUtils.isBlank((String)currencySplitterParams.inCol) || StringUtils.isBlank((String)currencySplitterParams.outColAmount) || StringUtils.isBlank((String)currencySplitterParams.outColCurrencyCode)) {
                    throw new IllegalConfigurationException("Missing columns information for lineage on the currency splitter processor.");
                }
                updatedDatasetPairLineage.addFactorizedColumnRelations(currencySplitterParams.inCol, currencySplitterParams.outColAmount);
                updatedDatasetPairLineage.addFactorizedColumnRelations(currencySplitterParams.inCol, currencySplitterParams.outColCurrencyCode);
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };

    private static class StreamImpl
    extends SingleRowProcessor
    implements Processor {
        private final Parameter param;
        private Column inCD;
        private Column outAmountCD;
        private Column outCurrencyCD;

        StreamImpl(Parameter parameter) {
            this.param = parameter;
        }

        public void init() throws Exception {
            this.inCD = this.getColumnFactory().column(this.param.inCol, Processor.ProcessorRole.INPUT_COLUMN);
            this.outAmountCD = this.getColumnFactory().columnAfter(this.inCD.getName(), this.param.outColAmount, Processor.ProcessorRole.OUTPUT_COLUMN);
            this.outCurrencyCD = this.getColumnFactory().columnAfter(this.inCD.getName(), this.param.outColCurrencyCode, Processor.ProcessorRole.OUTPUT_COLUMN);
        }

        public void processRow(Row row) throws Exception {
            String inString = row.get(this.inCD);
            CurrencyAmount currencyAmount = CurrencyExtractionUtils.extractCurrencyAmount((String)inString, (boolean)this.param.pristineAmount);
            if (currencyAmount != null) {
                row.put(this.outAmountCD, currencyAmount.amount);
                row.put(this.outCurrencyCD, currencyAmount.currency.name());
            }
        }

        public void postProcess() throws Exception {
        }
    }

    private static class SnowflakeUDFSQLTranslator
    implements SnowflakeUDFProcessorTranslator {
        private final Parameter parameter;
        private final String functionName;

        private SnowflakeUDFSQLTranslator(Parameter parameter) {
            this.parameter = parameter;
            this.functionName = "currencySplitter_" + SecretKeyGenerator.generate();
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> getUDFResources() throws IOException {
            List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> resources = SnowflakeUDFProcessorTranslator.createStandardResourceList();
            SnowflakeUDFProcessorTranslator.addStandardResources(resources, SnowflakeUDFProcessorTranslator.StandardResource.SHADELIB, SnowflakeUDFProcessorTranslator.StandardResource.COMMONS_LANG_JAR);
            return resources;
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef> getUDFs() {
            SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef def = new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef(this.functionName, "com.dataiku.dip.shaker.processors.transform.CurrencySplitterUDF.process", "data STRING, pristine BOOLEAN", "STRING, BOOLEAN", "ARRAY");
            def.importStandardResources(SnowflakeUDFProcessorTranslator.StandardResource.SHADELIB, SnowflakeUDFProcessorTranslator.StandardResource.COMMONS_LANG_JAR);
            return Lists.newArrayList((Object[])new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef[]{def});
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            SQLDialect d = chain.getDialect();
            ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            chain.select(ebf.expr(String.format("%s(%s, %s)", this.functionName, d.quoteIdentifier(this.parameter.inCol), this.parameter.pristineAmount)), "CURRENCYEXTRACT_RESULT");
            SQLQueryWithSchema outer = chain.makeSubquery();
            SchemaColumn inputSchemaColumn = outer.getCurrentColumn(this.parameter.inCol);
            outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("CURRENCYEXTRACT_RESULT[0]"), Type.STRING, this.parameter.outColAmount, false);
            outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr("CURRENCYEXTRACT_RESULT[1]"), Type.STRING, this.parameter.outColCurrencyCode, false);
            outer.deleteColumn("CURRENCYEXTRACT_RESULT");
            outer.deleteSelect("CURRENCYEXTRACT_RESULT");
            return outer;
        }
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String inCol;
        public String outColAmount;
        public String outColCurrencyCode;
        public boolean pristineAmount;

        public void validate() throws IllegalArgumentException {
        }
    }
}

