/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.OracleConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLCapability;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.metadata.DatabaseObjectKey;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OracleSQLDialect
extends GenericSQLDialect {
    private final String FORMAT_TZ = "'YYYY-MM-DD\"T\"HH24:MI:SS.FFTZR'";
    private final String FORMAT_NTZ = "'YYYY-MM-DD HH24:MI:SS.FF'";
    private int maxIdentifierLength = 30;
    private Boolean sqlDateAsDateonly = null;
    private static Logger logger = Logger.getLogger((String)"dku.sql.oracle");

    public OracleSQLDialect() {
        this(30, null);
    }

    public OracleSQLDialect(int maxIdentifierLength, Boolean sqlDateAsDateonly) {
        this.maxIdentifierLength = maxIdentifierLength;
        this.sqlDateAsDateonly = sqlDateAsDateonly;
    }

    public OracleSQLDialect(AuthCtx auth, Dataset ds) {
        String connectionName = ((AbstractSQLDatasetHandler.AbstractSQLConfig)ds.getParams()).connection;
        try {
            AbstractSQLConnection connection = ConnectionsDAO.get().getMandatoryConnectionAs(auth, connectionName, AbstractSQLConnection.class);
            this.maxIdentifierLength = ((OracleConnection)connection).params.maxIdentifierSize;
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get connection for building Oracle dialect, max identifier size defaulted to " + this.maxIdentifierLength));
        }
    }

    @Override
    protected boolean canWriteInfinityOrNaN() {
        return false;
    }

    @Override
    public boolean needSubQueryForConstantInWhereClause() {
        return true;
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case TINYINT: {
                return new DSSTypeSQLMapping(Type.TINYINT, 2, "integer", new Integer[0]);
            }
            case SMALLINT: {
                return new DSSTypeSQLMapping(Type.SMALLINT, 2, "integer", new Integer[0]);
            }
            case INT: 
            case BIGINT: {
                return new DSSTypeSQLMapping(Type.INT, 2, "integer", new Integer[0]);
            }
            case FLOAT: {
                return new DSSTypeSQLMapping(Type.FLOAT, 100, "binary_float", new Integer[]{2, 8, 6});
            }
            case DOUBLE: {
                return new DSSTypeSQLMapping(Type.DOUBLE, 101, "binary_double", new Integer[]{2, 8});
            }
            case STRING: {
                if (schemaColumn.getMaxLength() == -1 || schemaColumn.getMaxLength() > this.getDefaultVarcharLen()) {
                    return new DSSTypeSQLMapping(Type.STRING, 2011, "nclob", new Integer[]{2003, 1111, 1, -15, 12, -9, -1, -16, 2005, 2011});
                }
                return new DSSTypeSQLMapping(Type.STRING, -9, "nvarchar2(" + schemaColumn.getMaxLength() + ")", new Integer[]{2003, 1111, 1, -15, 12, -9, -1, -16, 2005, 2011, 91, 93, 92});
            }
            case BOOLEAN: {
                return new DSSTypeSQLMapping(Type.BOOLEAN, 2, "integer", new Integer[0]);
            }
            case DATE: {
                return new DSSTypeSQLMapping(Type.DATE, -102, "timestamp with local time zone", new Integer[]{-101});
            }
            case DATEONLY: {
                return new DSSTypeSQLMapping(Type.DATEONLY, 93, "date", new Integer[]{91});
            }
            case DATETIMENOTZ: {
                return new DSSTypeSQLMapping(Type.DATETIMENOTZ, 93, "timestamp", new Integer[]{91});
            }
            case GEOMETRY: 
            case GEOPOINT: 
            case MAP: 
            case ARRAY: 
            case OBJECT: {
                this.throwUnhandledColumnType(schemaColumn, dataset);
            }
        }
        throw new Error("unreachable");
    }

    public static AbstractSQLDatasetHandler.ReadTemporalMode adjustDateonlyReadMode(AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, SQLDialect dialect, Dataset dataset) {
        if (dialect instanceof OracleSQLDialect) {
            OracleSQLDialect oracleSQLDialect = (OracleSQLDialect)dialect;
            if (dataset != null && dataset.isManaged() && dataset.getTypeSystemVersion() == SerializedDataset.TypeSystemVersion.V1) {
                boolean useNewStyle = false;
                useNewStyle = oracleSQLDialect.sqlDateAsDateonly != null ? oracleSQLDialect.sqlDateAsDateonly : useNewStyle;
                useNewStyle = dataset.getDkuPropertiesAsParams().getBoolParam("sqlDate.as.dssDateonly", useNewStyle);
                return useNewStyle ? dateonlyReadMode : datetimenotzReadMode;
            }
        }
        return dateonlyReadMode;
    }

    @Override
    public SchemaColumn fromSQLType(String name, int sqlType, String sqlTypeName, int sqlPrecision, int sqlScale, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        if (sqlType == 3 || sqlType == 2) {
            if (sqlScale == 0 && sqlPrecision == 0) {
                return new SchemaColumn(name, Type.DOUBLE);
            }
            return new SchemaColumn(name, sqlScale == 0 ? Type.BIGINT : Type.DOUBLE);
        }
        if (sqlType == 93 && (sqlScale == 0 && sqlPrecision == 0 || "date".equalsIgnoreCase(sqlTypeName))) {
            if (dateonlyReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE) {
                return new SchemaColumn(name, Type.DATE).withTimestampNoTzAsDate(true);
            }
            if (dateonlyReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING) {
                return new SchemaColumn(name, Type.STRING);
            }
            return new SchemaColumn(name, Type.DATEONLY);
        }
        return super.fromSQLType(name, sqlType, sqlTypeName, sqlPrecision, sqlScale, datetimenotzReadMode, dateonlyReadMode);
    }

    @Override
    public void fill(PreparedStatement ps2, Type dssType, int colIdx, String dssStrVal) throws SQLException {
        switch (dssType) {
            case DATE: {
                long timestamp = this.typeDate.msSinceEpoch(dssStrVal);
                if (timestamp == Long.MAX_VALUE) {
                    throw new IllegalArgumentException("Invalid date: " + dssStrVal);
                }
                ps2.setTimestamp(colIdx, new Timestamp(timestamp));
                break;
            }
            default: {
                super.fill(ps2, dssType, colIdx, dssStrVal);
            }
        }
    }

    @Override
    public String getCreateTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages, boolean ifNotExist) {
        assert (!ifNotExist);
        return super.getCreateTableStatementSQL(connection, dataset, messages, ifNotExist);
    }

    @Override
    public String cleanupColumnName(String columnName) {
        return columnName;
    }

    @Override
    public String getValueAsDSSString(ResultSet rs2, int sqlType, int colIdx, SchemaColumn schemaColumn, boolean normalizeDoubles, boolean timestampNoTzAsDate, DateTimeZone assumedTz) throws SQLException {
        Type dssType = schemaColumn.getType();
        switch (sqlType) {
            case 100: 
            case 101: {
                return rs2.getString(colIdx);
            }
            case -102: 
            case -101: {
                Timestamp ts = rs2.getTimestamp(colIdx);
                if (ts == null) {
                    return null;
                }
                return DKUtils.isoFormatReadableByDateFormat((long)ts.getTime());
            }
            case 93: {
                if (dssType == Type.STRING && "date".equalsIgnoreCase(rs2.getMetaData().getColumnTypeName(colIdx))) {
                    return rs2.getString(colIdx);
                }
                return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
            }
            case 2005: 
            case 2011: {
                return rs2.getString(colIdx);
            }
            case -13: {
                return null;
            }
        }
        return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
    }

    @Override
    public void tryDeleteTable(SQLConnectionProvider.SQLConnectionWrapper conn, String catalog, String schema, String table) throws SQLException {
        try {
            SQLUtils.safeExec(conn, "DROP TABLE " + this.getQuotedTableFullName(catalog, schema, table));
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 942) {
                logger.info((Object)"Table did not exist");
                conn.rollback();
            }
            logger.error((Object)("Error dropping table " + this.getQuotedTableFullName(catalog, schema, table) + " : " + e.getMessage()));
            throw e;
        }
    }

    @Override
    public String createTemporaryTable(SQLUtils.SQLTable table, String columnListExpr) {
        return "CREATE GLOBAL TEMPORARY TABLE " + this.getQuotedTableFullName(table) + " (" + columnListExpr + ") ON COMMIT PRESERVE ROWS";
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        return new String[]{"CREATE GLOBAL TEMPORARY TABLE " + this.getQuotedTableFullName(table) + " ON COMMIT PRESERVE ROWS AS " + selectExpr};
    }

    @Override
    public boolean needsTruncateBeforeDropTemporaryTable() {
        return true;
    }

    @Override
    public boolean supportsIndexing() {
        return false;
    }

    @Override
    public SQLDialect.DefaultUnquotedCase getDefaultUnquotedCaseForTables() {
        return SQLDialect.DefaultUnquotedCase.UPPER;
    }

    @Override
    public int getDefaultVarcharLen() {
        return 2000;
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return 4000;
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        if ((query = query.trim()).toLowerCase().contains("rownum")) {
            return query;
        }
        if (query.toLowerCase().startsWith("select")) {
            if (query.endsWith(";")) {
                query = query.substring(0, query.length() - 1);
            }
            return "SELECT * FROM (\n" + query + "\n) WHERE rownum <= " + size;
        }
        return query;
    }

    @Override
    public SQLDialect.LimitMethod getLimitMethod() {
        return SQLDialect.LimitMethod.WRAP_QUERY;
    }

    @Override
    public String limitQueryUsingWhere(long size) {
        return "rownum <= " + size;
    }

    @Override
    public String captureGroup(int group) {
        return "\\" + group;
    }

    @Override
    public boolean supportsNonCapturingGroups() {
        return false;
    }

    @Override
    public boolean supportsLookAroundExpressions() {
        return false;
    }

    @Override
    public void failIfInvalidColumnIdentifier(String identifier) {
        super.failIfInvalidColumnIdentifier(identifier);
        if (identifier.length() > this.maxIdentifierLength) {
            throw new IllegalArgumentException("Oracle identifiers in this connection cannot have more than " + this.maxIdentifierLength + " characters");
        }
    }

    @Override
    public String quoteDateOnly(String str) {
        return this.dateOnly(this.quoteString(str));
    }

    private String dateOnly(String str) {
        if (this.alreadyCastedToTemporal(str)) {
            return "CAST(" + str + " AS DATE)";
        }
        return "TO_DATE(" + str + ", 'YYYY-MM-DD')";
    }

    @Override
    public String quoteDatetimeNoTz(String str) {
        return this.datetimeNoTz(this.quoteString(str));
    }

    private String datetimeNoTz(String str) {
        if (this.alreadyCastedToTemporal(str)) {
            return "CAST(" + str + " AS TIMESTAMP)";
        }
        return "TO_TIMESTAMP(" + str + ", 'YYYY-MM-DD HH24:MI:SS.FF')";
    }

    private String removeIdentifiers(String str) {
        String regex = "([\"]).*?\\1";
        return str.replaceAll(regex, "").replaceAll("\\s{2,}", " ").trim();
    }

    private boolean isCast(String str, String castType) {
        int index;
        int fromIndex;
        if (!str.startsWith("CAST")) {
            return false;
        }
        Splitter splitter = new Splitter(this.getSemicolonExclusionPortionFinders());
        str = splitter.stripCommentsAndStrings(str);
        str = this.removeIdentifiers(str);
        int startIndex = fromIndex = str.indexOf(40) + 1;
        while ((index = str.indexOf(" AS ", fromIndex)) > 0) {
            String before = str.substring(startIndex, index);
            if (StringUtils.countMatches((String)before, (String)"(") == StringUtils.countMatches((String)before, (String)")")) {
                return str.substring(index + 4).startsWith(castType);
            }
            fromIndex = index + 4;
        }
        return false;
    }

    public boolean alreadyCastedToTemporal(String str) {
        return str.startsWith("FROM_TZ") || str.startsWith("TO_TIMESTAMP_TZ") || str.startsWith("TO_DATE") || str.startsWith("TO_TIMESTAMP") || str.startsWith("SYS_EXTRACT_UTC") || this.isCast(str, "TIMESTAMP") || this.isCast(str, "DATE");
    }

    @Override
    public String quoteDate(String str) {
        if (this.alreadyCastedToTemporal(str)) {
            return "FROM_TZ(CAST(" + str + " AS TIMESTAMP ), 'UTC')";
        }
        if (str.contains("T")) {
            return "TO_TIMESTAMP_TZ('" + str + "', 'YYYY-MM-DD\"T\"HH24:MI:SS.FFTZR')";
        }
        return "FROM_TZ(TO_TIMESTAMP('" + str + "', 'YYYY-MM-DD HH24:MI:SS.FF'), 'UTC')";
    }

    private String date(String str) {
        if (str.startsWith("\"") || this.alreadyCastedToTemporal(str)) {
            return "FROM_TZ(CAST(" + str + " AS TIMESTAMP), 'UTC')";
        }
        return "(CASE WHEN " + str + " LIKE '%T%' THEN TO_TIMESTAMP_TZ(" + str + ", 'YYYY-MM-DD\"T\"HH24:MI:SS.FFTZR') ELSE FROM_TZ(TO_TIMESTAMP(" + str + ", 'YYYY-MM-DD HH24:MI:SS.FF'), 'UTC') END)";
    }

    public String castToDate(Type requestedType, String value) {
        boolean isRawLiteral = StringUtils.isNotEmpty((String)value) && Character.isDigit(value.charAt(0));
        switch (requestedType) {
            case DATE: {
                return isRawLiteral ? this.quoteDate(value) : this.date(value);
            }
            case DATETIMENOTZ: {
                return isRawLiteral ? this.quoteDatetimeNoTz(value) : this.datetimeNoTz(value);
            }
            case DATEONLY: {
                return isRawLiteral ? this.quoteDateOnly(value) : this.dateOnly(value);
            }
        }
        throw new IllegalArgumentException("castToDate call but not a date, type=" + String.valueOf(requestedType));
    }

    protected String modExpression(String op1Expr, String op2Expr) {
        return "MOD(" + op1Expr + "," + op2Expr + ")";
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "TO_TIMESTAMP_TZ(", ", 'YYYY-MM-DD HH24:MI:SS.FF TZR') AS TIMESTAMP WITH  TIME ZONE)"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_DATE, "TO_DATE(", ", 'YYYY-MM-DD')"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_TIMESTAMP, "TO_TIMESTAMP(", ", 'YYYY-MM-DD HH24:MI:SS.FF')"));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CAST_BOOL_TO_COLUMN, "CAST", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String ret = this.toSQLNoBrackets(args[0]);
                return String.format("CAST(CASE WHEN %s THEN 1 ELSE 0 END AS INTEGER)", ret);
            }
        });
        this.addOperator(this.hashingOperator(QueryUtils.OperatorType.MD5, "MD5"));
        this.addOperator(this.hashingOperator(QueryUtils.OperatorType.SHA256, "SHA256"));
        this.addOperator(this.hashingOperator(QueryUtils.OperatorType.SHA512, "SHA512"));
        this.addGenericFunction(QueryUtils.OperatorType.STDDEV_SAMP, "STDDEV_SAMP", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.MEDIAN, "MEDIAN", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.MOD, "%", QueryUtils.Arity.BINARY, 2){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String op1Expr = this.toSQLNoBrackets(args[0]);
                String op2Expr = this.toSQLNoBrackets(args[1]);
                return OracleSQLDialect.this.modExpression(op1Expr, op2Expr);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CONCAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String second;
                String first = this.toSQLNoBrackets(args[0]);
                if (args.length == 2) {
                    second = this.toSQLNoBrackets(args[1]);
                } else if (args.length > 2) {
                    second = this.apply(Arrays.copyOfRange(args, 1, args.length));
                } else {
                    throw new QueryUtils.SQLGenerationException("CONCAT requires at least two arguments");
                }
                return "CONCAT(" + first + ", " + second + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.AGG_CONCAT, "LISTAGG", QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                QueryAst.ConstExpr separatorExpr = (QueryAst.ConstExpr)args[1];
                String separator = (String)separatorExpr.value;
                if (separator == null) {
                    return "LISTAGG(CAST(" + column + " as VARCHAR2(4000)), '') WITHIN GROUP (ORDER BY 0)";
                }
                return "LISTAGG(CAST(" + column + " as VARCHAR2(4000)), " + this.toSQLNoBrackets(separatorExpr) + ") WITHIN GROUP (ORDER BY 0)";
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.NOT, null, QueryUtils.Arity.UNARY, GenericSQLDialect.SQLPriority.NOT.priority, false){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String arg1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.NOT.priority);
                return "NOT " + arg1;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.NE, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.OR.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                if (bIsConst && "".equals(((QueryAst.ConstExpr)args[1]).value)) {
                    return "(LENGTH(" + this.toSQLNoBrackets(args[0]) + ") > 0)";
                }
                if (aIsConst && "".equals(((QueryAst.ConstExpr)args[0]).value)) {
                    return "(LENGTH(" + this.toSQLNoBrackets(args[1]) + ") > 0)";
                }
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " != " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                String oneIsNull = null;
                if (!aIsConst && !bIsConst) {
                    oneIsNull = a2 + " IS NULL AND " + b2 + " IS NOT NULL OR " + a2 + " IS NOT NULL AND " + b2 + " IS NULL";
                } else if (!aIsConst) {
                    oneIsNull = a2 + " IS NULL";
                } else if (!bIsConst) {
                    oneIsNull = b2 + " IS NULL";
                }
                if (oneIsNull != null) {
                    ret = ret + " OR " + oneIsNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.GT, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " > " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.LT, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " < " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.GE, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " >= " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.LE, null, QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " <= " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.EQ, "=", QueryUtils.Arity.BINARY, GenericSQLDialect.SQLPriority.OR.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String baseComparison;
                boolean aIsConst = args[0] instanceof QueryAst.ConstExpr;
                boolean bIsConst = args[1] instanceof QueryAst.ConstExpr;
                if (bIsConst && "".equals(((QueryAst.ConstExpr)args[1]).value)) {
                    return "(LENGTH(" + this.toSQLNoBrackets(args[0]) + ") = 0)";
                }
                if (aIsConst && "".equals(((QueryAst.ConstExpr)args[0]).value)) {
                    return "(LENGTH(" + this.toSQLNoBrackets(args[1]) + ") = 0)";
                }
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], GenericSQLDialect.SQLPriority.ISNULL.priority);
                String ret = baseComparison = a1 + " = " + b1;
                String bothNotNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNotNull = a2 + " IS NOT NULL AND " + b2 + " IS NOT NULL";
                } else if (!aIsConst) {
                    bothNotNull = a2 + " IS NOT NULL";
                } else if (!bIsConst) {
                    bothNotNull = b2 + " IS NOT NULL";
                }
                if (bothNotNull != null) {
                    ret = ret + " AND " + bothNotNull;
                }
                String bothNull = null;
                if (!aIsConst && !bIsConst) {
                    bothNull = a2 + " IS NULL AND " + b2 + " IS NULL";
                }
                if (bothNull != null) {
                    ret = ret + " OR " + bothNull;
                }
                return ret;
            }
        });
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(QueryUtils.OperatorType.CONTAINS, true, true));
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(QueryUtils.OperatorType.STARTS_WITH, true, true));
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(QueryUtils.OperatorType.ENDS_WITH, true, true));
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.CAST, null, QueryUtils.Arity.NARY, GenericSQLDialect.SQLPriority.EQ.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                Type currentType = args[0].outputType.dssType;
                Type requestedType = this.getParamAs(args[1], Type.class);
                String x1 = this.toSQLNoBrackets(args[0]);
                if (requestedType == Type.BOOLEAN) {
                    if (currentType == Type.STRING) {
                        return "cast(case when (" + x1 + ") is null then null when regexp_like(" + x1 + ", '^" + OracleSQLDialect.this.booleanTrueValuesRegex + "$', 'i') then 1 else 0 end as integer)";
                    }
                    return "DECODE(CAST(" + x1 + " AS INTEGER),0, 0, NULL, NULL, 1)";
                }
                if (requestedType.isTemporal()) {
                    if (args[0] instanceof QueryAst.OperatorExpr && ((QueryAst.OperatorExpr)args[0]).op == QueryUtils.OperatorType.CAST) {
                        return x1;
                    }
                    return OracleSQLDialect.this.castToDate(requestedType, x1);
                }
                if (requestedType == Type.STRING && currentType != null && currentType.isNumeric()) {
                    return "TO_NCHAR(" + x1 + ")";
                }
                if (requestedType == Type.STRING) {
                    return "TO_NCHAR(" + x1 + ")";
                }
                if (currentType == null || currentType != requestedType) {
                    int maxLength = -1;
                    if (args.length > 2) {
                        maxLength = this.getParamAs(args[2], Integer.class);
                    }
                    return OracleSQLDialect.this.cast(x1, currentType, requestedType, maxLength);
                }
                return "(" + x1 + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATEDIFF, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                Object end = this.toSQLNoBrackets(args[0]);
                Object start = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class);
                if (args[0].outputType != null && args[0].outputType.dssType == Type.DATE) {
                    end = "SYS_EXTRACT_UTC(" + (String)end + ")";
                }
                if (args[1].outputType != null && args[1].outputType.dssType == Type.DATE) {
                    start = "SYS_EXTRACT_UTC(" + (String)start + ")";
                }
                String diff = "CAST(" + (String)end + " AS DATE) - CAST(" + (String)start + " AS DATE)";
                String endDayPart = "(CAST(" + (String)end + " AS DATE) - TRUNC(CAST(" + (String)end + " AS DATE)))";
                String startDayPart = "(CAST(" + (String)start + " AS DATE) - TRUNC(CAST(" + (String)start + " AS DATE)))";
                switch (unit) {
                    case "YEAR": {
                        return "TRUNC((MONTHS_BETWEEN(" + (String)end + ", " + (String)start + ") + SIGN(" + endDayPart + " - " + startDayPart + ") / 31)/12)";
                    }
                    case "MONTH": {
                        return "TRUNC(MONTHS_BETWEEN(" + (String)end + ", " + (String)start + ") + SIGN(" + endDayPart + " - " + startDayPart + ") / 31)";
                    }
                    case "WEEK": {
                        return "TRUNC((" + diff + ")/7)";
                    }
                    case "DAY": {
                        return "TRUNC(" + diff + ")";
                    }
                    case "HOUR": {
                        return "TRUNC((" + diff + ")*24.0000000001)";
                    }
                    case "MINUTE": {
                        return "TRUNC((" + diff + ")*24*60.000000001)";
                    }
                    case "SECOND": {
                        return "TRUNC((" + diff + ")*24*3600.0000000001)";
                    }
                }
                throw new QueryUtils.SQLGenerationException("Unknown datepart: '" + unit + "'");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                if (args.length > 2 && args[2] != null) {
                    return "(FROM_TZ(CAST( " + this.toSQLNoBrackets(args[0]) + " AS TIMESTAMP), 'UTC') AT TIME ZONE " + this.toSQLNoBrackets(args[1]) + ")";
                }
                if (args.length > 1 && args[1] != null) {
                    return "(SYS_EXTRACT_UTC(FROM_TZ(CAST(" + this.toSQLNoBrackets(args[0]) + " AS TIMESTAMP), " + this.toSQLNoBrackets(args[1]) + ")) AT TIME ZONE 'UTC')";
                }
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_APPROX_AGG, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "percentile_disc(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_CONT, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "percentile_cont(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ")";
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.ISTRUE, null, QueryUtils.Arity.UNARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String x = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String x2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                return x + " != 0 AND " + x2 + " IS NOT NULL";
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.ISFALSE, null, QueryUtils.Arity.UNARY, GenericSQLDialect.SQLPriority.AND.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String x = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.EQ.priority);
                String x2 = this.toSQLWithBracketsIfNeeded(args[0], GenericSQLDialect.SQLPriority.ISNULL.priority);
                return x + " = 0 AND " + x2 + " IS NOT NULL";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "STRING_TO_TIMESTAMPTZ", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String ret = this.toSQLNoBrackets(args[0]);
                return "CAST( TO_TIMESTAMP_TZ(" + ret + " || ' UTC', 'YYYY-MM-DD HH24:MI:SS.FF TZR') AS TIMESTAMP WITH TIME ZONE)";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEX_LIKE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String input = this.toSQLNoBrackets(args[0]);
                String regex = this.toSQLNoBrackets(args[1]);
                return "regexp_like(" + input + ", " + regex + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                Type requestedType;
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                if (args[0].outputType != null && args[0].outputType.dssType != Type.STRING) {
                    input = args[0].outputType.dssType != null && args[0].outputType.dssType.isNumeric() ? "TO_CHAR(" + (String)input + ")" : "TO_NCHAR(" + (String)input + ")";
                }
                if ((requestedType = this.getParamAs(args[1], Type.class)).isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    Locale locale = args.length > 3 ? this.getParamAs(args[3], Locale.class) : Locale.US;
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = OracleSQLDialect.this.toDateFormat(jodaFormat, true);
                    String nlsparam = "NLS_DATE_LANGUAGE=American";
                    if (StringUtils.equals((String)"fr_FR", (String)locale.toString()) || StringUtils.equals((String)"fr", (String)locale.toString())) {
                        nlsparam = "NLS_DATE_LANGUAGE=French";
                    }
                    if (requestedType == Type.DATEONLY) {
                        return "TO_DATE(" + (String)input + ",'" + sqlFormat + "', '" + nlsparam + "')";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        return "TO_TIMESTAMP(" + (String)input + ",'" + sqlFormat + "', '" + nlsparam + "')";
                    }
                    boolean expectsTz = false;
                    for (DKUDateUtils.FormatPatternPart part : DKUDateUtils.parsePattern((String)jodaFormat, (boolean)true)) {
                        if (part.type != DKUDateUtils.FormatPatternPartType.TIMEZONE) continue;
                        expectsTz = true;
                    }
                    if (expectsTz) {
                        return "(TO_TIMESTAMP_TZ(" + (String)input + ",'" + sqlFormat + "', '" + nlsparam + "') AT TIME ZONE '" + timezoneId + "')";
                    }
                    return "(TO_TIMESTAMP(" + (String)input + ",'" + sqlFormat + "', '" + nlsparam + "') AT TIME ZONE '" + timezoneId + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FORMAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    Locale locale = args.length > 3 ? this.getParamAs(args[3], Locale.class) : Locale.US;
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    Object sqlFormat = OracleSQLDialect.this.toDateFormat(jodaFormat, false);
                    boolean hasMonthOrDayName = false;
                    for (DKUDateUtils.FormatPatternPart part : DKUDateUtils.parsePattern((String)jodaFormat, (boolean)false)) {
                        if (part.numeric || part.type != DKUDateUtils.FormatPatternPartType.MONTH && part.type != DKUDateUtils.FormatPatternPartType.DAYOFWEEK) continue;
                        hasMonthOrDayName = true;
                    }
                    if (hasMonthOrDayName) {
                        sqlFormat = "FM" + (String)sqlFormat;
                    }
                    String nlsparam = "NLS_DATE_LANGUAGE=American";
                    if (StringUtils.equals((String)"fr_FR", (String)locale.toString()) || StringUtils.equals((String)"fr", (String)locale.toString())) {
                        nlsparam = "NLS_DATE_LANGUAGE=French";
                    }
                    if (requestedType.isTimestamp() && timezoneId != null && !StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        input = "CAST((" + (String)input + " AT TIME ZONE '" + timezoneId + "') AS TIMESTAMP)";
                    }
                    if (requestedType == Type.DATEONLY || requestedType == Type.DATETIMENOTZ) {
                        return "to_char(" + (String)input + ",'" + (String)sqlFormat + "', '" + nlsparam + "')";
                    }
                    return "to_char(" + (String)input + " at time zone 'UTC','" + (String)sqlFormat + "', '" + nlsparam + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ISNULLOREMPTY, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                ExpressionBuilder eb = ebf.or(ebf.op(QueryUtils.OperatorType.ISNULL, args[0]), ebf.op(QueryUtils.OperatorType.LENGTH, args[0]).nullUnsafeEq(ebf.cst(0)));
                return this.toSQLWithBrackets(eb.expr);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DEFAULT_IF_NULL_OR_EMPTY, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String input = this.toSQLNoBrackets(args[0]);
                String regex = this.toSQLNoBrackets(args[1]);
                return "nvl(" + input + ", " + regex + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.NULL_WHEN, QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 4;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                ExpressionBuilder col = ebf.expr(args[0]);
                ExpressionBuilder cond = ebf.expr(args[1]);
                Type outputType = this.getParamAs(args[2], Type.class);
                Integer outputMaxLength = this.getParamAs(args[3], Integer.class);
                return ebf.caseWhen(cond, ebf.op(QueryUtils.OperatorType.NULL, new Object[0]), col).cast(outputType, outputMaxLength).toSQL(this.dialect);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SWITCH_WHEN, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String parameterFormat;
                Object castParameter;
                this.validateMinNumberOfParameters(args, 3);
                int numberOfParameters = args.length;
                String expressionToMatch = this.toSQLNoBrackets(args[0]);
                if (expressionToMatch.equalsIgnoreCase("'true'")) {
                    castParameter = "1";
                    parameterFormat = "(CASE WHEN(%s) THEN 1 END) ";
                } else if (expressionToMatch.equalsIgnoreCase("'false'")) {
                    castParameter = "0";
                    parameterFormat = "(CASE WHEN(%s) THEN 1 END) ";
                } else {
                    castParameter = "TO_CHAR(" + expressionToMatch + ")";
                    parameterFormat = "TO_CHAR(%s)";
                }
                StringBuilder caseWhenThen = new StringBuilder();
                caseWhenThen.append("CASE ").append((String)castParameter);
                for (int parameterIndex = 1; parameterIndex < numberOfParameters - 1; parameterIndex += 2) {
                    caseWhenThen.append(" WHEN ").append(String.format(parameterFormat, this.toSQLNoBrackets(args[parameterIndex]))).append(" THEN ").append(this.toSQLNoBrackets(args[parameterIndex + 1]));
                }
                if (numberOfParameters % 2 == 0) {
                    caseWhenThen.append(" ELSE ").append(this.toSQLNoBrackets(args[numberOfParameters - 1]));
                }
                return caseWhenThen.append(" END").toString();
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.ATAN2, "ATAN2", QueryUtils.Arity.BINARY);
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.INDEX_OF, "(INSTR(", ", COALESCE(", ", TO_NCHAR(''))) - 1)", false));
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.LAST_INDEX_OF, "(INSTR(", ", COALESCE(", ", TO_NCHAR('')), -1) - 1)", false));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.DEC2HEX, "LTRIM(TO_CHAR(", ", 'xxxxxxxxxxxxxxxx'))"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.REVERSE_STR, "REVERSE(TO_CHAR(", "))"));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.COALESCE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String argsJoined = Lists.newArrayList((Object[])args).stream().map(a -> a instanceof QueryAst.ConstExpr && ((QueryAst.ConstExpr)a).value instanceof String ? "TO_NCHAR(" + OracleSQLDialect.this.quoteString((String)((QueryAst.ConstExpr)a).value) + ")" : this.toSQLNoBrackets((QueryAst.Expr)a)).collect(Collectors.joining(", "));
                return "COALESCE(" + argsJoined + ")";
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.CHAR, "CHR", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.RAND, "RAND", QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 0 || nArgs == 2;
            }

            @Override
            public String apply(QueryAst.Expr[] args) throws QueryUtils.SQLGenerationException {
                this.validateNumberOfParameters(args);
                if (args == null || args.length == 0) {
                    return "DBMS_RANDOM.VALUE";
                }
                if (args.length == 2) {
                    String min = "CAST(" + this.toSQLNoBrackets(args[0]) + " AS NUMBER(19))";
                    String max = "CAST(" + this.toSQLNoBrackets(args[1]) + " AS NUMBER(19))";
                    return String.format("CAST(FLOOR(DBMS_RANDOM.VALUE(%1$s, %2$s)) AS NUMBER(19))", min, max);
                }
                return super.apply(args);
            }
        });
    }

    @Override
    public String useUTCTimezone() {
        return "ALTER SESSION SET TIME_ZONE = '0:0'";
    }

    @Override
    public String datetimenotzPartExpression(String inputDateExpression, DatePart part) {
        inputDateExpression = "CAST(" + (String)inputDateExpression + " AS TIMESTAMP)";
        return this.temporalPartExpression((String)inputDateExpression, part, false);
    }

    @Override
    public String dateonlyPartExpression(String inputDateExpression, DatePart part) {
        return this.datetimenotzPartExpression(inputDateExpression, part);
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        inputDateExpression = "CAST(" + (String)inputDateExpression + " AS TIMESTAMP WITH TIME ZONE) AT TIME ZONE 'UTC'";
        return this.temporalPartExpression((String)inputDateExpression, part, true);
    }

    private String temporalPartExpression(String inputDateExpression, DatePart part, boolean hasTimezone) {
        Object epochStr = "timestamp '1970-01-01 00:00:00'";
        if (hasTimezone) {
            epochStr = "(" + (String)epochStr + " AT TIME ZONE 'UTC')";
        }
        switch (part) {
            case DAY_OF_MONTH: {
                return "EXTRACT(DAY FROM (" + inputDateExpression + ") )";
            }
            case HOUR_OF_DAY: {
                return "EXTRACT(HOUR FROM (" + inputDateExpression + ") )";
            }
            case MINUTE_OF_HOUR: {
                return "EXTRACT(MINUTE FROM (" + inputDateExpression + ") )";
            }
            case SECOND_OF_MINUTE: {
                return "EXTRACT(SECOND FROM (" + inputDateExpression + ") )";
            }
            case MILLISECOND_OF_SECOND: {
                return "FLOOR(MOD(EXTRACT(SECOND FROM (" + inputDateExpression + ") ) * 1000, 1000))";
            }
            case MONTH_OF_YEAR: {
                return "EXTRACT(MONTH FROM (" + inputDateExpression + ") )";
            }
            case WEEK_OF_YEAR: {
                return "TO_CHAR((" + inputDateExpression + ") , 'IW')";
            }
            case QUARTER_OF_YEAR: {
                return "(1 + ((EXTRACT(MONTH FROM (" + inputDateExpression + ") ) - 1) / 3))";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM (" + inputDateExpression + ") )";
            }
            case DAY_OF_WEEK: {
                return "(1 + TRUNC (" + inputDateExpression + " ) - TRUNC (" + inputDateExpression + ", 'IW'))";
            }
            case SECOND_FROM_EPOCH: {
                return "extract(day from (" + inputDateExpression + ") - " + (String)epochStr + ") * 86400 + extract(hour from (" + inputDateExpression + ") - " + (String)epochStr + ") * 3600 + extract(minute from (" + inputDateExpression + ") - " + (String)epochStr + ") * 60 + extract(second from (" + inputDateExpression + ") - " + (String)epochStr + ") ";
            }
            case MILLIS_FROM_EPOCH: {
                return "extract(day from (" + inputDateExpression + ") - " + (String)epochStr + ") * 86400000 + extract(hour from (" + inputDateExpression + ") - " + (String)epochStr + ") * 3600000 + extract(minute from (" + inputDateExpression + ") - " + (String)epochStr + ") * 60000 + extract(second from (" + inputDateExpression + ") - " + (String)epochStr + ") * 1000";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on Oracle", part));
    }

    @Override
    public String timeRange(String value, String unit) {
        switch (unit) {
            case "YEAR": {
                throw new QueryUtils.SQLGenerationException("Time interval not implemented with unit 'YEAR' for Oracle");
            }
            case "MONTH": {
                throw new QueryUtils.SQLGenerationException("Time interval not implemented with unit 'MONTH' for Oracle");
            }
            case "WEEK": {
                return value + "*7";
            }
            case "DAY": {
                return value;
            }
            case "HOUR": {
                return value + "/24";
            }
            case "MINUTE": {
                return value + "/24/60";
            }
            case "SECOND": {
                return value + "/24/3600";
            }
        }
        throw new QueryUtils.SQLGenerationException("Unknown datepart: '" + unit + "'");
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding, false);
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        String exp = "CAST(" + inputDateExpression + " AS TIMESTAMP)";
        String truncate = this.temporalTrunc(exp, rounding, true);
        return "CAST(" + truncate + " AS TIMESTAMP)";
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        String exp = "CAST(" + inputDateExpression + " AS TIMESTAMP WITH TIME ZONE) AT TIME ZONE 'UTC'";
        String truncate = this.temporalTrunc(exp, rounding, true);
        return "CAST(" + truncate + " AS TIMESTAMP) AT TIME ZONE 'UTC'";
    }

    private String temporalTrunc(String exp, DateRounding rounding, boolean canTime) {
        switch (rounding) {
            case DAY: {
                return "TRUNC(" + exp + ", 'DD')";
            }
            case WEEK: {
                return "TRUNC(" + exp + ", 'IW')";
            }
            case MONTH: {
                return "TRUNC(" + exp + ", 'MM')";
            }
            case YEAR: {
                return "TRUNC(" + exp + ", 'YYYY')";
            }
            case QUARTER: {
                return "TRUNC(" + exp + ", 'Q')";
            }
            case HOUR: {
                if (!canTime) {
                    throw new NotImplementedException("Rounding mode not implemented for Oracle date:" + String.valueOf(rounding));
                }
                return "TRUNC(" + exp + ", 'HH24')";
            }
            case MINUTE: {
                if (!canTime) {
                    throw new NotImplementedException("Rounding mode not implemented for Oracle date:" + String.valueOf(rounding));
                }
                return "TRUNC(" + exp + ", 'MI')";
            }
            case SECOND: {
                if (!canTime) {
                    throw new NotImplementedException("Rounding mode not implemented for Oracle date:" + String.valueOf(rounding));
                }
                return "CAST(" + exp + " AS DATE)";
            }
        }
        throw new NotImplementedException("Rounding mode not implemented for Oracle:" + String.valueOf(rounding));
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.MultiLineCommentFinder.META, QuotedPortionFinders.SingleQuotedNoEscapeFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META, QuotedPortionFinders.OracleQuotedStringLiteralFinder.META};
    }

    @Override
    public String getColumnExpressionForBoolean(String booleanExpression) {
        return "CASE WHEN " + booleanExpression + " THEN 1 ELSE 0 END";
    }

    public String makeCompliantIdentifier(String base, int hashLength) {
        return this.makeCompliantIdentifier(base, hashLength, "");
    }

    public String makeCompliantIdentifier(String base, int hashLength, String separator) {
        MessageDigest md;
        if (base.length() <= this.maxIdentifierLength) {
            return base;
        }
        try {
            md = MessageDigest.getInstance("MD5");
            md.update(base.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new Error("The imposible happened", e);
        }
        byte[] byteData = md.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < byteData.length && i < (hashLength + 1) / 2; ++i) {
            sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
        }
        return this.makeCompliantIdentifier(base, separator + sb.toString().substring(0, hashLength));
    }

    public String makeCompliantIdentifier(String base, String suffix) {
        if (suffix.length() > this.maxIdentifierLength) {
            throw new IllegalArgumentException("Suffix itself is too long");
        }
        if (base.length() + suffix.length() <= this.maxIdentifierLength) {
            return base + suffix;
        }
        return base.substring(0, this.maxIdentifierLength - suffix.length()) + suffix;
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return true;
    }

    @Override
    public int getIdentifiersMaxLength() {
        return this.maxIdentifierLength;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    public String emptyFromClause() {
        return "FROM DUAL";
    }

    @Override
    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities() {
        Map<SQLAggregateType, SQLAggregateAbility> abilities = super.getAggregationAbilities();
        abilities.put(SQLAggregateType.CONCAT, new SQLAggregateAbility(true, true, true, true));
        abilities.put(SQLAggregateType.FIRST_NOTNULL, new SQLAggregateAbility(true, true, true, true));
        abilities.put(SQLAggregateType.LAST_NOTNULL, new SQLAggregateAbility(true, true, true, true));
        abilities.put(SQLAggregateType.MEDIAN, new SQLAggregateAbility(false, false, true, false));
        return abilities;
    }

    @Override
    public String toDateFormatPart(DKUDateUtils.FormatPatternPart part, boolean forParsing, boolean hasIsoDatePart) {
        if (part.type == DKUDateUtils.FormatPatternPartType.TIMEZONE) {
            if (part.numeric) {
                return "TZH:TZM";
            }
            return "TZR";
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.TEXT) {
            Pattern toEscape = Pattern.compile("[a-zA-Z0-9\"()].*");
            if (toEscape.matcher(part.text).find()) {
                return "\"" + part.text.replace("\"", "\\\\\"") + "\"";
            }
            return part.text;
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.MILLISECOND) {
            return "FF";
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUR || part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUROFHALFDAY) {
            throw new IllegalArgumentException("Clock-hour is not supported by oracle");
        }
        if (forParsing && (part.type == DKUDateUtils.FormatPatternPartType.WEEK || part.type == DKUDateUtils.FormatPatternPartType.WEEKYEAR)) {
            throw new IllegalArgumentException("ISO week parsing not supported by oracle");
        }
        return super.toDateFormatPart(part, forParsing, hasIsoDatePart);
    }

    @Override
    public SQLCapability canFormatDatePart(DKUDateUtils.FormatPatternPart part, boolean forParsing) {
        if (forParsing && (part.type == DKUDateUtils.FormatPatternPartType.WEEK || part.type == DKUDateUtils.FormatPatternPartType.WEEKYEAR)) {
            return SQLCapability.nok("Oracle cannot parse week/year pairs");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUR || part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUROFHALFDAY) {
            return SQLCapability.nok("Oracle cannot format to clock hours");
        }
        return SQLCapability.ok();
    }

    @Override
    public String getId() {
        return "Oracle";
    }

    private QueryUtils.Function hashingOperator(QueryUtils.OperatorType operatorType, final String functionName) {
        return new QueryUtils.Function(this, operatorType, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String column = this.toSQLNoBrackets(args[0]);
                return "TO_NCHAR(LOWER(STANDARD_HASH(TO_CHAR(" + column + "), '" + functionName + "')))";
            }
        };
    }

    @Override
    public void fillWithEmpty(PreparedStatement ps2, Dataset dataset, Type dssType, int colIdx) throws SQLException {
        switch (dssType) {
            case FLOAT: {
                ps2.setNull(colIdx, 6);
                break;
            }
            case DOUBLE: {
                ps2.setNull(colIdx, 8);
                break;
            }
            case STRING: {
                ps2.setNull(colIdx, 12);
                break;
            }
            default: {
                super.fillWithEmpty(ps2, dataset, dssType, colIdx);
            }
        }
    }

    @Override
    public String getLeftoverPipelineViewsQuery(String schema) {
        return "SELECT owner, view_name FROM sys.all_views WHERE view_name LIKE 'DSSVIEW@_%' ESCAPE '@'" + this.getSchemaConditionForListingViews(schema, "owner", " AND owner != 'SYS'");
    }

    @Override
    public boolean canCastDSSFormatToTemporal() {
        return true;
    }

    @Override
    public boolean shouldForceFormatForDateOnlyComparison() {
        return true;
    }

    @Override
    public SQLDialect.UpsertWriter getUpsertWriter() {
        return new SQLUtils.MergeIntoUpsertWriter(this, false, true, true, false);
    }

    @Override
    public SQLDialect.UpdateSelectWriter getUpdateSelectWriter() {
        return new SQLUtils.MergeIntoBasedUpdateSelectWriter(this, false, true, true, false);
    }

    @Override
    public SQLDialect.MaterializedTemporaryTableWriter getMaterializedTemporaryTableWriter() {
        return new SQLUtils.RegularTableMaterializedTemporaryTableWriter(this, false){

            @Override
            protected String generateCTASTemp(String tempFullName, String targetFullName, String fieldsDef) {
                return String.format("CREATE TABLE %s AS SELECT * FROM %s WHERE rownum <= 0", tempFullName, targetFullName);
            }
        };
    }

    @Override
    public String generateTableCommentStatementQuery(DatabaseObjectKey tableKey, String description, InfoMessage.InfoMessages messages) {
        return "COMMENT ON TABLE " + this.getQuotedTableFullName(tableKey.catalog, tableKey.schema, tableKey.name) + " IS " + this.quoteDescriptionOrEmpty(this.truncateDescription(description, tableKey.name, true, messages));
    }

    @Override
    public String generateColumnCommentStatementQuery(DatabaseObjectKey tableKey, SchemaColumn column, InfoMessage.InfoMessages messages) {
        return "COMMENT ON COLUMN " + this.getQuotedColumnFullName(tableKey.catalog, tableKey.schema, tableKey.name, column.getName()) + " IS " + this.quoteDescriptionOrEmpty(this.truncateDescription(column.comment, column.getName(), false, messages));
    }

    @Override
    public boolean supportsWriteSQLComment() {
        return true;
    }

    @Override
    public boolean supportGroupByIndex() {
        return false;
    }

    @Override
    public int getMaxTableCommentLengthInChars() {
        return this.getDefaultVarcharLen();
    }

    @Override
    public int getMaxColumnCommentLengthInChars() {
        return this.getDefaultVarcharLen();
    }
}

