/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.BigQueryConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.JdbcConnection;
import com.dataiku.dip.connections.MySQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SQLServerConnection;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.connections.TreasureDataConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.SQLComputeResourceUsage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ShortTaskExecutor;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.RedshiftSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.util.ReflectionUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.BackOffStrategy;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelibgcp.com.google.api.client.util.BackOff;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;

public class SQLUtils {
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final String TABLE_SCHEM = "TABLE_SCHEM";
    public static final String TABLE_CAT = "TABLE_CAT";
    public static final String TABLE_CATALOG = "TABLE_CATALOG";
    public static final String TABLE_TYPE = "TABLE_TYPE";
    public static final String COLUMN_NAME = "COLUMN_NAME";
    public static final String TYPE_NAME = "TYPE_NAME";
    public static final String REMARKS = "REMARKS";
    private static final String DSS_VIEW_PREFIX = "DSSVIEW_";
    private static final int RANDOM_VIEW_SUFFIX_LENGTH = 5;
    private static final String TEMP_TABLE_PREFIX = "tmp_";
    private static final String FABRIC_WAREHOUSE_TRANSACT_RETRY_TIMEOUT_SEC_KEY = "dku.sql.utils.fabric.transactRetryTimeoutSec";
    private static final int FABRIC_WAREHOUSE_TRANSACT_DEFAULT_RETRY_TIMEOUT_SEC = 60;
    private static final int FABRIC_WAREHOUSE_TRANSACT_RETRY_TIMEOUT_SEC = DKUApp.getParams().getIntParam("dku.sql.utils.fabric.transactRetryTimeoutSec", Integer.valueOf(60));
    private static DKULogger logger = DKULogger.getLogger((String)"dku.dataset.sql");

    public static void unsafeRollbackAndClose(SQLConnectionProvider.SQLConnectionWrapper conn) {
        if (conn != null) {
            try {
                conn.rollbackAndClose();
            }
            catch (Exception e) {
                logger.warn((Object)("Could not safely close SQL connection " + String.valueOf(conn)), (Throwable)e);
            }
        }
    }

    public static String getQueryForPartition(String query, final Partition partition) {
        StrSubstitutor str = new StrSubstitutor(new StrLookup(){

            public String lookup(String s) {
                DimensionValue value = (DimensionValue)partition.getDimensionValues().get(s);
                if (value == null) {
                    throw ErrorContext.iaef((String)"Dataset not partitioned by dimension : %s", (Object)s, (Object[])new Object[0]);
                }
                return value.id();
            }
        });
        return str.replace(query);
    }

    public static SQLTable resolveAndExpandSQLCatalogAndSchema(SQLConnectionProvider.SQLConnectionData connData, String projectKey, String catalog, String schema) {
        if (connData.getConnection().getParams().useConnectionLevelCatalogAndSchemaForJDBCMetadataTableCheck && (StringUtils.isBlank((String)catalog) || StringUtils.isBlank((String)schema))) {
            catalog = SQLUtils.resolveCatalogFromConnectionDefault(connData, catalog);
            schema = SQLUtils.resolveSchemaFromConnectionDefault(connData, schema);
            if (!StringUtils.isBlank((String)catalog) || !StringUtils.isBlank((String)schema)) {
                VariablesService vs = (VariablesService)SpringUtils.getBean(VariablesService.class);
                VariablesContext vc = projectKey != null ? vs.getForProject(projectKey) : vs.getForGlobal();
                catalog = vc.expand(catalog);
                schema = vc.expand(schema);
                return new SQLTable(vc.expand(catalog), vc.expand(schema), null);
            }
            return new SQLTable(catalog, schema, null);
        }
        return new SQLTable(catalog, schema, null);
    }

    public static SQLTable getTableMetadata(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, String catalog, String schema, String table) throws Exception {
        List<SQLTable> tables;
        String catalogForListing = catalog;
        String schemaForListing = schema;
        String tableForListing = table;
        if (connData.getDialect() instanceof RedshiftSQLDialect) {
            catalogForListing = RedshiftSQLDialect.toLowerCase(catalogForListing);
            schemaForListing = RedshiftSQLDialect.toLowerCase(schemaForListing);
            tableForListing = RedshiftSQLDialect.toLowerCase(tableForListing);
        }
        if ((tables = SQLUtils.listTables(connData, conn, catalogForListing, schemaForListing, tableForListing, connData.getDialect())).size() > 1) {
            throw new Exception("Multiples tables were found when trying to get table");
        }
        if (tables.isEmpty()) {
            throw new Exception("No table found for the information provided");
        }
        return tables.get(0);
    }

    public static List<SQLTable> listTables(@Nullable SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, @Nullable String catalog, @Nullable String schema, SQLDialect dialect) throws SQLException, IOException, InterruptedException {
        return SQLUtils.listTables(connData, conn, catalog, schema, null, dialect);
    }

    public static List<SQLTable> listTables(@Nullable SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, @Nullable String catalog, @Nullable String schema, @Nullable String tableName, SQLDialect dialect) throws SQLException, IOException, InterruptedException {
        ConnectionUtils.SQLConnectionType connectionType;
        if (SQLUtils.connectionRequiresCatalogSelectionBeforeListingTables(connData) && StringUtils.isBlank((String)catalog)) {
            throw new IllegalArgumentException("Selecting a database/catalog is mandatory before listing tables");
        }
        if (SQLUtils.connectionRequiresSchemaSelectionBeforeListingTables(connData) && StringUtils.isBlank((String)schema)) {
            throw new IllegalArgumentException("Selecting a schema is mandatory before listing tables");
        }
        ConnectionUtils.SQLConnectionType sQLConnectionType = connectionType = connData != null ? connData.getType() : null;
        if (catalog == null) {
            catalog = connectionType == ConnectionUtils.SQLConnectionType.MYSQL ? ((MySQLConnection)connData.getConnection()).params.db : SQLUtils.getFilteringCatalogToListSchemas(connData);
        }
        String[] tableTypes = dialect.getTableTypes(connData, SQLDialect.GetTableTypesReason.LIST_FOR_EXPLORER).toArray(new String[0]);
        if (connectionType == ConnectionUtils.SQLConnectionType.SQLSERVER || connectionType == ConnectionUtils.SQLConnectionType.SYNAPSE || connectionType == ConnectionUtils.SQLConnectionType.FABRICWAREHOUSE) {
            return SQLUtils.listTablesForSQLServer(connData, conn, catalog, schema, tableName, tableTypes);
        }
        boolean listingIsCatalogAware = dialect.isCatalogAware();
        if (connectionType == ConnectionUtils.SQLConnectionType.JDBC) {
            JdbcConnection connection = (JdbcConnection)connData.getConnection();
            listingIsCatalogAware |= connection.params.supportsBrowsingCatalogs;
        }
        return SQLUtils.listTables(connData, conn, catalog, schema, tableName, tableTypes, listingIsCatalogAware);
    }

    private static List<SQLTable> listTablesForSQLServer(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, @Nullable String catalog, @Nullable String schema, @Nullable String tableName, String[] tableTypes) throws SQLException, InterruptedException, IOException {
        List<Object> tables = new ArrayList();
        if (SQLUtils.isSQLAzure(conn)) {
            BackOff backOff = BackOffStrategy.expBackOff((int)1000, (int)15000, (double)2.0, (int)(FABRIC_WAREHOUSE_TRANSACT_RETRY_TIMEOUT_SEC * 1000)).build();
            boolean done = false;
            while (!done) {
                try {
                    tables = SQLUtils.listTables(connData, conn, catalog, schema, tableName, tableTypes, connData.getType() == ConnectionUtils.SQLConnectionType.FABRICWAREHOUSE);
                    done = true;
                }
                catch (SQLException e) {
                    long millis = backOff.nextBackOffMillis();
                    if (e.getMessage().contains("Snapshot isolation transaction failed") && millis > 0L) {
                        logger.info((Object)"Failed attempt to list tables because of a transaction isolation issue.");
                        Thread.sleep(millis);
                        continue;
                    }
                    throw e;
                }
            }
        } else {
            tables = SQLUtils.listTablesForSQLServerOnPrem(connData, conn, catalog, schema, tableName, tableTypes);
        }
        return tables;
    }

    private static List<SQLTable> listTablesForSQLServerOnPrem(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, String catalog, String schema, String tableName, String[] tableTypes) throws SQLException {
        ArrayList<SQLTable> result = new ArrayList();
        try {
            String schemaPattern = conn.getDialect().escapeSchemaOrTableNameForJDBCMetadataQuerying(schema);
            String tableNamePattern = conn.getDialect().escapeSchemaOrTableNameForJDBCMetadataQuerying(tableName);
            for (String catalogName : catalog == null ? SQLUtils.getCatalogNames(conn.getMetaData()) : Collections.singleton(catalog)) {
                try {
                    ResultSet rs2 = conn.getMetaData().getTables(catalogName, schemaPattern, tableNamePattern, tableTypes);
                    try {
                        while (rs2.next()) {
                            SQLTable table = new SQLTable(catalogName, rs2.getString(TABLE_SCHEM), rs2.getString(TABLE_NAME), true);
                            table.type = SQLUtils.getStringSafe(rs2, TABLE_TYPE);
                            result.add(table);
                        }
                    }
                    finally {
                        if (rs2 == null) continue;
                        rs2.close();
                    }
                }
                catch (Exception e1) {
                    logger.warn((Object)("Unable to inspect catalog '" + catalogName + "', skipping."), (Throwable)e1);
                }
            }
        }
        catch (SQLException e) {
            logger.warn((Object)"Unable to iterate on all catalog. Fall-back to using a single call to getTables() with 'null' catalog.", (Throwable)e);
            result = SQLUtils.listTables(connData, conn, catalog, schema, tableName, tableTypes, false);
        }
        return result;
    }

    public static Map<SQLTable, String> getDatabricksCommentsOnTables(SQLConnectionProvider.SQLConnectionWrapper conn, String catalog, String schema, @Nullable String tableName) throws SQLException {
        boolean hasTableNamePattern;
        boolean hasSchema;
        HashMap<SQLTable, String> commentsByTable = new HashMap<SQLTable, String>();
        Statement statement = conn.createStatement();
        StringBuilder informationSchemaSQL = new StringBuilder("SELECT table_catalog, table_schema, table_name, comment FROM system.information_schema.tables");
        boolean hasCatalog = catalog != null && !catalog.isBlank() && !catalog.equals("%");
        ArrayList<CallSite> clauses = new ArrayList<CallSite>();
        if (hasCatalog) {
            clauses.add((CallSite)((Object)("table_catalog LIKE " + statement.enquoteLiteral(catalog))));
        }
        boolean bl = hasSchema = schema != null && !schema.isBlank() && !schema.equals("%");
        if (hasSchema) {
            clauses.add((CallSite)((Object)("table_schema LIKE " + statement.enquoteLiteral(schema))));
        }
        boolean bl2 = hasTableNamePattern = tableName != null && !tableName.isBlank() && !tableName.equals("%");
        if (hasTableNamePattern) {
            clauses.add((CallSite)((Object)("table_name LIKE " + statement.enquoteLiteral(tableName))));
        }
        if (!clauses.isEmpty()) {
            informationSchemaSQL.append(" WHERE ").append(String.join((CharSequence)" AND ", clauses));
        }
        try (ResultSet rs2 = statement.executeQuery(informationSchemaSQL.toString());){
            while (rs2.next()) {
                SQLTable table = new SQLTable(rs2.getString("table_catalog"), rs2.getString("table_schema"), rs2.getString("table_name"), rs2.getString("comment"));
                commentsByTable.put(table, table.remarks);
            }
        }
        return commentsByTable;
    }

    public static Boolean getRemarksReportingForOracle(SQLConnectionProvider.SQLConnectionWrapper conn) {
        if (conn.getConnectionData().getType() != ConnectionUtils.SQLConnectionType.ORACLE) {
            return null;
        }
        try {
            Connection connectionUnsafe = conn.getConnectionUnsafe(true);
            return ReflectionUtils.invokeMethod(Boolean.TYPE, connectionUnsafe, "getRemarksReporting", new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            logger.debug((Object)("An error occurred while trying to get the remarks reporting for oracle connection" + String.valueOf(e)));
            return null;
        }
    }

    public static void setRemarksReportingForOracle(SQLConnectionProvider.SQLConnectionWrapper conn, boolean remarksReporting) {
        if (conn.getConnectionData().getType() != ConnectionUtils.SQLConnectionType.ORACLE) {
            return;
        }
        try {
            Connection connectionUnsafe = conn.getConnectionUnsafe(true);
            ReflectionUtils.invokeMethod((Object)connectionUnsafe, "setRemarksReporting", remarksReporting);
        }
        catch (ReflectiveOperationException e) {
            logger.debug((Object)("An error occurred while trying to change remarks reporting for oracle connection" + String.valueOf(e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<SQLTable> listTables(@Nullable SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, @Nullable String catalog, @Nullable String schema, @Nullable String table, String[] tableTypes, boolean catalogAware) throws SQLException {
        ArrayList<SQLTable> result = new ArrayList<SQLTable>();
        logger.infoV("About to list tables conn=%s origCatalog=%s origSchema=%s origTable=%s tableTypes=%s", new Object[]{conn.getDebugId(), catalog, schema, table, JSON.json((Object)tableTypes)});
        String schemaPattern = conn.getDialect().escapeSchemaOrTableNameForJDBCMetadataQuerying(schema);
        String tableNamePattern = conn.getDialect().escapeSchemaOrTableNameForJDBCMetadataQuerying(table);
        logger.infoV("Starting to list tables conn=%s catalog=%s schemaPattern=%s tablePattern=%s tableTypes=%s", new Object[]{conn.getDebugId(), catalog, schemaPattern, tableNamePattern, JSON.json((Object)tableTypes)});
        boolean commentsFetchEnabled = SQLUtils.getDKUPropertiesAsParams(connData).getBoolParam("dku.connection.sql.commentsFetchEnabled", true);
        Map<Object, Object> commentsByTable = new HashMap();
        if (commentsFetchEnabled && conn.getConnectionData().getType() == ConnectionUtils.SQLConnectionType.DATABRICKS) {
            try {
                commentsByTable = SQLUtils.getDatabricksCommentsOnTables(conn, catalog, schemaPattern, tableNamePattern);
            }
            catch (SQLException e) {
                logger.warn((Object)"Could not fetch table comments", (Throwable)e);
            }
        }
        Boolean oracleRemarksReportingEnabled = SQLUtils.getRemarksReportingForOracle(conn);
        if (commentsFetchEnabled && oracleRemarksReportingEnabled != null && !oracleRemarksReportingEnabled.booleanValue()) {
            SQLUtils.setRemarksReportingForOracle(conn, true);
        }
        try (ResultSet rs2 = conn.getMetaData().getTables(catalog, schemaPattern, tableNamePattern, tableTypes);){
            logger.debug((Object)"Got table listing ResultSet");
            while (rs2.next()) {
                String tableCatalog = catalogAware ? SQLUtils.getStringSafe(rs2, TABLE_CAT) : null;
                String tableSchema = rs2.getString(TABLE_SCHEM);
                String tableName = rs2.getString(TABLE_NAME);
                String description = rs2.getString(REMARKS);
                if (commentsFetchEnabled && conn.getConnectionData().getType() == ConnectionUtils.SQLConnectionType.DATABRICKS) {
                    description = (String)commentsByTable.get(new SQLTable(tableCatalog, tableSchema, tableName));
                }
                SQLTable sqlTable = new SQLTable(tableCatalog, tableSchema, tableName, description, true);
                sqlTable = conn.getConnectionData().getDialect().postProcessTableFoundThroughJDBCMetadataSearch(sqlTable);
                sqlTable.type = SQLUtils.getStringSafe(rs2, TABLE_TYPE);
                result.add(sqlTable);
            }
            logger.debugV("Done enumerating listing, found %d tables", new Object[]{result.size()});
        }
        finally {
            if (commentsFetchEnabled && oracleRemarksReportingEnabled != null && !oracleRemarksReportingEnabled.booleanValue()) {
                SQLUtils.setRemarksReportingForOracle(conn, false);
            }
        }
        return result;
    }

    public static String getFilteringCatalogToListSchemas(SQLConnectionProvider.SQLConnectionData connData) {
        if (connData != null && connData.getType() == ConnectionUtils.SQLConnectionType.TREASUREDATA) {
            TreasureDataConnection.Params params = (TreasureDataConnection.Params)connData.getConnection().getParams();
            String catalog = params.region == null || params.region == TreasureDataConnection.TreasureDataRegion.CUSTOM ? params.db : "td-presto";
            return StringUtils.isNotBlank((String)catalog) ? catalog : null;
        }
        return null;
    }

    @Nullable
    private static List<String> getForcedCatalogsList(SQLConnectionProvider.SQLConnectionData connData) {
        Params p = SQLUtils.getDKUPropertiesAsParams(connData);
        String forcedHierarchicalList = p.getParam("dku.connection.sql.forcedCatalogsAndSchemasList");
        if (StringUtils.isNotBlank((String)forcedHierarchicalList)) {
            try {
                logger.info((Object)"Using forced catalog and schema list.");
                ForcedCatalogsAndSchemasList fcl = (ForcedCatalogsAndSchemasList)JSON.parse((String)forcedHierarchicalList, ForcedCatalogsAndSchemasList.class);
                return fcl.stream().map(fc -> fc.catalog).distinct().collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Forced catalogs and schemas list is not valid JSON (" + forcedHierarchicalList + ")", e);
            }
        }
        String forcedCatalogsList = p.getParam("dku.connection.sql.forcedCatalogsList");
        if (StringUtils.isNotBlank((String)forcedCatalogsList)) {
            try {
                logger.info((Object)"Using forced catalog list.");
                return (List)JSON.parse((String)forcedCatalogsList, JSON.StringList.class);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Forced catalogs list is not valid JSON (" + forcedCatalogsList + ")", e);
            }
        }
        return null;
    }

    @Nullable
    private static List<SQLSchema> getForcedCatalogsAndSchemasList(SQLConnectionProvider.SQLConnectionData connData) {
        Params p = SQLUtils.getDKUPropertiesAsParams(connData);
        String forcedHierarchicalList = p.getParam("dku.connection.sql.forcedCatalogsAndSchemasList");
        if (StringUtils.isNotBlank((String)forcedHierarchicalList)) {
            try {
                logger.info((Object)"Using forced catalog and schema list.");
                ForcedCatalogsAndSchemasList fcl = (ForcedCatalogsAndSchemasList)JSON.parse((String)forcedHierarchicalList, ForcedCatalogsAndSchemasList.class);
                return fcl.stream().flatMap(fc -> fc.schemas.stream().map(s -> new SQLSchema(fc.catalog, (String)s))).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Forced catalogs and schemas list is not valid JSON (" + forcedHierarchicalList + ")", e);
            }
        }
        return null;
    }

    @Nullable
    private static List<String> getForcedSchemasList(SQLConnectionProvider.SQLConnectionData connData) {
        Params p = SQLUtils.getDKUPropertiesAsParams(connData);
        String forcedSchemasList = p.getParam("dku.connection.sql.forcedSchemasList");
        if (StringUtils.isNotBlank((String)forcedSchemasList)) {
            try {
                logger.info((Object)"Using forced schema list.");
                return (List)JSON.parse((String)forcedSchemasList, JSON.StringList.class);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Forced schemas list is not valid JSON (" + forcedSchemasList + ")", e);
            }
        }
        return null;
    }

    private static boolean connectionRequiresCatalogSelectionBeforeListingTables(@Nullable SQLConnectionProvider.SQLConnectionData connData) {
        return SQLUtils.getDKUPropertiesAsParams(connData).getBoolParam("dku.connection.sql.requiresCatalogSelectionBeforeListingTables", false);
    }

    private static boolean connectionRequiresSchemaSelectionBeforeListingTables(@Nullable SQLConnectionProvider.SQLConnectionData connData) {
        return SQLUtils.getDKUPropertiesAsParams(connData).getBoolParam("dku.connection.sql.requiresSchemaSelectionBeforeListingTables", false);
    }

    @Nonnull
    public static List<String> listCatalogs(SQLConnectionProvider.SQLConnectionData connData, AuthCtx authCtx, String projectKey) throws SQLException, DKUSecurityException, InterruptedException {
        logger.debug((Object)("Listing catalogs on " + connData.getConnection().name));
        List<String> forcedCatalogsList = SQLUtils.getForcedCatalogsList(connData);
        if (forcedCatalogsList != null) {
            return forcedCatalogsList;
        }
        try (SQLConnectionProvider.SQLConnectionWrapper sqlConn = SQLConnectionProvider.newConnection(connData, authCtx, projectKey);){
            List<String> list = SQLUtils.getCatalogNames(sqlConn.getMetaData());
            return list;
        }
    }

    public static List<String> listSchemasCatalogUnaware(SQLConnectionProvider.SQLConnectionData connData, AuthCtx authCtx, String projectKey) throws SQLException, DKUSecurityException, InterruptedException {
        logger.debug((Object)("Listing schemas on " + connData.getConnection().name));
        List<String> forcedSchemasList = SQLUtils.getForcedSchemasList(connData);
        if (forcedSchemasList != null) {
            return forcedSchemasList;
        }
        try (SQLConnectionProvider.SQLConnectionWrapper sqlConn = SQLConnectionProvider.newConnection(connData, authCtx, projectKey);){
            List<String> list = SQLUtils.listSchemasCatalogUnaware(sqlConn);
            return list;
        }
    }

    public static List<String> listSchemasCatalogUnaware(SQLConnectionProvider.SQLConnectionWrapper sqlConn) throws SQLException {
        ArrayList<String> schemas = new ArrayList<String>();
        ResultSet rs2 = sqlConn.getMetaData().getSchemas();
        String filteringCatalog = SQLUtils.getFilteringCatalogToListSchemas(sqlConn.getConnectionData());
        while (rs2.next()) {
            if (filteringCatalog != null && !filteringCatalog.equals(SQLUtils.getStringSafe(rs2, TABLE_CATALOG))) continue;
            schemas.add(rs2.getString(TABLE_SCHEM));
        }
        return schemas;
    }

    /*
     * Loose catch block
     */
    public static List<String> listSchemasForCatalog(SQLConnectionProvider.SQLConnectionData connData, AuthCtx authCtx, String projectKey, @Nullable String catalog) throws SQLException, DKUSecurityException, InterruptedException {
        if (catalog == null) {
            forcedSchemasFromHierarchical = SQLUtils.getForcedCatalogsAndSchemasList(connData);
            if (forcedSchemasFromHierarchical != null) {
                return forcedSchemasFromHierarchical.stream().map(SQLSchema::getSchema).distinct().collect(Collectors.toList());
            }
            List<String> forcedSchemas = SQLUtils.getForcedSchemasList(connData);
            if (forcedSchemas != null) {
                return forcedSchemas;
            }
        } else {
            forcedSchemasFromHierarchical = SQLUtils.getForcedCatalogsAndSchemasList(connData);
            if (forcedSchemasFromHierarchical != null) {
                return forcedSchemasFromHierarchical.stream().filter(s -> catalog.equals(s.catalog)).map(SQLSchema::getSchema).collect(Collectors.toList());
            }
        }
        try (SQLConnectionProvider.SQLConnectionWrapper sqlConn = SQLConnectionProvider.newConnection(connData, authCtx, projectKey);){
            ConnectionUtils.SQLConnectionType connectionType = connData.getType();
            if (catalog == null && (connectionType == ConnectionUtils.SQLConnectionType.SQLSERVER || connectionType == ConnectionUtils.SQLConnectionType.SYNAPSE || connectionType == ConnectionUtils.SQLConnectionType.FABRICWAREHOUSE)) {
                try {
                    List<SQLSchema> sqlSchemaList = SQLUtils.listSchemasWithCatalogsForSQLServer(sqlConn);
                    List<String> list = sqlSchemaList.stream().map(SQLSchema::getSchema).collect(Collectors.toList());
                    return list;
                }
                catch (SQLException e) {
                    List<String> list;
                    block16: {
                        logger.warn((Object)"Unable to iterate on all catalog. Fall-back to using a single call to listSchemasWithCatalogs().", (Throwable)e);
                        list = SQLUtils.listSchemasForCatalogInternal(sqlConn, catalog);
                        if (sqlConn == null) break block16;
                        sqlConn.close();
                    }
                    return list;
                }
            }
            List<String> list = SQLUtils.listSchemasForCatalogInternal(sqlConn, catalog);
            return list;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    private static List<String> listSchemasForCatalogInternal(SQLConnectionProvider.SQLConnectionWrapper sqlConn, String catalog) throws SQLException {
        ArrayList<String> schemas = new ArrayList<String>();
        if (catalog == null) {
            catalog = SQLUtils.getFilteringCatalogToListSchemas(sqlConn.getConnectionData());
        }
        ResultSet rs2 = sqlConn.getMetaData().getSchemas(catalog, null);
        while (rs2.next()) {
            schemas.add(rs2.getString(TABLE_SCHEM));
        }
        return schemas;
    }

    /*
     * Loose catch block
     */
    public static List<SQLSchema> listSchemasWithCatalogs(SQLConnectionProvider.SQLConnectionData connData, AuthCtx authCtx, String projectKey) throws SQLException, DKUSecurityException, InterruptedException {
        List<SQLSchema> forcedResponse = SQLUtils.getForcedCatalogsAndSchemasList(connData);
        if (forcedResponse != null) {
            return forcedResponse;
        }
        List<String> forcedCatalogs = SQLUtils.getForcedCatalogsList(connData);
        if (forcedCatalogs != null) {
            ArrayList<SQLSchema> schemasResponse = new ArrayList<SQLSchema>();
            try (SQLConnectionProvider.SQLConnectionWrapper sqlConn2 = SQLConnectionProvider.newConnection(connData, authCtx, projectKey);){
                for (String catalog : forcedCatalogs) {
                    List<String> schemas = SQLUtils.listSchemasForCatalogInternal(sqlConn2, catalog);
                    schemas.stream().forEach(s -> schemasResponse.add(new SQLSchema(catalog, (String)s)));
                }
            }
            return schemasResponse;
        }
        try (SQLConnectionProvider.SQLConnectionWrapper sqlConn = SQLConnectionProvider.newConnection(connData, authCtx, projectKey);){
            if (connData.getType() == ConnectionUtils.SQLConnectionType.SQLSERVER || connData.getType() == ConnectionUtils.SQLConnectionType.SYNAPSE || connData.getType() == ConnectionUtils.SQLConnectionType.FABRICWAREHOUSE) {
                try {
                    List<SQLSchema> sqlConn2 = SQLUtils.listSchemasWithCatalogsForSQLServer(sqlConn);
                    return sqlConn2;
                }
                catch (SQLException e) {
                    List<SQLSchema> list;
                    block21: {
                        logger.warn((Object)"Unable to iterate on all catalog. Fall-back to using a single call to listSchemasWithCatalogs().", (Throwable)e);
                        list = SQLUtils.listSchemasWithCatalogsInternal(sqlConn);
                        if (sqlConn == null) break block21;
                        sqlConn.close();
                    }
                    return list;
                }
            }
            List<SQLSchema> list = SQLUtils.listSchemasWithCatalogsInternal(sqlConn);
            return list;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    @VisibleForTesting
    protected static List<SQLSchema> listSchemasWithCatalogsInternal(SQLConnectionProvider.SQLConnectionWrapper sqlConn) throws SQLException {
        ArrayList<SQLSchema> schemas = new ArrayList<SQLSchema>();
        ResultSet rs2 = sqlConn.getMetaData().getSchemas();
        String filteringCatalog = SQLUtils.getFilteringCatalogToListSchemas(sqlConn.getConnectionData());
        while (rs2.next()) {
            String catalog = SQLUtils.getStringSafe(rs2, TABLE_CATALOG);
            String schema = rs2.getString(TABLE_SCHEM);
            if (filteringCatalog != null && !filteringCatalog.equals(catalog)) continue;
            schemas.add(new SQLSchema(catalog, schema));
        }
        return schemas;
    }

    private static List<SQLSchema> listSchemasWithCatalogsForSQLServer(SQLConnectionProvider.SQLConnectionWrapper sqlConn) throws SQLException {
        ArrayList<SQLSchema> schemas = new ArrayList<SQLSchema>();
        DatabaseMetaData metaData = sqlConn.getMetaData();
        if (sqlConn.getConnectionData().getType() != ConnectionUtils.SQLConnectionType.FABRICWAREHOUSE && SQLUtils.isSQLAzure(sqlConn)) {
            try (ResultSet rs2 = metaData.getSchemas();){
                while (rs2.next()) {
                    String schema = rs2.getString(TABLE_SCHEM);
                    schemas.add(new SQLSchema(null, schema));
                }
            }
        }
        for (String catalogName : SQLUtils.getCatalogNames(metaData)) {
            ResultSet rs3 = metaData.getSchemas(catalogName, null);
            try {
                while (rs3.next()) {
                    String schema = rs3.getString(TABLE_SCHEM);
                    schemas.add(new SQLSchema(catalogName, schema));
                }
            }
            finally {
                if (rs3 == null) continue;
                rs3.close();
            }
        }
        return schemas;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isSQLAzure(SQLConnectionProvider.SQLConnectionWrapper sqlConn) throws SQLException {
        try (PreparedStatement preparedStatement = sqlConn.prepareStatement("SELECT SERVERPROPERTY('Edition')");){
            if (!preparedStatement.execute()) return false;
            try (ResultSet resultSet = preparedStatement.getResultSet();){
                if (!resultSet.next()) return false;
                String edition = resultSet.getString(1);
                boolean bl = edition != null && edition.toLowerCase().contains("azure");
                return bl;
            }
        }
        catch (SQLException e) {
            logger.warn((Object)"Unable to retrieve SQL Server edition", (Throwable)e);
        }
        return false;
    }

    public static List<SQLTable> listTables(SQLConnectionProvider.SQLConnectionData sqlData, AuthCtx authCtx, String projectKey, @Nullable String catalog, @Nullable String schema) throws SQLException, IOException, DKUSecurityException, InterruptedException {
        try (SQLConnectionProvider.SQLConnectionWrapper jdbcConn = SQLConnectionProvider.newConnection(sqlData, authCtx, projectKey);){
            List<SQLTable> list = SQLUtils.listTables(sqlData, jdbcConn, catalog, schema, sqlData.getDialect());
            return list;
        }
    }

    public static boolean checkTableExistenceWithMetadata(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, SQLDialect dialect, String catalog, String schema, String table) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        schema = StringUtils.defaultIfBlank((String)schema, null);
        catalog = StringUtils.defaultIfBlank((String)catalog, null);
        List<String> tableTypes = dialect.getTableTypes(connData, SQLDialect.GetTableTypesReason.TABLE_EXISTS);
        String schemaPattern = dialect.escapeSchemaOrTableNameForJDBCMetadataQuerying(schema);
        String tablePattern = dialect.escapeSchemaOrTableNameForJDBCMetadataQuerying(table);
        schemaPattern = dialect.postProcessSchemaPatternForJDBCMetadataSearch(schemaPattern);
        logger.debugV("Checking if table exists by querying meta: catalog=%s schemaPattern=%s tablePattern=%s types=%s", new Object[]{catalog, schemaPattern, tablePattern, JSON.json(tableTypes)});
        try (ResultSet rs2 = meta.getTables(catalog, schemaPattern, tablePattern, tableTypes.toArray(new String[0]));){
            if (rs2.next()) {
                try {
                    logger.infoV("Table %s.%s.%s exists (found as %s.%s.%s)", new Object[]{catalog, schema, table, rs2.getString(TABLE_CAT), rs2.getString(TABLE_SCHEM), rs2.getString(TABLE_NAME)});
                }
                catch (Exception e) {
                    logger.infoV("Table %s.%s.%s exists (failed to print found details: %s)", new Object[]{catalog, schema, table, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
                boolean bl = true;
                return bl;
            }
            logger.infoV("Table %s.%s.%s does not exist", new Object[]{catalog, schema, table});
            boolean bl = false;
            return bl;
        }
    }

    private static List<SQLField> listFields(SQLConnectionProvider.SQLConnectionData sqlData, SQLConnectionProvider.SQLConnectionWrapper conn, SQLTable sqlTable) throws SQLException {
        String schema = sqlTable.schema;
        SQLDialect dialect = sqlData.getDialect();
        ArrayList<SQLField> ret = new ArrayList<SQLField>();
        DatabaseMetaData meta = conn.getMetaData();
        if (StringUtils.isBlank((String)schema) && sqlData.getType() == ConnectionUtils.SQLConnectionType.ORACLE) {
            schema = meta.getUserName();
            logger.info((Object)("tableExists: schema not specified, using default " + schema));
        }
        String tablePattern = sqlData.getDialect().escapeSchemaOrTableNameForJDBCMetadataQuerying(sqlTable.table);
        String schemaPattern = sqlData.getDialect().escapeSchemaOrTableNameForJDBCMetadataQuerying(schema);
        try (ResultSet rs2 = meta.getColumns(sqlTable.getCatalog(), schemaPattern, tablePattern, "%");){
            while (rs2.next()) {
                SQLField f = new SQLField();
                f.schema = rs2.getString(TABLE_SCHEM);
                f.table = sqlTable.table;
                f.name = rs2.getString(COLUMN_NAME);
                f.type = rs2.getString(TYPE_NAME);
                f.quotedName = dialect.quoteIdentifier(f.name);
                ret.add(f);
            }
        }
        return ret;
    }

    public static List<SQLField> listFields(SQLConnectionProvider.SQLConnectionData sqlData, List<SQLTable> tables, AuthCtx authCtx, String projectKey) throws SQLException, DKUSecurityException, InterruptedException {
        try (ShortTaskExecutor.CloseableLater<SQLConnectionProvider.SQLConnectionWrapper> jdbcConn = ShortTaskExecutor.closeLater(SQLConnectionProvider.newConnection(sqlData, authCtx, projectKey));){
            ArrayList<SQLField> fields = new ArrayList<SQLField>();
            for (SQLTable table : tables) {
                SQLTable resolvedTable = SQLUtils.resolveTableFromConnectionDefaults(sqlData, table);
                fields.addAll(SQLUtils.listFields(sqlData, jdbcConn.get(), resolvedTable));
            }
            ArrayList<SQLField> arrayList = fields;
            return arrayList;
        }
    }

    public static void safeExec(SQLConnectionProvider.SQLConnectionWrapper conn, String sql) throws SQLException {
        SQLUtils.safeExec(conn, sql, sql, false, new InfoMessage.InfoMessages());
    }

    public static void safeExec(SQLConnectionProvider.SQLConnectionWrapper conn, String sql, boolean reportCRU) throws SQLException {
        SQLUtils.safeExec(conn, sql, sql, reportCRU, new InfoMessage.InfoMessages());
    }

    public static void safeExec(SQLConnectionProvider.SQLConnectionWrapper conn, String sql, String displaySql, boolean reportCRU) throws SQLException {
        SQLUtils.safeExec(conn, sql, displaySql, reportCRU, new InfoMessage.InfoMessages());
    }

    public static void safeExec(SQLConnectionProvider.SQLConnectionWrapper conn, String sql, InfoMessage.InfoMessages messages) throws SQLException {
        SQLUtils.safeExec(conn, sql, sql, false, messages);
    }

    public static void safeExec(SQLConnectionProvider.SQLConnectionWrapper conn, String sql, boolean reportCRU, InfoMessage.InfoMessages messages) throws SQLException {
        SQLUtils.safeExec(conn, sql, sql, reportCRU, messages);
    }

    public static void safeExec(SQLConnectionProvider.SQLConnectionWrapper conn, String sql, String displaySql, boolean reportCRU, InfoMessage.InfoMessages messages) throws SQLException {
        String loggableSql = StringUtils.defaultIfBlank((String)displaySql, (String)sql);
        logger.info((Object)("Executing statement: " + loggableSql));
        SQLDialect dialect = conn.getDialect();
        try (Statement statement = conn.createStatement();
             ComputeResourceUsage cru = SQLComputeResourceUsage.startSQLQuery(conn, loggableSql, reportCRU);){
            statement.execute(sql);
            for (String warning : SQLUtils.getWarningMessages(dialect, statement)) {
                messages.withWarning((InfoMessage.MessageCode)RecipeCodes.WARN_SQL_QUERY, warning);
            }
            logger.info((Object)"Statement done");
        }
    }

    public static void execute(SQLConnectionProvider.SQLConnectionWrapper conn, Statement statement, String sql, boolean reportCRU) throws SQLException {
        SQLUtils.execute(conn, statement, sql, sql, reportCRU, false);
    }

    public static void execute(SQLConnectionProvider.SQLConnectionWrapper conn, Statement statement, String sql, String sqlToDisplay, boolean reportCRU, boolean doLog) throws SQLException {
        String loggableSql = StringUtils.defaultIfBlank((String)sqlToDisplay, (String)sql);
        if (doLog) {
            logger.info((Object)"Executing statement:");
            logger.info((Object)loggableSql);
        }
        try (ComputeResourceUsage cru = SQLComputeResourceUsage.startSQLQuery(conn, loggableSql, reportCRU);){
            statement.execute(sql);
        }
    }

    public static void safeSplitAndExec(SQLDialect dialect, SQLConnectionProvider.SQLConnectionWrapper conn, String sql) throws SQLException {
        SQLUtils.safeSplitAndExec(dialect, conn, sql, false, new InfoMessage.InfoMessages());
    }

    public static void safeSplitAndExec(SQLDialect dialect, SQLConnectionProvider.SQLConnectionWrapper conn, String sql, boolean reportCRU) throws SQLException {
        SQLUtils.safeSplitAndExec(dialect, conn, sql, reportCRU, new InfoMessage.InfoMessages());
    }

    public static void safeSplitAndExec(SQLDialect dialect, SQLConnectionProvider.SQLConnectionWrapper conn, String sql, InfoMessage.InfoMessages messages) throws SQLException {
        SQLUtils.safeSplitAndExec(dialect, conn, sql, false, messages);
    }

    public static void safeSplitAndExec(SQLDialect dialect, SQLConnectionProvider.SQLConnectionWrapper conn, String sql, boolean reportCRU, InfoMessage.InfoMessages messages) throws SQLException {
        logger.info((Object)("Executing statements: " + sql));
        Splitter splitter = dialect.getSplitter();
        String[] statementSqls = splitter.split(sql);
        try (Statement statement = conn.createStatement();){
            for (String statementSql : statementSqls) {
                logger.info((Object)("Executing statement: " + statementSql));
                try (ComputeResourceUsage cru = SQLComputeResourceUsage.startSQLQuery(conn, sql, reportCRU);){
                    statement.execute(statementSql);
                }
                for (String warning : SQLUtils.getWarningMessages(dialect, statement)) {
                    messages.withWarning((InfoMessage.MessageCode)RecipeCodes.WARN_SQL_QUERY, warning);
                }
                logger.info((Object)"Statement done");
            }
        }
    }

    private static List<String> getWarningMessages(SQLDialect dialect, Statement statement) {
        ArrayList<String> warnings = new ArrayList<String>();
        try {
            for (SQLWarning nextWarning = statement.getWarnings(); nextWarning != null; nextWarning = nextWarning.getNextWarning()) {
                String message = nextWarning.toString();
                if (!dialect.filterWarning(nextWarning)) {
                    logger.warn((Object)message);
                    warnings.add(message);
                    continue;
                }
                logger.info((Object)String.format("Filtered SQL warning message with code %d: %s", nextWarning.getErrorCode(), message));
            }
        }
        catch (SQLException e) {
            logger.warn((Object)"Failed to fetch SQL query warnings ", (Throwable)e);
        }
        return warnings;
    }

    public static Statement getProperlyStreamableStatement(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn) throws SQLException {
        Statement s = connData.getType() == ConnectionUtils.SQLConnectionType.MYSQL ? conn.createStatement(1003, 1007) : conn.createStatement();
        SQLUtils.setFetchSize(s, SQLUtils.retrieveFetchSize(connData));
        return s;
    }

    public static int retrieveFetchSize(SQLConnectionProvider.SQLConnectionData connData) {
        if (connData.getType() == ConnectionUtils.SQLConnectionType.VERTICA) {
            return 99;
        }
        if (connData.getType() == ConnectionUtils.SQLConnectionType.MYSQL) {
            return Integer.MIN_VALUE;
        }
        int fetchSize = 2000;
        AbstractSQLConnection.AbstractSQLParams connParams = connData.getConnection().getParams();
        if (connParams instanceof AbstractSQLConnection.AbstractSQLParamsWithStdFields) {
            AbstractSQLConnection.AbstractSQLParamsWithStdFields connParamsWithStdFields = (AbstractSQLConnection.AbstractSQLParamsWithStdFields)connParams;
            if (StringUtils.isNotBlank((String)connParamsWithStdFields.fetchSize)) {
                try {
                    fetchSize = Integer.parseInt(connParamsWithStdFields.fetchSize);
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)("Could not use '" + connParamsWithStdFields.fetchSize + "' as fetchSize"));
                }
            }
        }
        return fetchSize;
    }

    public static PreparedStatement getProperlyStreamablePreparedStatement(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, String sql) throws SQLException {
        PreparedStatement s;
        if (connData.getType() == ConnectionUtils.SQLConnectionType.VERTICA) {
            s = conn.prepareStatement(sql);
            SQLUtils.setFetchSize(s, 99);
        } else if (connData.getType() == ConnectionUtils.SQLConnectionType.MYSQL) {
            s = conn.prepareStatement(sql, 1003, 1007);
            SQLUtils.setFetchSize(s, Integer.MIN_VALUE);
        } else {
            s = conn.prepareStatement(sql);
            SQLUtils.setFetchSize(s, SQLUtils.retrieveFetchSize(connData));
        }
        return s;
    }

    public static void setMaxRows(Statement s, int maxRows) throws SQLException {
        assert (maxRows > 0);
        try {
            s.setMaxRows(maxRows);
        }
        catch (SQLFeatureNotSupportedException e) {
            logger.warn((Object)"The JDBC driver does not support the 'setMaxRows' feature. The number of rows returned by the driver will be unbounded.", (Throwable)e);
        }
        if (s.getFetchSize() > maxRows) {
            SQLUtils.setFetchSize(s, maxRows);
        }
    }

    private static void setFetchSize(Statement s, int rows) throws SQLException {
        try {
            s.setFetchSize(rows);
        }
        catch (SQLFeatureNotSupportedException e) {
            logger.warn((Object)"The JDBC driver does not support the 'setFetchSize' feature.", (Throwable)e);
        }
    }

    public static void executePreWriteStatements(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset) throws SQLException {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        if (!StringUtils.isBlank((String)config.customPreWriteStatements)) {
            SQLUtils.safeSplitAndExec(connData.getDialect(), conn, config.customPreWriteStatements, true, new InfoMessage.InfoMessages());
        }
    }

    public static void executePostWriteStatements(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset) throws SQLException {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        if (!StringUtils.isBlank((String)config.customPostWriteStatements)) {
            SQLUtils.safeSplitAndExec(connData.getDialect(), conn, config.customPostWriteStatements, true, new InfoMessage.InfoMessages());
        }
    }

    public static int findLastSelectStatement(String[] statements, Splitter splitter) {
        Pattern selectPattern = Pattern.compile("\\bselect\\b", 2);
        Pattern notSelectPattern = Pattern.compile("\\b(insert|create|delete|update)\\b", 2);
        for (int i = statements.length - 1; i >= 0; --i) {
            Matcher notSelectMatcher;
            String statement = splitter.stripCommentsAndStrings(statements[i]).trim();
            Matcher selectMatcher = selectPattern.matcher(statement);
            if (!selectMatcher.find() || (notSelectMatcher = notSelectPattern.matcher(statement)).find()) continue;
            return i;
        }
        return -1;
    }

    public static String getFirstWord(String sql) {
        Pattern selectPattern = Pattern.compile("\\b\\w+\\b", 2);
        Matcher selectMatcher = selectPattern.matcher(sql);
        if (selectMatcher.find()) {
            return sql.substring(selectMatcher.start(), selectMatcher.end());
        }
        return "";
    }

    public static boolean isDMLStatement(String sql) {
        String firstWord = SQLUtils.getFirstWord(sql);
        return "select".equalsIgnoreCase(firstWord) || "insert".equalsIgnoreCase(firstWord) || "update".equalsIgnoreCase(firstWord) || "delete".equalsIgnoreCase(firstWord) || "merge".equalsIgnoreCase(firstWord);
    }

    public static void unsafeSetAutoCommit(Connection conn, boolean autoCommit) {
        try {
            if (conn.getMetaData().supportsTransactions()) {
                conn.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException e) {
            logger.warn((Object)"Failed to change autoCommit on connection", (Throwable)e);
        }
    }

    private static SQLTable resolveTableFromConnectionDefaults(SQLConnectionProvider.SQLConnectionData sqlData, SQLTable table) {
        return new SQLTable(SQLUtils.resolveCatalogFromConnectionDefault(sqlData, table.catalog), SQLUtils.resolveSchemaFromConnectionDefault(sqlData, table.schema), table.table, table.remarks, table.isTrueTable);
    }

    public static String resolveCatalogFromConnectionDefault(SQLConnectionProvider.SQLConnectionData sqlData, String catalog) {
        if (StringUtils.isBlank((String)catalog)) {
            if (ConnectionUtils.SQLConnectionType.MYSQL.equals((Object)sqlData.getType())) {
                return ((MySQLConnection.Params)sqlData.getConnection().getParams()).db;
            }
            if (ConnectionUtils.SQLConnectionType.SNOWFLAKE.equals((Object)sqlData.getType())) {
                String defaultCatalog = ((SnowflakeConnection.Params)sqlData.getConnection().getParams()).db;
                return StringUtils.isNotBlank((String)defaultCatalog) ? defaultCatalog : null;
            }
            if (ConnectionUtils.SQLConnectionType.BIGQUERY.equals((Object)sqlData.getType())) {
                String defaultCatalog = ((BigQueryConnection.Params)sqlData.getConnection().getParams()).projectId;
                return StringUtils.isNotBlank((String)defaultCatalog) ? defaultCatalog : null;
            }
            if (ConnectionUtils.SQLConnectionType.SQLSERVER.equals((Object)sqlData.getType())) {
                String defaultCatalog = ((SQLServerConnection.Params)sqlData.getConnection().getParams()).db;
                return StringUtils.isNotBlank((String)defaultCatalog) ? defaultCatalog : null;
            }
            if (ConnectionUtils.SQLConnectionType.DATABRICKS.equals((Object)sqlData.getType())) {
                String defaultCatalog = ((DatabricksConnection.Params)sqlData.getConnection().getParams()).defaultCatalog;
                return StringUtils.isNotBlank((String)defaultCatalog) ? defaultCatalog : null;
            }
        }
        return catalog;
    }

    public static String resolveSchemaFromConnectionDefault(SQLConnectionProvider.SQLConnectionData sqlData, String schema) {
        if (StringUtils.isBlank((String)schema)) {
            if (ConnectionUtils.SQLConnectionType.SNOWFLAKE.equals((Object)sqlData.getType())) {
                String defaultSchema = ((SnowflakeConnection.Params)sqlData.getConnection().getParams()).defaultSchema;
                return StringUtils.isNotBlank((String)defaultSchema) ? defaultSchema : "PUBLIC";
            }
            if (ConnectionUtils.SQLConnectionType.BIGQUERY.equals((Object)sqlData.getType())) {
                String defaultDataset = SQLUtils.getJDBCPropertyValue(sqlData.getConnection().getParams().properties, "DefaultDataset");
                return StringUtils.isNotBlank((String)defaultDataset) ? defaultDataset : null;
            }
            if (ConnectionUtils.SQLConnectionType.DATABRICKS.equals((Object)sqlData.getType())) {
                String defaultSchema = ((DatabricksConnection.Params)sqlData.getConnection().getParams()).defaultSchema;
                return StringUtils.isNotBlank((String)defaultSchema) ? defaultSchema : null;
            }
        }
        return schema;
    }

    private static String getJDBCPropertyValue(List<AbstractSQLConnection.CustomDatabaseProperty> properties, String key) {
        if (key != null) {
            for (AbstractSQLConnection.CustomDatabaseProperty property : properties) {
                if (!key.equals(property.name)) continue;
                return property.value;
            }
        }
        return null;
    }

    private static Params getDKUPropertiesAsParams(@Nullable SQLConnectionProvider.SQLConnectionData connData) {
        return connData == null ? new Params() : connData.getConnection().getDkuPropertiesAsParams();
    }

    public static void unsafeSetAutoCommit(SQLConnectionProvider.SQLConnectionWrapper conn, boolean autoCommit) {
        try {
            if (conn.getMetaData().supportsTransactions()) {
                conn.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException e) {
            logger.warn((Object)"Failed to change autoCommit on connection", (Throwable)e);
        }
    }

    private static String getStringSafe(ResultSet rs2, String columnName) {
        try {
            return rs2.getString(columnName);
        }
        catch (SQLException e) {
            return null;
        }
    }

    private static boolean isSystemSchema(@Nullable ConnectionUtils.SQLConnectionType connectionType, @Nullable String catalog, @Nullable String schema) {
        if ("INFORMATION_SCHEMA".equalsIgnoreCase(schema)) {
            return true;
        }
        if (connectionType != null) {
            switch (connectionType) {
                case DATABRICKSLAKEBASE: {
                    return schema != null && schema.startsWith("__db");
                }
                case POSTGRESQL: {
                    return schema != null && schema.startsWith("pg_");
                }
                case SQLSERVER: 
                case SYNAPSE: 
                case FABRICWAREHOUSE: {
                    if (Arrays.asList("tempdb", "msdb", "model").contains(catalog)) {
                        return true;
                    }
                    return Arrays.asList("sys", "db_accessadmin", "db_backupoperator", "db_datareader", "db_datawriter", "db_ddladmin", "db_denydatareader", "db_denydatawriter", "db_owner", "db_securityadmin").contains(schema);
                }
            }
            return false;
        }
        return false;
    }

    public static boolean isSystemTable(@Nullable ConnectionUtils.SQLConnectionType connectionType, String catalog, String schema, String table, String tableType) {
        if (SQLUtils.isSystemSchema(connectionType, catalog, schema)) {
            return true;
        }
        if (connectionType != null) {
            switch (connectionType) {
                case DATABRICKSLAKEBASE: {
                    return table != null && table.startsWith("__db");
                }
                case POSTGRESQL: {
                    return table != null && table.startsWith("pg_");
                }
                case SQLSERVER: 
                case SYNAPSE: 
                case FABRICWAREHOUSE: {
                    return Arrays.asList("spt_fallback_db", "spt_fallback_dev", "spt_fallback_usg", "spt_values", "spt_monitor", "MSreplication_options", "sysdac_instances", "sysdac_instances_internal", "sysdac_history_internal").contains(table);
                }
                case MYSQL: {
                    return "SYSTEM TABLE".equalsIgnoreCase(tableType);
                }
            }
            return false;
        }
        return false;
    }

    private static List<String> getCatalogNames(DatabaseMetaData metaData) throws SQLException {
        ArrayList<String> catalogNames = new ArrayList<String>();
        try (ResultSet catalogs = metaData.getCatalogs();){
            while (catalogs.next()) {
                catalogNames.add(catalogs.getString(TABLE_CAT));
            }
        }
        return catalogNames;
    }

    public static String generateSqlViewName(String tableName, SQLDialect dialect) {
        return SQLUtils.generateSqlViewName(tableName, Partition.newNP(), dialect);
    }

    public static String generateSqlViewName(String tableName, Partition partition, SQLDialect dialect) {
        return SQLUtils.generatePrefixedSqlNameWithRandomSuffix(DSS_VIEW_PREFIX, tableName, partition, dialect);
    }

    public static String generateSqlTempTableName(String tableName, Partition partition, SQLDialect dialect) {
        return SQLUtils.generatePrefixedSqlNameWithRandomSuffix(TEMP_TABLE_PREFIX, tableName, partition, dialect);
    }

    private static String generatePrefixedSqlNameWithRandomSuffix(String prefix, String tableName, Partition partition, SQLDialect dialect) {
        int maximumLength = dialect.getIdentifiersMaxLength();
        if (maximumLength <= 0) {
            maximumLength = 128;
        }
        int maxLengthWithoutSuffix = maximumLength - 6;
        Object joinedName = prefix + tableName;
        if (partition != null && !partition.isNP()) {
            joinedName = (String)joinedName + "_" + SchemaUtils.removeNonWordCharacters(partition.id());
        }
        if (((String)joinedName).length() > maxLengthWithoutSuffix) {
            joinedName = ((String)joinedName).substring(0, maxLengthWithoutSuffix);
        }
        return (String)joinedName + "_" + SecretKeyGenerator.generate((int)5);
    }

    private SQLUtils() {
    }

    public static class SQLTable {
        private final String table;
        private final String catalog;
        private final String schema;
        private final String remarks;
        private final boolean isTrueTable;
        public String type;

        public SQLTable(SQLTable other) {
            this.catalog = other.catalog;
            this.schema = other.schema;
            this.table = other.table;
            this.remarks = other.remarks;
            this.isTrueTable = other.isTrueTable;
        }

        public SQLTable(String tableName) {
            this(null, null, tableName, null, false);
        }

        public SQLTable(String catalog, String schema, String table, String remarks, boolean isTrueTable) {
            this.catalog = catalog;
            this.schema = schema;
            this.table = table;
            this.remarks = remarks;
            this.isTrueTable = isTrueTable;
        }

        public SQLTable(String catalog, String schema, String table, boolean isTrueTable) {
            this(catalog, schema, table, null, isTrueTable);
        }

        public SQLTable(String catalog, String schema, String table, String remarks) {
            this(catalog, schema, table, remarks, false);
        }

        public SQLTable(String catalog, String schema, String table) {
            this(catalog, schema, table, null, false);
        }

        public String getCatalog() {
            return StringUtils.isBlank((String)this.catalog) ? null : this.catalog;
        }

        public String getSchemaNullIfBlank() {
            return StringUtils.isBlank((String)this.schema) ? null : this.schema;
        }

        public String getTable() {
            return this.table;
        }

        public boolean isTrueTable() {
            return this.isTrueTable;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SQLTable other = (SQLTable)obj;
            return Objects.equals(this.catalog, other.catalog) && Objects.equals(this.schema, other.schema) && Objects.equals(this.table, other.table);
        }

        public int hashCode() {
            return Objects.hash(this.table, this.schema);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("<Table:");
            if (this.catalog != null) {
                sb.append(this.catalog).append(".").append(this.schema == null ? "" : this.schema).append(".");
            } else if (this.schema != null) {
                sb.append(this.schema).append(".");
            }
            sb.append(this.table);
            sb.append(">");
            return sb.toString();
        }
    }

    static class ForcedCatalogsAndSchemasList
    extends ArrayList<ForcedCatalogAndSchema> {
        ForcedCatalogsAndSchemasList() {
        }
    }

    public static class SQLSchema {
        private final String catalog;
        private final String schema;

        public SQLSchema(String catalog, String schema) {
            this.catalog = catalog;
            this.schema = schema;
        }

        public String getCatalog() {
            return StringUtils.isBlank((String)this.catalog) ? null : this.catalog;
        }

        public String getSchema() {
            return StringUtils.isBlank((String)this.schema) ? null : this.schema;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SQLSchema sqlSchema = (SQLSchema)o;
            return Objects.equals(this.catalog, sqlSchema.catalog) && Objects.equals(this.schema, sqlSchema.schema);
        }

        public int hashCode() {
            return Objects.hash(this.catalog, this.schema);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("<Schema:");
            if (this.catalog != null) {
                sb.append(this.catalog).append(".");
            }
            sb.append(this.schema).append(">");
            return sb.toString();
        }
    }

    public static class SQLField {
        public String schema;
        public String table;
        public String name;
        public String type;
        public String quotedName;
    }

    static class ForcedCatalogAndSchema {
        public String catalog;
        public List<String> schemas = new ArrayList<String>();

        ForcedCatalogAndSchema() {
        }
    }

    public static class RegularTableFromSchemaMaterializedTemporaryTableWriter
    extends RegularTableMaterializedTemporaryTableWriter {
        public RegularTableFromSchemaMaterializedTemporaryTableWriter(GenericSQLDialect dialect) {
            super(dialect, false);
        }

        @Override
        protected String generateCTASTemp(String tempFullName, String targetFullName, String fieldsDef) {
            return String.format("CREATE TABLE %s %s", tempFullName, fieldsDef);
        }
    }

    public static class RegularTableLikeMaterializedTemporaryTableWriter
    extends RegularTableMaterializedTemporaryTableWriter {
        private final boolean bracketLike;

        public RegularTableLikeMaterializedTemporaryTableWriter(GenericSQLDialect dialect, boolean hasDropIfExists, boolean bracketLike) {
            super(dialect, hasDropIfExists);
            this.bracketLike = bracketLike;
        }

        @Override
        protected String generateCTASTemp(String tempFullName, String targetFullName, String fieldsDef) {
            return String.format("CREATE TABLE %s %s LIKE %s %s", tempFullName, this.bracketLike ? "(" : "", targetFullName, this.bracketLike ? ")" : "");
        }
    }

    public static abstract class RegularTableMaterializedTemporaryTableWriter
    implements SQLDialect.MaterializedTemporaryTableWriter {
        private final GenericSQLDialect dialect;
        private final boolean hasDropIfExists;

        public RegularTableMaterializedTemporaryTableWriter(GenericSQLDialect dialect, boolean hasDropIfExists) {
            this.dialect = dialect;
            this.hasDropIfExists = hasDropIfExists;
        }

        @Override
        public String generateCreateTemp(SQLDialect.UpsertSpec spec) {
            return this.generateCTASTemp(this.dialect.getQuotedTableFullName(spec.temp), this.dialect.getQuotedTableFullName(spec.target), this.dialect.getCreateTableFieldsSQL(spec.targetDataset, new InfoMessage.InfoMessages()));
        }

        protected abstract String generateCTASTemp(String var1, String var2, String var3);

        @Override
        public String generateTruncateReal(SQLDialect.UpsertSpec spec, PartitioningScheme partitioningScheme) {
            if (partitioningScheme != null && partitioningScheme.isPartitioned()) {
                ArrayList<ExpressionBuilder> dimensionClauses = new ArrayList<ExpressionBuilder>();
                ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                for (String dim : partitioningScheme.getDimensionNames()) {
                    SchemaColumn sc = spec.targetDataset.getSchema().getColumnOrDefault(dim, Type.STRING);
                    dimensionClauses.add(ebf.col(dim).eq(ebf.dstPartitionId(sc, partitioningScheme.getDimension(dim))));
                }
                return String.format("DELETE FROM %s WHERE %s", this.dialect.getQuotedTableFullName(spec.target), dimensionClauses.stream().map(c2 -> c2.toSQL(this.dialect)).collect(Collectors.joining(" AND ")));
            }
            return this.getTruncateTableCommand(this.dialect.getQuotedTableFullName(spec.target));
        }

        protected String getTruncateTableCommand(String table) {
            return String.format("TRUNCATE TABLE %s", table);
        }

        @Override
        public String generateCopy(SQLDialect.UpsertSpec spec) {
            return String.format("INSERT INTO %s SELECT * FROM %s", this.dialect.getQuotedTableFullName(spec.target), this.dialect.getQuotedTableFullName(spec.temp));
        }

        @Override
        public String generateDropTemp(SQLDialect.UpsertSpec spec) {
            return String.format("DROP TABLE %s %s", this.hasDropIfExists ? "IF EXISTS" : "", this.dialect.getQuotedTableFullName(spec.temp));
        }
    }

    public static class MergeIntoBasedUpdateSelectWriter
    implements SQLDialect.UpdateSelectWriter {
        protected final SQLDialect dialect;
        private final boolean matchedFirst;
        private final boolean skipUpdatingKeys;
        private final boolean bracketJoinConditions;
        private final boolean noTargetAlias;

        public MergeIntoBasedUpdateSelectWriter(SQLDialect dialect, boolean matchedFirst, boolean skipUpdatingKeys, boolean bracketJoinConditions, boolean noTargetAlias) {
            this.dialect = dialect;
            this.matchedFirst = matchedFirst;
            this.skipUpdatingKeys = skipUpdatingKeys;
            this.bracketJoinConditions = bracketJoinConditions;
            this.noTargetAlias = noTargetAlias;
        }

        @Override
        public String generate(SQLDialect.UpsertSpec spec) {
            return new MergeIntoUpsertWriter(this.dialect, this.matchedFirst, this.skipUpdatingKeys, this.bracketJoinConditions, this.noTargetAlias, true).generate(spec);
        }
    }

    public static class UpdateFromJoinUpdateSelectWriter
    extends AbstractUpdateSelectWriter {
        public UpdateFromJoinUpdateSelectWriter(SQLDialect dialect) {
            super(dialect, false, false);
        }

        @Override
        protected String buildStatement(String targetFullName, String targetAlias, String setCommands, String sourceSelect, String sourceAlias, String joinFilter, List<String> partitionFilters) {
            String partitionFilter = partitionFilters.isEmpty() ? "" : String.format("\nWHERE %s", partitionFilters.stream().collect(Collectors.joining(" AND ")));
            return String.format("UPDATE %s\nSET %s\nFROM %s %s\nINNER JOIN %s %s\nON %s\n%s", targetFullName, setCommands, targetFullName, targetAlias, sourceSelect, sourceAlias, joinFilter, partitionFilter);
        }
    }

    public static class UpdateJoinUpdateSelectWriter
    extends AbstractUpdateSelectWriter {
        public UpdateJoinUpdateSelectWriter(SQLDialect dialect, boolean aliasSetColumns) {
            super(dialect, aliasSetColumns, false);
        }

        @Override
        protected String buildStatement(String targetFullName, String targetAlias, String setCommands, String sourceSelect, String sourceAlias, String joinFilter, List<String> partitionFilters) {
            String partitionFilter = partitionFilters.isEmpty() ? "" : String.format("\nWHERE %s", partitionFilters.stream().collect(Collectors.joining(" AND ")));
            return String.format("UPDATE %s %s\n  INNER JOIN %s %s ON %s\n  SET %s %s", targetFullName, targetAlias, sourceSelect, sourceAlias, joinFilter, setCommands, partitionFilter);
        }
    }

    public static class UpdateFromUpdateSelectWriter
    extends AbstractUpdateSelectWriter {
        private final boolean fromFirst;

        public UpdateFromUpdateSelectWriter(SQLDialect dialect, boolean fromFirst, boolean useTableNameAsTargetAlias) {
            super(dialect, false, useTableNameAsTargetAlias);
            this.fromFirst = fromFirst;
        }

        @Override
        protected String buildStatement(String targetFullName, String targetAlias, String setCommands, String sourceSelect, String sourceAlias, String joinFilter, List<String> partitionFilters) {
            ArrayList<String> allFilters = new ArrayList<String>();
            allFilters.add(joinFilter);
            allFilters.addAll(partitionFilters);
            String fullJoinFilter = allFilters.stream().collect(Collectors.joining(" AND "));
            String fromPart = String.format("FROM %s %s", sourceSelect, sourceAlias);
            String setPart = String.format("SET %s", setCommands);
            return String.format("UPDATE %s %s\n%s\n%s\nWHERE %s", targetFullName, this.useTableNameAsTargetAlias ? "" : targetAlias, this.fromFirst ? fromPart : setPart, this.fromFirst ? setPart : fromPart, fullJoinFilter);
        }
    }

    public static abstract class AbstractUpdateSelectWriter
    implements SQLDialect.UpdateSelectWriter {
        protected final SQLDialect dialect;
        private final boolean aliasSetColumns;
        protected final boolean useTableNameAsTargetAlias;

        public AbstractUpdateSelectWriter(SQLDialect dialect, boolean aliasSetColumns, boolean useTableNameAsTargetAlias) {
            this.dialect = dialect;
            this.aliasSetColumns = aliasSetColumns;
            this.useTableNameAsTargetAlias = useTableNameAsTargetAlias;
        }

        @Override
        public String generate(SQLDialect.UpsertSpec spec) {
            String sourceAlias = this.dialect.quoteIdentifier("src");
            String unquotedTargetAlias = this.useTableNameAsTargetAlias ? spec.target.getTable() : "dst";
            String targetAlias = this.dialect.quoteIdentifier(unquotedTargetAlias);
            ArrayList<String> setCommands = new ArrayList<String>();
            String optionalSetAlias = this.aliasSetColumns ? String.format("%s.", targetAlias) : "";
            for (String string : spec.columns) {
                setCommands.add(String.format("%s%s = %s.%s", optionalSetAlias, this.dialect.quoteIdentifier(string), sourceAlias, this.dialect.quoteIdentifier(string)));
            }
            ArrayList<String> joinExprs = new ArrayList<String>();
            for (String k : spec.keys) {
                joinExprs.add(String.format("%s.%s = %s.%s", targetAlias, this.dialect.quoteIdentifier(k), sourceAlias, this.dialect.quoteIdentifier(k)));
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (spec.sourcePartitionFilter != null) {
                ExpressionUtils.aliasColumns(spec.sourcePartitionFilter, "src");
                arrayList.add("(" + spec.sourcePartitionFilter.toSQL(this.dialect) + ")");
            }
            if (spec.targetPartitionFilter != null) {
                ExpressionUtils.aliasColumns(spec.targetPartitionFilter, unquotedTargetAlias);
                arrayList.add("(" + spec.targetPartitionFilter.toSQL(this.dialect) + ")");
            }
            String joinFilter = joinExprs.stream().collect(Collectors.joining(" AND "));
            return this.buildStatement(this.dialect.getQuotedTableFullName(spec.target), targetAlias, setCommands.stream().collect(Collectors.joining("\n  , ")), spec.sourceSelect, sourceAlias, joinFilter, arrayList);
        }

        protected abstract String buildStatement(String var1, String var2, String var3, String var4, String var5, String var6, List<String> var7);
    }

    public static class MergeIntoUpsertWriter
    implements SQLDialect.UpsertWriter {
        private final SQLDialect dialect;
        private final boolean matchedFirst;
        private final boolean skipUpdatingKeys;
        private final boolean bracketJoinConditions;
        private final boolean noTargetAlias;
        private final boolean onlyUpdate;

        public MergeIntoUpsertWriter(SQLDialect dialect, boolean matchedFirst, boolean skipUpdatingKeys, boolean bracketJoinConditions, boolean noTargetAlias) {
            this(dialect, matchedFirst, skipUpdatingKeys, bracketJoinConditions, noTargetAlias, false);
        }

        MergeIntoUpsertWriter(SQLDialect dialect, boolean matchedFirst, boolean skipUpdatingKeys, boolean bracketJoinConditions, boolean noTargetAlias, boolean onlyUpdate) {
            this.dialect = dialect;
            this.matchedFirst = matchedFirst;
            this.skipUpdatingKeys = skipUpdatingKeys;
            this.bracketJoinConditions = bracketJoinConditions;
            this.noTargetAlias = noTargetAlias;
            this.onlyUpdate = onlyUpdate;
        }

        @Override
        public boolean canUpsertConcurrently() {
            return true;
        }

        @Override
        public String generate(SQLDialect.UpsertSpec spec) {
            String targetAlias = this.noTargetAlias ? this.dialect.getQuotedTableFullName(spec.target) : this.dialect.quoteIdentifier("dst");
            String sourceAlias = this.dialect.quoteIdentifier("src");
            List upsertKeys = spec.keys.stream().collect(Collectors.toList());
            if (spec.scheme != null && spec.scheme.isPartitioned()) {
                upsertKeys.addAll(spec.scheme.getDimensionNames());
            }
            List joinsSql = upsertKeys.stream().map(c2 -> String.format("%s.%s = %s.%s", targetAlias, this.dialect.quoteIdentifier((String)c2), sourceAlias, this.dialect.quoteIdentifier((String)c2))).collect(Collectors.toList());
            List targetFields = spec.columns.stream().map(c2 -> this.dialect.quoteIdentifier((String)c2)).collect(Collectors.toList());
            List sourceFields = spec.columns.stream().map(c2 -> String.format("%s.%s", sourceAlias, this.dialect.quoteIdentifier((String)c2))).collect(Collectors.toList());
            ArrayList<String> setCommands = new ArrayList<String>();
            for (String c3 : spec.columns) {
                if (this.skipUpdatingKeys && upsertKeys.contains(c3)) continue;
                setCommands.add(String.format("%s = %s.%s", this.dialect.quoteIdentifier(c3), sourceAlias, this.dialect.quoteIdentifier(c3)));
            }
            String whenMatched = setCommands.isEmpty() ? "" : String.format("WHEN MATCHED THEN UPDATE SET %s", setCommands.stream().collect(Collectors.joining(", ")));
            String whenNotMatched = String.format("WHEN NOT MATCHED THEN INSERT (%s) VALUES (%s)", targetFields.stream().collect(Collectors.joining(", ")), sourceFields.stream().collect(Collectors.joining(", ")));
            String mergeStart = String.format("MERGE INTO %s %s\n  USING %s %s\n  ON %s%s%s", this.dialect.getQuotedTableFullName(spec.target), this.noTargetAlias ? "" : targetAlias, spec.sourceSelect, sourceAlias, this.bracketJoinConditions ? "( " : "", joinsSql.stream().collect(Collectors.joining(" AND ")), this.bracketJoinConditions ? " )" : "");
            if (this.onlyUpdate) {
                if (whenMatched.isBlank()) {
                    throw new IllegalArgumentException("Invalid settings: no column will be modified upon update");
                }
                return mergeStart + "\n" + whenMatched;
            }
            if (this.matchedFirst) {
                return mergeStart + "\n" + whenMatched + "\n" + whenNotMatched;
            }
            return mergeStart + "\n" + whenNotMatched + "\n" + whenMatched;
        }

        @Override
        public boolean usesIndex() {
            return false;
        }
    }
}

