/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.timelines;

import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.coremodel.HeadWithVersioningInfo;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.discussions.Discussion;
import com.dataiku.dip.discussions.DiscussionsCacheService;
import com.dataiku.dip.discussions.DiscussionsInternalDB;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.DeleteQueryBuilder;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.InsertQueryBuilder;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.sql.queries.SimpleSelectQueryBuilder;
import com.dataiku.dip.timelines.ProjectTimeline;
import com.dataiku.dip.timelines.TimelineItem;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.wikis.ArticlesCacheService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ProjectTimelineBehavior {
    public final String projectKey;
    private final ProjectCache cache = new ProjectCache();
    private SQLUtils.SQLTable resolvedTable;
    public SQLDialect dialect;
    public static final String timelineTable = "TIMELINE_ITEM";
    private static final String USER_COLUMN = "USER";
    private static final String ACTION_COLUMN = "ACTION";
    static final String OBJECT_TYPE_COLUMN = "OBJECT_TYPE";
    static final String OBJECT_ID_COLUMN = "OBJECT_ID";
    private static final String DETAILS_COLUMN = "DETAILS";
    public static final String ITEM_TIME_COLUMN = "ITEM_TIME";
    private static final SchemaColumn OBJECT_TYPE_SCHEMA_COLUMN = new SchemaColumn("OBJECT_TYPE", Type.STRING);
    private static final SchemaColumn OBJECT_ID_SCHEMA_COLUMN = new SchemaColumn("OBJECT_ID", Type.STRING);
    public static final String PROJECT_KEY_COLUMN = "PROJECT_KEY";
    static final SchemaColumn PROJECT_KEY_SCHEMA_COLUMN = new SchemaColumn("PROJECT_KEY", Type.STRING);
    static final SchemaColumn[] timelineColumns = new SchemaColumn[]{new SchemaColumn("USER", Type.STRING), new SchemaColumn("ACTION", Type.STRING), OBJECT_TYPE_SCHEMA_COLUMN, OBJECT_ID_SCHEMA_COLUMN, new SchemaColumn("DETAILS", Type.STRING), new SchemaColumn("ITEM_TIME", Type.BIGINT), PROJECT_KEY_SCHEMA_COLUMN};
    private static final ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
    private final String insert;
    private final String getAll;
    private final String getRecent;
    private final String getForObject;
    private final String getFirstForObject;
    private final String getLatestForObject;
    private final String getLastItemAndUser;
    private final String getForProject;
    private final String getForWiki;
    private final String getLastItem;
    private final String listContributors;
    private final String listContributorsForWiki;
    private final String update;
    private final String changeObjectId;
    private final String flagDeletedUser;
    private final String deleteObject;
    private final String getCreationAndUpdateInfo;
    private final String fetchProjectContributors;
    private final String deleteProjectTimeline;
    private static final String ROOT_CACHE_KEY = "$$$root$$$";
    private static DKULogger logger = DKULogger.getLogger((String)"dku.timelines");

    public ProjectTimelineBehavior(String projectKey, SQLUtils.SQLTable resolvedTable, SQLDialect dialect) {
        this.projectKey = projectKey;
        this.resolvedTable = resolvedTable;
        this.dialect = dialect;
        this.insert = InsertQueryBuilder.insertInto(resolvedTable).addColumns(timelineColumns).toSQL(dialect);
        this.getAll = SimpleSelectQueryBuilder.selectAll().from(resolvedTable, resolvedTable.getTable()).wheres(PROJECT_KEY_COLUMN).toSQL(dialect);
        this.getRecent = this.selectAllColumnsFromTimeline().where(EBF.parameterizedColumnOperation(PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(ITEM_TIME_COLUMN, QueryUtils.OperatorType.GT))).toSQL(dialect);
        this.getForObject = this.getQueryForObject().descending().withParameterizedMax().toSQL(dialect);
        this.getFirstForObject = this.getQueryForObject().first().toSQL(dialect);
        this.getLatestForObject = this.getQueryForObject().last().toSQL(dialect);
        this.getLastItemAndUser = SimpleSelectQueryBuilder.selectAll().from(resolvedTable, resolvedTable.getTable()).wheres(PROJECT_KEY_COLUMN, USER_COLUMN).orderedBy(ITEM_TIME_COLUMN).last().toSQL(dialect);
        this.getForProject = SimpleSelectQueryBuilder.selectAll().from(resolvedTable, resolvedTable.getTable()).wheres(PROJECT_KEY_COLUMN).orderedBy(ITEM_TIME_COLUMN).descending().withParameterizedMax().toSQL(dialect);
        this.getForWiki = SimpleSelectQueryBuilder.selectAll().from(resolvedTable, resolvedTable.getTable()).wheres(PROJECT_KEY_COLUMN, OBJECT_TYPE_COLUMN).orderedBy(ITEM_TIME_COLUMN).descending().withParameterizedMax().toSQL(dialect);
        this.getLastItem = SimpleSelectQueryBuilder.selectAll().from(resolvedTable, resolvedTable.getTable()).wheres(PROJECT_KEY_COLUMN).orderedBy(ITEM_TIME_COLUMN).last().toSQL(dialect);
        this.listContributors = SimpleSelectQueryBuilder.select(USER_COLUMN).from(resolvedTable, resolvedTable.getTable()).wheres(PROJECT_KEY_COLUMN, OBJECT_TYPE_COLUMN, OBJECT_ID_COLUMN).orderedBy(ITEM_TIME_COLUMN).toSQL(dialect);
        this.listContributorsForWiki = SimpleSelectQueryBuilder.select(USER_COLUMN).from(resolvedTable, resolvedTable.getTable()).wheres(PROJECT_KEY_COLUMN, OBJECT_TYPE_COLUMN).orderedBy(ITEM_TIME_COLUMN).toSQL(dialect);
        this.update = "UPDATE " + dialect.getQuotedTableFullName(resolvedTable) + " SET " + this.quote(ITEM_TIME_COLUMN) + "=?, " + this.quote(DETAILS_COLUMN) + "=? WHERE " + this.quote(PROJECT_KEY_COLUMN) + "=? AND " + this.quote(OBJECT_TYPE_COLUMN) + "=? AND " + this.quote(OBJECT_ID_COLUMN) + "=? AND " + this.quote(ACTION_COLUMN) + "=? AND " + this.quote(ITEM_TIME_COLUMN) + "=?";
        this.changeObjectId = "UPDATE " + dialect.getQuotedTableFullName(resolvedTable) + " SET " + this.quote(OBJECT_ID_COLUMN) + "=? WHERE " + this.quote(PROJECT_KEY_COLUMN) + "=? AND " + this.quote(OBJECT_TYPE_COLUMN) + "=? AND " + this.quote(OBJECT_ID_COLUMN) + "=?";
        this.flagDeletedUser = "UPDATE " + dialect.getQuotedTableFullName(resolvedTable) + " SET " + this.quote(USER_COLUMN) + "=? WHERE " + this.quote(PROJECT_KEY_COLUMN) + "=? AND " + this.quote(USER_COLUMN) + "=?";
        this.deleteObject = "DELETE FROM " + dialect.getQuotedTableFullName(resolvedTable) + " WHERE " + this.quote(PROJECT_KEY_COLUMN) + "=? AND " + this.quote(OBJECT_TYPE_COLUMN) + "=? AND " + this.quote(OBJECT_ID_COLUMN) + "=?";
        this.getCreationAndUpdateInfo = "SELECT t." + this.quote(PROJECT_KEY_COLUMN) + ", t." + this.quote(OBJECT_TYPE_COLUMN) + ", t." + this.quote(OBJECT_ID_COLUMN) + ", u1." + this.quote(USER_COLUMN) + " as createdBy, u2." + this.quote(USER_COLUMN) + " as updatedBy, t.created, t.updated FROM (SELECT " + this.quote(PROJECT_KEY_COLUMN) + ", " + this.quote(OBJECT_TYPE_COLUMN) + ", " + this.quote(OBJECT_ID_COLUMN) + ", MIN(" + this.quote(ITEM_TIME_COLUMN) + ") as created, MAX(" + this.quote(ITEM_TIME_COLUMN) + ") as updated FROM " + dialect.getQuotedTableFullName(resolvedTable) + " WHERE " + this.quote(PROJECT_KEY_COLUMN) + "=? GROUP BY " + this.quote(PROJECT_KEY_COLUMN) + ", " + this.quote(OBJECT_TYPE_COLUMN) + ", " + this.quote(OBJECT_ID_COLUMN) + ") as t INNER JOIN " + dialect.getQuotedTableFullName(resolvedTable) + " as u1 ON t." + this.quote(PROJECT_KEY_COLUMN) + " = u1." + this.quote(PROJECT_KEY_COLUMN) + " AND t." + this.quote(OBJECT_TYPE_COLUMN) + " = u1." + this.quote(OBJECT_TYPE_COLUMN) + " AND t." + this.quote(OBJECT_ID_COLUMN) + " = u1." + this.quote(OBJECT_ID_COLUMN) + " AND t.created = u1." + this.quote(ITEM_TIME_COLUMN) + " INNER JOIN " + dialect.getQuotedTableFullName(resolvedTable) + " as u2 ON t." + this.quote(PROJECT_KEY_COLUMN) + " = u2." + this.quote(PROJECT_KEY_COLUMN) + " AND t." + this.quote(OBJECT_TYPE_COLUMN) + " = u2." + this.quote(OBJECT_TYPE_COLUMN) + " AND t." + this.quote(OBJECT_ID_COLUMN) + " = u2." + this.quote(OBJECT_ID_COLUMN) + " AND t.updated = u2." + this.quote(ITEM_TIME_COLUMN);
        this.fetchProjectContributors = SimpleSelectQueryBuilder.select(USER_COLUMN).from(resolvedTable, resolvedTable.getTable()).wheres(PROJECT_KEY_COLUMN).toSQL(dialect);
        this.deleteProjectTimeline = DeleteQueryBuilder.deleteFrom(resolvedTable).withParameterizedEqualWheres(PROJECT_KEY_COLUMN).toSql(dialect);
    }

    void fetchInitialUIData(DSSDBConnection conn) {
        this.fetchProjectContributors(conn);
    }

    public SQLUtils.SQLTable getResolvedTable() {
        return this.resolvedTable;
    }

    public SQLDialect getDialect() {
        return this.dialect;
    }

    protected PreparedStatement getPreparedStatement(DSSDBConnection conn, String sql) throws CodedSQLException {
        return conn.getOrCreatePreparedStatement(sql);
    }

    private String quote(String identifier) {
        return this.dialect.quoteIdentifier(identifier);
    }

    private SelectQueryBuilder selectAllColumnsFromTimeline() {
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        sqb.from(this.resolvedTable, this.resolvedTable.getTable());
        sqb.select("*");
        return sqb;
    }

    private SimpleSelectQueryBuilder getQueryForObject() {
        return SimpleSelectQueryBuilder.selectAll().from(this.resolvedTable, this.resolvedTable.getTable()).wheres(PROJECT_KEY_COLUMN, OBJECT_TYPE_COLUMN, OBJECT_ID_COLUMN).orderedBy(ITEM_TIME_COLUMN);
    }

    private void fetchProjectContributors(DSSDBConnection conn) {
        assert (this.cache.contributors.isEmpty()) : "Should not fetch contributors after the cache has already been updated.";
        try {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.fetchProjectContributors);
            ps2.setString(1, this.projectKey);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    this.cache.contributors.add(rs2.getString(1));
                }
            }
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Could not fetch the project contributors for project %s.", new Object[]{this.projectKey});
        }
    }

    private String objectKey(ITaggingService.TaggableType objectType, String objectId) {
        return String.valueOf((Object)objectType) + "$$$" + this.projectKey + "$$$" + objectId;
    }

    private TaggableObjectsService.TaggableObjectRef makeTaggableObjectRef(ResultSet rs2) throws SQLException {
        ITaggingService.TaggableType type = null;
        try {
            type = ITaggingService.TaggableType.valueOf(rs2.getString(OBJECT_TYPE_COLUMN));
        }
        catch (Exception e) {
            logger.info((Object)("Taggable type does not exist anymore: " + rs2.getString(OBJECT_TYPE_COLUMN) + " " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
        return new TaggableObjectsService.TaggableObjectRef(this.projectKey, type, rs2.getString(OBJECT_ID_COLUMN));
    }

    private TaggableObjectChangedEvent.ActionType readSafeActionType(String s) {
        try {
            if (!StringUtils.isBlank((String)s)) {
                return TaggableObjectChangedEvent.ActionType.valueOf(s);
            }
        }
        catch (IllegalArgumentException e) {
            logger.info((Object)"Failed to read action type.", (Throwable)e);
        }
        return TaggableObjectChangedEvent.ActionType.UNKNOWN;
    }

    public TimelineItem readTimelineItem(ResultSet rs2) throws SQLException {
        return new TimelineItem(rs2.getString(USER_COLUMN), this.readSafeActionType(rs2.getString(ACTION_COLUMN)), this.projectKey, ITaggingService.TaggableType.valueOf(rs2.getString(OBJECT_TYPE_COLUMN)), rs2.getString(OBJECT_ID_COLUMN), null, rs2.getLong(ITEM_TIME_COLUMN)).withDetails((JsonObject)JSON.parse((String)rs2.getString(DETAILS_COLUMN), JsonObject.class));
    }

    private List<TimelineItem> readAsTimelineItemsList(ResultSet rs2) throws SQLException {
        ArrayList<TimelineItem> ret = new ArrayList<TimelineItem>();
        while (rs2.next()) {
            try {
                ret.add(this.readTimelineItem(rs2));
            }
            catch (Exception e) {
                logger.info((Object)"Failed to read timeline item", (Throwable)e);
            }
        }
        return ret;
    }

    private Map<TaggableObjectsService.TaggableObjectRef, List<TimelineItem>> readAsMap(ResultSet rs2) throws SQLException {
        HashMap<TaggableObjectsService.TaggableObjectRef, List<TimelineItem>> ret = new HashMap<TaggableObjectsService.TaggableObjectRef, List<TimelineItem>>();
        while (rs2.next()) {
            TaggableObjectsService.TaggableObjectRef ref = this.makeTaggableObjectRef(rs2);
            TimelineItem ti = this.readTimelineItem(rs2);
            if (ret.containsKey(ref)) {
                ((List)ret.get(ref)).add(ti);
                continue;
            }
            ret.put(ref, Lists.newArrayList((Object[])new TimelineItem[]{ti}));
        }
        return ret;
    }

    void insert(DSSDBConnection conn, TimelineItem ti) throws CodedSQLException {
        String key = this.objectKey(ti.objectType, ti.objectId);
        try {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.insert);
            ps2.setString(1, ti.user);
            ps2.setString(2, ti.action.toString());
            ps2.setString(3, ti.objectType.toString());
            ps2.setString(4, ti.objectId);
            ps2.setString(5, JSON.json((Object)ti.details));
            ps2.setLong(6, ti.time);
            ps2.setString(7, this.projectKey);
            ps2.execute();
            conn.commit();
            this.cache.latestItemCache.put((Object)key, (Object)ti);
            this.cache.latestItemCache.put((Object)ROOT_CACHE_KEY, (Object)ti);
            this.cache.latestItemCache.put((Object)this.getUserCacheKey(ti.user), (Object)ti);
            this.cache.contributors.add(ti.user);
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access timelines database", (Throwable)e);
        }
    }

    void update(DSSDBConnection conn, TimelineItem ti) throws CodedSQLException {
        String key = this.objectKey(ti.objectType, ti.objectId);
        try {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.update);
            ps2.setLong(1, System.currentTimeMillis());
            ps2.setString(2, JSON.json((Object)ti.details));
            ps2.setString(3, this.projectKey);
            ps2.setString(4, ti.objectType.toString());
            ps2.setString(5, ti.objectId);
            ps2.setString(6, ti.action.toString());
            ps2.setLong(7, ti.time);
            ps2.execute();
            conn.commit();
            this.cache.latestItemCache.put((Object)key, (Object)ti);
            this.cache.latestItemCache.put((Object)ROOT_CACHE_KEY, (Object)ti);
            this.cache.latestItemCache.put((Object)this.getUserCacheKey(ti.user), (Object)ti);
            this.cache.contributors.add(ti.user);
        }
        catch (Exception e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access timelines database", (Throwable)e);
        }
    }

    void changeObjectId(DSSDBConnection conn, ITaggingService.TaggableType objectType, String oldId, String newId) throws CodedSQLException {
        try {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.changeObjectId);
            ps2.setString(1, newId);
            ps2.setString(2, this.projectKey);
            ps2.setString(3, objectType.toString());
            ps2.setString(4, oldId);
            ps2.execute();
            conn.commit();
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access timelines database", (Throwable)e);
        }
    }

    private TimelineItem getFirstForObjectInternal(DSSDBConnection conn, ITaggingService.TaggableType objectType, String objectId) throws SQLException {
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getFirstForObject);
        ps2.setString(1, this.projectKey);
        ps2.setString(2, objectType.toString());
        ps2.setString(3, objectId);
        ps2.execute();
        try (ResultSet rs2 = ps2.getResultSet();){
            TimelineItem timelineItem = rs2.next() ? this.readTimelineItem(rs2) : null;
            return timelineItem;
        }
    }

    @Nullable
    TimelineItem getFirstForObjectNoCache(DSSDBConnection conn, ITaggingService.TaggableType objectType, String objectId) throws CodedSQLException {
        try {
            return this.getFirstForObjectInternal(conn, objectType, objectId);
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access timelines database", (Throwable)e);
        }
    }

    @Nullable
    TimelineItem getFirstForObject(DSSDBConnection conn, ITaggingService.TaggableType objectType, String objectId) throws CodedSQLException {
        TimelineItemLoader loader = () -> this.getFirstForObjectInternal(conn, objectType, objectId);
        return this.getTimelineItem(this.cache.firstItemCache, this.objectKey(objectType, objectId), loader);
    }

    @Nullable
    TimelineItem getLatestForObject(DSSDBConnection conn, ITaggingService.TaggableType objectType, String objectId) throws CodedSQLException {
        TimelineItemLoader loader = () -> {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getLatestForObject);
            ps2.setString(1, this.projectKey);
            ps2.setString(2, objectType.toString());
            ps2.setString(3, objectId);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                TimelineItem timelineItem = rs2.next() ? this.readTimelineItem(rs2) : null;
                return timelineItem;
            }
        };
        return this.getTimelineItem(this.cache.latestItemCache, this.objectKey(objectType, objectId), loader);
    }

    @Nullable
    TimelineItem getLatest(DSSDBConnection conn) throws CodedSQLException {
        TimelineItemLoader loader = () -> {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getLastItem);
            ps2.setString(1, this.projectKey);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                TimelineItem timelineItem = rs2.next() ? this.readTimelineItem(rs2) : null;
                return timelineItem;
            }
        };
        return this.getTimelineItem(this.cache.latestItemCache, ROOT_CACHE_KEY, loader);
    }

    @Nullable
    TimelineItem getLatestForUser(DSSDBConnection conn, String login) throws CodedSQLException {
        TimelineItemLoader loader = () -> {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getLastItemAndUser);
            ps2.setString(1, this.projectKey);
            ps2.setString(2, login);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                TimelineItem timelineItem = rs2.next() ? this.readTimelineItem(rs2) : null;
                return timelineItem;
            }
        };
        return this.getTimelineItem(this.cache.latestItemCache, this.getUserCacheKey(login), loader);
    }

    @Nullable
    private TimelineItem getTimelineItem(Cache<String, TimelineItem> itemCache, String itemKey, TimelineItemLoader loader) throws CodedSQLException {
        TimelineItem item = (TimelineItem)itemCache.getIfPresent((Object)itemKey);
        if (item == null) {
            try {
                item = loader.load();
            }
            catch (SQLException e) {
                throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access timelines database", (Throwable)e);
            }
            if (item == null) {
                item = new TimelineItem();
                item.time = -1L;
            }
            itemCache.put((Object)itemKey, (Object)item);
        }
        return item.time > 0L ? item : null;
    }

    public void migrateCommentsToDiscussions(DSSDBConnection conn) throws Exception {
        HashMap commentsByObject = new HashMap();
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getAll);
        ps2.setString(1, this.projectKey);
        try (ResultSet rs2 = ps2.executeQuery();){
            while (rs2.next()) {
                try {
                    TimelineItem ti = this.readTimelineItem(rs2);
                    if (ti.action != TaggableObjectChangedEvent.ActionType.COMMENT) continue;
                    TaggableObjectsService.TaggableObjectRef tor = new TaggableObjectsService.TaggableObjectRef(this.projectKey, ti.objectType, ti.objectId);
                    if (!commentsByObject.containsKey(tor)) {
                        commentsByObject.put(tor, new ArrayList());
                    }
                    ((List)commentsByObject.get(tor)).add(ti);
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to read timeline item", (Throwable)e);
                }
            }
        }
        logger.infoV("Objects with comments %s", new Object[]{commentsByObject.size()});
        if (commentsByObject.isEmpty()) {
            return;
        }
        DiscussionsInternalDB didb = (DiscussionsInternalDB)SpringUtils.getBean(DiscussionsInternalDB.class);
        for (Map.Entry entry : commentsByObject.entrySet()) {
            TaggableObjectsService.TaggableObjectRef tor = (TaggableObjectsService.TaggableObjectRef)entry.getKey();
            List objectTimeline = (List)entry.getValue();
            String discussionId = null;
            for (TimelineItem ti : objectTimeline) {
                logger.infoV("Add reply for %s", new Object[]{tor.toString()});
                if (StringUtils.isBlank(discussionId)) {
                    Discussion discussion = this.createDiscussion(didb, tor.type, tor.projectKey, tor.id, ti.details.get("text").getAsString(), ti.user, ti.time);
                    discussionId = discussion.id;
                } else {
                    this.replyDiscussion(didb, tor.projectKey, discussionId, ti.details.get("text").getAsString(), ti.user, ti.time);
                }
                this.updateDiscussionCache(tor, discussionId, ti.user);
            }
        }
        try (PreparedStatement deleteComment = conn.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolvedTable).where(EBF.col(ACTION_COLUMN).eq("COMMENT")).toSql(this.dialect));){
            deleteComment.execute();
            conn.commit();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to delete comments", (Throwable)e);
            conn.rollback();
        }
    }

    public void migrateArticlesToNumericIds(DSSDBConnection conn) throws Exception {
        ConcurrentMap<String, String> namesMapping;
        ArticlesCacheService articlesCacheService = (ArticlesCacheService)SpringUtils.getBean(ArticlesCacheService.class);
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = transactionService.beginRead();){
            namesMapping = articlesCacheService.getNamesMapping(this.projectKey);
        }
        if (namesMapping.isEmpty()) {
            return;
        }
        try {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.changeObjectId);
            String articleType = ITaggingService.TaggableType.ARTICLE.toString();
            for (Map.Entry entry : namesMapping.entrySet()) {
                String articleName = (String)entry.getValue();
                String articleId = (String)entry.getKey();
                ps2.setString(1, "__DKU__" + articleId);
                ps2.setString(2, this.projectKey);
                ps2.setString(3, articleType);
                ps2.setString(4, articleName);
                ps2.addBatch();
            }
            for (String articleId : namesMapping.keySet()) {
                ps2.setString(1, articleId);
                ps2.setString(2, this.projectKey);
                ps2.setString(3, articleType);
                ps2.setString(4, "__DKU__" + articleId);
                ps2.addBatch();
            }
            ps2.executeBatch();
            conn.commit();
        }
        catch (Exception e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access timelines database", (Throwable)e);
        }
    }

    private void updateDiscussionCache(TaggableObjectsService.TaggableObjectRef tor, String discussionId, String userId) throws NotFoundException, SQLException {
        if (SpringUtils.getInstance().hasBean(DiscussionsCacheService.class)) {
            DiscussionsCacheService discussionsCacheService = (DiscussionsCacheService)SpringUtils.getBean(DiscussionsCacheService.class);
            discussionsCacheService.reply(tor, discussionId, userId);
        }
    }

    private Discussion createDiscussion(DiscussionsInternalDB didb, ITaggingService.TaggableType objectType, String projectKey, String objectId, String text, String user, long time) throws NotFoundException, SQLException {
        String discussionId = SecretKeyGenerator.generate((int)8);
        Discussion conv = new Discussion(discussionId, projectKey, null, objectId, objectType, "Comments", 0L, null, 0L);
        String replyId = SecretKeyGenerator.generate((int)8);
        Discussion.DiscussionReply reply = new Discussion.DiscussionReply(replyId, text, user, time, 0L);
        conv.addReply(reply);
        didb.saveDiscussion(conv, true);
        didb.saveReply(projectKey, null, discussionId, reply, true);
        return conv;
    }

    private void replyDiscussion(DiscussionsInternalDB didb, String projectKey, String discussionId, String text, String user, long time) throws NotFoundException, SQLException {
        String replyId = SecretKeyGenerator.generate((int)8);
        Discussion.DiscussionReply reply = new Discussion.DiscussionReply(replyId, text, user, time, 0L);
        didb.saveReply(projectKey, null, discussionId, reply, true);
    }

    public void delete(DSSDBConnection conn) {
        this.clearTimelineTable(conn);
    }

    private void clearTimelineTable(DSSDBConnection conn) {
        try {
            PreparedStatement deleteTimelineItems = this.getPreparedStatement(conn, this.deleteProjectTimeline);
            logger.debugV("Deleting timeline items for %s", new Object[]{this.projectKey});
            deleteTimelineItems.setString(1, this.projectKey);
            deleteTimelineItems.execute();
            conn.commit();
        }
        catch (SQLException e) {
            logger.errorV((Throwable)e, "Failed to remove timeline items from for project %s when deleting project.", new Object[]{this.projectKey});
        }
    }

    void deleteObject(DSSDBConnection conn, ITaggingService.TaggableType objectType, String objectId) throws CodedSQLException {
        try {
            logger.info((Object)("Delete object from timeline: " + String.valueOf((Object)objectType) + " " + objectId));
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.deleteObject);
            ps2.setString(1, this.projectKey);
            ps2.setString(2, objectType.toString());
            ps2.setString(3, objectId);
            ps2.execute();
            conn.commit();
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access timelines database", (Throwable)e);
        }
    }

    void flagDeletedUser(DSSDBConnection conn, String user) throws CodedSQLException {
        try {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.flagDeletedUser);
            ps2.setString(1, user + " (deleted)");
            ps2.setString(2, this.projectKey);
            ps2.setString(3, user);
            ps2.execute();
            conn.commit();
        }
        catch (SQLException e) {
            logger.error((Object)"Failed to flag deleted user", (Throwable)e);
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access timelines database", (Throwable)e);
        }
    }

    List<TimelineItem> getForObject(DSSDBConnection conn, ITaggingService.TaggableType objectType, String objectId, int from, int limit) throws CodedSQLException {
        List<TimelineItem> list;
        block8: {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getForObject);
            ps2.setString(1, this.projectKey);
            ps2.setString(2, objectType.toString());
            ps2.setString(3, objectId);
            ps2.setInt(4, limit);
            ps2.setInt(5, from);
            ps2.execute();
            ResultSet rs2 = ps2.getResultSet();
            try {
                list = this.readAsTimelineItemsList(rs2);
                if (rs2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs2 != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access timelines database", (Throwable)e);
                }
            }
            rs2.close();
        }
        return list;
    }

    ProjectTimeline getTimeLineItemsForProject(DSSDBConnection conn, int from, int limit) throws CodedSQLException {
        try {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getForProject);
            ps2.setString(1, this.projectKey);
            ps2.setInt(2, limit);
            ps2.setInt(3, from);
            ps2.execute();
            ProjectTimeline result = new ProjectTimeline();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    try {
                        result.items.add(this.readTimelineItem(rs2));
                    }
                    catch (Exception e) {
                        logger.info((Object)"Failed to read timeline item", (Throwable)e);
                    }
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access timelines database", (Throwable)e);
        }
    }

    TimelinesService.TimelineWithVersioning getForProject(DSSDBConnection conn, int from, int limit) throws CodedSQLException {
        try {
            TimelinesService.TimelineWithVersioning ret = new TimelinesService.TimelineWithVersioning();
            ret.items.addAll(this.getTimeLineItemsForProject((DSSDBConnection)conn, (int)from, (int)limit).items);
            return ret;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access timelines database", (Throwable)e);
        }
    }

    TimelinesService.TimelineWithVersioning getForWiki(DSSDBConnection conn, int from, int limit) throws CodedSQLException {
        try {
            TimelinesService.TimelineWithVersioning ret = new TimelinesService.TimelineWithVersioning();
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getForWiki);
            ps2.setString(1, this.projectKey);
            ps2.setString(2, ITaggingService.TaggableType.ARTICLE.toString());
            ps2.setInt(3, limit);
            ps2.setInt(4, from);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    try {
                        ret.items.add(this.readTimelineItem(rs2));
                    }
                    catch (Exception e) {
                        logger.info((Object)"Failed to read timeline item", (Throwable)e);
                    }
                }
            }
            return ret;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access timelines database", (Throwable)e);
        }
    }

    Map<TaggableObjectsService.TaggableObjectRef, HeadWithVersioningInfo> getCreationAndUpdateInfoForAllObjects(DSSDBConnection conn) throws CodedSQLException {
        try {
            logger.info((Object)"Getting create/update info for all objects");
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getCreationAndUpdateInfo);
            ps2.setString(1, this.projectKey);
            ps2.execute();
            logger.debug((Object)"Statement executed");
            HashMap<TaggableObjectsService.TaggableObjectRef, HeadWithVersioningInfo> items = new HashMap<TaggableObjectsService.TaggableObjectRef, HeadWithVersioningInfo>();
            try (ResultSet rs2 = ps2.getResultSet();){
                int nb = 0;
                while (rs2.next()) {
                    ++nb;
                    TaggableObjectsService.TaggableObjectRef ref = this.makeTaggableObjectRef(rs2);
                    HeadWithVersioningInfo head = new HeadWithVersioningInfo();
                    head.lastModifiedBy = new PublicUser();
                    head.lastModifiedBy.login = rs2.getString("updatedBy");
                    head.lastModifiedOn = rs2.getLong("updated");
                    head.createdBy = new PublicUser();
                    head.createdBy.login = rs2.getString("createdBy");
                    head.createdOn = rs2.getLong("created");
                    items.put(ref, head);
                }
                logger.info((Object)("Total " + nb + " results"));
            }
            return items;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access timelines database", (Throwable)e);
        }
    }

    List<String> getContributors() {
        return Lists.newArrayList(this.cache.contributors).stream().filter(contributor -> !"no:auth".equals(contributor)).collect(Collectors.toList());
    }

    List<String> listContributors(DSSDBConnection conn, ITaggingService.TaggableType objectType, String objectId) throws CodedSQLException {
        try {
            if (objectType == ITaggingService.TaggableType.PROJECT) {
                return this.getContributors();
            }
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.listContributors);
            ps2.setString(1, this.projectKey);
            ps2.setString(2, objectType.toString());
            ps2.setString(3, objectId);
            ps2.execute();
            HashSet<String> users = new HashSet<String>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    users.add(rs2.getString(1));
                }
            }
            return Lists.newArrayList(users);
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access timelines database", (Throwable)e);
        }
    }

    List<String> listContributorsForWiki(DSSDBConnection conn) throws CodedSQLException {
        try {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.listContributorsForWiki);
            ps2.setString(1, this.projectKey);
            ps2.setString(2, ITaggingService.TaggableType.ARTICLE.toString());
            ps2.execute();
            HashSet<String> users = new HashSet<String>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    users.add(rs2.getString(1));
                }
            }
            return Lists.newArrayList(users);
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access timelines database", (Throwable)e);
        }
    }

    Map<TaggableObjectsService.TaggableObjectRef, List<TimelineItem>> getRecent(DSSDBConnection conn, long since) throws CodedSQLException {
        Map<TaggableObjectsService.TaggableObjectRef, List<TimelineItem>> map;
        block8: {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getRecent);
            ps2.setString(1, this.projectKey);
            ps2.setLong(2, since);
            ResultSet rs2 = ps2.executeQuery();
            try {
                map = this.readAsMap(rs2);
                if (rs2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs2 != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access timelines database", (Throwable)e);
                }
            }
            rs2.close();
        }
        return map;
    }

    Map<TaggableObjectsService.TaggableObjectRef, Collection<String>> getContributorsForAllObjects(DSSDBConnection conn) throws CodedSQLException {
        try {
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getAll);
            ps2.setString(1, this.projectKey);
            ps2.execute();
            HashMap<TaggableObjectsService.TaggableObjectRef, Collection<String>> ret = new HashMap<TaggableObjectsService.TaggableObjectRef, Collection<String>>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    ITaggingService.TaggableType objectType = ITaggingService.TaggableType.valueOf(rs2.getString(OBJECT_TYPE_COLUMN));
                    String objectId = rs2.getString(OBJECT_ID_COLUMN);
                    String user = rs2.getString(USER_COLUMN);
                    TaggableObjectsService.TaggableObjectRef tor = new TaggableObjectsService.TaggableObjectRef(this.projectKey, objectType, objectId);
                    if (!ret.containsKey(tor)) {
                        ret.put(tor, new HashSet());
                    }
                    ((Collection)ret.get(tor)).add(user);
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access timelines database", (Throwable)e);
        }
    }

    private String getUserCacheKey(String login) {
        return "$$$user$$$" + login;
    }

    public static class ProjectCache {
        Set<String> contributors = Collections.newSetFromMap(new ConcurrentHashMap());
        Cache<String, TimelineItem> firstItemCache = CacheBuilder.newBuilder().maximumSize(10000L).build();
        Cache<String, TimelineItem> latestItemCache = CacheBuilder.newBuilder().maximumSize(10000L).build();
    }

    @FunctionalInterface
    private static interface TimelineItemLoader {
        @Nullable
        public TimelineItem load() throws SQLException;
    }
}

