/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.shiny;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.shiny.ShinyWebAppMeta;
import java.io.File;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractShinyWebAppHandler
extends WebAppHandler {
    @Autowired
    protected VariablesService variablesService;
    protected ShinyWebAppMeta.ShinyWebAppParams params;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.shiny");

    public AbstractShinyWebAppHandler(WebApp webapp) {
        this.webapp = webapp;
        this.params = webapp.getParamsAs(ShinyWebAppMeta.ShinyWebAppParams.class);
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public void initWebApp() throws IOException {
    }

    @Override
    public void initWebAppTemplate(String templateId, File templateDir) throws IOException {
        File serverFile;
        logger.info((Object)("Init webapp with template: " + templateId));
        this.params.ui = "";
        this.params.server = "";
        File uiFile = new File(templateDir, "ui.R");
        if (uiFile.exists()) {
            this.params.ui = DKUFileUtils.readFileToStringUTF8((File)uiFile);
        }
        if ((serverFile = new File(templateDir, "server.R")).exists()) {
            this.params.server = DKUFileUtils.readFileToStringUTF8((File)serverFile);
        }
    }
}

