/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.shiny.backend;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppLaunchInfo;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.backend.AbstractWebAppBackendRunner;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendKernel;
import com.dataiku.dip.webapps.shiny.backend.ShinyWebAppDockerKernel;
import com.dataiku.dip.webapps.shiny.backend.ShinyWebAppKubernetesKernel;
import com.dataiku.dip.webapps.shiny.backend.ShinyWebAppLocalKernel;
import com.google.gson.JsonObject;
import java.io.File;

public class ShinyWebAppBackendRunner
extends AbstractWebAppBackendRunner {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.shiny");

    public ShinyWebAppBackendRunner(WebApp webApp, WebAppBackend backend, JsonObject userVariables, AuthCtx user, WebAppBackendInstance webAppBackendInstance) {
        super(webApp, backend, userVariables, user, webAppBackendInstance);
    }

    @Override
    protected WebAppBackendKernel createKernel(WebAppLaunchInfo launchInfo, WebAppSecurityInfo securityInfo, ContainerExecRuntimeConfig containerConfig, APITicketService.Ticket ticket, File workingDir, DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) {
        if (containerConfig == null) {
            return new ShinyWebAppLocalKernel(this.webApp, this.authCtx, this.userVariables, launchInfo, securityInfo, workingDir, ticket, mainLog, smartLogTailBuilder);
        }
        if (containerConfig.type == ContainerExecRuntimeConfig.Container.DOCKER) {
            return new ShinyWebAppDockerKernel(this.webApp, containerConfig, this.authCtx, this.userVariables, launchInfo, securityInfo, workingDir, ticket, mainLog, smartLogTailBuilder);
        }
        if (containerConfig.type == ContainerExecRuntimeConfig.Container.KUBERNETES) {
            return new ShinyWebAppKubernetesKernel(this.webApp, containerConfig, this.authCtx, this.userVariables, launchInfo, securityInfo, workingDir, ticket, mainLog, smartLogTailBuilder);
        }
        return null;
    }

    @Override
    public String getLivelinessPath() {
        return "/shared/shiny.js";
    }

    public static class StartCommand {
        public String projectKey;
        public String webAppId;
        public String ui;
        public String server;
        public WebAppSecurityInfo securityInfo;
    }
}

