/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.math;

import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class Min
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 0) {
            return null;
        }
        for (Object arg : args) {
            if (arg != null && !"".equals(arg)) continue;
            return null;
        }
        if (args.length >= 2 && args[0] != null) {
            Object min;
            if (args[0] instanceof Number) {
                min = (Number)args[0];
                for (Object arg : args) {
                    if (arg instanceof Number) {
                        Number nArg = (Number)arg;
                        if (!(nArg.doubleValue() < ((Number)min).doubleValue())) continue;
                        min = nArg;
                        continue;
                    }
                    return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expect all arguments to be of the same type (numbers)");
                }
                return min;
            }
            if (args[0] instanceof DateTime) {
                min = (DateTime)args[0];
                for (Object arg : args) {
                    if (arg instanceof DateTime) {
                        DateTime dArg = (DateTime)arg;
                        if (min.compareTo((ReadableInstant)dArg) <= 0) continue;
                        min = dArg;
                        continue;
                    }
                    return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expect all arguments to be of the same type (date)");
                }
                return min;
            }
            if (args[0] instanceof String) {
                min = (String)args[0];
                for (Object arg : args) {
                    if (arg instanceof String) {
                        String sArg = (String)arg;
                        if (((String)min).compareTo(sArg) <= 0) continue;
                        min = sArg;
                        continue;
                    }
                    return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expect all arguments to be of the same type (string)");
                }
                return min;
            }
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects at least 2 arguments");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Min.DOCUMENTATION", "Returns the smaller of N numbers or N strings or N dates.").withParams("a, b ...").withReturns("number, string or date").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("-1", "5", "3").returns("-1")).withExample(Example.with("\"luke\"", "\"leia\"").returns("\"leia\""));
    }
}

