/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.math;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class Pow
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2 && args[0] instanceof Number && args[1] instanceof Number) {
            return Math.pow(((Number)args[0]).doubleValue(), ((Number)args[1]).doubleValue());
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects two numbers");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Pow.DOCUMENTATION", "Returns <code>a</code> to the power of <code>b</code>.").withParams("number a, number b").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("2", "-1").returns("0.5"));
    }
}

