/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import com.dataiku.dip.input.formats.hive.serde.DSSInspectionException;
import org.apache.hadoop.hive.serde2.objectinspector.DSSBaseInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DSSAbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableFloatObjectInspector;
import org.apache.hadoop.io.DoubleWritable;

public class DSSFloatInspector
extends DSSAbstractPrimitiveJavaObjectInspector
implements SettableFloatObjectInspector {
    public DSSFloatInspector() {
        super(floatTypeInfo);
    }

    public Object create(float value) {
        return Float.valueOf(value);
    }

    public Object set(Object o, float value) {
        return Float.valueOf(value);
    }

    public Object getPrimitiveWritableObject(Object o) {
        return o == null ? null : new DoubleWritable((double)this.get(o));
    }

    public float get(Object o) {
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        if (o instanceof String) {
            try {
                return Float.valueOf((String)o).floatValue();
            }
            catch (NumberFormatException e) {
                throw new DSSInspectionException((DSSBaseInspector)this, (Throwable)e);
            }
        }
        throw new DSSInspectionException((DSSBaseInspector)this, "Not a float: " + String.valueOf(o) + " (" + o.getClass().getSimpleName() + ")");
    }
}

