/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.oauth2;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.ApiClient;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.oauth2.CreateServicePrincipalFederationPolicyRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.oauth2.DeleteServicePrincipalFederationPolicyRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.oauth2.FederationPolicy;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.oauth2.GetServicePrincipalFederationPolicyRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.oauth2.ListFederationPoliciesResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.oauth2.ListServicePrincipalFederationPoliciesRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.oauth2.ServicePrincipalFederationPolicyImpl;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.oauth2.ServicePrincipalFederationPolicyService;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.oauth2.UpdateServicePrincipalFederationPolicyRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Generated;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ServicePrincipalFederationPolicyAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ServicePrincipalFederationPolicyAPI.class);
    private final ServicePrincipalFederationPolicyService impl;

    public ServicePrincipalFederationPolicyAPI(ApiClient apiClient) {
        this.impl = new ServicePrincipalFederationPolicyImpl(apiClient);
    }

    public ServicePrincipalFederationPolicyAPI(ServicePrincipalFederationPolicyService mock) {
        this.impl = mock;
    }

    public FederationPolicy create(long servicePrincipalId) {
        return this.create(new CreateServicePrincipalFederationPolicyRequest().setServicePrincipalId(servicePrincipalId));
    }

    public FederationPolicy create(CreateServicePrincipalFederationPolicyRequest request) {
        return this.impl.create(request);
    }

    public void delete(long servicePrincipalId, String policyId) {
        this.delete(new DeleteServicePrincipalFederationPolicyRequest().setServicePrincipalId(servicePrincipalId).setPolicyId(policyId));
    }

    public void delete(DeleteServicePrincipalFederationPolicyRequest request) {
        this.impl.delete(request);
    }

    public FederationPolicy get(long servicePrincipalId, String policyId) {
        return this.get(new GetServicePrincipalFederationPolicyRequest().setServicePrincipalId(servicePrincipalId).setPolicyId(policyId));
    }

    public FederationPolicy get(GetServicePrincipalFederationPolicyRequest request) {
        return this.impl.get(request);
    }

    public Iterable<FederationPolicy> list(long servicePrincipalId) {
        return this.list(new ListServicePrincipalFederationPoliciesRequest().setServicePrincipalId(servicePrincipalId));
    }

    public Iterable<FederationPolicy> list(ListServicePrincipalFederationPoliciesRequest request) {
        return new Paginator(request, this.impl::list, ListFederationPoliciesResponse::getPolicies, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public FederationPolicy update(long servicePrincipalId, String policyId, String updateMask) {
        return this.update(new UpdateServicePrincipalFederationPolicyRequest().setServicePrincipalId(servicePrincipalId).setPolicyId(policyId).setUpdateMask(updateMask));
    }

    public FederationPolicy update(UpdateServicePrincipalFederationPolicyRequest request) {
        return this.impl.update(request);
    }

    public ServicePrincipalFederationPolicyService impl() {
        return this.impl;
    }
}

