/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.google.auth.oauth2;

import com.dataiku.dss.shadelibdatabricks.com.google.auth.oauth2.AccessToken;
import com.dataiku.dss.shadelibdatabricks.com.google.auth.oauth2.OAuth2Credentials;
import com.dataiku.dss.shadelibdatabricks.com.google.common.base.Preconditions;
import java.io.IOException;

public class OAuth2CredentialsWithRefresh
extends OAuth2Credentials {
    private final OAuth2RefreshHandler refreshHandler;

    protected OAuth2CredentialsWithRefresh(Builder builder) {
        super(builder.getAccessToken(), builder.getRefreshMargin(), builder.getExpirationMargin());
        if (builder.getAccessToken() != null && builder.getAccessToken().getExpirationTime() == null) {
            throw new IllegalArgumentException("The provided access token must contain the expiration time.");
        }
        this.refreshHandler = Preconditions.checkNotNull(builder.refreshHandler);
    }

    protected OAuth2CredentialsWithRefresh(AccessToken accessToken, OAuth2RefreshHandler refreshHandler) {
        super(accessToken);
        if (accessToken != null && accessToken.getExpirationTime() == null) {
            throw new IllegalArgumentException("The provided access token must contain the expiration time.");
        }
        this.refreshHandler = Preconditions.checkNotNull(refreshHandler);
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        return this.refreshHandler.refreshAccessToken();
    }

    public OAuth2RefreshHandler getRefreshHandler() {
        return this.refreshHandler;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends OAuth2Credentials.Builder {
        private OAuth2RefreshHandler refreshHandler;

        private Builder() {
        }

        @Override
        public Builder setAccessToken(AccessToken token) {
            super.setAccessToken(token);
            return this;
        }

        public Builder setRefreshHandler(OAuth2RefreshHandler handler) {
            this.refreshHandler = handler;
            return this;
        }

        @Override
        public OAuth2CredentialsWithRefresh build() {
            return new OAuth2CredentialsWithRefresh(this);
        }
    }

    public static interface OAuth2RefreshHandler {
        public AccessToken refreshAccessToken() throws IOException;
    }
}

