/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.builders;

import com.dataiku.dss.shadelib.com.google.gson.JsonDeserializationContext;
import com.dataiku.dss.shadelib.com.google.gson.JsonDeserializer;
import com.dataiku.dss.shadelib.com.google.gson.JsonElement;
import com.dataiku.dss.shadelib.com.google.gson.JsonObject;
import com.dataiku.dss.shadelib.com.google.gson.JsonParseException;
import com.dataiku.scoring.builders.BuildUtils;
import com.dataiku.scoring.pipelines.Binarizer;
import com.dataiku.scoring.pipelines.CategoricalEncoder;
import com.dataiku.scoring.pipelines.CountVectorizer;
import com.dataiku.scoring.pipelines.DatetimeCyclicalEncoder;
import com.dataiku.scoring.pipelines.DerivativesGenerator;
import com.dataiku.scoring.pipelines.DropRow;
import com.dataiku.scoring.pipelines.Dummifier;
import com.dataiku.scoring.pipelines.FeatureSelection;
import com.dataiku.scoring.pipelines.Flagger;
import com.dataiku.scoring.pipelines.HashingVectorizer;
import com.dataiku.scoring.pipelines.ImputeWithValue;
import com.dataiku.scoring.pipelines.Interactions;
import com.dataiku.scoring.pipelines.Processor;
import com.dataiku.scoring.pipelines.Rescaler;
import com.dataiku.scoring.pipelines.TfidfVectorizer;
import com.dataiku.scoring.pipelines.Tokenizer;
import com.dataiku.scoring.pipelines.UnfoldVectors;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

abstract class ProcessorBuilder<T extends Processor> {
    static final Logger logger = Logger.getLogger("dku.scoring");

    ProcessorBuilder() {
    }

    abstract T buildFrom(URL var1) throws IOException;

    static {
        BuildUtils.registerAdapter(SelectionParams.class, new JsonDeserializer<SelectionParams>(){

            public SelectionParams deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObj = json.getAsJsonObject();
                SelectionMethod method = SelectionMethod.valueOf(jsonObj.get("method").getAsString());
                Object selectionParams = null;
                switch (method) {
                    case DROP: {
                        selectionParams = new Object();
                        break;
                    }
                    case PCA: {
                        selectionParams = context.deserialize(jsonObj.get("selection_params"), PCAData.class);
                    }
                }
                SelectionParams par = new SelectionParams();
                par.method = method;
                par.selection_params = selectionParams;
                return par;
            }
        });
    }

    static class SelectionParams {
        SelectionMethod method;
        Object selection_params;

        SelectionParams() {
        }
    }

    static class SelectionBuilder
    extends ProcessorBuilder<Processor> {
        SelectionBuilder() {
        }

        @Override
        Processor buildFrom(URL resources) throws IOException {
            SelectionParams par = BuildUtils.parseURL(new URL(resources, "feature_selection.json"), SelectionParams.class);
            switch (par.method) {
                case DROP: {
                    return new FeatureSelection.Drop();
                }
                case PCA: {
                    PCAData dat = (PCAData)par.selection_params;
                    return new FeatureSelection.PCA(dat.sparse, dat.rot, dat.explained_variance, dat.means, dat.input_names);
                }
            }
            throw new IllegalArgumentException("Method " + String.valueOf((Object)par.method) + " unknown for feature selection.");
        }
    }

    static class PCAData {
        double[] explained_variance;
        double[] means;
        double[][] rot;
        boolean sparse;
        String[] input_names;

        PCAData() {
        }
    }

    static enum SelectionMethod {
        DROP,
        PCA;

    }

    static class InteractionBuilder
    extends ProcessorBuilder<Interactions> {
        InteractionBuilder() {
        }

        @Override
        Interactions buildFrom(URL resources) throws IOException {
            int i;
            ArrayList<Interactions.Interaction> interactions = new ArrayList<Interactions.Interaction>();
            try {
                NumNumData num_num = BuildUtils.parseURL(new URL(resources, "num_num.json"), NumNumData.class);
                for (i = 0; i < num_num.column_1.length; ++i) {
                    interactions.add(new Interactions.NumericalNumericalInteraction(num_num.column_1[i], num_num.column_2[i], num_num.rescale[i], num_num.shift[i], num_num.inv_scale[i]));
                }
            }
            catch (IOException num_num) {
                // empty catch block
            }
            try {
                NumCatData num_cat = BuildUtils.parseURL(new URL(resources, "num_cat.json"), NumCatData.class);
                for (i = 0; i < num_cat.cat.length; ++i) {
                    interactions.add(new Interactions.NumericalCategoricalInteraction(num_cat.num[i], num_cat.cat[i], new HashSet<String>(num_cat.values[i])));
                }
            }
            catch (IOException num_cat) {
                // empty catch block
            }
            try {
                CatCatData cat_cat = BuildUtils.parseURL(new URL(resources, "cat_cat.json"), CatCatData.class);
                for (i = 0; i < cat_cat.column_1.length; ++i) {
                    HashSet<Interactions.CategoricalCategoricalInteraction.StringPair> sps = new HashSet<Interactions.CategoricalCategoricalInteraction.StringPair>();
                    for (Object[] objectArray : cat_cat.values[i]) {
                        logger.info("ab " + Arrays.toString(objectArray));
                        sps.add(new Interactions.CategoricalCategoricalInteraction.StringPair((String)objectArray[0], (String)objectArray[1]));
                    }
                    interactions.add(new Interactions.CategoricalCategoricalInteraction(cat_cat.column_1[i], cat_cat.column_2[i], sps));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (interactions.isEmpty()) {
                throw new IOException();
            }
            return new Interactions(interactions);
        }
    }

    static class CatCatData {
        public String[] column_1;
        public String[] column_2;
        public List<String[]>[] values;

        CatCatData() {
        }
    }

    static class NumCatData {
        public String[] num;
        public String[] cat;
        public List<String>[] values;

        NumCatData() {
        }
    }

    static class NumNumData {
        public String[] column_1;
        public String[] column_2;
        public Boolean[] rescale;
        public Double[] shift;
        public Double[] inv_scale;

        NumNumData() {
        }
    }

    static class DropRowBuilder
    extends ProcessorBuilder<DropRow> {
        DropRowBuilder() {
        }

        @Override
        DropRow buildFrom(URL resources) throws IOException {
            OnlyColumnsData data = BuildUtils.parseURL(new URL(resources, "drop_rows.json"), OnlyColumnsData.class);
            return new DropRow(data.columns);
        }
    }

    static class DerivativesRescalerBuilder
    extends ProcessorBuilder<Rescaler> {
        DerivativesRescalerBuilder() {
        }

        @Override
        Rescaler buildFrom(URL resources) throws IOException {
            OnlyColumnsData cols = BuildUtils.parseURL(new URL(resources, "derivatives.json"), OnlyColumnsData.class);
            HashSet<String> toKeep = new HashSet<String>();
            for (String c : cols.columns) {
                toKeep.add(DerivativesGenerator.logName(c));
                toKeep.add(DerivativesGenerator.sqrtName(c));
                toKeep.add(DerivativesGenerator.squareName(c));
            }
            RescalerBuilder.RescalerData data = BuildUtils.parseURL(new URL(resources, "rescalers.json"), RescalerBuilder.RescalerData.class);
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<Double> shifts = new ArrayList<Double>();
            ArrayList<Double> invScales = new ArrayList<Double>();
            for (int i = 0; i < data.columns.length; ++i) {
                String col = data.columns[i];
                if (!toKeep.contains(col)) continue;
                columns.add(col);
                shifts.add(data.shifts[i]);
                invScales.add(data.inv_scales[i]);
            }
            return new Rescaler(columns, shifts, invScales);
        }
    }

    static class DerivativesBuilder
    extends ProcessorBuilder<DerivativesGenerator> {
        DerivativesBuilder() {
        }

        @Override
        DerivativesGenerator buildFrom(URL resources) throws IOException {
            OnlyColumnsData data = BuildUtils.parseURL(new URL(resources, "derivatives.json"), OnlyColumnsData.class);
            return new DerivativesGenerator(data.columns);
        }
    }

    static class OnlyColumnsData {
        String[] columns;

        OnlyColumnsData() {
        }
    }

    static class DatetimeCyclicalEncodingBuilder
    extends ProcessorBuilder<DatetimeCyclicalEncoder> {
        DatetimeCyclicalEncodingBuilder() {
        }

        @Override
        DatetimeCyclicalEncoder buildFrom(URL resources) throws IOException {
            DatetimeCyclicalEncodingData data = BuildUtils.parseURL(new URL(resources, "datetime_cyclical.json"), DatetimeCyclicalEncodingData.class);
            return new DatetimeCyclicalEncoder(data.mapping);
        }
    }

    public static class DatetimeCyclicalEncodingData {
        public Map<String, Set<DatetimeCyclicalEncoder.Period>> mapping;
    }

    static class CategoricalEncodingBuilder
    extends ProcessorBuilder<CategoricalEncoder> {
        CategoricalEncodingBuilder() {
        }

        @Override
        CategoricalEncoder buildFrom(URL resources) throws IOException {
            CategoricalEncodingData data = BuildUtils.parseURL(new URL(resources, "impact_coded.json"), CategoricalEncodingData.class);
            return new CategoricalEncoder(data.columns, data.levels, data.outputNames, data.encodings, data.defaults);
        }
    }

    static class CategoricalEncodingData {
        String[] columns;
        String[][] levels;
        double[][][] encodings;
        double[][] defaults;
        String[][] outputNames;

        CategoricalEncodingData() {
        }
    }

    static class HashingVectorizerBuilder
    extends ProcessorBuilder<HashingVectorizer> {
        HashingVectorizerBuilder() {
        }

        @Override
        HashingVectorizer buildFrom(URL resources) throws IOException {
            HashingVectorizerData data = BuildUtils.parseURL(new URL(resources, "hashed.json"), HashingVectorizerData.class);
            int size = data.columns.length;
            Tokenizer[] tokenizers = new Tokenizer[size];
            if ("MLLIB".equals(data.origin)) {
                for (int i = 0; i < size; ++i) {
                    tokenizers[i] = new Tokenizer("(?u)\\b\\w\\w+\\b", data.stop_words[i], 1, 1, false);
                }
            } else {
                throw new UnsupportedOperationException("Origin " + data.origin + " not supported for hashing vectorization.");
            }
            return new HashingVectorizer(data.columns, HashingVectorizer.Method.MLLIB, tokenizers, data.num_features);
        }
    }

    static class HashingVectorizerData {
        String[] columns;
        int[] num_features;
        String origin;
        String[][] stop_words;

        HashingVectorizerData() {
        }
    }

    static class TfidfVectorizerBuilder
    extends ProcessorBuilder<TfidfVectorizer> {
        TfidfVectorizerBuilder() {
        }

        @Override
        TfidfVectorizer buildFrom(URL resources) throws IOException {
            TfidfVectorizerData data = BuildUtils.parseURL(new URL(resources, "tfidf.json"), TfidfVectorizerData.class);
            int size = data.column.length;
            Tokenizer[] tokenizers = new Tokenizer[size];
            if (data.origin.equals("SCIKIT")) {
                for (int i = 0; i < data.column.length; ++i) {
                    tokenizers[i] = new Tokenizer("(?u)\\b\\w\\w+\\b", data.stop_words[i], data.min_n_grams[i], data.max_n_grams[i], true);
                }
            } else {
                throw new UnsupportedOperationException("Origin " + data.origin + " not supported for count vectorization.");
            }
            return new TfidfVectorizer(data.column, tokenizers, data.vocabulary, data.idf, data.norm, data.output_names);
        }
    }

    static class TfidfVectorizerData
    extends CountVectorizerData {
        TfidfVectorizer.Normalization[] norm;
        String[][] output_names;
        double[][] idf;

        TfidfVectorizerData() {
        }
    }

    static class CountVectorizerBuilder
    extends ProcessorBuilder<CountVectorizer> {
        CountVectorizerBuilder() {
        }

        @Override
        CountVectorizer buildFrom(URL resources) throws IOException {
            CountVectorizerData data = BuildUtils.parseURL(new URL(resources, "word_counts.json"), CountVectorizerData.class);
            int size = data.column.length;
            Tokenizer[] tokenizers = new Tokenizer[size];
            if (data.origin.equals("SCIKIT")) {
                for (int i = 0; i < data.column.length; ++i) {
                    tokenizers[i] = new Tokenizer("(?u)\\b\\w\\w+\\b", data.stop_words[i], data.min_n_grams[i], data.max_n_grams[i], true);
                }
            } else {
                throw new UnsupportedOperationException("Origin " + data.origin + " not supported for count vectorization.");
            }
            return new CountVectorizer(data.column, tokenizers, data.vocabulary);
        }
    }

    static class CountVectorizerData {
        String[] column;
        String[][] vocabulary;
        String[][] stop_words;
        int[] min_n_grams;
        int[] max_n_grams;
        String origin;

        CountVectorizerData() {
        }
    }

    static class BinarizerBuilder
    extends ProcessorBuilder<Binarizer> {
        BinarizerBuilder() {
        }

        @Override
        Binarizer buildFrom(URL resources) throws IOException {
            BinarizerData data = BuildUtils.parseURL(new URL(resources, "binarized.json"), BinarizerData.class);
            return new Binarizer(data.columns, data.output_name, data.thresholds);
        }

        static class BinarizerData {
            String[] columns;
            String[] output_name;
            double[] thresholds;

            BinarizerData() {
            }
        }
    }

    static class FlaggerBuilder
    extends ProcessorBuilder<Flagger> {
        FlaggerBuilder() {
        }

        @Override
        Flagger buildFrom(URL resources) throws IOException {
            FlaggerData data = BuildUtils.parseURL(new URL(resources, "flagged.json"), FlaggerData.class);
            return new Flagger(data.columns, data.output_names);
        }

        static class FlaggerData {
            String[] columns;
            String[] output_names;

            FlaggerData() {
            }
        }
    }

    static class RescalerBuilder
    extends ProcessorBuilder<Rescaler> {
        RescalerBuilder() {
        }

        @Override
        Rescaler buildFrom(URL resources) throws IOException {
            RescalerData rescalerData = BuildUtils.parseURL(new URL(resources, "rescalers.json"), RescalerData.class);
            return new Rescaler(rescalerData.columns, rescalerData.shifts, rescalerData.inv_scales);
        }

        public static class RescalerData {
            String[] columns;
            double[] shifts;
            double[] inv_scales;
        }
    }

    static class ImputeBuilder
    extends ProcessorBuilder<ImputeWithValue> {
        ImputeBuilder() {
        }

        @Override
        public ImputeWithValue buildFrom(URL resources) throws IOException {
            int i;
            ImputeData imputeData = BuildUtils.parseURL(new URL(resources, "imputed.json"), ImputeData.class);
            HashMap<String, Object> mapping = new HashMap<String, Object>();
            for (i = 0; i < imputeData.cat_columns.length; ++i) {
                mapping.put(imputeData.cat_columns[i], imputeData.cat_values[i]);
            }
            for (i = 0; i < imputeData.num_columns.length; ++i) {
                mapping.put(imputeData.num_columns[i], imputeData.num_values[i]);
            }
            return new ImputeWithValue(mapping, false);
        }

        public static class ImputeData {
            public String[] cat_columns;
            public String[] num_columns;
            public String[] cat_values;
            public Double[] num_values;
        }
    }

    static class UnfoldVectorsBuilder
    extends ProcessorBuilder<UnfoldVectors> {
        UnfoldVectorsBuilder() {
        }

        @Override
        UnfoldVectors buildFrom(URL resources) throws IOException {
            UnfoldVectorsData unfoldData = BuildUtils.parseURL(new URL(resources, "vectors-unfold.json"), UnfoldVectorsData.class);
            String[] columns = new String[unfoldData.vector_lengths.size()];
            int[] vectorLengths = new int[unfoldData.vector_lengths.size()];
            int i = 0;
            for (Map.Entry<String, Integer> uc : unfoldData.vector_lengths.entrySet()) {
                columns[i] = uc.getKey();
                vectorLengths[i] = uc.getValue();
                ++i;
            }
            return new UnfoldVectors(columns, vectorLengths);
        }

        private static class UnfoldVectorsData {
            Map<String, Integer> vector_lengths;

            private UnfoldVectorsData() {
            }
        }
    }

    static class DummifierBuilder
    extends ProcessorBuilder<Dummifier> {
        DummifierBuilder() {
        }

        @Override
        public Dummifier buildFrom(URL resources) throws IOException {
            DummyData dumData = BuildUtils.parseURL(new URL(resources, "dummies.json"), DummyData.class);
            String[] dummified = new String[dumData.details.size()];
            ArrayList<Set<String>> levels = new ArrayList<Set<String>>();
            boolean[] withOthers = new boolean[dumData.details.size()];
            int i = 0;
            for (Map.Entry<String, DummyData.DummyDetails> e : dumData.details.entrySet()) {
                dummified[i] = e.getKey();
                levels.add(new HashSet<String>(e.getValue().levels));
                withOthers[i] = e.getValue().with_others;
                ++i;
            }
            return new Dummifier(dummified, levels, withOthers);
        }

        private static class DummyData {
            Map<String, DummyDetails> details;

            private DummyData() {
            }

            static class DummyDetails {
                public boolean with_others;
                public List<String> levels;

                DummyDetails() {
                }
            }
        }
    }
}

