/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.scoring.pipelines.Processor;
import com.dataiku.scoring.util.RawObservation;
import java.util.List;
import java.util.Set;

public class Dummifier
implements Processor {
    private static final String N_A = "N/A";
    private static final String OTHERS = "__Others__";
    private static final long serialVersionUID = 0L;
    private final String[] columns;
    private final List<Set<String>> levels;
    private final boolean[] withOthers;

    public Dummifier(String[] columns, List<Set<String>> levels, boolean[] withOthers) {
        this.columns = columns;
        this.levels = levels;
        this.withOthers = withOthers;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public List<Set<String>> getLevels() {
        return this.levels;
    }

    public boolean[] getWithOthers() {
        return this.withOthers;
    }

    public static String dummifyName(String col, String level) {
        return "dummy:" + col + ":" + level;
    }

    @Override
    public void process(RawObservation data) {
        for (int i = 0; i < this.columns.length; ++i) {
            String col = this.columns[i];
            String level = (String)data.get(col);
            if (level == null) {
                data.put(Dummifier.dummifyName(col, N_A), 1.0);
                continue;
            }
            if (this.levels.get(i).contains(level)) {
                data.put(Dummifier.dummifyName(col, level), 1.0);
                continue;
            }
            if (!this.withOthers[i]) continue;
            data.put(Dummifier.dummifyName(col, OTHERS), 1.0);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append("Dummifier(");
        for (int i = 0; i < this.columns.length; ++i) {
            s.append(this.columns[i]).append(" in [");
            for (String l : this.levels.get(i)) {
                s.append(l).append(", ");
            }
            s.append("]");
            if (i == this.columns.length - 1) continue;
            s.append(" ; ");
        }
        return s.append(")").toString();
    }
}

