/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.joauth.keyvalue;

import com.twitter.joauth.Request;
import com.twitter.joauth.keyvalue.Transformer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface KeyValueHandler {
    public static final KeyValueHandler NULL_KEY_VALUE_HANDLER = new NullKeyValueHandler();

    public void handle(String var1, String var2);

    public static class OneKeyOnlyKeyValueHandler
    implements KeyValueHandler {
        private boolean invoked = false;
        private String _key = null;

        @Override
        public void handle(String key, String value) {
            if (this.invoked) {
                if (this._key != null) {
                    this._key = null;
                }
            } else {
                this.invoked = true;
                if (value == null || value.equals("")) {
                    this._key = key;
                }
            }
        }

        public String getKey() {
            return this._key;
        }
    }

    public static class UrlEncodingNormalizingKeyValueHandler
    extends TransformingKeyValueHandler {
        public UrlEncodingNormalizingKeyValueHandler(KeyValueHandler underlying) {
            super(underlying, Transformer.URL_ENCODING_NORMALIZING_TRANSFORMER, Transformer.URL_ENCODING_NORMALIZING_TRANSFORMER);
        }
    }

    public static class ValueTransformingKeyValueHandler
    extends TransformingKeyValueHandler {
        public ValueTransformingKeyValueHandler(KeyValueHandler underlying, Transformer valueTransformer) {
            super(underlying, null, valueTransformer);
        }

        @Override
        public void handle(String key, String value) {
            this.underlying.handle(key, this.valueTransformer.transform(value));
        }
    }

    public static class KeyTransformingKeyValueHandler
    extends TransformingKeyValueHandler {
        public KeyTransformingKeyValueHandler(KeyValueHandler underlying, Transformer keyTransformer) {
            super(underlying, keyTransformer, null);
        }

        @Override
        public void handle(String key, String value) {
            this.underlying.handle(this.keyTransformer.transform(key), value);
        }
    }

    public static class TrimmingKeyValueHandler
    extends TransformingKeyValueHandler {
        public TrimmingKeyValueHandler(KeyValueHandler underlying) {
            super(underlying, Transformer.TRIM_TRANSFORMER, Transformer.TRIM_TRANSFORMER);
        }
    }

    public static class TransformingKeyValueHandler
    implements KeyValueHandler {
        protected final KeyValueHandler underlying;
        protected final Transformer keyTransformer;
        protected final Transformer valueTransformer;

        public TransformingKeyValueHandler(KeyValueHandler underlying, Transformer keyTransformer, Transformer valueTransformer) {
            this.underlying = underlying;
            this.keyTransformer = keyTransformer;
            this.valueTransformer = valueTransformer;
        }

        @Override
        public void handle(String key, String value) {
            this.underlying.handle(this.keyTransformer.transform(key), this.valueTransformer.transform(value));
        }
    }

    public static class PrintlnKeyValueHandler
    implements KeyValueHandler {
        private final String prefix;

        public PrintlnKeyValueHandler(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public void handle(String key, String value) {
            System.out.println(String.format("%s%s=%s", this.prefix, key, value));
        }
    }

    public static class MaybeQuotedValueKeyValueHandler
    implements KeyValueHandler {
        private final KeyValueHandler underlying;

        public MaybeQuotedValueKeyValueHandler(KeyValueHandler underlying) {
            this.underlying = underlying;
        }

        @Override
        public void handle(String key, String value) {
            String trimmed = value.trim();
            if (trimmed.length() > 1 && trimmed.charAt(0) == '\"' && trimmed.charAt(trimmed.length() - 1) == '\"') {
                this.underlying.handle(key, trimmed.substring(1, trimmed.length() - 1));
            } else {
                this.underlying.handle(key, value);
            }
        }
    }

    public static class SingleKeyValueHandler
    implements KeyValueHandler {
        private final Map<String, String> kv = new LinkedHashMap<String, String>();

        @Override
        public void handle(String key, String value) {
            this.kv.put(key, value);
        }

        public Map<String, String> toMap() {
            return this.kv;
        }

        public List<Request.Pair> toList() {
            Iterator<Map.Entry<String, String>> iterator = this.kv.entrySet().iterator();
            ArrayList<Request.Pair> list = new ArrayList<Request.Pair>(this.kv.size());
            while (iterator.hasNext()) {
                Map.Entry<String, String> next = iterator.next();
                list.add(new Request.Pair(next.getKey(), next.getValue()));
            }
            return list;
        }
    }

    public static class DuplicateKeyValueHandler
    implements KeyValueHandler {
        private final List<Request.Pair> buffer = new ArrayList<Request.Pair>();

        @Override
        public void handle(String key, String value) {
            this.buffer.add(new Request.Pair(key, value));
        }

        public List<Request.Pair> toList() {
            return this.buffer;
        }
    }

    public static class NullKeyValueHandler
    implements KeyValueHandler {
        @Override
        public void handle(String key, String value) {
        }
    }
}

