/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.arrow.vector;

import com.databricks.client.jdbc42.internal.apache.arrow.memory.BufferAllocator;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.BitVectorHelper;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.NullCheckingForGet;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.TimeStampVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.ValueIterableVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.ValueVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl.TimeStampMicroReaderImpl;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.reader.FieldReader;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableTimeStampMicroHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.TimeStampMicroHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.Types;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.Field;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.FieldType;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.util.DateUtility;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.util.TransferPair;
import java.time.LocalDateTime;

public final class TimeStampMicroVector
extends TimeStampVector
implements ValueIterableVector<LocalDateTime> {
    public TimeStampMicroVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.TIMESTAMPMICRO.getType()), allocator);
    }

    public TimeStampMicroVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, fieldType, allocator);
    }

    public TimeStampMicroVector(Field field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new TimeStampMicroReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMESTAMPMICRO;
    }

    public void get(int index, NullableTimeStampMicroHolder holder) {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getLong((long)index * 8L);
    }

    @Override
    public LocalDateTime getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        long micros = this.valueBuffer.getLong((long)index * 8L);
        return DateUtility.getLocalDateTimeFromEpochMicro(micros);
    }

    public void set(int index, NullableTimeStampMicroHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, TimeStampMicroHolder holder) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, NullableTimeStampMicroHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, TimeStampMicroHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        TimeStampMicroVector to = new TimeStampMicroVector(ref, this.field.getFieldType(), allocator);
        return new TimeStampVector.TransferImpl(this, to);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        TimeStampMicroVector to = new TimeStampMicroVector(field, allocator);
        return new TimeStampVector.TransferImpl(this, to);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TimeStampVector.TransferImpl(this, (TimeStampMicroVector)to);
    }
}

