/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.mail;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.integrations.IntegrationChannelMeta;
import com.dataiku.dip.integrations.IntegrationChannelParams;
import com.dataiku.dip.integrations.mail.AbstractMailSender;
import com.dataiku.dip.integrations.mail.MailChannelConfiguration;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.aws.AWSClientBrokerService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.SdkBytes;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sesv2.SesV2Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sesv2.SesV2ClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sesv2.model.EmailContent;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sesv2.model.RawMessage;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sesv2.model.SendEmailRequest;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import org.springframework.beans.factory.annotation.Autowired;

public class AWSMailSender
extends AbstractMailSender {
    public static final IntegrationChannelMeta CHANNEL_META = new IntegrationChannelMeta(){

        @Override
        public String getType() {
            return "aws-ses-mail";
        }

        @Override
        public Class<? extends IntegrationChannelParams> paramsClass() {
            return AWSChannelConfiguration.class;
        }

        @Override
        public String getAssociatedIntegrationType() {
            return "mail-scenario";
        }
    };
    private final AWSChannelConfiguration channelParams;
    @Autowired
    private PasswordEncryptionService symmetricCryptoService;
    @Autowired
    private AWSClientBrokerService awsClientBrokerService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.sender.aws");

    public AWSMailSender(AWSChannelConfiguration channelParams) {
        this.channelParams = channelParams;
        SpringUtils.getInstance().autowire(this);
    }

    @Override
    public MailChannelConfiguration getConfiguration() {
        return this.channelParams;
    }

    @Override
    public Session newSession() {
        return Session.getInstance((Properties)new Properties());
    }

    @Override
    public void send(Session session, Message mail, InfoMessage.InfoMessages messages) throws Exception {
        try {
            logger.info((Object)"Attempting to send an email through Amazon SES by using the AWS SDK for Java...");
            AWSMailSender.filterMailRecipients(this.channelParams.authorizedDomain, mail, messages);
            RawMessage rawMessage = AWSMailSender.buildRawMessage(mail);
            SendEmailRequest.Builder sendEmailRequestBuilder = SendEmailRequest.builder();
            sendEmailRequestBuilder.content((EmailContent)EmailContent.builder().raw(rawMessage).build());
            try (SesV2Client client = (SesV2Client)this.initializeSesV2ClientBuilder().build();){
                client.sendEmail((SendEmailRequest)sendEmailRequestBuilder.build());
            }
            logger.info((Object)"Email sent!");
        }
        catch (Exception ex) {
            logger.error((Object)"Email not sent: ", (Throwable)ex);
            throw ex;
        }
    }

    private SesV2ClientBuilder initializeSesV2ClientBuilder() {
        String secretKey = this.symmetricCryptoService.decryptIfEncrypted(this.channelParams.secretKey);
        AwsBasicCredentials credentials = AwsBasicCredentials.builder().accessKeyId(this.channelParams.accessKey).secretAccessKey(secretKey).build();
        SesV2ClientBuilder sesV2ClientBuilder = this.awsClientBrokerService.createSesV2ClientBuilder();
        sesV2ClientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials));
        try {
            AWSClientBrokerService.setRegionOrEndpoint(this.channelParams.regionOrEndpoint, sesV2ClientBuilder);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid channel configuration: error setting endpoint: " + this.channelParams.regionOrEndpoint, e);
        }
        return sesV2ClientBuilder;
    }

    private static RawMessage buildRawMessage(Message mail) throws IOException, MessagingException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        mail.writeTo((OutputStream)outputStream);
        return (RawMessage)RawMessage.builder().data(SdkBytes.fromByteArray((byte[])outputStream.toByteArray())).build();
    }

    @Override
    public Future<InfoMessage.InfoMessages> startSending(Session session, Message mail) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<InfoMessage.InfoMessages> task = executor.submit(() -> {
            InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
            this.send(session, mail, infoMessages);
            return infoMessages;
        });
        executor.shutdown();
        return task;
    }

    @UIModel
    public static class AWSChannelConfiguration
    extends MailChannelConfiguration {
        public String accessKey;
        public String secretKey;
        public String regionOrEndpoint;

        @Override
        public void encryptFields(PasswordEncryptionService cryptoService) {
            this.secretKey = cryptoService.encryptIfNotEncryptedOrEmpty(this.secretKey);
        }
    }
}

