/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.azure;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.auth.ServerAuthenticationFailure;
import com.dataiku.dip.security.auth.UserAttributes;
import com.dataiku.dip.security.auth.UserIdentity;
import com.dataiku.dip.security.auth.UserNotFoundException;
import com.dataiku.dip.security.auth.UserQueryFilter;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.auth.UserSupplier;
import com.dataiku.dip.security.auth.UserSupplierSettings;
import com.dataiku.dip.security.azure.AzureADSettings;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpClient;
import com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.OkHttpAsyncHttpClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.identity.ClientCertificateCredentialBuilder;
import com.dataiku.dss.shadelibazure.com.azure.identity.ClientSecretCredentialBuilder;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonElement;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.authentication.IAuthenticationProvider;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.core.ClientException;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.httpcore.HttpClients;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.Group;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.User;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.options.Option;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.DirectoryObjectCollectionReferenceRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.DirectoryObjectCollectionWithReferencesPage;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.DirectoryObjectCollectionWithReferencesRequestBuilder;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.GraphServiceClient;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.GroupCollectionPage;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.GroupCollectionRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.GroupCollectionRequestBuilder;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.UserCollectionPage;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.UserCollectionRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.UserCollectionRequestBuilder;
import com.dataiku.dss.shadelibazure.okhttp3.OkHttpClient;
import com.dataiku.dss.shadelibazure.okhttp3.Request;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AzureADUserSupplier
implements UserSupplier {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth.azuread");
    private static final Logger log = LoggerFactory.getLogger(AzureADUserSupplier.class);
    private final PasswordEncryptionService passwordEncryptionService;
    protected AzureADSettings azureADSettings;
    protected GraphServiceClient<Request> graphClientSingleton = null;
    private static final Object mutex = new Object();

    public AzureADUserSupplier(PasswordEncryptionService passwordEncryptionService) {
        this.passwordEncryptionService = passwordEncryptionService;
    }

    @Override
    public boolean canSyncOnDemand() {
        return true;
    }

    @Override
    public boolean canFetchUsers() {
        return true;
    }

    @Override
    public boolean canFetchGroups() {
        return true;
    }

    @Override
    public UserSupplierSettings getUserSupplierSettings() {
        return this.azureADSettings;
    }

    @Override
    public UserAttributes getUserAttributes(UserIdentity userIdentity) throws ServerAuthenticationFailure, UserNotFoundException {
        try {
            GraphServiceClient<Request> graphClient = this.getGraphClient();
            String queryFilter = this.azureADSettings.userQueryFilter.replace("$login", Optional.ofNullable(userIdentity.login).orElse("").replace("'", "''")).replace("$email", ((String)StringUtils.defaultIfEmpty((CharSequence)userIdentity.email, (CharSequence)"DO_NOT_MATCH_EMPTY_EMAIL")).replace("'", "''"));
            logger.info((Object)("use the following Azure AD user query: '" + queryFilter + "'"));
            UserCollectionPage userCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(new Option[0])).filter(queryFilter).expand("transitiveMemberOf").get();
            List foundUsers = userCollectionPage.getCurrentPage();
            if (foundUsers.isEmpty()) {
                throw new UserNotFoundException("No user found in AZURE AD matching attributes: " + String.valueOf(userIdentity));
            }
            if (foundUsers.size() > 1) {
                StringBuilder errorMessage = new StringBuilder("The identity '").append(userIdentity).append("' matches more than one Azure AD users:\n");
                foundUsers.forEach(u -> {
                    errorMessage.append("- {\n");
                    errorMessage.append("    'id': '").append(u.id).append("'\n");
                    errorMessage.append("    'userPrincipalName': '").append(u.userPrincipalName).append("'\n");
                    errorMessage.append("    'displayName': '").append(u.displayName).append("'\n");
                    errorMessage.append("    'mail': '").append(u.mail).append("'\n");
                    errorMessage.append("  }\n");
                });
                logger.error((Object)errorMessage.toString());
                throw new ServerAuthenticationFailure("More than one user matches the user identity '" + String.valueOf(userIdentity) + "'");
            }
            User azureADUser = (User)foundUsers.get(0);
            return this.toUserAttributes(graphClient, azureADUser);
        }
        catch (ClientException e) {
            throw new ServerAuthenticationFailure("Failure while communicating with Azure AD", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphServiceClient<Request> getGraphClient() throws ServerAuthenticationFailure {
        Object object = mutex;
        synchronized (object) {
            if (this.graphClientSingleton == null) {
                OkHttpClient okHttpClient;
                HttpClient azureHttpClient;
                List<String> scopes = Collections.singletonList("https://graph.microsoft.com/.default");
                try {
                    azureHttpClient = this.getAzureHttpClient(this.getProxySettingsDecrypted(), this.azureADSettings.trustAllCerts);
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    throw new ServerAuthenticationFailure("Couldn't setup proxy for Azure Identity HTTP client", e);
                }
                TokenCredentialAuthProvider tokenCredentialAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)(switch (this.azureADSettings.credentialMethod) {
                    case AzureADSettings.CredentialMethod.OAUTH2_CERT -> ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().clientId(this.azureADSettings.credentialsClientId)).tenantId(this.azureADSettings.credentialsTenantId)).pfxCertificate(this.azureADSettings.credentialsCertificatePath, this.azureADSettings.getCredentialsCertificatePasswordDecrypted(this.passwordEncryptionService)).httpClient(azureHttpClient)).build();
                    default -> ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(this.azureADSettings.credentialsClientId)).clientSecret(this.azureADSettings.getCredentialsClientSecretDecrypted(this.passwordEncryptionService)).tenantId(this.azureADSettings.credentialsTenantId)).httpClient(azureHttpClient)).build();
                }));
                try {
                    okHttpClient = AzureADUserSupplier.getOkHttpClient(this.getProxySettingsDecrypted(), tokenCredentialAuthProvider, this.azureADSettings.trustAllCerts);
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    throw new ServerAuthenticationFailure("Couldn't setup proxy for Azure Graph HTTP client", e);
                }
                this.graphClientSingleton = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredentialAuthProvider).httpClient((Object)okHttpClient).buildClient();
            }
            return this.graphClientSingleton;
        }
    }

    @Override
    public String getDefaultProfile() {
        return this.azureADSettings.defaultUserProfile;
    }

    private HttpClient getAzureHttpClient(ProxySettings proxySettings, boolean trustAllCerts) throws NoSuchAlgorithmException, KeyManagementException {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (proxySettings.hasProxy()) {
            ProxyUtils.applyToOkHttpClient(proxySettings, trustAllCerts, clientBuilder);
        }
        return new OkHttpAsyncHttpClientBuilder(clientBuilder.build()).build();
    }

    private static OkHttpClient getOkHttpClient(ProxySettings proxySettings, TokenCredentialAuthProvider tokenCredentialAuthProvider, boolean trustAllCerts) throws NoSuchAlgorithmException, KeyManagementException {
        OkHttpClient.Builder clientBuilder = HttpClients.createDefault((IAuthenticationProvider)tokenCredentialAuthProvider).newBuilder();
        if (proxySettings.hasProxy()) {
            ProxyUtils.applyToOkHttpClient(proxySettings, trustAllCerts, clientBuilder);
        }
        return clientBuilder.build();
    }

    protected abstract ProxySettings getProxySetting();

    private ProxySettings getProxySettingsDecrypted() {
        ProxySettings ps = this.getProxySetting().deepCopy();
        if (this.passwordEncryptionService != null) {
            ps.decryptFields(this.passwordEncryptionService);
        }
        return ps;
    }

    @Override
    public Set<UserAttributes> fetchUsers(UserQueryFilter filter) throws ServerAuthenticationFailure {
        UserCollectionRequestBuilder nextPage;
        UserCollectionPage initialPage;
        if (filter.getLogin() != null || filter.getEmail() != null) {
            try {
                UserIdentity userIdentity = new UserIdentity(UserSourceType.AZURE_AD, filter.getLogin());
                userIdentity.email = filter.getEmail();
                return Collections.singleton(this.getUserAttributes(userIdentity));
            }
            catch (UserNotFoundException e) {
                return Collections.emptySet();
            }
        }
        GraphServiceClient<Request> graphClient = this.getGraphClient();
        FutureProgress.pushState("Fetching users");
        if (filter.getGroupName() != null) {
            Optional foundGroup = ((GroupCollectionPage)((GroupCollectionRequest)graphClient.groups().buildRequest(new Option[0])).filter("displayName eq '" + filter.getGroupName() + "'").get()).getCurrentPage().stream().findAny();
            if (!foundGroup.isPresent()) {
                return Collections.emptySet();
            }
            initialPage = (UserCollectionPage)((UserCollectionRequest)graphClient.groups(((Group)foundGroup.get()).id).transitiveMembersAsUser().buildRequest(new Option[0])).expand("transitiveMemberOf").get();
        } else {
            initialPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(new Option[0])).expand("transitiveMemberOf").get();
        }
        HashSet<UserAttributes> response = new HashSet<UserAttributes>();
        int currentPageNumber = 1;
        do {
            FutureProgress.pushState("Converting Azure users for page " + currentPageNumber);
            logger.info((Object)("Converting Azure users to user attributes for page '" + currentPageNumber + "'"));
            response.addAll(initialPage.getCurrentPage().stream().map(u -> this.toUserAttributes(graphClient, (User)u)).collect(Collectors.toList()));
            try {
                FutureProgressState.checkInterrupt();
            }
            catch (InterruptedException e) {
                logger.info((Object)"Fetch users interrupted, returning current results");
                return response;
            }
            FutureProgress.popState();
            nextPage = (UserCollectionRequestBuilder)initialPage.getNextPage();
            if (nextPage == null) continue;
            logger.info((Object)("Fetching Azure users, page " + ++currentPageNumber));
            FutureProgress.pushState("Fetching Azure users, page " + currentPageNumber);
        } while ((initialPage = nextPage == null ? null : (UserCollectionPage)((UserCollectionRequest)nextPage.buildRequest(new Option[0])).get()) != null);
        return response;
    }

    @Override
    public Set<String> fetchGroups() throws ServerAuthenticationFailure {
        GraphServiceClient<Request> graphClient = this.getGraphClient();
        HashSet<String> allGroups = new HashSet<String>();
        GroupCollectionPage initialPage = (GroupCollectionPage)((GroupCollectionRequest)graphClient.groups().buildRequest(new Option[0])).filter(this.azureADSettings.groupQueryFilter).orderBy("displayName").get();
        do {
            HashSet currentPageUser = new HashSet(initialPage.getCurrentPage());
            allGroups.addAll(currentPageUser.stream().map(g -> g.displayName).collect(Collectors.toSet()));
            GroupCollectionRequestBuilder nextPage = (GroupCollectionRequestBuilder)initialPage.getNextPage();
            GroupCollectionPage groupCollectionPage = initialPage = nextPage == null ? null : (GroupCollectionPage)((GroupCollectionRequest)nextPage.buildRequest(new Option[0])).get();
        } while (initialPage != null && allGroups.size() < this.azureADSettings.groupsLimit);
        return allGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRefreshSettings() {
        Object object = mutex;
        synchronized (object) {
            this.graphClientSingleton = null;
        }
    }

    private UserAttributes toUserAttributes(GraphServiceClient<Request> graphClient, User u) {
        logger.info((Object)("Convert Azure user '" + u.id + "' to user attribute"));
        UserAttributes userAttributes = new UserAttributes();
        switch (this.azureADSettings.loginAttributeRef) {
            case EMAIL: {
                userAttributes.login = u.mail;
                break;
            }
            case DISPLAY_NAME: {
                userAttributes.login = u.displayName;
                break;
            }
            default: {
                userAttributes.login = u.userPrincipalName;
            }
        }
        userAttributes.email = u.mail;
        userAttributes.displayName = u.displayName;
        if (u.transitiveMemberOf.getCurrentPage().size() < 10) {
            logger.info((Object)("User '" + userAttributes.login + "' has less than 10 groups, no need to call Azure to fetch other groups"));
            userAttributes.sourceGroupNames = u.transitiveMemberOf.getCurrentPage().stream().filter(d -> d.oDataType.equals("#microsoft.graph.group")).map(d -> ((JsonElement)d.additionalDataManager().get((Object)"displayName")).getAsString()).collect(Collectors.toSet());
        } else {
            DirectoryObjectCollectionWithReferencesRequestBuilder nextPage;
            logger.info((Object)("User '" + userAttributes.login + "' has more than 10 groups, calling Azure to fetch other groups"));
            FutureProgress.pushState("Fetching groups for user  '" + userAttributes.login + "'");
            HashSet<String> allGroupList = new HashSet<String>();
            DirectoryObjectCollectionWithReferencesPage transitiveMemberOf = (DirectoryObjectCollectionWithReferencesPage)((DirectoryObjectCollectionReferenceRequest)graphClient.users(u.id).transitiveMemberOf().buildRequest(new Option[0])).get();
            int currentGroupPage = 1;
            do {
                Set currentPageGroup = transitiveMemberOf.getCurrentPage().stream().filter(d -> d.oDataType.equals("#microsoft.graph.group")).map(d -> ((JsonElement)d.additionalDataManager().get((Object)"displayName")).getAsString()).collect(Collectors.toSet());
                allGroupList.addAll(currentPageGroup);
                nextPage = (DirectoryObjectCollectionWithReferencesRequestBuilder)transitiveMemberOf.getNextPage();
                FutureProgress.popState();
                if (nextPage == null) continue;
                logger.info((Object)("Fetching next group page " + ++currentGroupPage + " for user '" + userAttributes.login + "'"));
                FutureProgress.pushState("Fetching next group page " + currentGroupPage + " for user '" + userAttributes.login + "'");
            } while ((transitiveMemberOf = nextPage == null ? null : (DirectoryObjectCollectionWithReferencesPage)((DirectoryObjectCollectionReferenceRequest)nextPage.buildRequest(new Option[0])).get()) != null);
            userAttributes.sourceGroupNames = allGroupList;
        }
        return userAttributes;
    }
}

